/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/credentials/v1/common.proto

package com.google.cloud.iam.credentials.v1;

/** Protobuf type {@code google.iam.credentials.v1.GenerateIdTokenRequest} */
public final class GenerateIdTokenRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.credentials.v1.GenerateIdTokenRequest)
    GenerateIdTokenRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateIdTokenRequest.newBuilder() to construct.
  private GenerateIdTokenRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateIdTokenRequest() {
    name_ = "";
    delegates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    audience_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateIdTokenRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private GenerateIdTokenRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                delegates_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              delegates_.add(s);
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              audience_ = s;
              break;
            }
          case 32:
            {
              includeEmail_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        delegates_ = delegates_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
        .internal_static_google_iam_credentials_v1_GenerateIdTokenRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
        .internal_static_google_iam_credentials_v1_GenerateIdTokenRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest.class,
            com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account for which the credentials
   * are requested, in the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account for which the credentials
   * are requested, in the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELEGATES_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList delegates_;
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @return A list containing the delegates.
   */
  public com.google.protobuf.ProtocolStringList getDelegatesList() {
    return delegates_;
  }
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @return The count of delegates.
   */
  public int getDelegatesCount() {
    return delegates_.size();
  }
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The delegates at the given index.
   */
  public java.lang.String getDelegates(int index) {
    return delegates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the delegates at the given index.
   */
  public com.google.protobuf.ByteString getDelegatesBytes(int index) {
    return delegates_.getByteString(index);
  }

  public static final int AUDIENCE_FIELD_NUMBER = 3;
  private volatile java.lang.Object audience_;
  /**
   *
   *
   * <pre>
   * Required. The audience for the token, such as the API or account that this token
   * grants access to.
   * </pre>
   *
   * <code>string audience = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The audience.
   */
  @java.lang.Override
  public java.lang.String getAudience() {
    java.lang.Object ref = audience_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      audience_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The audience for the token, such as the API or account that this token
   * grants access to.
   * </pre>
   *
   * <code>string audience = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for audience.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudienceBytes() {
    java.lang.Object ref = audience_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      audience_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_EMAIL_FIELD_NUMBER = 4;
  private boolean includeEmail_;
  /**
   *
   *
   * <pre>
   * Include the service account email in the token. If set to `true`, the
   * token will contain `email` and `email_verified` claims.
   * </pre>
   *
   * <code>bool include_email = 4;</code>
   *
   * @return The includeEmail.
   */
  @java.lang.Override
  public boolean getIncludeEmail() {
    return includeEmail_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < delegates_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, delegates_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, audience_);
    }
    if (includeEmail_ != false) {
      output.writeBool(4, includeEmail_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < delegates_.size(); i++) {
        dataSize += computeStringSizeNoTag(delegates_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDelegatesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, audience_);
    }
    if (includeEmail_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, includeEmail_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest other =
        (com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDelegatesList().equals(other.getDelegatesList())) return false;
    if (!getAudience().equals(other.getAudience())) return false;
    if (getIncludeEmail() != other.getIncludeEmail()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getDelegatesCount() > 0) {
      hash = (37 * hash) + DELEGATES_FIELD_NUMBER;
      hash = (53 * hash) + getDelegatesList().hashCode();
    }
    hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
    hash = (53 * hash) + getAudience().hashCode();
    hash = (37 * hash) + INCLUDE_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeEmail());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.iam.credentials.v1.GenerateIdTokenRequest} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.credentials.v1.GenerateIdTokenRequest)
      com.google.cloud.iam.credentials.v1.GenerateIdTokenRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
          .internal_static_google_iam_credentials_v1_GenerateIdTokenRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
          .internal_static_google_iam_credentials_v1_GenerateIdTokenRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest.class,
              com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest.Builder.class);
    }

    // Construct using com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      delegates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      audience_ = "";

      includeEmail_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
          .internal_static_google_iam_credentials_v1_GenerateIdTokenRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest getDefaultInstanceForType() {
      return com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest build() {
      com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest buildPartial() {
      com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest result =
          new com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (((bitField0_ & 0x00000001) != 0)) {
        delegates_ = delegates_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.delegates_ = delegates_;
      result.audience_ = audience_;
      result.includeEmail_ = includeEmail_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest) {
        return mergeFrom((com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest other) {
      if (other == com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.delegates_.isEmpty()) {
        if (delegates_.isEmpty()) {
          delegates_ = other.delegates_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureDelegatesIsMutable();
          delegates_.addAll(other.delegates_);
        }
        onChanged();
      }
      if (!other.getAudience().isEmpty()) {
        audience_ = other.audience_;
        onChanged();
      }
      if (other.getIncludeEmail() != false) {
        setIncludeEmail(other.getIncludeEmail());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList delegates_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureDelegatesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        delegates_ = new com.google.protobuf.LazyStringArrayList(delegates_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @return A list containing the delegates.
     */
    public com.google.protobuf.ProtocolStringList getDelegatesList() {
      return delegates_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @return The count of delegates.
     */
    public int getDelegatesCount() {
      return delegates_.size();
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The delegates at the given index.
     */
    public java.lang.String getDelegates(int index) {
      return delegates_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the delegates at the given index.
     */
    public com.google.protobuf.ByteString getDelegatesBytes(int index) {
      return delegates_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The delegates to set.
     * @return This builder for chaining.
     */
    public Builder setDelegates(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDelegatesIsMutable();
      delegates_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param value The delegates to add.
     * @return This builder for chaining.
     */
    public Builder addDelegates(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDelegatesIsMutable();
      delegates_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param values The delegates to add.
     * @return This builder for chaining.
     */
    public Builder addAllDelegates(java.lang.Iterable<java.lang.String> values) {
      ensureDelegatesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, delegates_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDelegates() {
      delegates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param value The bytes of the delegates to add.
     * @return This builder for chaining.
     */
    public Builder addDelegatesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDelegatesIsMutable();
      delegates_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object audience_ = "";
    /**
     *
     *
     * <pre>
     * Required. The audience for the token, such as the API or account that this token
     * grants access to.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The audience.
     */
    public java.lang.String getAudience() {
      java.lang.Object ref = audience_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audience_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The audience for the token, such as the API or account that this token
     * grants access to.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for audience.
     */
    public com.google.protobuf.ByteString getAudienceBytes() {
      java.lang.Object ref = audience_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audience_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The audience for the token, such as the API or account that this token
     * grants access to.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The audience to set.
     * @return This builder for chaining.
     */
    public Builder setAudience(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      audience_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The audience for the token, such as the API or account that this token
     * grants access to.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudience() {

      audience_ = getDefaultInstance().getAudience();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The audience for the token, such as the API or account that this token
     * grants access to.
     * </pre>
     *
     * <code>string audience = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for audience to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      audience_ = value;
      onChanged();
      return this;
    }

    private boolean includeEmail_;
    /**
     *
     *
     * <pre>
     * Include the service account email in the token. If set to `true`, the
     * token will contain `email` and `email_verified` claims.
     * </pre>
     *
     * <code>bool include_email = 4;</code>
     *
     * @return The includeEmail.
     */
    @java.lang.Override
    public boolean getIncludeEmail() {
      return includeEmail_;
    }
    /**
     *
     *
     * <pre>
     * Include the service account email in the token. If set to `true`, the
     * token will contain `email` and `email_verified` claims.
     * </pre>
     *
     * <code>bool include_email = 4;</code>
     *
     * @param value The includeEmail to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeEmail(boolean value) {

      includeEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Include the service account email in the token. If set to `true`, the
     * token will contain `email` and `email_verified` claims.
     * </pre>
     *
     * <code>bool include_email = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeEmail() {

      includeEmail_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.credentials.v1.GenerateIdTokenRequest)
  }

  // @@protoc_insertion_point(class_scope:google.iam.credentials.v1.GenerateIdTokenRequest)
  private static final com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest();
  }

  public static com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateIdTokenRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateIdTokenRequest>() {
        @java.lang.Override
        public GenerateIdTokenRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new GenerateIdTokenRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<GenerateIdTokenRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateIdTokenRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
