/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/credentials/v1/common.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.iam.credentials.v1;

/** Protobuf type {@code google.iam.credentials.v1.GenerateAccessTokenRequest} */
public final class GenerateAccessTokenRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.credentials.v1.GenerateAccessTokenRequest)
    GenerateAccessTokenRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateAccessTokenRequest.newBuilder() to construct.
  private GenerateAccessTokenRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateAccessTokenRequest() {
    name_ = "";
    delegates_ = com.google.protobuf.LazyStringArrayList.emptyList();
    scope_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateAccessTokenRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
        .internal_static_google_iam_credentials_v1_GenerateAccessTokenRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
        .internal_static_google_iam_credentials_v1_GenerateAccessTokenRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest.class,
            com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account for which the credentials
   * are requested, in the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account for which the credentials
   * are requested, in the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELEGATES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList delegates_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   *
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @return A list containing the delegates.
   */
  public com.google.protobuf.ProtocolStringList getDelegatesList() {
    return delegates_;
  }
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   *
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @return The count of delegates.
   */
  public int getDelegatesCount() {
    return delegates_.size();
  }
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   *
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The delegates at the given index.
   */
  public java.lang.String getDelegates(int index) {
    return delegates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The sequence of service accounts in a delegation chain. Each service
   * account must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on its next service account in the chain. The last service account in the
   * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
   * on the service account that is specified in the `name` field of the
   * request.
   *
   * The delegates must have the following format:
   * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
   * character is required; replacing it with a project ID is invalid.
   * </pre>
   *
   * <code>repeated string delegates = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the delegates at the given index.
   */
  public com.google.protobuf.ByteString getDelegatesBytes(int index) {
    return delegates_.getByteString(index);
  }

  public static final int SCOPE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList scope_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
   * See https://developers.google.com/identity/protocols/googlescopes for more
   * information.
   * At least one value required.
   * </pre>
   *
   * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the scope.
   */
  public com.google.protobuf.ProtocolStringList getScopeList() {
    return scope_;
  }
  /**
   *
   *
   * <pre>
   * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
   * See https://developers.google.com/identity/protocols/googlescopes for more
   * information.
   * At least one value required.
   * </pre>
   *
   * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of scope.
   */
  public int getScopeCount() {
    return scope_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
   * See https://developers.google.com/identity/protocols/googlescopes for more
   * information.
   * At least one value required.
   * </pre>
   *
   * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The scope at the given index.
   */
  public java.lang.String getScope(int index) {
    return scope_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
   * See https://developers.google.com/identity/protocols/googlescopes for more
   * information.
   * At least one value required.
   * </pre>
   *
   * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the scope at the given index.
   */
  public com.google.protobuf.ByteString getScopeBytes(int index) {
    return scope_.getByteString(index);
  }

  public static final int LIFETIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration lifetime_;
  /**
   *
   *
   * <pre>
   * The desired lifetime duration of the access token in seconds.
   * Must be set to a value less than or equal to 3600 (1 hour). If a value is
   * not specified, the token's lifetime will be set to a default value of one
   * hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration lifetime = 7;</code>
   *
   * @return Whether the lifetime field is set.
   */
  @java.lang.Override
  public boolean hasLifetime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired lifetime duration of the access token in seconds.
   * Must be set to a value less than or equal to 3600 (1 hour). If a value is
   * not specified, the token's lifetime will be set to a default value of one
   * hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration lifetime = 7;</code>
   *
   * @return The lifetime.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getLifetime() {
    return lifetime_ == null ? com.google.protobuf.Duration.getDefaultInstance() : lifetime_;
  }
  /**
   *
   *
   * <pre>
   * The desired lifetime duration of the access token in seconds.
   * Must be set to a value less than or equal to 3600 (1 hour). If a value is
   * not specified, the token's lifetime will be set to a default value of one
   * hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration lifetime = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getLifetimeOrBuilder() {
    return lifetime_ == null ? com.google.protobuf.Duration.getDefaultInstance() : lifetime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < delegates_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, delegates_.getRaw(i));
    }
    for (int i = 0; i < scope_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, scope_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getLifetime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < delegates_.size(); i++) {
        dataSize += computeStringSizeNoTag(delegates_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDelegatesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < scope_.size(); i++) {
        dataSize += computeStringSizeNoTag(scope_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getScopeList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLifetime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest other =
        (com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDelegatesList().equals(other.getDelegatesList())) return false;
    if (!getScopeList().equals(other.getScopeList())) return false;
    if (hasLifetime() != other.hasLifetime()) return false;
    if (hasLifetime()) {
      if (!getLifetime().equals(other.getLifetime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getDelegatesCount() > 0) {
      hash = (37 * hash) + DELEGATES_FIELD_NUMBER;
      hash = (53 * hash) + getDelegatesList().hashCode();
    }
    if (getScopeCount() > 0) {
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getScopeList().hashCode();
    }
    if (hasLifetime()) {
      hash = (37 * hash) + LIFETIME_FIELD_NUMBER;
      hash = (53 * hash) + getLifetime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.iam.credentials.v1.GenerateAccessTokenRequest} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.credentials.v1.GenerateAccessTokenRequest)
      com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
          .internal_static_google_iam_credentials_v1_GenerateAccessTokenRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
          .internal_static_google_iam_credentials_v1_GenerateAccessTokenRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest.class,
              com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest.Builder.class);
    }

    // Construct using com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLifetimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      delegates_ = com.google.protobuf.LazyStringArrayList.emptyList();
      scope_ = com.google.protobuf.LazyStringArrayList.emptyList();
      lifetime_ = null;
      if (lifetimeBuilder_ != null) {
        lifetimeBuilder_.dispose();
        lifetimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.iam.credentials.v1.IAMCredentialsCommonProto
          .internal_static_google_iam_credentials_v1_GenerateAccessTokenRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest
        getDefaultInstanceForType() {
      return com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest build() {
      com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest buildPartial() {
      com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest result =
          new com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        delegates_.makeImmutable();
        result.delegates_ = delegates_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        scope_.makeImmutable();
        result.scope_ = scope_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lifetime_ = lifetimeBuilder_ == null ? lifetime_ : lifetimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest) {
        return mergeFrom((com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest other) {
      if (other
          == com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.delegates_.isEmpty()) {
        if (delegates_.isEmpty()) {
          delegates_ = other.delegates_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDelegatesIsMutable();
          delegates_.addAll(other.delegates_);
        }
        onChanged();
      }
      if (!other.scope_.isEmpty()) {
        if (scope_.isEmpty()) {
          scope_ = other.scope_;
          bitField0_ |= 0x00000004;
        } else {
          ensureScopeIsMutable();
          scope_.addAll(other.scope_);
        }
        onChanged();
      }
      if (other.hasLifetime()) {
        mergeLifetime(other.getLifetime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDelegatesIsMutable();
                delegates_.add(s);
                break;
              } // case 18
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureScopeIsMutable();
                scope_.add(s);
                break;
              } // case 34
            case 58:
              {
                input.readMessage(getLifetimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account for which the credentials
     * are requested, in the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList delegates_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDelegatesIsMutable() {
      if (!delegates_.isModifiable()) {
        delegates_ = new com.google.protobuf.LazyStringArrayList(delegates_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @return A list containing the delegates.
     */
    public com.google.protobuf.ProtocolStringList getDelegatesList() {
      delegates_.makeImmutable();
      return delegates_;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @return The count of delegates.
     */
    public int getDelegatesCount() {
      return delegates_.size();
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The delegates at the given index.
     */
    public java.lang.String getDelegates(int index) {
      return delegates_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the delegates at the given index.
     */
    public com.google.protobuf.ByteString getDelegatesBytes(int index) {
      return delegates_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The delegates to set.
     * @return This builder for chaining.
     */
    public Builder setDelegates(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDelegatesIsMutable();
      delegates_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param value The delegates to add.
     * @return This builder for chaining.
     */
    public Builder addDelegates(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDelegatesIsMutable();
      delegates_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param values The delegates to add.
     * @return This builder for chaining.
     */
    public Builder addAllDelegates(java.lang.Iterable<java.lang.String> values) {
      ensureDelegatesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, delegates_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDelegates() {
      delegates_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sequence of service accounts in a delegation chain. Each service
     * account must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on its next service account in the chain. The last service account in the
     * chain must be granted the `roles/iam.serviceAccountTokenCreator` role
     * on the service account that is specified in the `name` field of the
     * request.
     *
     * The delegates must have the following format:
     * `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The `-` wildcard
     * character is required; replacing it with a project ID is invalid.
     * </pre>
     *
     * <code>repeated string delegates = 2;</code>
     *
     * @param value The bytes of the delegates to add.
     * @return This builder for chaining.
     */
    public Builder addDelegatesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDelegatesIsMutable();
      delegates_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList scope_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureScopeIsMutable() {
      if (!scope_.isModifiable()) {
        scope_ = new com.google.protobuf.LazyStringArrayList(scope_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the scope.
     */
    public com.google.protobuf.ProtocolStringList getScopeList() {
      scope_.makeImmutable();
      return scope_;
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of scope.
     */
    public int getScopeCount() {
      return scope_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The scope at the given index.
     */
    public java.lang.String getScope(int index) {
      return scope_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the scope at the given index.
     */
    public com.google.protobuf.ByteString getScopeBytes(int index) {
      return scope_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The scope to set.
     * @return This builder for chaining.
     */
    public Builder setScope(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureScopeIsMutable();
      scope_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The scope to add.
     * @return This builder for chaining.
     */
    public Builder addScope(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureScopeIsMutable();
      scope_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The scope to add.
     * @return This builder for chaining.
     */
    public Builder addAllScope(java.lang.Iterable<java.lang.String> values) {
      ensureScopeIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scope_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScope() {
      scope_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Code to identify the scopes to be included in the OAuth 2.0 access token.
     * See https://developers.google.com/identity/protocols/googlescopes for more
     * information.
     * At least one value required.
     * </pre>
     *
     * <code>repeated string scope = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the scope to add.
     * @return This builder for chaining.
     */
    public Builder addScopeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureScopeIsMutable();
      scope_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration lifetime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        lifetimeBuilder_;
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     *
     * @return Whether the lifetime field is set.
     */
    public boolean hasLifetime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     *
     * @return The lifetime.
     */
    public com.google.protobuf.Duration getLifetime() {
      if (lifetimeBuilder_ == null) {
        return lifetime_ == null ? com.google.protobuf.Duration.getDefaultInstance() : lifetime_;
      } else {
        return lifetimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     */
    public Builder setLifetime(com.google.protobuf.Duration value) {
      if (lifetimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lifetime_ = value;
      } else {
        lifetimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     */
    public Builder setLifetime(com.google.protobuf.Duration.Builder builderForValue) {
      if (lifetimeBuilder_ == null) {
        lifetime_ = builderForValue.build();
      } else {
        lifetimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     */
    public Builder mergeLifetime(com.google.protobuf.Duration value) {
      if (lifetimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lifetime_ != null
            && lifetime_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getLifetimeBuilder().mergeFrom(value);
        } else {
          lifetime_ = value;
        }
      } else {
        lifetimeBuilder_.mergeFrom(value);
      }
      if (lifetime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     */
    public Builder clearLifetime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lifetime_ = null;
      if (lifetimeBuilder_ != null) {
        lifetimeBuilder_.dispose();
        lifetimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getLifetimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLifetimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getLifetimeOrBuilder() {
      if (lifetimeBuilder_ != null) {
        return lifetimeBuilder_.getMessageOrBuilder();
      } else {
        return lifetime_ == null ? com.google.protobuf.Duration.getDefaultInstance() : lifetime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired lifetime duration of the access token in seconds.
     * Must be set to a value less than or equal to 3600 (1 hour). If a value is
     * not specified, the token's lifetime will be set to a default value of one
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration lifetime = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getLifetimeFieldBuilder() {
      if (lifetimeBuilder_ == null) {
        lifetimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getLifetime(), getParentForChildren(), isClean());
        lifetime_ = null;
      }
      return lifetimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.credentials.v1.GenerateAccessTokenRequest)
  }

  // @@protoc_insertion_point(class_scope:google.iam.credentials.v1.GenerateAccessTokenRequest)
  private static final com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest();
  }

  public static com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateAccessTokenRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateAccessTokenRequest>() {
        @java.lang.Override
        public GenerateAccessTokenRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateAccessTokenRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateAccessTokenRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
