/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceDriftName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PREVIEW_RESOURCE_DRIFT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/previews/{preview}/resourceDrifts/{resource_drift}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String preview;
    private final String resourceDrift;

    @Deprecated
    protected ResourceDriftName() {
        this.project = null;
        this.location = null;
        this.preview = null;
        this.resourceDrift = null;
    }

    private ResourceDriftName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.preview = (String)Preconditions.checkNotNull((Object)builder.getPreview());
        this.resourceDrift = (String)Preconditions.checkNotNull((Object)builder.getResourceDrift());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPreview() {
        return this.preview;
    }

    public String getResourceDrift() {
        return this.resourceDrift;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceDriftName of(String project, String location, String preview, String resourceDrift) {
        return ResourceDriftName.newBuilder().setProject(project).setLocation(location).setPreview(preview).setResourceDrift(resourceDrift).build();
    }

    public static String format(String project, String location, String preview, String resourceDrift) {
        return ResourceDriftName.newBuilder().setProject(project).setLocation(location).setPreview(preview).setResourceDrift(resourceDrift).build().toString();
    }

    public static ResourceDriftName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PREVIEW_RESOURCE_DRIFT.validatedMatch(formattedString, "ResourceDriftName.parse: formattedString not in valid format");
        return ResourceDriftName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("preview"), (String)matchMap.get("resource_drift"));
    }

    public static List<ResourceDriftName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceDriftName> list = new ArrayList<ResourceDriftName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceDriftName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceDriftName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceDriftName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PREVIEW_RESOURCE_DRIFT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceDriftName resourceDriftName = this;
            synchronized (resourceDriftName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.preview != null) {
                        fieldMapBuilder.put((Object)"preview", (Object)this.preview);
                    }
                    if (this.resourceDrift != null) {
                        fieldMapBuilder.put((Object)"resource_drift", (Object)this.resourceDrift);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PREVIEW_RESOURCE_DRIFT.instantiate(new String[]{"project", this.project, "location", this.location, "preview", this.preview, "resource_drift", this.resourceDrift});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceDriftName that = (ResourceDriftName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.preview, that.preview) && Objects.equals(this.resourceDrift, that.resourceDrift);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.preview);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceDrift);
    }

    public static class Builder {
        private String project;
        private String location;
        private String preview;
        private String resourceDrift;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPreview() {
            return this.preview;
        }

        public String getResourceDrift() {
            return this.resourceDrift;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPreview(String preview) {
            this.preview = preview;
            return this;
        }

        public Builder setResourceDrift(String resourceDrift) {
            this.resourceDrift = resourceDrift;
            return this;
        }

        private Builder(ResourceDriftName resourceDriftName) {
            this.project = resourceDriftName.project;
            this.location = resourceDriftName.location;
            this.preview = resourceDriftName.preview;
            this.resourceDrift = resourceDriftName.resourceDrift;
        }

        public ResourceDriftName build() {
            return new ResourceDriftName(this);
        }
    }
}

