/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TerraformVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TERRAFORM_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/terraformVersions/{terraform_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String terraformVersion;

    @Deprecated
    protected TerraformVersionName() {
        this.project = null;
        this.location = null;
        this.terraformVersion = null;
    }

    private TerraformVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.terraformVersion = (String)Preconditions.checkNotNull((Object)builder.getTerraformVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTerraformVersion() {
        return this.terraformVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TerraformVersionName of(String project, String location, String terraformVersion) {
        return TerraformVersionName.newBuilder().setProject(project).setLocation(location).setTerraformVersion(terraformVersion).build();
    }

    public static String format(String project, String location, String terraformVersion) {
        return TerraformVersionName.newBuilder().setProject(project).setLocation(location).setTerraformVersion(terraformVersion).build().toString();
    }

    public static TerraformVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TERRAFORM_VERSION.validatedMatch(formattedString, "TerraformVersionName.parse: formattedString not in valid format");
        return TerraformVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("terraform_version"));
    }

    public static List<TerraformVersionName> parseList(List<String> formattedStrings) {
        ArrayList<TerraformVersionName> list = new ArrayList<TerraformVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TerraformVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TerraformVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TerraformVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TERRAFORM_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TerraformVersionName terraformVersionName = this;
            synchronized (terraformVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.terraformVersion != null) {
                        fieldMapBuilder.put((Object)"terraform_version", (Object)this.terraformVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TERRAFORM_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "terraform_version", this.terraformVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TerraformVersionName that = (TerraformVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.terraformVersion, that.terraformVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.terraformVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String terraformVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTerraformVersion() {
            return this.terraformVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTerraformVersion(String terraformVersion) {
            this.terraformVersion = terraformVersion;
            return this;
        }

        private Builder(TerraformVersionName terraformVersionName) {
            this.project = terraformVersionName.project;
            this.location = terraformVersionName.location;
            this.terraformVersion = terraformVersionName.terraformVersion;
        }

        public TerraformVersionName build() {
            return new TerraformVersionName(this);
        }
    }
}

