/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/config/v1/config.proto

package com.google.cloud.config.v1;

/**
 *
 *
 * <pre>
 * A Deployment is a group of resources and configs managed and provisioned by
 * Infra Manager.
 * </pre>
 *
 * Protobuf type {@code google.cloud.config.v1.Deployment}
 */
public final class Deployment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.config.v1.Deployment)
    DeploymentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Deployment.newBuilder() to construct.
  private Deployment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Deployment() {
    name_ = "";
    state_ = 0;
    latestRevision_ = "";
    stateDetail_ = "";
    errorCode_ = 0;
    deleteBuild_ = "";
    deleteLogs_ = "";
    tfErrors_ = java.util.Collections.emptyList();
    errorLogs_ = "";
    artifactsGcsBucket_ = "";
    serviceAccount_ = "";
    workerPool_ = "";
    lockState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Deployment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_Deployment_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_Deployment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.config.v1.Deployment.class,
            com.google.cloud.config.v1.Deployment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a deployment.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Deployment.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The deployment is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The deployment is healthy.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The deployment is being updated.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    UPDATING(3),
    /**
     *
     *
     * <pre>
     * The deployment is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * The deployment has encountered an unexpected error.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * The deployment is no longer being actively reconciled.
     * This may be the result of recovering the project after deletion.
     * </pre>
     *
     * <code>SUSPENDED = 6;</code>
     */
    SUSPENDED(6),
    /**
     *
     *
     * <pre>
     * The deployment has been deleted.
     * </pre>
     *
     * <code>DELETED = 7;</code>
     */
    DELETED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The deployment is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The deployment is healthy.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The deployment is being updated.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    public static final int UPDATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The deployment is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The deployment has encountered an unexpected error.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The deployment is no longer being actively reconciled.
     * This may be the result of recovering the project after deletion.
     * </pre>
     *
     * <code>SUSPENDED = 6;</code>
     */
    public static final int SUSPENDED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The deployment has been deleted.
     * </pre>
     *
     * <code>DELETED = 7;</code>
     */
    public static final int DELETED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return UPDATING;
        case 4:
          return DELETING;
        case 5:
          return FAILED;
        case 6:
          return SUSPENDED;
        case 7:
          return DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Deployment.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Deployment.State)
  }

  /**
   *
   *
   * <pre>
   * Possible errors that can occur with deployments.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Deployment.ErrorCode}
   */
  public enum ErrorCode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No error code was specified.
     * </pre>
     *
     * <code>ERROR_CODE_UNSPECIFIED = 0;</code>
     */
    ERROR_CODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The revision failed. See Revision for more details.
     * </pre>
     *
     * <code>REVISION_FAILED = 1;</code>
     */
    REVISION_FAILED(1),
    /**
     *
     *
     * <pre>
     * Cloud Build failed due to a permission issue.
     * </pre>
     *
     * <code>CLOUD_BUILD_PERMISSION_DENIED = 3;</code>
     */
    CLOUD_BUILD_PERMISSION_DENIED(3),
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with a deployment deletion could not be
     * started.
     * </pre>
     *
     * <code>DELETE_BUILD_API_FAILED = 5;</code>
     */
    DELETE_BUILD_API_FAILED(5),
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with a deployment deletion was started but
     * failed.
     * </pre>
     *
     * <code>DELETE_BUILD_RUN_FAILED = 6;</code>
     */
    DELETE_BUILD_RUN_FAILED(6),
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket creation failed due to a permission issue.
     * </pre>
     *
     * <code>BUCKET_CREATION_PERMISSION_DENIED = 7;</code>
     */
    BUCKET_CREATION_PERMISSION_DENIED(7),
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket creation failed due to an issue unrelated to
     * permissions.
     * </pre>
     *
     * <code>BUCKET_CREATION_FAILED = 8;</code>
     */
    BUCKET_CREATION_FAILED(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No error code was specified.
     * </pre>
     *
     * <code>ERROR_CODE_UNSPECIFIED = 0;</code>
     */
    public static final int ERROR_CODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The revision failed. See Revision for more details.
     * </pre>
     *
     * <code>REVISION_FAILED = 1;</code>
     */
    public static final int REVISION_FAILED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Cloud Build failed due to a permission issue.
     * </pre>
     *
     * <code>CLOUD_BUILD_PERMISSION_DENIED = 3;</code>
     */
    public static final int CLOUD_BUILD_PERMISSION_DENIED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with a deployment deletion could not be
     * started.
     * </pre>
     *
     * <code>DELETE_BUILD_API_FAILED = 5;</code>
     */
    public static final int DELETE_BUILD_API_FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with a deployment deletion was started but
     * failed.
     * </pre>
     *
     * <code>DELETE_BUILD_RUN_FAILED = 6;</code>
     */
    public static final int DELETE_BUILD_RUN_FAILED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket creation failed due to a permission issue.
     * </pre>
     *
     * <code>BUCKET_CREATION_PERMISSION_DENIED = 7;</code>
     */
    public static final int BUCKET_CREATION_PERMISSION_DENIED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket creation failed due to an issue unrelated to
     * permissions.
     * </pre>
     *
     * <code>BUCKET_CREATION_FAILED = 8;</code>
     */
    public static final int BUCKET_CREATION_FAILED_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ErrorCode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ErrorCode forNumber(int value) {
      switch (value) {
        case 0:
          return ERROR_CODE_UNSPECIFIED;
        case 1:
          return REVISION_FAILED;
        case 3:
          return CLOUD_BUILD_PERMISSION_DENIED;
        case 5:
          return DELETE_BUILD_API_FAILED;
        case 6:
          return DELETE_BUILD_RUN_FAILED;
        case 7:
          return BUCKET_CREATION_PERMISSION_DENIED;
        case 8:
          return BUCKET_CREATION_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ErrorCode>() {
          public ErrorCode findValueByNumber(int number) {
            return ErrorCode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Deployment.getDescriptor().getEnumTypes().get(1);
    }

    private static final ErrorCode[] VALUES = values();

    public static ErrorCode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ErrorCode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Deployment.ErrorCode)
  }

  /**
   *
   *
   * <pre>
   * Possible lock states of a deployment.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Deployment.LockState}
   */
  public enum LockState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the lock state is omitted.
     * </pre>
     *
     * <code>LOCK_STATE_UNSPECIFIED = 0;</code>
     */
    LOCK_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The deployment is locked.
     * </pre>
     *
     * <code>LOCKED = 1;</code>
     */
    LOCKED(1),
    /**
     *
     *
     * <pre>
     * The deployment is unlocked.
     * </pre>
     *
     * <code>UNLOCKED = 2;</code>
     */
    UNLOCKED(2),
    /**
     *
     *
     * <pre>
     * The deployment is being locked.
     * </pre>
     *
     * <code>LOCKING = 3;</code>
     */
    LOCKING(3),
    /**
     *
     *
     * <pre>
     * The deployment is being unlocked.
     * </pre>
     *
     * <code>UNLOCKING = 4;</code>
     */
    UNLOCKING(4),
    /**
     *
     *
     * <pre>
     * The deployment has failed to lock.
     * </pre>
     *
     * <code>LOCK_FAILED = 5;</code>
     */
    LOCK_FAILED(5),
    /**
     *
     *
     * <pre>
     * The deployment has failed to unlock.
     * </pre>
     *
     * <code>UNLOCK_FAILED = 6;</code>
     */
    UNLOCK_FAILED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the lock state is omitted.
     * </pre>
     *
     * <code>LOCK_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int LOCK_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The deployment is locked.
     * </pre>
     *
     * <code>LOCKED = 1;</code>
     */
    public static final int LOCKED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The deployment is unlocked.
     * </pre>
     *
     * <code>UNLOCKED = 2;</code>
     */
    public static final int UNLOCKED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The deployment is being locked.
     * </pre>
     *
     * <code>LOCKING = 3;</code>
     */
    public static final int LOCKING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The deployment is being unlocked.
     * </pre>
     *
     * <code>UNLOCKING = 4;</code>
     */
    public static final int UNLOCKING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The deployment has failed to lock.
     * </pre>
     *
     * <code>LOCK_FAILED = 5;</code>
     */
    public static final int LOCK_FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The deployment has failed to unlock.
     * </pre>
     *
     * <code>UNLOCK_FAILED = 6;</code>
     */
    public static final int UNLOCK_FAILED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LockState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LockState forNumber(int value) {
      switch (value) {
        case 0:
          return LOCK_STATE_UNSPECIFIED;
        case 1:
          return LOCKED;
        case 2:
          return UNLOCKED;
        case 3:
          return LOCKING;
        case 4:
          return UNLOCKING;
        case 5:
          return LOCK_FAILED;
        case 6:
          return UNLOCK_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LockState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LockState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LockState>() {
          public LockState findValueByNumber(int number) {
            return LockState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Deployment.getDescriptor().getEnumTypes().get(2);
    }

    private static final LockState[] VALUES = values();

    public static LockState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LockState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Deployment.LockState)
  }

  private int bitField0_;
  private int blueprintCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object blueprint_;

  public enum BlueprintCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TERRAFORM_BLUEPRINT(6),
    BLUEPRINT_NOT_SET(0);
    private final int value;

    private BlueprintCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BlueprintCase valueOf(int value) {
      return forNumber(value);
    }

    public static BlueprintCase forNumber(int value) {
      switch (value) {
        case 6:
          return TERRAFORM_BLUEPRINT;
        case 0:
          return BLUEPRINT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BlueprintCase getBlueprintCase() {
    return BlueprintCase.forNumber(blueprintCase_);
  }

  public static final int TERRAFORM_BLUEPRINT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A blueprint described using Terraform's HashiCorp Configuration Language
   * as a root module.
   * </pre>
   *
   * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
   *
   * @return Whether the terraformBlueprint field is set.
   */
  @java.lang.Override
  public boolean hasTerraformBlueprint() {
    return blueprintCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A blueprint described using Terraform's HashiCorp Configuration Language
   * as a root module.
   * </pre>
   *
   * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
   *
   * @return The terraformBlueprint.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformBlueprint getTerraformBlueprint() {
    if (blueprintCase_ == 6) {
      return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
    }
    return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A blueprint described using Terraform's HashiCorp Configuration Language
   * as a root module.
   * </pre>
   *
   * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformBlueprintOrBuilder getTerraformBlueprintOrBuilder() {
    if (blueprintCase_ == 6) {
      return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
    }
    return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of the deployment.
   * Format: `projects/{project}/locations/{location}/deployments/{deployment}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of the deployment.
   * Format: `projects/{project}/locations/{location}/deployments/{deployment}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the deployment was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the deployment was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the deployment was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the deployment was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the deployment was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the deployment was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.config.v1.ConfigProto
                .internal_static_google_cloud_config_v1_Deployment_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-defined metadata for the deployment.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined metadata for the deployment.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined metadata for the deployment.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-defined metadata for the deployment.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Deployment.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Deployment.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Deployment.State getState() {
    com.google.cloud.config.v1.Deployment.State result =
        com.google.cloud.config.v1.Deployment.State.forNumber(state_);
    return result == null ? com.google.cloud.config.v1.Deployment.State.UNRECOGNIZED : result;
  }

  public static final int LATEST_REVISION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestRevision_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Revision name that was most recently applied.
   * Format: `projects/{project}/locations/{location}/deployments/{deployment}/
   * revisions/{revision}`
   * </pre>
   *
   * <code>string latest_revision = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The latestRevision.
   */
  @java.lang.Override
  public java.lang.String getLatestRevision() {
    java.lang.Object ref = latestRevision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestRevision_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Revision name that was most recently applied.
   * Format: `projects/{project}/locations/{location}/deployments/{deployment}/
   * revisions/{revision}`
   * </pre>
   *
   * <code>string latest_revision = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for latestRevision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestRevisionBytes() {
    java.lang.Object ref = latestRevision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestRevision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_DETAIL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateDetail_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information regarding the current state.
   * </pre>
   *
   * <code>string state_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateDetail.
   */
  @java.lang.Override
  public java.lang.String getStateDetail() {
    java.lang.Object ref = stateDetail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateDetail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information regarding the current state.
   * </pre>
   *
   * <code>string state_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateDetail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateDetailBytes() {
    java.lang.Object ref = stateDetail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateDetail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_CODE_FIELD_NUMBER = 10;
  private int errorCode_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Error code describing errors that may have occurred.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Deployment.ErrorCode error_code = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for errorCode.
   */
  @java.lang.Override
  public int getErrorCodeValue() {
    return errorCode_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Error code describing errors that may have occurred.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Deployment.ErrorCode error_code = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The errorCode.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Deployment.ErrorCode getErrorCode() {
    com.google.cloud.config.v1.Deployment.ErrorCode result =
        com.google.cloud.config.v1.Deployment.ErrorCode.forNumber(errorCode_);
    return result == null ? com.google.cloud.config.v1.Deployment.ErrorCode.UNRECOGNIZED : result;
  }

  public static final int DELETE_RESULTS_FIELD_NUMBER = 8;
  private com.google.cloud.config.v1.ApplyResults deleteResults_;
  /**
   *
   *
   * <pre>
   * Output only. Location of artifacts from a DeleteDeployment operation.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteResults field is set.
   */
  @java.lang.Override
  public boolean hasDeleteResults() {
    return deleteResults_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Location of artifacts from a DeleteDeployment operation.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteResults.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ApplyResults getDeleteResults() {
    return deleteResults_ == null
        ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
        : deleteResults_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Location of artifacts from a DeleteDeployment operation.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ApplyResultsOrBuilder getDeleteResultsOrBuilder() {
    return deleteResults_ == null
        ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
        : deleteResults_;
  }

  public static final int DELETE_BUILD_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deleteBuild_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Cloud Build instance UUID associated with deleting this
   * deployment.
   * </pre>
   *
   * <code>string delete_build = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The deleteBuild.
   */
  @java.lang.Override
  public java.lang.String getDeleteBuild() {
    java.lang.Object ref = deleteBuild_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deleteBuild_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Build instance UUID associated with deleting this
   * deployment.
   * </pre>
   *
   * <code>string delete_build = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for deleteBuild.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeleteBuildBytes() {
    java.lang.Object ref = deleteBuild_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deleteBuild_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETE_LOGS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deleteLogs_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Location of Cloud Build logs in Google Cloud Storage,
   * populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
   * </pre>
   *
   * <code>string delete_logs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The deleteLogs.
   */
  @java.lang.Override
  public java.lang.String getDeleteLogs() {
    java.lang.Object ref = deleteLogs_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deleteLogs_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Location of Cloud Build logs in Google Cloud Storage,
   * populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
   * </pre>
   *
   * <code>string delete_logs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for deleteLogs.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeleteLogsBytes() {
    java.lang.Object ref = deleteLogs_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deleteLogs_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TF_ERRORS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.config.v1.TerraformError> tfErrors_;
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when deleting this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.config.v1.TerraformError> getTfErrorsList() {
    return tfErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when deleting this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.config.v1.TerraformErrorOrBuilder>
      getTfErrorsOrBuilderList() {
    return tfErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when deleting this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getTfErrorsCount() {
    return tfErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when deleting this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformError getTfErrors(int index) {
    return tfErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when deleting this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformErrorOrBuilder getTfErrorsOrBuilder(int index) {
    return tfErrors_.get(index);
  }

  public static final int ERROR_LOGS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorLogs_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Location of Terraform error logs in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`.
   * </pre>
   *
   * <code>string error_logs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The errorLogs.
   */
  @java.lang.Override
  public java.lang.String getErrorLogs() {
    java.lang.Object ref = errorLogs_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorLogs_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Location of Terraform error logs in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`.
   * </pre>
   *
   * <code>string error_logs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for errorLogs.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorLogsBytes() {
    java.lang.Object ref = errorLogs_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorLogs_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARTIFACTS_GCS_BUCKET_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object artifactsGcsBucket_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-defined location of Cloud Build logs and artifacts in Google
   * Cloud Storage. Format: `gs://{bucket}/{folder}`
   *
   * A default bucket will be bootstrapped if the field is not set or empty.
   * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
   * Constraints:
   * - The bucket needs to be in the same project as the deployment
   * - The path cannot be within the path of `gcs_source`
   * - The field cannot be updated, including changing its presence
   * </pre>
   *
   * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the artifactsGcsBucket field is set.
   */
  @java.lang.Override
  public boolean hasArtifactsGcsBucket() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. User-defined location of Cloud Build logs and artifacts in Google
   * Cloud Storage. Format: `gs://{bucket}/{folder}`
   *
   * A default bucket will be bootstrapped if the field is not set or empty.
   * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
   * Constraints:
   * - The bucket needs to be in the same project as the deployment
   * - The path cannot be within the path of `gcs_source`
   * - The field cannot be updated, including changing its presence
   * </pre>
   *
   * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The artifactsGcsBucket.
   */
  @java.lang.Override
  public java.lang.String getArtifactsGcsBucket() {
    java.lang.Object ref = artifactsGcsBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      artifactsGcsBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-defined location of Cloud Build logs and artifacts in Google
   * Cloud Storage. Format: `gs://{bucket}/{folder}`
   *
   * A default bucket will be bootstrapped if the field is not set or empty.
   * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
   * Constraints:
   * - The bucket needs to be in the same project as the deployment
   * - The path cannot be within the path of `gcs_source`
   * - The field cannot be updated, including changing its presence
   * </pre>
   *
   * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for artifactsGcsBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArtifactsGcsBucketBytes() {
    java.lang.Object ref = artifactsGcsBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      artifactsGcsBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-specified Service Account (SA) credentials to be used when
   * actuating resources.
   * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
   * </pre>
   *
   * <code>
   * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the serviceAccount field is set.
   */
  @java.lang.Override
  public boolean hasServiceAccount() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. User-specified Service Account (SA) credentials to be used when
   * actuating resources.
   * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
   * </pre>
   *
   * <code>
   * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-specified Service Account (SA) credentials to be used when
   * actuating resources.
   * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
   * </pre>
   *
   * <code>
   * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMPORT_EXISTING_RESOURCES_FIELD_NUMBER = 17;
  private boolean importExistingResources_ = false;
  /**
   *
   *
   * <pre>
   * By default, Infra Manager will return a failure when
   * Terraform encounters a 409 code (resource conflict error) during actuation.
   * If this flag is set to true, Infra Manager will instead
   * attempt to automatically import the resource into the Terraform state (for
   * supported resource types) and continue actuation.
   *
   * Not all resource types are supported, refer to documentation.
   * </pre>
   *
   * <code>optional bool import_existing_resources = 17;</code>
   *
   * @return Whether the importExistingResources field is set.
   */
  @java.lang.Override
  public boolean hasImportExistingResources() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * By default, Infra Manager will return a failure when
   * Terraform encounters a 409 code (resource conflict error) during actuation.
   * If this flag is set to true, Infra Manager will instead
   * attempt to automatically import the resource into the Terraform state (for
   * supported resource types) and continue actuation.
   *
   * Not all resource types are supported, refer to documentation.
   * </pre>
   *
   * <code>optional bool import_existing_resources = 17;</code>
   *
   * @return The importExistingResources.
   */
  @java.lang.Override
  public boolean getImportExistingResources() {
    return importExistingResources_;
  }

  public static final int WORKER_POOL_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workerPool_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The user-specified Cloud Build worker pool resource in which the
   * Cloud Build job will execute. Format:
   * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
   * If this field is unspecified, the default Cloud Build worker pool will be
   * used.
   * </pre>
   *
   * <code>
   * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the workerPool field is set.
   */
  @java.lang.Override
  public boolean hasWorkerPool() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The user-specified Cloud Build worker pool resource in which the
   * Cloud Build job will execute. Format:
   * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
   * If this field is unspecified, the default Cloud Build worker pool will be
   * used.
   * </pre>
   *
   * <code>
   * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workerPool.
   */
  @java.lang.Override
  public java.lang.String getWorkerPool() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workerPool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The user-specified Cloud Build worker pool resource in which the
   * Cloud Build job will execute. Format:
   * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
   * If this field is unspecified, the default Cloud Build worker pool will be
   * used.
   * </pre>
   *
   * <code>
   * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workerPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkerPoolBytes() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workerPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCK_STATE_FIELD_NUMBER = 20;
  private int lockState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current lock state of the deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Deployment.LockState lock_state = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for lockState.
   */
  @java.lang.Override
  public int getLockStateValue() {
    return lockState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current lock state of the deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Deployment.LockState lock_state = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lockState.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Deployment.LockState getLockState() {
    com.google.cloud.config.v1.Deployment.LockState result =
        com.google.cloud.config.v1.Deployment.LockState.forNumber(lockState_);
    return result == null ? com.google.cloud.config.v1.Deployment.LockState.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (state_ != com.google.cloud.config.v1.Deployment.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (blueprintCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.config.v1.TerraformBlueprint) blueprint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestRevision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, latestRevision_);
    }
    if (deleteResults_ != null) {
      output.writeMessage(8, getDeleteResults());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDetail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, stateDetail_);
    }
    if (errorCode_
        != com.google.cloud.config.v1.Deployment.ErrorCode.ERROR_CODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deleteBuild_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, deleteBuild_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deleteLogs_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, deleteLogs_);
    }
    for (int i = 0; i < tfErrors_.size(); i++) {
      output.writeMessage(13, tfErrors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorLogs_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, errorLogs_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, artifactsGcsBucket_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, serviceAccount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(17, importExistingResources_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, workerPool_);
    }
    if (lockState_
        != com.google.cloud.config.v1.Deployment.LockState.LOCK_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(20, lockState_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (state_ != com.google.cloud.config.v1.Deployment.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (blueprintCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.config.v1.TerraformBlueprint) blueprint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestRevision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, latestRevision_);
    }
    if (deleteResults_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDeleteResults());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDetail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, stateDetail_);
    }
    if (errorCode_
        != com.google.cloud.config.v1.Deployment.ErrorCode.ERROR_CODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deleteBuild_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, deleteBuild_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deleteLogs_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, deleteLogs_);
    }
    for (int i = 0; i < tfErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, tfErrors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorLogs_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, errorLogs_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, artifactsGcsBucket_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, serviceAccount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(17, importExistingResources_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, workerPool_);
    }
    if (lockState_
        != com.google.cloud.config.v1.Deployment.LockState.LOCK_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(20, lockState_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.config.v1.Deployment)) {
      return super.equals(obj);
    }
    com.google.cloud.config.v1.Deployment other = (com.google.cloud.config.v1.Deployment) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (state_ != other.state_) return false;
    if (!getLatestRevision().equals(other.getLatestRevision())) return false;
    if (!getStateDetail().equals(other.getStateDetail())) return false;
    if (errorCode_ != other.errorCode_) return false;
    if (hasDeleteResults() != other.hasDeleteResults()) return false;
    if (hasDeleteResults()) {
      if (!getDeleteResults().equals(other.getDeleteResults())) return false;
    }
    if (!getDeleteBuild().equals(other.getDeleteBuild())) return false;
    if (!getDeleteLogs().equals(other.getDeleteLogs())) return false;
    if (!getTfErrorsList().equals(other.getTfErrorsList())) return false;
    if (!getErrorLogs().equals(other.getErrorLogs())) return false;
    if (hasArtifactsGcsBucket() != other.hasArtifactsGcsBucket()) return false;
    if (hasArtifactsGcsBucket()) {
      if (!getArtifactsGcsBucket().equals(other.getArtifactsGcsBucket())) return false;
    }
    if (hasServiceAccount() != other.hasServiceAccount()) return false;
    if (hasServiceAccount()) {
      if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    }
    if (hasImportExistingResources() != other.hasImportExistingResources()) return false;
    if (hasImportExistingResources()) {
      if (getImportExistingResources() != other.getImportExistingResources()) return false;
    }
    if (hasWorkerPool() != other.hasWorkerPool()) return false;
    if (hasWorkerPool()) {
      if (!getWorkerPool().equals(other.getWorkerPool())) return false;
    }
    if (lockState_ != other.lockState_) return false;
    if (!getBlueprintCase().equals(other.getBlueprintCase())) return false;
    switch (blueprintCase_) {
      case 6:
        if (!getTerraformBlueprint().equals(other.getTerraformBlueprint())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + LATEST_REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getLatestRevision().hashCode();
    hash = (37 * hash) + STATE_DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getStateDetail().hashCode();
    hash = (37 * hash) + ERROR_CODE_FIELD_NUMBER;
    hash = (53 * hash) + errorCode_;
    if (hasDeleteResults()) {
      hash = (37 * hash) + DELETE_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteResults().hashCode();
    }
    hash = (37 * hash) + DELETE_BUILD_FIELD_NUMBER;
    hash = (53 * hash) + getDeleteBuild().hashCode();
    hash = (37 * hash) + DELETE_LOGS_FIELD_NUMBER;
    hash = (53 * hash) + getDeleteLogs().hashCode();
    if (getTfErrorsCount() > 0) {
      hash = (37 * hash) + TF_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getTfErrorsList().hashCode();
    }
    hash = (37 * hash) + ERROR_LOGS_FIELD_NUMBER;
    hash = (53 * hash) + getErrorLogs().hashCode();
    if (hasArtifactsGcsBucket()) {
      hash = (37 * hash) + ARTIFACTS_GCS_BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getArtifactsGcsBucket().hashCode();
    }
    if (hasServiceAccount()) {
      hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccount().hashCode();
    }
    if (hasImportExistingResources()) {
      hash = (37 * hash) + IMPORT_EXISTING_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportExistingResources());
    }
    if (hasWorkerPool()) {
      hash = (37 * hash) + WORKER_POOL_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerPool().hashCode();
    }
    hash = (37 * hash) + LOCK_STATE_FIELD_NUMBER;
    hash = (53 * hash) + lockState_;
    switch (blueprintCase_) {
      case 6:
        hash = (37 * hash) + TERRAFORM_BLUEPRINT_FIELD_NUMBER;
        hash = (53 * hash) + getTerraformBlueprint().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Deployment parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Deployment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Deployment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.config.v1.Deployment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Deployment is a group of resources and configs managed and provisioned by
   * Infra Manager.
   * </pre>
   *
   * Protobuf type {@code google.cloud.config.v1.Deployment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.config.v1.Deployment)
      com.google.cloud.config.v1.DeploymentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Deployment_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Deployment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.config.v1.Deployment.class,
              com.google.cloud.config.v1.Deployment.Builder.class);
    }

    // Construct using com.google.cloud.config.v1.Deployment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (terraformBlueprintBuilder_ != null) {
        terraformBlueprintBuilder_.clear();
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      state_ = 0;
      latestRevision_ = "";
      stateDetail_ = "";
      errorCode_ = 0;
      deleteResults_ = null;
      if (deleteResultsBuilder_ != null) {
        deleteResultsBuilder_.dispose();
        deleteResultsBuilder_ = null;
      }
      deleteBuild_ = "";
      deleteLogs_ = "";
      if (tfErrorsBuilder_ == null) {
        tfErrors_ = java.util.Collections.emptyList();
      } else {
        tfErrors_ = null;
        tfErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      errorLogs_ = "";
      artifactsGcsBucket_ = "";
      serviceAccount_ = "";
      importExistingResources_ = false;
      workerPool_ = "";
      lockState_ = 0;
      blueprintCase_ = 0;
      blueprint_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Deployment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Deployment getDefaultInstanceForType() {
      return com.google.cloud.config.v1.Deployment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Deployment build() {
      com.google.cloud.config.v1.Deployment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Deployment buildPartial() {
      com.google.cloud.config.v1.Deployment result =
          new com.google.cloud.config.v1.Deployment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.config.v1.Deployment result) {
      if (tfErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          tfErrors_ = java.util.Collections.unmodifiableList(tfErrors_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.tfErrors_ = tfErrors_;
      } else {
        result.tfErrors_ = tfErrorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.config.v1.Deployment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.latestRevision_ = latestRevision_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.stateDetail_ = stateDetail_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.errorCode_ = errorCode_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.deleteResults_ =
            deleteResultsBuilder_ == null ? deleteResults_ : deleteResultsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.deleteBuild_ = deleteBuild_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.deleteLogs_ = deleteLogs_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.errorLogs_ = errorLogs_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.artifactsGcsBucket_ = artifactsGcsBucket_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.importExistingResources_ = importExistingResources_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.workerPool_ = workerPool_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.lockState_ = lockState_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.config.v1.Deployment result) {
      result.blueprintCase_ = blueprintCase_;
      result.blueprint_ = this.blueprint_;
      if (blueprintCase_ == 6 && terraformBlueprintBuilder_ != null) {
        result.blueprint_ = terraformBlueprintBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.config.v1.Deployment) {
        return mergeFrom((com.google.cloud.config.v1.Deployment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.config.v1.Deployment other) {
      if (other == com.google.cloud.config.v1.Deployment.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getLatestRevision().isEmpty()) {
        latestRevision_ = other.latestRevision_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getStateDetail().isEmpty()) {
        stateDetail_ = other.stateDetail_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.errorCode_ != 0) {
        setErrorCodeValue(other.getErrorCodeValue());
      }
      if (other.hasDeleteResults()) {
        mergeDeleteResults(other.getDeleteResults());
      }
      if (!other.getDeleteBuild().isEmpty()) {
        deleteBuild_ = other.deleteBuild_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getDeleteLogs().isEmpty()) {
        deleteLogs_ = other.deleteLogs_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (tfErrorsBuilder_ == null) {
        if (!other.tfErrors_.isEmpty()) {
          if (tfErrors_.isEmpty()) {
            tfErrors_ = other.tfErrors_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureTfErrorsIsMutable();
            tfErrors_.addAll(other.tfErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.tfErrors_.isEmpty()) {
          if (tfErrorsBuilder_.isEmpty()) {
            tfErrorsBuilder_.dispose();
            tfErrorsBuilder_ = null;
            tfErrors_ = other.tfErrors_;
            bitField0_ = (bitField0_ & ~0x00001000);
            tfErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTfErrorsFieldBuilder()
                    : null;
          } else {
            tfErrorsBuilder_.addAllMessages(other.tfErrors_);
          }
        }
      }
      if (!other.getErrorLogs().isEmpty()) {
        errorLogs_ = other.errorLogs_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasArtifactsGcsBucket()) {
        artifactsGcsBucket_ = other.artifactsGcsBucket_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasServiceAccount()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasImportExistingResources()) {
        setImportExistingResources(other.getImportExistingResources());
      }
      if (other.hasWorkerPool()) {
        workerPool_ = other.workerPool_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.lockState_ != 0) {
        setLockStateValue(other.getLockStateValue());
      }
      switch (other.getBlueprintCase()) {
        case TERRAFORM_BLUEPRINT:
          {
            mergeTerraformBlueprint(other.getTerraformBlueprint());
            break;
          }
        case BLUEPRINT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(
                    getTerraformBlueprintFieldBuilder().getBuilder(), extensionRegistry);
                blueprintCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                latestRevision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDeleteResultsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                stateDetail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 80:
              {
                errorCode_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 90:
              {
                deleteBuild_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                deleteLogs_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                com.google.cloud.config.v1.TerraformError m =
                    input.readMessage(
                        com.google.cloud.config.v1.TerraformError.parser(), extensionRegistry);
                if (tfErrorsBuilder_ == null) {
                  ensureTfErrorsIsMutable();
                  tfErrors_.add(m);
                } else {
                  tfErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                errorLogs_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                artifactsGcsBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 136:
              {
                importExistingResources_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case 136
            case 154:
              {
                workerPool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 154
            case 160:
              {
                lockState_ = input.readEnum();
                bitField0_ |= 0x00040000;
                break;
              } // case 160
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int blueprintCase_ = 0;
    private java.lang.Object blueprint_;

    public BlueprintCase getBlueprintCase() {
      return BlueprintCase.forNumber(blueprintCase_);
    }

    public Builder clearBlueprint() {
      blueprintCase_ = 0;
      blueprint_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.TerraformBlueprint,
            com.google.cloud.config.v1.TerraformBlueprint.Builder,
            com.google.cloud.config.v1.TerraformBlueprintOrBuilder>
        terraformBlueprintBuilder_;
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     *
     * @return Whether the terraformBlueprint field is set.
     */
    @java.lang.Override
    public boolean hasTerraformBlueprint() {
      return blueprintCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     *
     * @return The terraformBlueprint.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.TerraformBlueprint getTerraformBlueprint() {
      if (terraformBlueprintBuilder_ == null) {
        if (blueprintCase_ == 6) {
          return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
        }
        return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
      } else {
        if (blueprintCase_ == 6) {
          return terraformBlueprintBuilder_.getMessage();
        }
        return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     */
    public Builder setTerraformBlueprint(com.google.cloud.config.v1.TerraformBlueprint value) {
      if (terraformBlueprintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        blueprint_ = value;
        onChanged();
      } else {
        terraformBlueprintBuilder_.setMessage(value);
      }
      blueprintCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     */
    public Builder setTerraformBlueprint(
        com.google.cloud.config.v1.TerraformBlueprint.Builder builderForValue) {
      if (terraformBlueprintBuilder_ == null) {
        blueprint_ = builderForValue.build();
        onChanged();
      } else {
        terraformBlueprintBuilder_.setMessage(builderForValue.build());
      }
      blueprintCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     */
    public Builder mergeTerraformBlueprint(com.google.cloud.config.v1.TerraformBlueprint value) {
      if (terraformBlueprintBuilder_ == null) {
        if (blueprintCase_ == 6
            && blueprint_ != com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance()) {
          blueprint_ =
              com.google.cloud.config.v1.TerraformBlueprint.newBuilder(
                      (com.google.cloud.config.v1.TerraformBlueprint) blueprint_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          blueprint_ = value;
        }
        onChanged();
      } else {
        if (blueprintCase_ == 6) {
          terraformBlueprintBuilder_.mergeFrom(value);
        } else {
          terraformBlueprintBuilder_.setMessage(value);
        }
      }
      blueprintCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     */
    public Builder clearTerraformBlueprint() {
      if (terraformBlueprintBuilder_ == null) {
        if (blueprintCase_ == 6) {
          blueprintCase_ = 0;
          blueprint_ = null;
          onChanged();
        }
      } else {
        if (blueprintCase_ == 6) {
          blueprintCase_ = 0;
          blueprint_ = null;
        }
        terraformBlueprintBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     */
    public com.google.cloud.config.v1.TerraformBlueprint.Builder getTerraformBlueprintBuilder() {
      return getTerraformBlueprintFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.config.v1.TerraformBlueprintOrBuilder getTerraformBlueprintOrBuilder() {
      if ((blueprintCase_ == 6) && (terraformBlueprintBuilder_ != null)) {
        return terraformBlueprintBuilder_.getMessageOrBuilder();
      } else {
        if (blueprintCase_ == 6) {
          return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
        }
        return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A blueprint described using Terraform's HashiCorp Configuration Language
     * as a root module.
     * </pre>
     *
     * <code>.google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.TerraformBlueprint,
            com.google.cloud.config.v1.TerraformBlueprint.Builder,
            com.google.cloud.config.v1.TerraformBlueprintOrBuilder>
        getTerraformBlueprintFieldBuilder() {
      if (terraformBlueprintBuilder_ == null) {
        if (!(blueprintCase_ == 6)) {
          blueprint_ = com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
        }
        terraformBlueprintBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.config.v1.TerraformBlueprint,
                com.google.cloud.config.v1.TerraformBlueprint.Builder,
                com.google.cloud.config.v1.TerraformBlueprintOrBuilder>(
                (com.google.cloud.config.v1.TerraformBlueprint) blueprint_,
                getParentForChildren(),
                isClean());
        blueprint_ = null;
      }
      blueprintCase_ = 6;
      onChanged();
      return terraformBlueprintBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of the deployment.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the deployment.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the deployment.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the deployment.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the deployment.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the deployment was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-defined metadata for the deployment.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined metadata for the deployment.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined metadata for the deployment.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-defined metadata for the deployment.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined metadata for the deployment.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined metadata for the deployment.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined metadata for the deployment.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Deployment.State getState() {
      com.google.cloud.config.v1.Deployment.State result =
          com.google.cloud.config.v1.Deployment.State.forNumber(state_);
      return result == null ? com.google.cloud.config.v1.Deployment.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.config.v1.Deployment.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object latestRevision_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Revision name that was most recently applied.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string latest_revision = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The latestRevision.
     */
    public java.lang.String getLatestRevision() {
      java.lang.Object ref = latestRevision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestRevision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision name that was most recently applied.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string latest_revision = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for latestRevision.
     */
    public com.google.protobuf.ByteString getLatestRevisionBytes() {
      java.lang.Object ref = latestRevision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestRevision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision name that was most recently applied.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string latest_revision = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The latestRevision to set.
     * @return This builder for chaining.
     */
    public Builder setLatestRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestRevision_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision name that was most recently applied.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string latest_revision = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestRevision() {
      latestRevision_ = getDefaultInstance().getLatestRevision();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision name that was most recently applied.
     * Format: `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string latest_revision = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for latestRevision to set.
     * @return This builder for chaining.
     */
    public Builder setLatestRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestRevision_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object stateDetail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateDetail.
     */
    public java.lang.String getStateDetail() {
      java.lang.Object ref = stateDetail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateDetail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateDetail.
     */
    public com.google.protobuf.ByteString getStateDetailBytes() {
      java.lang.Object ref = stateDetail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateDetail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStateDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateDetail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateDetail() {
      stateDetail_ = getDefaultInstance().getStateDetail();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStateDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateDetail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int errorCode_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Error code describing errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.ErrorCode error_code = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for errorCode.
     */
    @java.lang.Override
    public int getErrorCodeValue() {
      return errorCode_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error code describing errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.ErrorCode error_code = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCodeValue(int value) {
      errorCode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error code describing errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.ErrorCode error_code = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The errorCode.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Deployment.ErrorCode getErrorCode() {
      com.google.cloud.config.v1.Deployment.ErrorCode result =
          com.google.cloud.config.v1.Deployment.ErrorCode.forNumber(errorCode_);
      return result == null ? com.google.cloud.config.v1.Deployment.ErrorCode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error code describing errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.ErrorCode error_code = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCode(com.google.cloud.config.v1.Deployment.ErrorCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      errorCode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error code describing errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.ErrorCode error_code = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorCode() {
      bitField0_ = (bitField0_ & ~0x00000100);
      errorCode_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.config.v1.ApplyResults deleteResults_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ApplyResults,
            com.google.cloud.config.v1.ApplyResults.Builder,
            com.google.cloud.config.v1.ApplyResultsOrBuilder>
        deleteResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteResults field is set.
     */
    public boolean hasDeleteResults() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteResults.
     */
    public com.google.cloud.config.v1.ApplyResults getDeleteResults() {
      if (deleteResultsBuilder_ == null) {
        return deleteResults_ == null
            ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
            : deleteResults_;
      } else {
        return deleteResultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteResults(com.google.cloud.config.v1.ApplyResults value) {
      if (deleteResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteResults_ = value;
      } else {
        deleteResultsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteResults(
        com.google.cloud.config.v1.ApplyResults.Builder builderForValue) {
      if (deleteResultsBuilder_ == null) {
        deleteResults_ = builderForValue.build();
      } else {
        deleteResultsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteResults(com.google.cloud.config.v1.ApplyResults value) {
      if (deleteResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && deleteResults_ != null
            && deleteResults_ != com.google.cloud.config.v1.ApplyResults.getDefaultInstance()) {
          getDeleteResultsBuilder().mergeFrom(value);
        } else {
          deleteResults_ = value;
        }
      } else {
        deleteResultsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteResults() {
      bitField0_ = (bitField0_ & ~0x00000200);
      deleteResults_ = null;
      if (deleteResultsBuilder_ != null) {
        deleteResultsBuilder_.dispose();
        deleteResultsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.ApplyResults.Builder getDeleteResultsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDeleteResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.ApplyResultsOrBuilder getDeleteResultsOrBuilder() {
      if (deleteResultsBuilder_ != null) {
        return deleteResultsBuilder_.getMessageOrBuilder();
      } else {
        return deleteResults_ == null
            ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
            : deleteResults_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of artifacts from a DeleteDeployment operation.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults delete_results = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ApplyResults,
            com.google.cloud.config.v1.ApplyResults.Builder,
            com.google.cloud.config.v1.ApplyResultsOrBuilder>
        getDeleteResultsFieldBuilder() {
      if (deleteResultsBuilder_ == null) {
        deleteResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.config.v1.ApplyResults,
                com.google.cloud.config.v1.ApplyResults.Builder,
                com.google.cloud.config.v1.ApplyResultsOrBuilder>(
                getDeleteResults(), getParentForChildren(), isClean());
        deleteResults_ = null;
      }
      return deleteResultsBuilder_;
    }

    private java.lang.Object deleteBuild_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with deleting this
     * deployment.
     * </pre>
     *
     * <code>string delete_build = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The deleteBuild.
     */
    public java.lang.String getDeleteBuild() {
      java.lang.Object ref = deleteBuild_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deleteBuild_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with deleting this
     * deployment.
     * </pre>
     *
     * <code>string delete_build = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for deleteBuild.
     */
    public com.google.protobuf.ByteString getDeleteBuildBytes() {
      java.lang.Object ref = deleteBuild_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deleteBuild_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with deleting this
     * deployment.
     * </pre>
     *
     * <code>string delete_build = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The deleteBuild to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteBuild(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deleteBuild_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with deleting this
     * deployment.
     * </pre>
     *
     * <code>string delete_build = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleteBuild() {
      deleteBuild_ = getDefaultInstance().getDeleteBuild();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with deleting this
     * deployment.
     * </pre>
     *
     * <code>string delete_build = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for deleteBuild to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteBuildBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deleteBuild_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object deleteLogs_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Location of Cloud Build logs in Google Cloud Storage,
     * populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string delete_logs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The deleteLogs.
     */
    public java.lang.String getDeleteLogs() {
      java.lang.Object ref = deleteLogs_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deleteLogs_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Cloud Build logs in Google Cloud Storage,
     * populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string delete_logs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for deleteLogs.
     */
    public com.google.protobuf.ByteString getDeleteLogsBytes() {
      java.lang.Object ref = deleteLogs_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deleteLogs_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Cloud Build logs in Google Cloud Storage,
     * populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string delete_logs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The deleteLogs to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteLogs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deleteLogs_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Cloud Build logs in Google Cloud Storage,
     * populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string delete_logs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleteLogs() {
      deleteLogs_ = getDefaultInstance().getDeleteLogs();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Cloud Build logs in Google Cloud Storage,
     * populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string delete_logs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for deleteLogs to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteLogsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deleteLogs_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.config.v1.TerraformError> tfErrors_ =
        java.util.Collections.emptyList();

    private void ensureTfErrorsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        tfErrors_ = new java.util.ArrayList<com.google.cloud.config.v1.TerraformError>(tfErrors_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.config.v1.TerraformError,
            com.google.cloud.config.v1.TerraformError.Builder,
            com.google.cloud.config.v1.TerraformErrorOrBuilder>
        tfErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.config.v1.TerraformError> getTfErrorsList() {
      if (tfErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tfErrors_);
      } else {
        return tfErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getTfErrorsCount() {
      if (tfErrorsBuilder_ == null) {
        return tfErrors_.size();
      } else {
        return tfErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError getTfErrors(int index) {
      if (tfErrorsBuilder_ == null) {
        return tfErrors_.get(index);
      } else {
        return tfErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTfErrors(int index, com.google.cloud.config.v1.TerraformError value) {
      if (tfErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTfErrorsIsMutable();
        tfErrors_.set(index, value);
        onChanged();
      } else {
        tfErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTfErrors(
        int index, com.google.cloud.config.v1.TerraformError.Builder builderForValue) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        tfErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(com.google.cloud.config.v1.TerraformError value) {
      if (tfErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTfErrorsIsMutable();
        tfErrors_.add(value);
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(int index, com.google.cloud.config.v1.TerraformError value) {
      if (tfErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTfErrorsIsMutable();
        tfErrors_.add(index, value);
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(com.google.cloud.config.v1.TerraformError.Builder builderForValue) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.add(builderForValue.build());
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(
        int index, com.google.cloud.config.v1.TerraformError.Builder builderForValue) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllTfErrors(
        java.lang.Iterable<? extends com.google.cloud.config.v1.TerraformError> values) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tfErrors_);
        onChanged();
      } else {
        tfErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTfErrors() {
      if (tfErrorsBuilder_ == null) {
        tfErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        tfErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTfErrors(int index) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.remove(index);
        onChanged();
      } else {
        tfErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError.Builder getTfErrorsBuilder(int index) {
      return getTfErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformErrorOrBuilder getTfErrorsOrBuilder(int index) {
      if (tfErrorsBuilder_ == null) {
        return tfErrors_.get(index);
      } else {
        return tfErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.config.v1.TerraformErrorOrBuilder>
        getTfErrorsOrBuilderList() {
      if (tfErrorsBuilder_ != null) {
        return tfErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tfErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError.Builder addTfErrorsBuilder() {
      return getTfErrorsFieldBuilder()
          .addBuilder(com.google.cloud.config.v1.TerraformError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError.Builder addTfErrorsBuilder(int index) {
      return getTfErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.config.v1.TerraformError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when deleting this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.config.v1.TerraformError.Builder>
        getTfErrorsBuilderList() {
      return getTfErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.config.v1.TerraformError,
            com.google.cloud.config.v1.TerraformError.Builder,
            com.google.cloud.config.v1.TerraformErrorOrBuilder>
        getTfErrorsFieldBuilder() {
      if (tfErrorsBuilder_ == null) {
        tfErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.config.v1.TerraformError,
                com.google.cloud.config.v1.TerraformError.Builder,
                com.google.cloud.config.v1.TerraformErrorOrBuilder>(
                tfErrors_, ((bitField0_ & 0x00001000) != 0), getParentForChildren(), isClean());
        tfErrors_ = null;
      }
      return tfErrorsBuilder_;
    }

    private java.lang.Object errorLogs_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The errorLogs.
     */
    public java.lang.String getErrorLogs() {
      java.lang.Object ref = errorLogs_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorLogs_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for errorLogs.
     */
    public com.google.protobuf.ByteString getErrorLogsBytes() {
      java.lang.Object ref = errorLogs_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorLogs_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The errorLogs to set.
     * @return This builder for chaining.
     */
    public Builder setErrorLogs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorLogs_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorLogs() {
      errorLogs_ = getDefaultInstance().getErrorLogs();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for errorLogs to set.
     * @return This builder for chaining.
     */
    public Builder setErrorLogsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorLogs_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object artifactsGcsBucket_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-defined location of Cloud Build logs and artifacts in Google
     * Cloud Storage. Format: `gs://{bucket}/{folder}`
     *
     * A default bucket will be bootstrapped if the field is not set or empty.
     * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
     * Constraints:
     * - The bucket needs to be in the same project as the deployment
     * - The path cannot be within the path of `gcs_source`
     * - The field cannot be updated, including changing its presence
     * </pre>
     *
     * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the artifactsGcsBucket field is set.
     */
    public boolean hasArtifactsGcsBucket() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. User-defined location of Cloud Build logs and artifacts in Google
     * Cloud Storage. Format: `gs://{bucket}/{folder}`
     *
     * A default bucket will be bootstrapped if the field is not set or empty.
     * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
     * Constraints:
     * - The bucket needs to be in the same project as the deployment
     * - The path cannot be within the path of `gcs_source`
     * - The field cannot be updated, including changing its presence
     * </pre>
     *
     * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The artifactsGcsBucket.
     */
    public java.lang.String getArtifactsGcsBucket() {
      java.lang.Object ref = artifactsGcsBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactsGcsBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-defined location of Cloud Build logs and artifacts in Google
     * Cloud Storage. Format: `gs://{bucket}/{folder}`
     *
     * A default bucket will be bootstrapped if the field is not set or empty.
     * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
     * Constraints:
     * - The bucket needs to be in the same project as the deployment
     * - The path cannot be within the path of `gcs_source`
     * - The field cannot be updated, including changing its presence
     * </pre>
     *
     * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for artifactsGcsBucket.
     */
    public com.google.protobuf.ByteString getArtifactsGcsBucketBytes() {
      java.lang.Object ref = artifactsGcsBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactsGcsBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-defined location of Cloud Build logs and artifacts in Google
     * Cloud Storage. Format: `gs://{bucket}/{folder}`
     *
     * A default bucket will be bootstrapped if the field is not set or empty.
     * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
     * Constraints:
     * - The bucket needs to be in the same project as the deployment
     * - The path cannot be within the path of `gcs_source`
     * - The field cannot be updated, including changing its presence
     * </pre>
     *
     * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The artifactsGcsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactsGcsBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      artifactsGcsBucket_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-defined location of Cloud Build logs and artifacts in Google
     * Cloud Storage. Format: `gs://{bucket}/{folder}`
     *
     * A default bucket will be bootstrapped if the field is not set or empty.
     * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
     * Constraints:
     * - The bucket needs to be in the same project as the deployment
     * - The path cannot be within the path of `gcs_source`
     * - The field cannot be updated, including changing its presence
     * </pre>
     *
     * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArtifactsGcsBucket() {
      artifactsGcsBucket_ = getDefaultInstance().getArtifactsGcsBucket();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-defined location of Cloud Build logs and artifacts in Google
     * Cloud Storage. Format: `gs://{bucket}/{folder}`
     *
     * A default bucket will be bootstrapped if the field is not set or empty.
     * Default bucket format: `gs://&lt;project number&gt;-&lt;region&gt;-blueprint-config`
     * Constraints:
     * - The bucket needs to be in the same project as the deployment
     * - The path cannot be within the path of `gcs_source`
     * - The field cannot be updated, including changing its presence
     * </pre>
     *
     * <code>optional string artifacts_gcs_bucket = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for artifactsGcsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactsGcsBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      artifactsGcsBucket_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-specified Service Account (SA) credentials to be used when
     * actuating resources.
     * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the serviceAccount field is set.
     */
    public boolean hasServiceAccount() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. User-specified Service Account (SA) credentials to be used when
     * actuating resources.
     * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-specified Service Account (SA) credentials to be used when
     * actuating resources.
     * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-specified Service Account (SA) credentials to be used when
     * actuating resources.
     * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-specified Service Account (SA) credentials to be used when
     * actuating resources.
     * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-specified Service Account (SA) credentials to be used when
     * actuating resources.
     * Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * optional string service_account = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private boolean importExistingResources_;
    /**
     *
     *
     * <pre>
     * By default, Infra Manager will return a failure when
     * Terraform encounters a 409 code (resource conflict error) during actuation.
     * If this flag is set to true, Infra Manager will instead
     * attempt to automatically import the resource into the Terraform state (for
     * supported resource types) and continue actuation.
     *
     * Not all resource types are supported, refer to documentation.
     * </pre>
     *
     * <code>optional bool import_existing_resources = 17;</code>
     *
     * @return Whether the importExistingResources field is set.
     */
    @java.lang.Override
    public boolean hasImportExistingResources() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * By default, Infra Manager will return a failure when
     * Terraform encounters a 409 code (resource conflict error) during actuation.
     * If this flag is set to true, Infra Manager will instead
     * attempt to automatically import the resource into the Terraform state (for
     * supported resource types) and continue actuation.
     *
     * Not all resource types are supported, refer to documentation.
     * </pre>
     *
     * <code>optional bool import_existing_resources = 17;</code>
     *
     * @return The importExistingResources.
     */
    @java.lang.Override
    public boolean getImportExistingResources() {
      return importExistingResources_;
    }
    /**
     *
     *
     * <pre>
     * By default, Infra Manager will return a failure when
     * Terraform encounters a 409 code (resource conflict error) during actuation.
     * If this flag is set to true, Infra Manager will instead
     * attempt to automatically import the resource into the Terraform state (for
     * supported resource types) and continue actuation.
     *
     * Not all resource types are supported, refer to documentation.
     * </pre>
     *
     * <code>optional bool import_existing_resources = 17;</code>
     *
     * @param value The importExistingResources to set.
     * @return This builder for chaining.
     */
    public Builder setImportExistingResources(boolean value) {

      importExistingResources_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * By default, Infra Manager will return a failure when
     * Terraform encounters a 409 code (resource conflict error) during actuation.
     * If this flag is set to true, Infra Manager will instead
     * attempt to automatically import the resource into the Terraform state (for
     * supported resource types) and continue actuation.
     *
     * Not all resource types are supported, refer to documentation.
     * </pre>
     *
     * <code>optional bool import_existing_resources = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportExistingResources() {
      bitField0_ = (bitField0_ & ~0x00010000);
      importExistingResources_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object workerPool_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The user-specified Cloud Build worker pool resource in which the
     * Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the workerPool field is set.
     */
    public boolean hasWorkerPool() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-specified Cloud Build worker pool resource in which the
     * Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The workerPool.
     */
    public java.lang.String getWorkerPool() {
      java.lang.Object ref = workerPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workerPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-specified Cloud Build worker pool resource in which the
     * Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for workerPool.
     */
    public com.google.protobuf.ByteString getWorkerPoolBytes() {
      java.lang.Object ref = workerPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workerPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-specified Cloud Build worker pool resource in which the
     * Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workerPool_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-specified Cloud Build worker pool resource in which the
     * Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerPool() {
      workerPool_ = getDefaultInstance().getWorkerPool();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user-specified Cloud Build worker pool resource in which the
     * Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * optional string worker_pool = 19 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workerPool_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private int lockState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current lock state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.LockState lock_state = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for lockState.
     */
    @java.lang.Override
    public int getLockStateValue() {
      return lockState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current lock state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.LockState lock_state = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for lockState to set.
     * @return This builder for chaining.
     */
    public Builder setLockStateValue(int value) {
      lockState_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current lock state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.LockState lock_state = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lockState.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Deployment.LockState getLockState() {
      com.google.cloud.config.v1.Deployment.LockState result =
          com.google.cloud.config.v1.Deployment.LockState.forNumber(lockState_);
      return result == null ? com.google.cloud.config.v1.Deployment.LockState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current lock state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.LockState lock_state = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lockState to set.
     * @return This builder for chaining.
     */
    public Builder setLockState(com.google.cloud.config.v1.Deployment.LockState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00040000;
      lockState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current lock state of the deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Deployment.LockState lock_state = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLockState() {
      bitField0_ = (bitField0_ & ~0x00040000);
      lockState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.config.v1.Deployment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.config.v1.Deployment)
  private static final com.google.cloud.config.v1.Deployment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.config.v1.Deployment();
  }

  public static com.google.cloud.config.v1.Deployment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Deployment> PARSER =
      new com.google.protobuf.AbstractParser<Deployment>() {
        @java.lang.Override
        public Deployment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Deployment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Deployment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.config.v1.Deployment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
