/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/config/v1/config.proto

package com.google.cloud.config.v1;

/**
 *
 *
 * <pre>
 * Ephemeral metadata content describing the state of a deployment operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.config.v1.DeploymentOperationMetadata}
 */
public final class DeploymentOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.config.v1.DeploymentOperationMetadata)
    DeploymentOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeploymentOperationMetadata.newBuilder() to construct.
  private DeploymentOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeploymentOperationMetadata() {
    step_ = 0;
    build_ = "";
    logs_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeploymentOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_DeploymentOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_DeploymentOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.config.v1.DeploymentOperationMetadata.class,
            com.google.cloud.config.v1.DeploymentOperationMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The possible steps a deployment may be running.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep}
   */
  public enum DeploymentStep implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified deployment step
     * </pre>
     *
     * <code>DEPLOYMENT_STEP_UNSPECIFIED = 0;</code>
     */
    DEPLOYMENT_STEP_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Infra Manager is creating a Google Cloud Storage bucket to store
     * artifacts and metadata about the deployment and revision
     * </pre>
     *
     * <code>PREPARING_STORAGE_BUCKET = 1;</code>
     */
    PREPARING_STORAGE_BUCKET(1),
    /**
     *
     *
     * <pre>
     * Downloading the blueprint onto the Google Cloud Storage bucket
     * </pre>
     *
     * <code>DOWNLOADING_BLUEPRINT = 2;</code>
     */
    DOWNLOADING_BLUEPRINT(2),
    /**
     *
     *
     * <pre>
     * Initializing Terraform using `terraform init`
     * </pre>
     *
     * <code>RUNNING_TF_INIT = 3;</code>
     */
    RUNNING_TF_INIT(3),
    /**
     *
     *
     * <pre>
     * Running `terraform plan`
     * </pre>
     *
     * <code>RUNNING_TF_PLAN = 4;</code>
     */
    RUNNING_TF_PLAN(4),
    /**
     *
     *
     * <pre>
     * Actuating resources using Terraform using `terraform apply`
     * </pre>
     *
     * <code>RUNNING_TF_APPLY = 5;</code>
     */
    RUNNING_TF_APPLY(5),
    /**
     *
     *
     * <pre>
     * Destroying resources using Terraform using `terraform destroy`
     * </pre>
     *
     * <code>RUNNING_TF_DESTROY = 6;</code>
     */
    RUNNING_TF_DESTROY(6),
    /**
     *
     *
     * <pre>
     * Validating the uploaded TF state file when unlocking a deployment
     * </pre>
     *
     * <code>RUNNING_TF_VALIDATE = 7;</code>
     */
    RUNNING_TF_VALIDATE(7),
    /**
     *
     *
     * <pre>
     * Unlocking a deployment
     * </pre>
     *
     * <code>UNLOCKING_DEPLOYMENT = 8;</code>
     */
    UNLOCKING_DEPLOYMENT(8),
    /**
     *
     *
     * <pre>
     * Operation was successful
     * </pre>
     *
     * <code>SUCCEEDED = 9;</code>
     */
    SUCCEEDED(9),
    /**
     *
     *
     * <pre>
     * Operation failed
     * </pre>
     *
     * <code>FAILED = 10;</code>
     */
    FAILED(10),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified deployment step
     * </pre>
     *
     * <code>DEPLOYMENT_STEP_UNSPECIFIED = 0;</code>
     */
    public static final int DEPLOYMENT_STEP_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Infra Manager is creating a Google Cloud Storage bucket to store
     * artifacts and metadata about the deployment and revision
     * </pre>
     *
     * <code>PREPARING_STORAGE_BUCKET = 1;</code>
     */
    public static final int PREPARING_STORAGE_BUCKET_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Downloading the blueprint onto the Google Cloud Storage bucket
     * </pre>
     *
     * <code>DOWNLOADING_BLUEPRINT = 2;</code>
     */
    public static final int DOWNLOADING_BLUEPRINT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Initializing Terraform using `terraform init`
     * </pre>
     *
     * <code>RUNNING_TF_INIT = 3;</code>
     */
    public static final int RUNNING_TF_INIT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Running `terraform plan`
     * </pre>
     *
     * <code>RUNNING_TF_PLAN = 4;</code>
     */
    public static final int RUNNING_TF_PLAN_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Actuating resources using Terraform using `terraform apply`
     * </pre>
     *
     * <code>RUNNING_TF_APPLY = 5;</code>
     */
    public static final int RUNNING_TF_APPLY_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Destroying resources using Terraform using `terraform destroy`
     * </pre>
     *
     * <code>RUNNING_TF_DESTROY = 6;</code>
     */
    public static final int RUNNING_TF_DESTROY_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Validating the uploaded TF state file when unlocking a deployment
     * </pre>
     *
     * <code>RUNNING_TF_VALIDATE = 7;</code>
     */
    public static final int RUNNING_TF_VALIDATE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Unlocking a deployment
     * </pre>
     *
     * <code>UNLOCKING_DEPLOYMENT = 8;</code>
     */
    public static final int UNLOCKING_DEPLOYMENT_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Operation was successful
     * </pre>
     *
     * <code>SUCCEEDED = 9;</code>
     */
    public static final int SUCCEEDED_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Operation failed
     * </pre>
     *
     * <code>FAILED = 10;</code>
     */
    public static final int FAILED_VALUE = 10;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeploymentStep valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DeploymentStep forNumber(int value) {
      switch (value) {
        case 0:
          return DEPLOYMENT_STEP_UNSPECIFIED;
        case 1:
          return PREPARING_STORAGE_BUCKET;
        case 2:
          return DOWNLOADING_BLUEPRINT;
        case 3:
          return RUNNING_TF_INIT;
        case 4:
          return RUNNING_TF_PLAN;
        case 5:
          return RUNNING_TF_APPLY;
        case 6:
          return RUNNING_TF_DESTROY;
        case 7:
          return RUNNING_TF_VALIDATE;
        case 8:
          return UNLOCKING_DEPLOYMENT;
        case 9:
          return SUCCEEDED;
        case 10:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeploymentStep> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DeploymentStep> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DeploymentStep>() {
          public DeploymentStep findValueByNumber(int number) {
            return DeploymentStep.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.DeploymentOperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DeploymentStep[] VALUES = values();

    public static DeploymentStep valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeploymentStep(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep)
  }

  public static final int STEP_FIELD_NUMBER = 1;
  private int step_ = 0;
  /**
   *
   *
   * <pre>
   * The current step the deployment operation is running.
   * </pre>
   *
   * <code>.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep step = 1;</code>
   *
   * @return The enum numeric value on the wire for step.
   */
  @java.lang.Override
  public int getStepValue() {
    return step_;
  }
  /**
   *
   *
   * <pre>
   * The current step the deployment operation is running.
   * </pre>
   *
   * <code>.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep step = 1;</code>
   *
   * @return The step.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep getStep() {
    com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep result =
        com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep.forNumber(step_);
    return result == null
        ? com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep.UNRECOGNIZED
        : result;
  }

  public static final int APPLY_RESULTS_FIELD_NUMBER = 2;
  private com.google.cloud.config.v1.ApplyResults applyResults_;
  /**
   *
   *
   * <pre>
   * Outputs and artifacts from applying a deployment.
   * </pre>
   *
   * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
   *
   * @return Whether the applyResults field is set.
   */
  @java.lang.Override
  public boolean hasApplyResults() {
    return applyResults_ != null;
  }
  /**
   *
   *
   * <pre>
   * Outputs and artifacts from applying a deployment.
   * </pre>
   *
   * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
   *
   * @return The applyResults.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ApplyResults getApplyResults() {
    return applyResults_ == null
        ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
        : applyResults_;
  }
  /**
   *
   *
   * <pre>
   * Outputs and artifacts from applying a deployment.
   * </pre>
   *
   * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ApplyResultsOrBuilder getApplyResultsOrBuilder() {
    return applyResults_ == null
        ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
        : applyResults_;
  }

  public static final int BUILD_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object build_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Cloud Build instance UUID associated with this operation.
   * </pre>
   *
   * <code>string build = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The build.
   */
  @java.lang.Override
  public java.lang.String getBuild() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      build_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Build instance UUID associated with this operation.
   * </pre>
   *
   * <code>string build = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for build.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildBytes() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      build_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object logs_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Location of Deployment operations logs in
   * `gs://{bucket}/{object}` format.
   * </pre>
   *
   * <code>string logs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The logs.
   */
  @java.lang.Override
  public java.lang.String getLogs() {
    java.lang.Object ref = logs_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logs_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Location of Deployment operations logs in
   * `gs://{bucket}/{object}` format.
   * </pre>
   *
   * <code>string logs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for logs.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogsBytes() {
    java.lang.Object ref = logs_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logs_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (step_
        != com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep
            .DEPLOYMENT_STEP_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, step_);
    }
    if (applyResults_ != null) {
      output.writeMessage(2, getApplyResults());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, build_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logs_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, logs_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (step_
        != com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep
            .DEPLOYMENT_STEP_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, step_);
    }
    if (applyResults_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getApplyResults());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, build_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logs_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, logs_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.config.v1.DeploymentOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.config.v1.DeploymentOperationMetadata other =
        (com.google.cloud.config.v1.DeploymentOperationMetadata) obj;

    if (step_ != other.step_) return false;
    if (hasApplyResults() != other.hasApplyResults()) return false;
    if (hasApplyResults()) {
      if (!getApplyResults().equals(other.getApplyResults())) return false;
    }
    if (!getBuild().equals(other.getBuild())) return false;
    if (!getLogs().equals(other.getLogs())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STEP_FIELD_NUMBER;
    hash = (53 * hash) + step_;
    if (hasApplyResults()) {
      hash = (37 * hash) + APPLY_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getApplyResults().hashCode();
    }
    hash = (37 * hash) + BUILD_FIELD_NUMBER;
    hash = (53 * hash) + getBuild().hashCode();
    hash = (37 * hash) + LOGS_FIELD_NUMBER;
    hash = (53 * hash) + getLogs().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.config.v1.DeploymentOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Ephemeral metadata content describing the state of a deployment operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.config.v1.DeploymentOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.config.v1.DeploymentOperationMetadata)
      com.google.cloud.config.v1.DeploymentOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_DeploymentOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_DeploymentOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.config.v1.DeploymentOperationMetadata.class,
              com.google.cloud.config.v1.DeploymentOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.config.v1.DeploymentOperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      step_ = 0;
      applyResults_ = null;
      if (applyResultsBuilder_ != null) {
        applyResultsBuilder_.dispose();
        applyResultsBuilder_ = null;
      }
      build_ = "";
      logs_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_DeploymentOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.DeploymentOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.config.v1.DeploymentOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.config.v1.DeploymentOperationMetadata build() {
      com.google.cloud.config.v1.DeploymentOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.DeploymentOperationMetadata buildPartial() {
      com.google.cloud.config.v1.DeploymentOperationMetadata result =
          new com.google.cloud.config.v1.DeploymentOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.config.v1.DeploymentOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.step_ = step_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.applyResults_ =
            applyResultsBuilder_ == null ? applyResults_ : applyResultsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.build_ = build_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.logs_ = logs_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.config.v1.DeploymentOperationMetadata) {
        return mergeFrom((com.google.cloud.config.v1.DeploymentOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.config.v1.DeploymentOperationMetadata other) {
      if (other == com.google.cloud.config.v1.DeploymentOperationMetadata.getDefaultInstance())
        return this;
      if (other.step_ != 0) {
        setStepValue(other.getStepValue());
      }
      if (other.hasApplyResults()) {
        mergeApplyResults(other.getApplyResults());
      }
      if (!other.getBuild().isEmpty()) {
        build_ = other.build_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLogs().isEmpty()) {
        logs_ = other.logs_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                step_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getApplyResultsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                build_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                logs_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int step_ = 0;
    /**
     *
     *
     * <pre>
     * The current step the deployment operation is running.
     * </pre>
     *
     * <code>.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep step = 1;</code>
     *
     * @return The enum numeric value on the wire for step.
     */
    @java.lang.Override
    public int getStepValue() {
      return step_;
    }
    /**
     *
     *
     * <pre>
     * The current step the deployment operation is running.
     * </pre>
     *
     * <code>.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep step = 1;</code>
     *
     * @param value The enum numeric value on the wire for step to set.
     * @return This builder for chaining.
     */
    public Builder setStepValue(int value) {
      step_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current step the deployment operation is running.
     * </pre>
     *
     * <code>.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep step = 1;</code>
     *
     * @return The step.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep getStep() {
      com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep result =
          com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep.forNumber(step_);
      return result == null
          ? com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The current step the deployment operation is running.
     * </pre>
     *
     * <code>.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep step = 1;</code>
     *
     * @param value The step to set.
     * @return This builder for chaining.
     */
    public Builder setStep(
        com.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      step_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current step the deployment operation is running.
     * </pre>
     *
     * <code>.google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep step = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStep() {
      bitField0_ = (bitField0_ & ~0x00000001);
      step_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.config.v1.ApplyResults applyResults_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ApplyResults,
            com.google.cloud.config.v1.ApplyResults.Builder,
            com.google.cloud.config.v1.ApplyResultsOrBuilder>
        applyResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     *
     * @return Whether the applyResults field is set.
     */
    public boolean hasApplyResults() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     *
     * @return The applyResults.
     */
    public com.google.cloud.config.v1.ApplyResults getApplyResults() {
      if (applyResultsBuilder_ == null) {
        return applyResults_ == null
            ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
            : applyResults_;
      } else {
        return applyResultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     */
    public Builder setApplyResults(com.google.cloud.config.v1.ApplyResults value) {
      if (applyResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        applyResults_ = value;
      } else {
        applyResultsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     */
    public Builder setApplyResults(
        com.google.cloud.config.v1.ApplyResults.Builder builderForValue) {
      if (applyResultsBuilder_ == null) {
        applyResults_ = builderForValue.build();
      } else {
        applyResultsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     */
    public Builder mergeApplyResults(com.google.cloud.config.v1.ApplyResults value) {
      if (applyResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && applyResults_ != null
            && applyResults_ != com.google.cloud.config.v1.ApplyResults.getDefaultInstance()) {
          getApplyResultsBuilder().mergeFrom(value);
        } else {
          applyResults_ = value;
        }
      } else {
        applyResultsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     */
    public Builder clearApplyResults() {
      bitField0_ = (bitField0_ & ~0x00000002);
      applyResults_ = null;
      if (applyResultsBuilder_ != null) {
        applyResultsBuilder_.dispose();
        applyResultsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     */
    public com.google.cloud.config.v1.ApplyResults.Builder getApplyResultsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getApplyResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     */
    public com.google.cloud.config.v1.ApplyResultsOrBuilder getApplyResultsOrBuilder() {
      if (applyResultsBuilder_ != null) {
        return applyResultsBuilder_.getMessageOrBuilder();
      } else {
        return applyResults_ == null
            ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
            : applyResults_;
      }
    }
    /**
     *
     *
     * <pre>
     * Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>.google.cloud.config.v1.ApplyResults apply_results = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ApplyResults,
            com.google.cloud.config.v1.ApplyResults.Builder,
            com.google.cloud.config.v1.ApplyResultsOrBuilder>
        getApplyResultsFieldBuilder() {
      if (applyResultsBuilder_ == null) {
        applyResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.config.v1.ApplyResults,
                com.google.cloud.config.v1.ApplyResults.Builder,
                com.google.cloud.config.v1.ApplyResultsOrBuilder>(
                getApplyResults(), getParentForChildren(), isClean());
        applyResults_ = null;
      }
      return applyResultsBuilder_;
    }

    private java.lang.Object build_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this operation.
     * </pre>
     *
     * <code>string build = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The build.
     */
    public java.lang.String getBuild() {
      java.lang.Object ref = build_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        build_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this operation.
     * </pre>
     *
     * <code>string build = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for build.
     */
    public com.google.protobuf.ByteString getBuildBytes() {
      java.lang.Object ref = build_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        build_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this operation.
     * </pre>
     *
     * <code>string build = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The build to set.
     * @return This builder for chaining.
     */
    public Builder setBuild(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      build_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this operation.
     * </pre>
     *
     * <code>string build = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuild() {
      build_ = getDefaultInstance().getBuild();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this operation.
     * </pre>
     *
     * <code>string build = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for build to set.
     * @return This builder for chaining.
     */
    public Builder setBuildBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      build_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object logs_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Location of Deployment operations logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The logs.
     */
    public java.lang.String getLogs() {
      java.lang.Object ref = logs_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logs_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Deployment operations logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for logs.
     */
    public com.google.protobuf.ByteString getLogsBytes() {
      java.lang.Object ref = logs_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logs_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Deployment operations logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The logs to set.
     * @return This builder for chaining.
     */
    public Builder setLogs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      logs_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Deployment operations logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogs() {
      logs_ = getDefaultInstance().getLogs();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Deployment operations logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for logs to set.
     * @return This builder for chaining.
     */
    public Builder setLogsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      logs_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.config.v1.DeploymentOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.config.v1.DeploymentOperationMetadata)
  private static final com.google.cloud.config.v1.DeploymentOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.config.v1.DeploymentOperationMetadata();
  }

  public static com.google.cloud.config.v1.DeploymentOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeploymentOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<DeploymentOperationMetadata>() {
        @java.lang.Override
        public DeploymentOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeploymentOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeploymentOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.config.v1.DeploymentOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
