/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/config/v1/config.proto

package com.google.cloud.config.v1;

/**
 *
 *
 * <pre>
 * Resource represents a Google Cloud Platform resource actuated by IM.
 * Resources are child resources of Revisions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.config.v1.Resource}
 */
public final class Resource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.config.v1.Resource)
    ResourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Resource.newBuilder() to construct.
  private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Resource() {
    name_ = "";
    intent_ = 0;
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Resource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_Resource_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetCaiAssets();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_Resource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.config.v1.Resource.class,
            com.google.cloud.config.v1.Resource.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible intent of the resource.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Resource.Intent}
   */
  public enum Intent implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the intent is omitted.
     * </pre>
     *
     * <code>INTENT_UNSPECIFIED = 0;</code>
     */
    INTENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Infra Manager will create this Resource.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    CREATE(1),
    /**
     *
     *
     * <pre>
     * Infra Manager will update this Resource.
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    UPDATE(2),
    /**
     *
     *
     * <pre>
     * Infra Manager will delete this Resource.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    DELETE(3),
    /**
     *
     *
     * <pre>
     * Infra Manager will destroy and recreate this Resource.
     * </pre>
     *
     * <code>RECREATE = 4;</code>
     */
    RECREATE(4),
    /**
     *
     *
     * <pre>
     * Infra Manager will leave this Resource untouched.
     * </pre>
     *
     * <code>UNCHANGED = 5;</code>
     */
    UNCHANGED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the intent is omitted.
     * </pre>
     *
     * <code>INTENT_UNSPECIFIED = 0;</code>
     */
    public static final int INTENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Infra Manager will create this Resource.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    public static final int CREATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Infra Manager will update this Resource.
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    public static final int UPDATE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Infra Manager will delete this Resource.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    public static final int DELETE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Infra Manager will destroy and recreate this Resource.
     * </pre>
     *
     * <code>RECREATE = 4;</code>
     */
    public static final int RECREATE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Infra Manager will leave this Resource untouched.
     * </pre>
     *
     * <code>UNCHANGED = 5;</code>
     */
    public static final int UNCHANGED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Intent valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Intent forNumber(int value) {
      switch (value) {
        case 0:
          return INTENT_UNSPECIFIED;
        case 1:
          return CREATE;
        case 2:
          return UPDATE;
        case 3:
          return DELETE;
        case 4:
          return RECREATE;
        case 5:
          return UNCHANGED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Intent> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Intent> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Intent>() {
          public Intent findValueByNumber(int number) {
            return Intent.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Resource.getDescriptor().getEnumTypes().get(0);
    }

    private static final Intent[] VALUES = values();

    public static Intent valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Intent(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Resource.Intent)
  }

  /**
   *
   *
   * <pre>
   * Possible states of a resource.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Resource.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Resource has been planned for reconcile.
     * </pre>
     *
     * <code>PLANNED = 1;</code>
     */
    PLANNED(1),
    /**
     *
     *
     * <pre>
     * Resource is actively reconciling into the intended state.
     * </pre>
     *
     * <code>IN_PROGRESS = 2;</code>
     */
    IN_PROGRESS(2),
    /**
     *
     *
     * <pre>
     * Resource has reconciled to intended state.
     * </pre>
     *
     * <code>RECONCILED = 3;</code>
     */
    RECONCILED(3),
    /**
     *
     *
     * <pre>
     * Resource failed to reconcile.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Resource has been planned for reconcile.
     * </pre>
     *
     * <code>PLANNED = 1;</code>
     */
    public static final int PLANNED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Resource is actively reconciling into the intended state.
     * </pre>
     *
     * <code>IN_PROGRESS = 2;</code>
     */
    public static final int IN_PROGRESS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Resource has reconciled to intended state.
     * </pre>
     *
     * <code>RECONCILED = 3;</code>
     */
    public static final int RECONCILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Resource failed to reconcile.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PLANNED;
        case 2:
          return IN_PROGRESS;
        case 3:
          return RECONCILED;
        case 4:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Resource.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Resource.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name.
   * Format:
   * `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name.
   * Format:
   * `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TERRAFORM_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.config.v1.ResourceTerraformInfo terraformInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Terraform-specific info if this resource was created using
   * Terraform.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the terraformInfo field is set.
   */
  @java.lang.Override
  public boolean hasTerraformInfo() {
    return terraformInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Terraform-specific info if this resource was created using
   * Terraform.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The terraformInfo.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ResourceTerraformInfo getTerraformInfo() {
    return terraformInfo_ == null
        ? com.google.cloud.config.v1.ResourceTerraformInfo.getDefaultInstance()
        : terraformInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Terraform-specific info if this resource was created using
   * Terraform.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ResourceTerraformInfoOrBuilder getTerraformInfoOrBuilder() {
    return terraformInfo_ == null
        ? com.google.cloud.config.v1.ResourceTerraformInfo.getDefaultInstance()
        : terraformInfo_;
  }

  public static final int CAI_ASSETS_FIELD_NUMBER = 3;

  private static final class CaiAssetsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>newDefaultInstance(
                    com.google.cloud.config.v1.ConfigProto
                        .internal_static_google_cloud_config_v1_Resource_CaiAssetsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.config.v1.ResourceCAIInfo.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
      caiAssets_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
      internalGetCaiAssets() {
    if (caiAssets_ == null) {
      return com.google.protobuf.MapField.emptyMapField(CaiAssetsDefaultEntryHolder.defaultEntry);
    }
    return caiAssets_;
  }

  public int getCaiAssetsCount() {
    return internalGetCaiAssets().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
   * ID). CAI type format follows
   * https://cloud.google.com/asset-inventory/docs/supported-asset-types
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsCaiAssets(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetCaiAssets().getMap().containsKey(key);
  }
  /** Use {@link #getCaiAssetsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
      getCaiAssets() {
    return getCaiAssetsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
   * ID). CAI type format follows
   * https://cloud.google.com/asset-inventory/docs/supported-asset-types
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
      getCaiAssetsMap() {
    return internalGetCaiAssets().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
   * ID). CAI type format follows
   * https://cloud.google.com/asset-inventory/docs/supported-asset-types
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.config.v1.ResourceCAIInfo getCaiAssetsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.config.v1.ResourceCAIInfo defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo> map =
        internalGetCaiAssets().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
   * ID). CAI type format follows
   * https://cloud.google.com/asset-inventory/docs/supported-asset-types
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ResourceCAIInfo getCaiAssetsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo> map =
        internalGetCaiAssets().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int INTENT_FIELD_NUMBER = 4;
  private int intent_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Intent of the resource.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Resource.Intent intent = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for intent.
   */
  @java.lang.Override
  public int getIntentValue() {
    return intent_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Intent of the resource.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Resource.Intent intent = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The intent.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Resource.Intent getIntent() {
    com.google.cloud.config.v1.Resource.Intent result =
        com.google.cloud.config.v1.Resource.Intent.forNumber(intent_);
    return result == null ? com.google.cloud.config.v1.Resource.Intent.UNRECOGNIZED : result;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the resource.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Resource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the resource.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Resource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Resource.State getState() {
    com.google.cloud.config.v1.Resource.State result =
        com.google.cloud.config.v1.Resource.State.forNumber(state_);
    return result == null ? com.google.cloud.config.v1.Resource.State.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (terraformInfo_ != null) {
      output.writeMessage(2, getTerraformInfo());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetCaiAssets(), CaiAssetsDefaultEntryHolder.defaultEntry, 3);
    if (intent_ != com.google.cloud.config.v1.Resource.Intent.INTENT_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, intent_);
    }
    if (state_ != com.google.cloud.config.v1.Resource.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (terraformInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTerraformInfo());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo> entry :
        internalGetCaiAssets().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
          caiAssets__ =
              CaiAssetsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, caiAssets__);
    }
    if (intent_ != com.google.cloud.config.v1.Resource.Intent.INTENT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, intent_);
    }
    if (state_ != com.google.cloud.config.v1.Resource.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.config.v1.Resource)) {
      return super.equals(obj);
    }
    com.google.cloud.config.v1.Resource other = (com.google.cloud.config.v1.Resource) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasTerraformInfo() != other.hasTerraformInfo()) return false;
    if (hasTerraformInfo()) {
      if (!getTerraformInfo().equals(other.getTerraformInfo())) return false;
    }
    if (!internalGetCaiAssets().equals(other.internalGetCaiAssets())) return false;
    if (intent_ != other.intent_) return false;
    if (state_ != other.state_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasTerraformInfo()) {
      hash = (37 * hash) + TERRAFORM_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getTerraformInfo().hashCode();
    }
    if (!internalGetCaiAssets().getMap().isEmpty()) {
      hash = (37 * hash) + CAI_ASSETS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCaiAssets().hashCode();
    }
    hash = (37 * hash) + INTENT_FIELD_NUMBER;
    hash = (53 * hash) + intent_;
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.config.v1.Resource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Resource parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Resource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Resource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.config.v1.Resource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Resource represents a Google Cloud Platform resource actuated by IM.
   * Resources are child resources of Revisions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.config.v1.Resource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.config.v1.Resource)
      com.google.cloud.config.v1.ResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Resource_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetCaiAssets();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableCaiAssets();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Resource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.config.v1.Resource.class,
              com.google.cloud.config.v1.Resource.Builder.class);
    }

    // Construct using com.google.cloud.config.v1.Resource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      terraformInfo_ = null;
      if (terraformInfoBuilder_ != null) {
        terraformInfoBuilder_.dispose();
        terraformInfoBuilder_ = null;
      }
      internalGetMutableCaiAssets().clear();
      intent_ = 0;
      state_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Resource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Resource getDefaultInstanceForType() {
      return com.google.cloud.config.v1.Resource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Resource build() {
      com.google.cloud.config.v1.Resource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Resource buildPartial() {
      com.google.cloud.config.v1.Resource result = new com.google.cloud.config.v1.Resource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.config.v1.Resource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.terraformInfo_ =
            terraformInfoBuilder_ == null ? terraformInfo_ : terraformInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.caiAssets_ = internalGetCaiAssets();
        result.caiAssets_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.intent_ = intent_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.config.v1.Resource) {
        return mergeFrom((com.google.cloud.config.v1.Resource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.config.v1.Resource other) {
      if (other == com.google.cloud.config.v1.Resource.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTerraformInfo()) {
        mergeTerraformInfo(other.getTerraformInfo());
      }
      internalGetMutableCaiAssets().mergeFrom(other.internalGetCaiAssets());
      bitField0_ |= 0x00000004;
      if (other.intent_ != 0) {
        setIntentValue(other.getIntentValue());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTerraformInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
                    caiAssets__ =
                        input.readMessage(
                            CaiAssetsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableCaiAssets()
                    .getMutableMap()
                    .put(caiAssets__.getKey(), caiAssets__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                intent_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.config.v1.ResourceTerraformInfo terraformInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ResourceTerraformInfo,
            com.google.cloud.config.v1.ResourceTerraformInfo.Builder,
            com.google.cloud.config.v1.ResourceTerraformInfoOrBuilder>
        terraformInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terraformInfo field is set.
     */
    public boolean hasTerraformInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terraformInfo.
     */
    public com.google.cloud.config.v1.ResourceTerraformInfo getTerraformInfo() {
      if (terraformInfoBuilder_ == null) {
        return terraformInfo_ == null
            ? com.google.cloud.config.v1.ResourceTerraformInfo.getDefaultInstance()
            : terraformInfo_;
      } else {
        return terraformInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerraformInfo(com.google.cloud.config.v1.ResourceTerraformInfo value) {
      if (terraformInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        terraformInfo_ = value;
      } else {
        terraformInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerraformInfo(
        com.google.cloud.config.v1.ResourceTerraformInfo.Builder builderForValue) {
      if (terraformInfoBuilder_ == null) {
        terraformInfo_ = builderForValue.build();
      } else {
        terraformInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTerraformInfo(com.google.cloud.config.v1.ResourceTerraformInfo value) {
      if (terraformInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && terraformInfo_ != null
            && terraformInfo_
                != com.google.cloud.config.v1.ResourceTerraformInfo.getDefaultInstance()) {
          getTerraformInfoBuilder().mergeFrom(value);
        } else {
          terraformInfo_ = value;
        }
      } else {
        terraformInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTerraformInfo() {
      bitField0_ = (bitField0_ & ~0x00000002);
      terraformInfo_ = null;
      if (terraformInfoBuilder_ != null) {
        terraformInfoBuilder_.dispose();
        terraformInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.ResourceTerraformInfo.Builder getTerraformInfoBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTerraformInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.ResourceTerraformInfoOrBuilder getTerraformInfoOrBuilder() {
      if (terraformInfoBuilder_ != null) {
        return terraformInfoBuilder_.getMessageOrBuilder();
      } else {
        return terraformInfo_ == null
            ? com.google.cloud.config.v1.ResourceTerraformInfo.getDefaultInstance()
            : terraformInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Terraform-specific info if this resource was created using
     * Terraform.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ResourceTerraformInfo terraform_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ResourceTerraformInfo,
            com.google.cloud.config.v1.ResourceTerraformInfo.Builder,
            com.google.cloud.config.v1.ResourceTerraformInfoOrBuilder>
        getTerraformInfoFieldBuilder() {
      if (terraformInfoBuilder_ == null) {
        terraformInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.config.v1.ResourceTerraformInfo,
                com.google.cloud.config.v1.ResourceTerraformInfo.Builder,
                com.google.cloud.config.v1.ResourceTerraformInfoOrBuilder>(
                getTerraformInfo(), getParentForChildren(), isClean());
        terraformInfo_ = null;
      }
      return terraformInfoBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
        caiAssets_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
        internalGetCaiAssets() {
      if (caiAssets_ == null) {
        return com.google.protobuf.MapField.emptyMapField(CaiAssetsDefaultEntryHolder.defaultEntry);
      }
      return caiAssets_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
        internalGetMutableCaiAssets() {
      if (caiAssets_ == null) {
        caiAssets_ =
            com.google.protobuf.MapField.newMapField(CaiAssetsDefaultEntryHolder.defaultEntry);
      }
      if (!caiAssets_.isMutable()) {
        caiAssets_ = caiAssets_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return caiAssets_;
    }

    public int getCaiAssetsCount() {
      return internalGetCaiAssets().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
     * ID). CAI type format follows
     * https://cloud.google.com/asset-inventory/docs/supported-asset-types
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsCaiAssets(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCaiAssets().getMap().containsKey(key);
    }
    /** Use {@link #getCaiAssetsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
        getCaiAssets() {
      return getCaiAssetsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
     * ID). CAI type format follows
     * https://cloud.google.com/asset-inventory/docs/supported-asset-types
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
        getCaiAssetsMap() {
      return internalGetCaiAssets().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
     * ID). CAI type format follows
     * https://cloud.google.com/asset-inventory/docs/supported-asset-types
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.config.v1.ResourceCAIInfo getCaiAssetsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.config.v1.ResourceCAIInfo defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo> map =
          internalGetCaiAssets().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
     * ID). CAI type format follows
     * https://cloud.google.com/asset-inventory/docs/supported-asset-types
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.config.v1.ResourceCAIInfo getCaiAssetsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo> map =
          internalGetCaiAssets().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearCaiAssets() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableCaiAssets().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
     * ID). CAI type format follows
     * https://cloud.google.com/asset-inventory/docs/supported-asset-types
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeCaiAssets(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableCaiAssets().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo>
        getMutableCaiAssets() {
      bitField0_ |= 0x00000004;
      return internalGetMutableCaiAssets().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
     * ID). CAI type format follows
     * https://cloud.google.com/asset-inventory/docs/supported-asset-types
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putCaiAssets(
        java.lang.String key, com.google.cloud.config.v1.ResourceCAIInfo value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableCaiAssets().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
     * ID). CAI type format follows
     * https://cloud.google.com/asset-inventory/docs/supported-asset-types
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.config.v1.ResourceCAIInfo&gt; cai_assets = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllCaiAssets(
        java.util.Map<java.lang.String, com.google.cloud.config.v1.ResourceCAIInfo> values) {
      internalGetMutableCaiAssets().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private int intent_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Intent of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.Intent intent = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for intent.
     */
    @java.lang.Override
    public int getIntentValue() {
      return intent_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Intent of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.Intent intent = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for intent to set.
     * @return This builder for chaining.
     */
    public Builder setIntentValue(int value) {
      intent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Intent of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.Intent intent = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The intent.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Resource.Intent getIntent() {
      com.google.cloud.config.v1.Resource.Intent result =
          com.google.cloud.config.v1.Resource.Intent.forNumber(intent_);
      return result == null ? com.google.cloud.config.v1.Resource.Intent.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Intent of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.Intent intent = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The intent to set.
     * @return This builder for chaining.
     */
    public Builder setIntent(com.google.cloud.config.v1.Resource.Intent value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      intent_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Intent of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.Intent intent = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntent() {
      bitField0_ = (bitField0_ & ~0x00000008);
      intent_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Resource.State getState() {
      com.google.cloud.config.v1.Resource.State result =
          com.google.cloud.config.v1.Resource.State.forNumber(state_);
      return result == null ? com.google.cloud.config.v1.Resource.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.config.v1.Resource.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the resource.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Resource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.config.v1.Resource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.config.v1.Resource)
  private static final com.google.cloud.config.v1.Resource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.config.v1.Resource();
  }

  public static com.google.cloud.config.v1.Resource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Resource> PARSER =
      new com.google.protobuf.AbstractParser<Resource>() {
        @java.lang.Override
        public Resource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Resource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Resource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.config.v1.Resource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
