/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/config/v1/config.proto

package com.google.cloud.config.v1;

/**
 *
 *
 * <pre>
 * A child resource of a Deployment generated by a 'CreateDeployment' or
 * 'UpdateDeployment' call. Each Revision contains metadata pertaining to a
 * snapshot of a particular Deployment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.config.v1.Revision}
 */
public final class Revision extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.config.v1.Revision)
    RevisionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Revision.newBuilder() to construct.
  private Revision(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Revision() {
    name_ = "";
    action_ = 0;
    state_ = 0;
    stateDetail_ = "";
    errorCode_ = 0;
    build_ = "";
    logs_ = "";
    tfErrors_ = java.util.Collections.emptyList();
    errorLogs_ = "";
    serviceAccount_ = "";
    workerPool_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Revision();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_Revision_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_Revision_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.config.v1.Revision.class,
            com.google.cloud.config.v1.Revision.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Actions that generate a revision.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Revision.Action}
   */
  public enum Action implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the action is omitted.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    ACTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The revision was generated by creating a deployment.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    CREATE(1),
    /**
     *
     *
     * <pre>
     * The revision was generated by updating a deployment.
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    UPDATE(2),
    /**
     *
     *
     * <pre>
     * The revision was deleted.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    DELETE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the action is omitted.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    public static final int ACTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The revision was generated by creating a deployment.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    public static final int CREATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The revision was generated by updating a deployment.
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    public static final int UPDATE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The revision was deleted.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    public static final int DELETE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Action forNumber(int value) {
      switch (value) {
        case 0:
          return ACTION_UNSPECIFIED;
        case 1:
          return CREATE;
        case 2:
          return UPDATE;
        case 3:
          return DELETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Action> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Action>() {
          public Action findValueByNumber(int number) {
            return Action.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Revision.getDescriptor().getEnumTypes().get(0);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Revision.Action)
  }

  /**
   *
   *
   * <pre>
   * Possible states of a revision.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Revision.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The revision is being applied.
     * </pre>
     *
     * <code>APPLYING = 1;</code>
     */
    APPLYING(1),
    /**
     *
     *
     * <pre>
     * The revision was applied successfully.
     * </pre>
     *
     * <code>APPLIED = 2;</code>
     */
    APPLIED(2),
    /**
     *
     *
     * <pre>
     * The revision could not be applied successfully.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The revision is being applied.
     * </pre>
     *
     * <code>APPLYING = 1;</code>
     */
    public static final int APPLYING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The revision was applied successfully.
     * </pre>
     *
     * <code>APPLIED = 2;</code>
     */
    public static final int APPLIED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The revision could not be applied successfully.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return APPLYING;
        case 2:
          return APPLIED;
        case 3:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Revision.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Revision.State)
  }

  /**
   *
   *
   * <pre>
   * Possible errors if Revision could not be created or updated successfully.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.config.v1.Revision.ErrorCode}
   */
  public enum ErrorCode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No error code was specified.
     * </pre>
     *
     * <code>ERROR_CODE_UNSPECIFIED = 0;</code>
     */
    ERROR_CODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Cloud Build failed due to a permission issue.
     * </pre>
     *
     * <code>CLOUD_BUILD_PERMISSION_DENIED = 1;</code>
     */
    CLOUD_BUILD_PERMISSION_DENIED(1),
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with creating or updating a deployment could
     * not be started.
     * </pre>
     *
     * <code>APPLY_BUILD_API_FAILED = 4;</code>
     */
    APPLY_BUILD_API_FAILED(4),
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with creating or updating a deployment was
     * started but failed.
     * </pre>
     *
     * <code>APPLY_BUILD_RUN_FAILED = 5;</code>
     */
    APPLY_BUILD_RUN_FAILED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No error code was specified.
     * </pre>
     *
     * <code>ERROR_CODE_UNSPECIFIED = 0;</code>
     */
    public static final int ERROR_CODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Cloud Build failed due to a permission issue.
     * </pre>
     *
     * <code>CLOUD_BUILD_PERMISSION_DENIED = 1;</code>
     */
    public static final int CLOUD_BUILD_PERMISSION_DENIED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with creating or updating a deployment could
     * not be started.
     * </pre>
     *
     * <code>APPLY_BUILD_API_FAILED = 4;</code>
     */
    public static final int APPLY_BUILD_API_FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Cloud Build job associated with creating or updating a deployment was
     * started but failed.
     * </pre>
     *
     * <code>APPLY_BUILD_RUN_FAILED = 5;</code>
     */
    public static final int APPLY_BUILD_RUN_FAILED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ErrorCode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ErrorCode forNumber(int value) {
      switch (value) {
        case 0:
          return ERROR_CODE_UNSPECIFIED;
        case 1:
          return CLOUD_BUILD_PERMISSION_DENIED;
        case 4:
          return APPLY_BUILD_API_FAILED;
        case 5:
          return APPLY_BUILD_RUN_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ErrorCode>() {
          public ErrorCode findValueByNumber(int number) {
            return ErrorCode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.config.v1.Revision.getDescriptor().getEnumTypes().get(2);
    }

    private static final ErrorCode[] VALUES = values();

    public static ErrorCode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ErrorCode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.config.v1.Revision.ErrorCode)
  }

  private int blueprintCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object blueprint_;

  public enum BlueprintCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TERRAFORM_BLUEPRINT(6),
    BLUEPRINT_NOT_SET(0);
    private final int value;

    private BlueprintCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BlueprintCase valueOf(int value) {
      return forNumber(value);
    }

    public static BlueprintCase forNumber(int value) {
      switch (value) {
        case 6:
          return TERRAFORM_BLUEPRINT;
        case 0:
          return BLUEPRINT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BlueprintCase getBlueprintCase() {
    return BlueprintCase.forNumber(blueprintCase_);
  }

  public static final int TERRAFORM_BLUEPRINT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Output only. A blueprint described using Terraform's HashiCorp
   * Configuration Language as a root module.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the terraformBlueprint field is set.
   */
  @java.lang.Override
  public boolean hasTerraformBlueprint() {
    return blueprintCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Output only. A blueprint described using Terraform's HashiCorp
   * Configuration Language as a root module.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The terraformBlueprint.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformBlueprint getTerraformBlueprint() {
    if (blueprintCase_ == 6) {
      return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
    }
    return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. A blueprint described using Terraform's HashiCorp
   * Configuration Language as a root module.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformBlueprintOrBuilder getTerraformBlueprintOrBuilder() {
    if (blueprintCase_ == 6) {
      return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
    }
    return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Revision name. Format:
   * `projects/{project}/locations/{location}/deployments/{deployment}/
   * revisions/{revision}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Revision name. Format:
   * `projects/{project}/locations/{location}/deployments/{deployment}/
   * revisions/{revision}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the revision was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the revision was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the revision was last modified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ACTION_FIELD_NUMBER = 4;
  private int action_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The action which created this revision
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Revision.Action action = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for action.
   */
  @java.lang.Override
  public int getActionValue() {
    return action_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The action which created this revision
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Revision.Action action = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Revision.Action getAction() {
    com.google.cloud.config.v1.Revision.Action result =
        com.google.cloud.config.v1.Revision.Action.forNumber(action_);
    return result == null ? com.google.cloud.config.v1.Revision.Action.UNRECOGNIZED : result;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the revision.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Revision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the revision.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Revision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Revision.State getState() {
    com.google.cloud.config.v1.Revision.State result =
        com.google.cloud.config.v1.Revision.State.forNumber(state_);
    return result == null ? com.google.cloud.config.v1.Revision.State.UNRECOGNIZED : result;
  }

  public static final int APPLY_RESULTS_FIELD_NUMBER = 7;
  private com.google.cloud.config.v1.ApplyResults applyResults_;
  /**
   *
   *
   * <pre>
   * Output only. Outputs and artifacts from applying a deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the applyResults field is set.
   */
  @java.lang.Override
  public boolean hasApplyResults() {
    return applyResults_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Outputs and artifacts from applying a deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The applyResults.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ApplyResults getApplyResults() {
    return applyResults_ == null
        ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
        : applyResults_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Outputs and artifacts from applying a deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.ApplyResultsOrBuilder getApplyResultsOrBuilder() {
    return applyResults_ == null
        ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
        : applyResults_;
  }

  public static final int STATE_DETAIL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateDetail_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional info regarding the current state.
   * </pre>
   *
   * <code>string state_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateDetail.
   */
  @java.lang.Override
  public java.lang.String getStateDetail() {
    java.lang.Object ref = stateDetail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateDetail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional info regarding the current state.
   * </pre>
   *
   * <code>string state_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateDetail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateDetailBytes() {
    java.lang.Object ref = stateDetail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateDetail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_CODE_FIELD_NUMBER = 9;
  private int errorCode_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Code describing any errors that may have occurred.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Revision.ErrorCode error_code = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for errorCode.
   */
  @java.lang.Override
  public int getErrorCodeValue() {
    return errorCode_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Code describing any errors that may have occurred.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.Revision.ErrorCode error_code = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The errorCode.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.Revision.ErrorCode getErrorCode() {
    com.google.cloud.config.v1.Revision.ErrorCode result =
        com.google.cloud.config.v1.Revision.ErrorCode.forNumber(errorCode_);
    return result == null ? com.google.cloud.config.v1.Revision.ErrorCode.UNRECOGNIZED : result;
  }

  public static final int BUILD_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object build_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Cloud Build instance UUID associated with this revision.
   * </pre>
   *
   * <code>string build = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The build.
   */
  @java.lang.Override
  public java.lang.String getBuild() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      build_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Build instance UUID associated with this revision.
   * </pre>
   *
   * <code>string build = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for build.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildBytes() {
    java.lang.Object ref = build_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      build_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOGS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object logs_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Location of Revision operation logs in
   * `gs://{bucket}/{object}` format.
   * </pre>
   *
   * <code>string logs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The logs.
   */
  @java.lang.Override
  public java.lang.String getLogs() {
    java.lang.Object ref = logs_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logs_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Location of Revision operation logs in
   * `gs://{bucket}/{object}` format.
   * </pre>
   *
   * <code>string logs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for logs.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogsBytes() {
    java.lang.Object ref = logs_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logs_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TF_ERRORS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.config.v1.TerraformError> tfErrors_;
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when creating or updating this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.config.v1.TerraformError> getTfErrorsList() {
    return tfErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when creating or updating this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.config.v1.TerraformErrorOrBuilder>
      getTfErrorsOrBuilderList() {
    return tfErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when creating or updating this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getTfErrorsCount() {
    return tfErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when creating or updating this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformError getTfErrors(int index) {
    return tfErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered when creating or updating this deployment.
   * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
   * for full details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformErrorOrBuilder getTfErrorsOrBuilder(int index) {
    return tfErrors_.get(index);
  }

  public static final int ERROR_LOGS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorLogs_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Location of Terraform error logs in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`.
   * </pre>
   *
   * <code>string error_logs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The errorLogs.
   */
  @java.lang.Override
  public java.lang.String getErrorLogs() {
    java.lang.Object ref = errorLogs_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorLogs_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Location of Terraform error logs in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`.
   * </pre>
   *
   * <code>string error_logs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for errorLogs.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorLogsBytes() {
    java.lang.Object ref = errorLogs_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorLogs_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Output only. User-specified Service Account (SA) to be used as credential
   * to manage resources. Format:
   * `projects/{projectID}/serviceAccounts/{serviceAccount}`
   * </pre>
   *
   * <code>
   * string service_account = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. User-specified Service Account (SA) to be used as credential
   * to manage resources. Format:
   * `projects/{projectID}/serviceAccounts/{serviceAccount}`
   * </pre>
   *
   * <code>
   * string service_account = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMPORT_EXISTING_RESOURCES_FIELD_NUMBER = 15;
  private boolean importExistingResources_ = false;
  /**
   *
   *
   * <pre>
   * Output only. By default, Infra Manager will return a failure when
   * Terraform encounters a 409 code (resource conflict error) during actuation.
   * If this flag is set to true, Infra Manager will instead
   * attempt to automatically import the resource into the Terraform state (for
   * supported resource types) and continue actuation.
   *
   * Not all resource types are supported, refer to documentation.
   * </pre>
   *
   * <code>bool import_existing_resources = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The importExistingResources.
   */
  @java.lang.Override
  public boolean getImportExistingResources() {
    return importExistingResources_;
  }

  public static final int WORKER_POOL_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workerPool_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The user-specified Cloud Build worker pool resource in which
   * the Cloud Build job will execute. Format:
   * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
   * If this field is unspecified, the default Cloud Build worker pool will be
   * used.
   * </pre>
   *
   * <code>
   * string worker_pool = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workerPool.
   */
  @java.lang.Override
  public java.lang.String getWorkerPool() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workerPool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The user-specified Cloud Build worker pool resource in which
   * the Cloud Build job will execute. Format:
   * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
   * If this field is unspecified, the default Cloud Build worker pool will be
   * used.
   * </pre>
   *
   * <code>
   * string worker_pool = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workerPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkerPoolBytes() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workerPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    if (action_ != com.google.cloud.config.v1.Revision.Action.ACTION_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, action_);
    }
    if (state_ != com.google.cloud.config.v1.Revision.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (blueprintCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.config.v1.TerraformBlueprint) blueprint_);
    }
    if (applyResults_ != null) {
      output.writeMessage(7, getApplyResults());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDetail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, stateDetail_);
    }
    if (errorCode_
        != com.google.cloud.config.v1.Revision.ErrorCode.ERROR_CODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, build_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logs_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, logs_);
    }
    for (int i = 0; i < tfErrors_.size(); i++) {
      output.writeMessage(12, tfErrors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorLogs_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, errorLogs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, serviceAccount_);
    }
    if (importExistingResources_ != false) {
      output.writeBool(15, importExistingResources_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, workerPool_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (action_ != com.google.cloud.config.v1.Revision.Action.ACTION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, action_);
    }
    if (state_ != com.google.cloud.config.v1.Revision.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (blueprintCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.config.v1.TerraformBlueprint) blueprint_);
    }
    if (applyResults_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getApplyResults());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDetail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, stateDetail_);
    }
    if (errorCode_
        != com.google.cloud.config.v1.Revision.ErrorCode.ERROR_CODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(build_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, build_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logs_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, logs_);
    }
    for (int i = 0; i < tfErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, tfErrors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorLogs_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, errorLogs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, serviceAccount_);
    }
    if (importExistingResources_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, importExistingResources_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, workerPool_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.config.v1.Revision)) {
      return super.equals(obj);
    }
    com.google.cloud.config.v1.Revision other = (com.google.cloud.config.v1.Revision) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (action_ != other.action_) return false;
    if (state_ != other.state_) return false;
    if (hasApplyResults() != other.hasApplyResults()) return false;
    if (hasApplyResults()) {
      if (!getApplyResults().equals(other.getApplyResults())) return false;
    }
    if (!getStateDetail().equals(other.getStateDetail())) return false;
    if (errorCode_ != other.errorCode_) return false;
    if (!getBuild().equals(other.getBuild())) return false;
    if (!getLogs().equals(other.getLogs())) return false;
    if (!getTfErrorsList().equals(other.getTfErrorsList())) return false;
    if (!getErrorLogs().equals(other.getErrorLogs())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (getImportExistingResources() != other.getImportExistingResources()) return false;
    if (!getWorkerPool().equals(other.getWorkerPool())) return false;
    if (!getBlueprintCase().equals(other.getBlueprintCase())) return false;
    switch (blueprintCase_) {
      case 6:
        if (!getTerraformBlueprint().equals(other.getTerraformBlueprint())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + action_;
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasApplyResults()) {
      hash = (37 * hash) + APPLY_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getApplyResults().hashCode();
    }
    hash = (37 * hash) + STATE_DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getStateDetail().hashCode();
    hash = (37 * hash) + ERROR_CODE_FIELD_NUMBER;
    hash = (53 * hash) + errorCode_;
    hash = (37 * hash) + BUILD_FIELD_NUMBER;
    hash = (53 * hash) + getBuild().hashCode();
    hash = (37 * hash) + LOGS_FIELD_NUMBER;
    hash = (53 * hash) + getLogs().hashCode();
    if (getTfErrorsCount() > 0) {
      hash = (37 * hash) + TF_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getTfErrorsList().hashCode();
    }
    hash = (37 * hash) + ERROR_LOGS_FIELD_NUMBER;
    hash = (53 * hash) + getErrorLogs().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + IMPORT_EXISTING_RESOURCES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportExistingResources());
    hash = (37 * hash) + WORKER_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getWorkerPool().hashCode();
    switch (blueprintCase_) {
      case 6:
        hash = (37 * hash) + TERRAFORM_BLUEPRINT_FIELD_NUMBER;
        hash = (53 * hash) + getTerraformBlueprint().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.config.v1.Revision parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Revision parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Revision parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.Revision parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.config.v1.Revision prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A child resource of a Deployment generated by a 'CreateDeployment' or
   * 'UpdateDeployment' call. Each Revision contains metadata pertaining to a
   * snapshot of a particular Deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.config.v1.Revision}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.config.v1.Revision)
      com.google.cloud.config.v1.RevisionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Revision_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Revision_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.config.v1.Revision.class,
              com.google.cloud.config.v1.Revision.Builder.class);
    }

    // Construct using com.google.cloud.config.v1.Revision.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (terraformBlueprintBuilder_ != null) {
        terraformBlueprintBuilder_.clear();
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      action_ = 0;
      state_ = 0;
      applyResults_ = null;
      if (applyResultsBuilder_ != null) {
        applyResultsBuilder_.dispose();
        applyResultsBuilder_ = null;
      }
      stateDetail_ = "";
      errorCode_ = 0;
      build_ = "";
      logs_ = "";
      if (tfErrorsBuilder_ == null) {
        tfErrors_ = java.util.Collections.emptyList();
      } else {
        tfErrors_ = null;
        tfErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      errorLogs_ = "";
      serviceAccount_ = "";
      importExistingResources_ = false;
      workerPool_ = "";
      blueprintCase_ = 0;
      blueprint_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_Revision_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Revision getDefaultInstanceForType() {
      return com.google.cloud.config.v1.Revision.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Revision build() {
      com.google.cloud.config.v1.Revision result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.Revision buildPartial() {
      com.google.cloud.config.v1.Revision result = new com.google.cloud.config.v1.Revision(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.config.v1.Revision result) {
      if (tfErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          tfErrors_ = java.util.Collections.unmodifiableList(tfErrors_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.tfErrors_ = tfErrors_;
      } else {
        result.tfErrors_ = tfErrorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.config.v1.Revision result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.action_ = action_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.applyResults_ =
            applyResultsBuilder_ == null ? applyResults_ : applyResultsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.stateDetail_ = stateDetail_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.errorCode_ = errorCode_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.build_ = build_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.logs_ = logs_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.errorLogs_ = errorLogs_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.importExistingResources_ = importExistingResources_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.workerPool_ = workerPool_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.config.v1.Revision result) {
      result.blueprintCase_ = blueprintCase_;
      result.blueprint_ = this.blueprint_;
      if (blueprintCase_ == 6 && terraformBlueprintBuilder_ != null) {
        result.blueprint_ = terraformBlueprintBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.config.v1.Revision) {
        return mergeFrom((com.google.cloud.config.v1.Revision) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.config.v1.Revision other) {
      if (other == com.google.cloud.config.v1.Revision.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.action_ != 0) {
        setActionValue(other.getActionValue());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasApplyResults()) {
        mergeApplyResults(other.getApplyResults());
      }
      if (!other.getStateDetail().isEmpty()) {
        stateDetail_ = other.stateDetail_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.errorCode_ != 0) {
        setErrorCodeValue(other.getErrorCodeValue());
      }
      if (!other.getBuild().isEmpty()) {
        build_ = other.build_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getLogs().isEmpty()) {
        logs_ = other.logs_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (tfErrorsBuilder_ == null) {
        if (!other.tfErrors_.isEmpty()) {
          if (tfErrors_.isEmpty()) {
            tfErrors_ = other.tfErrors_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureTfErrorsIsMutable();
            tfErrors_.addAll(other.tfErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.tfErrors_.isEmpty()) {
          if (tfErrorsBuilder_.isEmpty()) {
            tfErrorsBuilder_.dispose();
            tfErrorsBuilder_ = null;
            tfErrors_ = other.tfErrors_;
            bitField0_ = (bitField0_ & ~0x00000800);
            tfErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTfErrorsFieldBuilder()
                    : null;
          } else {
            tfErrorsBuilder_.addAllMessages(other.tfErrors_);
          }
        }
      }
      if (!other.getErrorLogs().isEmpty()) {
        errorLogs_ = other.errorLogs_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.getImportExistingResources() != false) {
        setImportExistingResources(other.getImportExistingResources());
      }
      if (!other.getWorkerPool().isEmpty()) {
        workerPool_ = other.workerPool_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      switch (other.getBlueprintCase()) {
        case TERRAFORM_BLUEPRINT:
          {
            mergeTerraformBlueprint(other.getTerraformBlueprint());
            break;
          }
        case BLUEPRINT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                action_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(
                    getTerraformBlueprintFieldBuilder().getBuilder(), extensionRegistry);
                blueprintCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getApplyResultsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                stateDetail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                errorCode_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                build_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                logs_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.config.v1.TerraformError m =
                    input.readMessage(
                        com.google.cloud.config.v1.TerraformError.parser(), extensionRegistry);
                if (tfErrorsBuilder_ == null) {
                  ensureTfErrorsIsMutable();
                  tfErrors_.add(m);
                } else {
                  tfErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                errorLogs_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 120:
              {
                importExistingResources_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 120
            case 138:
              {
                workerPool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int blueprintCase_ = 0;
    private java.lang.Object blueprint_;

    public BlueprintCase getBlueprintCase() {
      return BlueprintCase.forNumber(blueprintCase_);
    }

    public Builder clearBlueprint() {
      blueprintCase_ = 0;
      blueprint_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.TerraformBlueprint,
            com.google.cloud.config.v1.TerraformBlueprint.Builder,
            com.google.cloud.config.v1.TerraformBlueprintOrBuilder>
        terraformBlueprintBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terraformBlueprint field is set.
     */
    @java.lang.Override
    public boolean hasTerraformBlueprint() {
      return blueprintCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terraformBlueprint.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.TerraformBlueprint getTerraformBlueprint() {
      if (terraformBlueprintBuilder_ == null) {
        if (blueprintCase_ == 6) {
          return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
        }
        return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
      } else {
        if (blueprintCase_ == 6) {
          return terraformBlueprintBuilder_.getMessage();
        }
        return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerraformBlueprint(com.google.cloud.config.v1.TerraformBlueprint value) {
      if (terraformBlueprintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        blueprint_ = value;
        onChanged();
      } else {
        terraformBlueprintBuilder_.setMessage(value);
      }
      blueprintCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerraformBlueprint(
        com.google.cloud.config.v1.TerraformBlueprint.Builder builderForValue) {
      if (terraformBlueprintBuilder_ == null) {
        blueprint_ = builderForValue.build();
        onChanged();
      } else {
        terraformBlueprintBuilder_.setMessage(builderForValue.build());
      }
      blueprintCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTerraformBlueprint(com.google.cloud.config.v1.TerraformBlueprint value) {
      if (terraformBlueprintBuilder_ == null) {
        if (blueprintCase_ == 6
            && blueprint_ != com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance()) {
          blueprint_ =
              com.google.cloud.config.v1.TerraformBlueprint.newBuilder(
                      (com.google.cloud.config.v1.TerraformBlueprint) blueprint_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          blueprint_ = value;
        }
        onChanged();
      } else {
        if (blueprintCase_ == 6) {
          terraformBlueprintBuilder_.mergeFrom(value);
        } else {
          terraformBlueprintBuilder_.setMessage(value);
        }
      }
      blueprintCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTerraformBlueprint() {
      if (terraformBlueprintBuilder_ == null) {
        if (blueprintCase_ == 6) {
          blueprintCase_ = 0;
          blueprint_ = null;
          onChanged();
        }
      } else {
        if (blueprintCase_ == 6) {
          blueprintCase_ = 0;
          blueprint_ = null;
        }
        terraformBlueprintBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformBlueprint.Builder getTerraformBlueprintBuilder() {
      return getTerraformBlueprintFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.config.v1.TerraformBlueprintOrBuilder getTerraformBlueprintOrBuilder() {
      if ((blueprintCase_ == 6) && (terraformBlueprintBuilder_ != null)) {
        return terraformBlueprintBuilder_.getMessageOrBuilder();
      } else {
        if (blueprintCase_ == 6) {
          return (com.google.cloud.config.v1.TerraformBlueprint) blueprint_;
        }
        return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A blueprint described using Terraform's HashiCorp
     * Configuration Language as a root module.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.TerraformBlueprint terraform_blueprint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.TerraformBlueprint,
            com.google.cloud.config.v1.TerraformBlueprint.Builder,
            com.google.cloud.config.v1.TerraformBlueprintOrBuilder>
        getTerraformBlueprintFieldBuilder() {
      if (terraformBlueprintBuilder_ == null) {
        if (!(blueprintCase_ == 6)) {
          blueprint_ = com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
        }
        terraformBlueprintBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.config.v1.TerraformBlueprint,
                com.google.cloud.config.v1.TerraformBlueprint.Builder,
                com.google.cloud.config.v1.TerraformBlueprintOrBuilder>(
                (com.google.cloud.config.v1.TerraformBlueprint) blueprint_,
                getParentForChildren(),
                isClean());
        blueprint_ = null;
      }
      blueprintCase_ = 6;
      onChanged();
      return terraformBlueprintBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Revision name. Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Revision name. Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Revision name. Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Revision name. Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Revision name. Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}/
     * revisions/{revision}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the revision was last modified.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int action_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The action which created this revision
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.Action action = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for action.
     */
    @java.lang.Override
    public int getActionValue() {
      return action_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The action which created this revision
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.Action action = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionValue(int value) {
      action_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The action which created this revision
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.Action action = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Revision.Action getAction() {
      com.google.cloud.config.v1.Revision.Action result =
          com.google.cloud.config.v1.Revision.Action.forNumber(action_);
      return result == null ? com.google.cloud.config.v1.Revision.Action.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The action which created this revision
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.Action action = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(com.google.cloud.config.v1.Revision.Action value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      action_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The action which created this revision
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.Action action = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      action_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the revision.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the revision.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the revision.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Revision.State getState() {
      com.google.cloud.config.v1.Revision.State result =
          com.google.cloud.config.v1.Revision.State.forNumber(state_);
      return result == null ? com.google.cloud.config.v1.Revision.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the revision.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.config.v1.Revision.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the revision.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.config.v1.ApplyResults applyResults_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ApplyResults,
            com.google.cloud.config.v1.ApplyResults.Builder,
            com.google.cloud.config.v1.ApplyResultsOrBuilder>
        applyResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the applyResults field is set.
     */
    public boolean hasApplyResults() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The applyResults.
     */
    public com.google.cloud.config.v1.ApplyResults getApplyResults() {
      if (applyResultsBuilder_ == null) {
        return applyResults_ == null
            ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
            : applyResults_;
      } else {
        return applyResultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApplyResults(com.google.cloud.config.v1.ApplyResults value) {
      if (applyResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        applyResults_ = value;
      } else {
        applyResultsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApplyResults(
        com.google.cloud.config.v1.ApplyResults.Builder builderForValue) {
      if (applyResultsBuilder_ == null) {
        applyResults_ = builderForValue.build();
      } else {
        applyResultsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeApplyResults(com.google.cloud.config.v1.ApplyResults value) {
      if (applyResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && applyResults_ != null
            && applyResults_ != com.google.cloud.config.v1.ApplyResults.getDefaultInstance()) {
          getApplyResultsBuilder().mergeFrom(value);
        } else {
          applyResults_ = value;
        }
      } else {
        applyResultsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearApplyResults() {
      bitField0_ = (bitField0_ & ~0x00000040);
      applyResults_ = null;
      if (applyResultsBuilder_ != null) {
        applyResultsBuilder_.dispose();
        applyResultsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.ApplyResults.Builder getApplyResultsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getApplyResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.ApplyResultsOrBuilder getApplyResultsOrBuilder() {
      if (applyResultsBuilder_ != null) {
        return applyResultsBuilder_.getMessageOrBuilder();
      } else {
        return applyResults_ == null
            ? com.google.cloud.config.v1.ApplyResults.getDefaultInstance()
            : applyResults_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Outputs and artifacts from applying a deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.ApplyResults apply_results = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.ApplyResults,
            com.google.cloud.config.v1.ApplyResults.Builder,
            com.google.cloud.config.v1.ApplyResultsOrBuilder>
        getApplyResultsFieldBuilder() {
      if (applyResultsBuilder_ == null) {
        applyResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.config.v1.ApplyResults,
                com.google.cloud.config.v1.ApplyResults.Builder,
                com.google.cloud.config.v1.ApplyResultsOrBuilder>(
                getApplyResults(), getParentForChildren(), isClean());
        applyResults_ = null;
      }
      return applyResultsBuilder_;
    }

    private java.lang.Object stateDetail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional info regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateDetail.
     */
    public java.lang.String getStateDetail() {
      java.lang.Object ref = stateDetail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateDetail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional info regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateDetail.
     */
    public com.google.protobuf.ByteString getStateDetailBytes() {
      java.lang.Object ref = stateDetail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateDetail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional info regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStateDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateDetail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional info regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateDetail() {
      stateDetail_ = getDefaultInstance().getStateDetail();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional info regarding the current state.
     * </pre>
     *
     * <code>string state_detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStateDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateDetail_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int errorCode_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Code describing any errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.ErrorCode error_code = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for errorCode.
     */
    @java.lang.Override
    public int getErrorCodeValue() {
      return errorCode_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Code describing any errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.ErrorCode error_code = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCodeValue(int value) {
      errorCode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Code describing any errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.ErrorCode error_code = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The errorCode.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.Revision.ErrorCode getErrorCode() {
      com.google.cloud.config.v1.Revision.ErrorCode result =
          com.google.cloud.config.v1.Revision.ErrorCode.forNumber(errorCode_);
      return result == null ? com.google.cloud.config.v1.Revision.ErrorCode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Code describing any errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.ErrorCode error_code = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCode(com.google.cloud.config.v1.Revision.ErrorCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      errorCode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Code describing any errors that may have occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.Revision.ErrorCode error_code = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorCode() {
      bitField0_ = (bitField0_ & ~0x00000100);
      errorCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object build_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this revision.
     * </pre>
     *
     * <code>string build = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The build.
     */
    public java.lang.String getBuild() {
      java.lang.Object ref = build_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        build_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this revision.
     * </pre>
     *
     * <code>string build = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for build.
     */
    public com.google.protobuf.ByteString getBuildBytes() {
      java.lang.Object ref = build_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        build_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this revision.
     * </pre>
     *
     * <code>string build = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The build to set.
     * @return This builder for chaining.
     */
    public Builder setBuild(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      build_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this revision.
     * </pre>
     *
     * <code>string build = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuild() {
      build_ = getDefaultInstance().getBuild();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Build instance UUID associated with this revision.
     * </pre>
     *
     * <code>string build = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for build to set.
     * @return This builder for chaining.
     */
    public Builder setBuildBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      build_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object logs_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Location of Revision operation logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The logs.
     */
    public java.lang.String getLogs() {
      java.lang.Object ref = logs_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logs_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Revision operation logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for logs.
     */
    public com.google.protobuf.ByteString getLogsBytes() {
      java.lang.Object ref = logs_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logs_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Revision operation logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The logs to set.
     * @return This builder for chaining.
     */
    public Builder setLogs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      logs_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Revision operation logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogs() {
      logs_ = getDefaultInstance().getLogs();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Revision operation logs in
     * `gs://{bucket}/{object}` format.
     * </pre>
     *
     * <code>string logs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for logs to set.
     * @return This builder for chaining.
     */
    public Builder setLogsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      logs_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.config.v1.TerraformError> tfErrors_ =
        java.util.Collections.emptyList();

    private void ensureTfErrorsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        tfErrors_ = new java.util.ArrayList<com.google.cloud.config.v1.TerraformError>(tfErrors_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.config.v1.TerraformError,
            com.google.cloud.config.v1.TerraformError.Builder,
            com.google.cloud.config.v1.TerraformErrorOrBuilder>
        tfErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.config.v1.TerraformError> getTfErrorsList() {
      if (tfErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tfErrors_);
      } else {
        return tfErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getTfErrorsCount() {
      if (tfErrorsBuilder_ == null) {
        return tfErrors_.size();
      } else {
        return tfErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError getTfErrors(int index) {
      if (tfErrorsBuilder_ == null) {
        return tfErrors_.get(index);
      } else {
        return tfErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTfErrors(int index, com.google.cloud.config.v1.TerraformError value) {
      if (tfErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTfErrorsIsMutable();
        tfErrors_.set(index, value);
        onChanged();
      } else {
        tfErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTfErrors(
        int index, com.google.cloud.config.v1.TerraformError.Builder builderForValue) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        tfErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(com.google.cloud.config.v1.TerraformError value) {
      if (tfErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTfErrorsIsMutable();
        tfErrors_.add(value);
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(int index, com.google.cloud.config.v1.TerraformError value) {
      if (tfErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTfErrorsIsMutable();
        tfErrors_.add(index, value);
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(com.google.cloud.config.v1.TerraformError.Builder builderForValue) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.add(builderForValue.build());
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTfErrors(
        int index, com.google.cloud.config.v1.TerraformError.Builder builderForValue) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        tfErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllTfErrors(
        java.lang.Iterable<? extends com.google.cloud.config.v1.TerraformError> values) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tfErrors_);
        onChanged();
      } else {
        tfErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTfErrors() {
      if (tfErrorsBuilder_ == null) {
        tfErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        tfErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTfErrors(int index) {
      if (tfErrorsBuilder_ == null) {
        ensureTfErrorsIsMutable();
        tfErrors_.remove(index);
        onChanged();
      } else {
        tfErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError.Builder getTfErrorsBuilder(int index) {
      return getTfErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformErrorOrBuilder getTfErrorsOrBuilder(int index) {
      if (tfErrorsBuilder_ == null) {
        return tfErrors_.get(index);
      } else {
        return tfErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.config.v1.TerraformErrorOrBuilder>
        getTfErrorsOrBuilderList() {
      if (tfErrorsBuilder_ != null) {
        return tfErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tfErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError.Builder addTfErrorsBuilder() {
      return getTfErrorsFieldBuilder()
          .addBuilder(com.google.cloud.config.v1.TerraformError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.config.v1.TerraformError.Builder addTfErrorsBuilder(int index) {
      return getTfErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.config.v1.TerraformError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered when creating or updating this deployment.
     * Errors are truncated to 10 entries, see `delete_results` and `error_logs`
     * for full details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.config.v1.TerraformError tf_errors = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.config.v1.TerraformError.Builder>
        getTfErrorsBuilderList() {
      return getTfErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.config.v1.TerraformError,
            com.google.cloud.config.v1.TerraformError.Builder,
            com.google.cloud.config.v1.TerraformErrorOrBuilder>
        getTfErrorsFieldBuilder() {
      if (tfErrorsBuilder_ == null) {
        tfErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.config.v1.TerraformError,
                com.google.cloud.config.v1.TerraformError.Builder,
                com.google.cloud.config.v1.TerraformErrorOrBuilder>(
                tfErrors_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        tfErrors_ = null;
      }
      return tfErrorsBuilder_;
    }

    private java.lang.Object errorLogs_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The errorLogs.
     */
    public java.lang.String getErrorLogs() {
      java.lang.Object ref = errorLogs_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorLogs_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for errorLogs.
     */
    public com.google.protobuf.ByteString getErrorLogsBytes() {
      java.lang.Object ref = errorLogs_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorLogs_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The errorLogs to set.
     * @return This builder for chaining.
     */
    public Builder setErrorLogs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorLogs_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorLogs() {
      errorLogs_ = getDefaultInstance().getErrorLogs();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Location of Terraform error logs in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`.
     * </pre>
     *
     * <code>string error_logs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for errorLogs to set.
     * @return This builder for chaining.
     */
    public Builder setErrorLogsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorLogs_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Output only. User-specified Service Account (SA) to be used as credential
     * to manage resources. Format:
     * `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * string service_account = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. User-specified Service Account (SA) to be used as credential
     * to manage resources. Format:
     * `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * string service_account = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. User-specified Service Account (SA) to be used as credential
     * to manage resources. Format:
     * `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * string service_account = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User-specified Service Account (SA) to be used as credential
     * to manage resources. Format:
     * `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * string service_account = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User-specified Service Account (SA) to be used as credential
     * to manage resources. Format:
     * `projects/{projectID}/serviceAccounts/{serviceAccount}`
     * </pre>
     *
     * <code>
     * string service_account = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private boolean importExistingResources_;
    /**
     *
     *
     * <pre>
     * Output only. By default, Infra Manager will return a failure when
     * Terraform encounters a 409 code (resource conflict error) during actuation.
     * If this flag is set to true, Infra Manager will instead
     * attempt to automatically import the resource into the Terraform state (for
     * supported resource types) and continue actuation.
     *
     * Not all resource types are supported, refer to documentation.
     * </pre>
     *
     * <code>bool import_existing_resources = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The importExistingResources.
     */
    @java.lang.Override
    public boolean getImportExistingResources() {
      return importExistingResources_;
    }
    /**
     *
     *
     * <pre>
     * Output only. By default, Infra Manager will return a failure when
     * Terraform encounters a 409 code (resource conflict error) during actuation.
     * If this flag is set to true, Infra Manager will instead
     * attempt to automatically import the resource into the Terraform state (for
     * supported resource types) and continue actuation.
     *
     * Not all resource types are supported, refer to documentation.
     * </pre>
     *
     * <code>bool import_existing_resources = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The importExistingResources to set.
     * @return This builder for chaining.
     */
    public Builder setImportExistingResources(boolean value) {

      importExistingResources_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. By default, Infra Manager will return a failure when
     * Terraform encounters a 409 code (resource conflict error) during actuation.
     * If this flag is set to true, Infra Manager will instead
     * attempt to automatically import the resource into the Terraform state (for
     * supported resource types) and continue actuation.
     *
     * Not all resource types are supported, refer to documentation.
     * </pre>
     *
     * <code>bool import_existing_resources = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportExistingResources() {
      bitField0_ = (bitField0_ & ~0x00004000);
      importExistingResources_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object workerPool_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The user-specified Cloud Build worker pool resource in which
     * the Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The workerPool.
     */
    public java.lang.String getWorkerPool() {
      java.lang.Object ref = workerPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workerPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified Cloud Build worker pool resource in which
     * the Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for workerPool.
     */
    public com.google.protobuf.ByteString getWorkerPoolBytes() {
      java.lang.Object ref = workerPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workerPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified Cloud Build worker pool resource in which
     * the Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workerPool_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified Cloud Build worker pool resource in which
     * the Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerPool() {
      workerPool_ = getDefaultInstance().getWorkerPool();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-specified Cloud Build worker pool resource in which
     * the Cloud Build job will execute. Format:
     * `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
     * If this field is unspecified, the default Cloud Build worker pool will be
     * used.
     * </pre>
     *
     * <code>
     * string worker_pool = 17 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workerPool_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.config.v1.Revision)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.config.v1.Revision)
  private static final com.google.cloud.config.v1.Revision DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.config.v1.Revision();
  }

  public static com.google.cloud.config.v1.Revision getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Revision> PARSER =
      new com.google.protobuf.AbstractParser<Revision>() {
        @java.lang.Override
        public Revision parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Revision> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Revision> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.config.v1.Revision getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
