/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/config/v1/config.proto

package com.google.cloud.config.v1;

/**
 *
 *
 * <pre>
 * TerraformBlueprint describes the source of a Terraform root module which
 * describes the resources and configs to be deployed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.config.v1.TerraformBlueprint}
 */
public final class TerraformBlueprint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.config.v1.TerraformBlueprint)
    TerraformBlueprintOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TerraformBlueprint.newBuilder() to construct.
  private TerraformBlueprint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TerraformBlueprint() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TerraformBlueprint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_TerraformBlueprint_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetInputValues();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_TerraformBlueprint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.config.v1.TerraformBlueprint.class,
            com.google.cloud.config.v1.TerraformBlueprint.Builder.class);
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(1),
    GIT_SOURCE(2),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_SOURCE;
        case 2:
          return GIT_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Required. URI of an object in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`
   *
   * URI may also specify an object version for zipped objects.
   * Format: `gs://{bucket}/{object}#{version}`
   * </pre>
   *
   * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the gcsSource field is set.
   */
  public boolean hasGcsSource() {
    return sourceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Required. URI of an object in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`
   *
   * URI may also specify an object version for zipped objects.
   * Format: `gs://{bucket}/{object}#{version}`
   * </pre>
   *
   * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The gcsSource.
   */
  public java.lang.String getGcsSource() {
    java.lang.Object ref = "";
    if (sourceCase_ == 1) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 1) {
        source_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. URI of an object in Google Cloud Storage.
   * Format: `gs://{bucket}/{object}`
   *
   * URI may also specify an object version for zipped objects.
   * Format: `gs://{bucket}/{object}#{version}`
   * </pre>
   *
   * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for gcsSource.
   */
  public com.google.protobuf.ByteString getGcsSourceBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 1) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 1) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GIT_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Required. URI of a public Git repo.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the gitSource field is set.
   */
  @java.lang.Override
  public boolean hasGitSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Required. URI of a public Git repo.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The gitSource.
   */
  @java.lang.Override
  public com.google.cloud.config.v1.GitSource getGitSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.config.v1.GitSource) source_;
    }
    return com.google.cloud.config.v1.GitSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. URI of a public Git repo.
   * </pre>
   *
   * <code>
   * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.GitSourceOrBuilder getGitSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.config.v1.GitSource) source_;
    }
    return com.google.cloud.config.v1.GitSource.getDefaultInstance();
  }

  public static final int INPUT_VALUES_FIELD_NUMBER = 4;

  private static final class InputValuesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.config.v1.TerraformVariable>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.config.v1.TerraformVariable>newDefaultInstance(
                    com.google.cloud.config.v1.ConfigProto
                        .internal_static_google_cloud_config_v1_TerraformBlueprint_InputValuesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.config.v1.TerraformVariable.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.config.v1.TerraformVariable>
      inputValues_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.config.v1.TerraformVariable>
      internalGetInputValues() {
    if (inputValues_ == null) {
      return com.google.protobuf.MapField.emptyMapField(InputValuesDefaultEntryHolder.defaultEntry);
    }
    return inputValues_;
  }

  public int getInputValuesCount() {
    return internalGetInputValues().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Input variable values for the Terraform blueprint.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
   */
  @java.lang.Override
  public boolean containsInputValues(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetInputValues().getMap().containsKey(key);
  }
  /** Use {@link #getInputValuesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable>
      getInputValues() {
    return getInputValuesMap();
  }
  /**
   *
   *
   * <pre>
   * Input variable values for the Terraform blueprint.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable>
      getInputValuesMap() {
    return internalGetInputValues().getMap();
  }
  /**
   *
   *
   * <pre>
   * Input variable values for the Terraform blueprint.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.config.v1.TerraformVariable getInputValuesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.config.v1.TerraformVariable defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable> map =
        internalGetInputValues().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Input variable values for the Terraform blueprint.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.config.v1.TerraformVariable getInputValuesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable> map =
        internalGetInputValues().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, source_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.config.v1.GitSource) source_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetInputValues(), InputValuesDefaultEntryHolder.defaultEntry, 4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, source_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.config.v1.GitSource) source_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.config.v1.TerraformVariable> entry :
        internalGetInputValues().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.config.v1.TerraformVariable>
          inputValues__ =
              InputValuesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, inputValues__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.config.v1.TerraformBlueprint)) {
      return super.equals(obj);
    }
    com.google.cloud.config.v1.TerraformBlueprint other =
        (com.google.cloud.config.v1.TerraformBlueprint) obj;

    if (!internalGetInputValues().equals(other.internalGetInputValues())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 2:
        if (!getGitSource().equals(other.getGitSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetInputValues().getMap().isEmpty()) {
      hash = (37 * hash) + INPUT_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetInputValues().hashCode();
    }
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 2:
        hash = (37 * hash) + GIT_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGitSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.TerraformBlueprint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.config.v1.TerraformBlueprint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * TerraformBlueprint describes the source of a Terraform root module which
   * describes the resources and configs to be deployed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.config.v1.TerraformBlueprint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.config.v1.TerraformBlueprint)
      com.google.cloud.config.v1.TerraformBlueprintOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_TerraformBlueprint_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetInputValues();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableInputValues();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_TerraformBlueprint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.config.v1.TerraformBlueprint.class,
              com.google.cloud.config.v1.TerraformBlueprint.Builder.class);
    }

    // Construct using com.google.cloud.config.v1.TerraformBlueprint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gitSourceBuilder_ != null) {
        gitSourceBuilder_.clear();
      }
      internalGetMutableInputValues().clear();
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_TerraformBlueprint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.TerraformBlueprint getDefaultInstanceForType() {
      return com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.config.v1.TerraformBlueprint build() {
      com.google.cloud.config.v1.TerraformBlueprint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.TerraformBlueprint buildPartial() {
      com.google.cloud.config.v1.TerraformBlueprint result =
          new com.google.cloud.config.v1.TerraformBlueprint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.config.v1.TerraformBlueprint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.inputValues_ = internalGetInputValues();
        result.inputValues_.makeImmutable();
      }
    }

    private void buildPartialOneofs(com.google.cloud.config.v1.TerraformBlueprint result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && gitSourceBuilder_ != null) {
        result.source_ = gitSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.config.v1.TerraformBlueprint) {
        return mergeFrom((com.google.cloud.config.v1.TerraformBlueprint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.config.v1.TerraformBlueprint other) {
      if (other == com.google.cloud.config.v1.TerraformBlueprint.getDefaultInstance()) return this;
      internalGetMutableInputValues().mergeFrom(other.internalGetInputValues());
      bitField0_ |= 0x00000004;
      switch (other.getSourceCase()) {
        case GCS_SOURCE:
          {
            sourceCase_ = 1;
            source_ = other.source_;
            onChanged();
            break;
          }
        case GIT_SOURCE:
          {
            mergeGitSource(other.getGitSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 1;
                source_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGitSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.config.v1.TerraformVariable>
                    inputValues__ =
                        input.readMessage(
                            InputValuesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableInputValues()
                    .getMutableMap()
                    .put(inputValues__.getKey(), inputValues__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Required. URI of an object in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`
     *
     * URI may also specify an object version for zipped objects.
     * Format: `gs://{bucket}/{object}#{version}`
     * </pre>
     *
     * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of an object in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`
     *
     * URI may also specify an object version for zipped objects.
     * Format: `gs://{bucket}/{object}#{version}`
     * </pre>
     *
     * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public java.lang.String getGcsSource() {
      java.lang.Object ref = "";
      if (sourceCase_ == 1) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 1) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URI of an object in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`
     *
     * URI may also specify an object version for zipped objects.
     * Format: `gs://{bucket}/{object}#{version}`
     * </pre>
     *
     * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsSourceBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 1) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 1) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URI of an object in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`
     *
     * URI may also specify an object version for zipped objects.
     * Format: `gs://{bucket}/{object}#{version}`
     * </pre>
     *
     * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The gcsSource to set.
     * @return This builder for chaining.
     */
    public Builder setGcsSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 1;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of an object in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`
     *
     * URI may also specify an object version for zipped objects.
     * Format: `gs://{bucket}/{object}#{version}`
     * </pre>
     *
     * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcsSource() {
      if (sourceCase_ == 1) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of an object in Google Cloud Storage.
     * Format: `gs://{bucket}/{object}`
     *
     * URI may also specify an object version for zipped objects.
     * Format: `gs://{bucket}/{object}#{version}`
     * </pre>
     *
     * <code>string gcs_source = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for gcsSource to set.
     * @return This builder for chaining.
     */
    public Builder setGcsSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 1;
      source_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.GitSource,
            com.google.cloud.config.v1.GitSource.Builder,
            com.google.cloud.config.v1.GitSourceOrBuilder>
        gitSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the gitSource field is set.
     */
    @java.lang.Override
    public boolean hasGitSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The gitSource.
     */
    @java.lang.Override
    public com.google.cloud.config.v1.GitSource getGitSource() {
      if (gitSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.config.v1.GitSource) source_;
        }
        return com.google.cloud.config.v1.GitSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return gitSourceBuilder_.getMessage();
        }
        return com.google.cloud.config.v1.GitSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGitSource(com.google.cloud.config.v1.GitSource value) {
      if (gitSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gitSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGitSource(com.google.cloud.config.v1.GitSource.Builder builderForValue) {
      if (gitSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gitSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeGitSource(com.google.cloud.config.v1.GitSource value) {
      if (gitSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_ != com.google.cloud.config.v1.GitSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.config.v1.GitSource.newBuilder(
                      (com.google.cloud.config.v1.GitSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          gitSourceBuilder_.mergeFrom(value);
        } else {
          gitSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearGitSource() {
      if (gitSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        gitSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.config.v1.GitSource.Builder getGitSourceBuilder() {
      return getGitSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.config.v1.GitSourceOrBuilder getGitSourceOrBuilder() {
      if ((sourceCase_ == 2) && (gitSourceBuilder_ != null)) {
        return gitSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.config.v1.GitSource) source_;
        }
        return com.google.cloud.config.v1.GitSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URI of a public Git repo.
     * </pre>
     *
     * <code>
     * .google.cloud.config.v1.GitSource git_source = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.config.v1.GitSource,
            com.google.cloud.config.v1.GitSource.Builder,
            com.google.cloud.config.v1.GitSourceOrBuilder>
        getGitSourceFieldBuilder() {
      if (gitSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.cloud.config.v1.GitSource.getDefaultInstance();
        }
        gitSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.config.v1.GitSource,
                com.google.cloud.config.v1.GitSource.Builder,
                com.google.cloud.config.v1.GitSourceOrBuilder>(
                (com.google.cloud.config.v1.GitSource) source_, getParentForChildren(), isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return gitSourceBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.config.v1.TerraformVariable>
        inputValues_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.config.v1.TerraformVariable>
        internalGetInputValues() {
      if (inputValues_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InputValuesDefaultEntryHolder.defaultEntry);
      }
      return inputValues_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.config.v1.TerraformVariable>
        internalGetMutableInputValues() {
      if (inputValues_ == null) {
        inputValues_ =
            com.google.protobuf.MapField.newMapField(InputValuesDefaultEntryHolder.defaultEntry);
      }
      if (!inputValues_.isMutable()) {
        inputValues_ = inputValues_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return inputValues_;
    }

    public int getInputValuesCount() {
      return internalGetInputValues().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Input variable values for the Terraform blueprint.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
     */
    @java.lang.Override
    public boolean containsInputValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetInputValues().getMap().containsKey(key);
    }
    /** Use {@link #getInputValuesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable>
        getInputValues() {
      return getInputValuesMap();
    }
    /**
     *
     *
     * <pre>
     * Input variable values for the Terraform blueprint.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable>
        getInputValuesMap() {
      return internalGetInputValues().getMap();
    }
    /**
     *
     *
     * <pre>
     * Input variable values for the Terraform blueprint.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.config.v1.TerraformVariable getInputValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.config.v1.TerraformVariable defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable> map =
          internalGetInputValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Input variable values for the Terraform blueprint.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.config.v1.TerraformVariable getInputValuesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable> map =
          internalGetInputValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearInputValues() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableInputValues().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input variable values for the Terraform blueprint.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
     */
    public Builder removeInputValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableInputValues().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable>
        getMutableInputValues() {
      bitField0_ |= 0x00000004;
      return internalGetMutableInputValues().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Input variable values for the Terraform blueprint.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
     */
    public Builder putInputValues(
        java.lang.String key, com.google.cloud.config.v1.TerraformVariable value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableInputValues().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input variable values for the Terraform blueprint.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.config.v1.TerraformVariable&gt; input_values = 4;</code>
     */
    public Builder putAllInputValues(
        java.util.Map<java.lang.String, com.google.cloud.config.v1.TerraformVariable> values) {
      internalGetMutableInputValues().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.config.v1.TerraformBlueprint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.config.v1.TerraformBlueprint)
  private static final com.google.cloud.config.v1.TerraformBlueprint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.config.v1.TerraformBlueprint();
  }

  public static com.google.cloud.config.v1.TerraformBlueprint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TerraformBlueprint> PARSER =
      new com.google.protobuf.AbstractParser<TerraformBlueprint>() {
        @java.lang.Override
        public TerraformBlueprint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TerraformBlueprint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TerraformBlueprint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.config.v1.TerraformBlueprint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
