/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/config/v1/config.proto

package com.google.cloud.config.v1;

/**
 *
 *
 * <pre>
 * Errors encountered during actuation using Terraform
 * </pre>
 *
 * Protobuf type {@code google.cloud.config.v1.TerraformError}
 */
public final class TerraformError extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.config.v1.TerraformError)
    TerraformErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TerraformError.newBuilder() to construct.
  private TerraformError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TerraformError() {
    resourceAddress_ = "";
    errorDescription_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TerraformError();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_TerraformError_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.config.v1.ConfigProto
        .internal_static_google_cloud_config_v1_TerraformError_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.config.v1.TerraformError.class,
            com.google.cloud.config.v1.TerraformError.Builder.class);
  }

  public static final int RESOURCE_ADDRESS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceAddress_ = "";
  /**
   *
   *
   * <pre>
   * Address of the resource associated with the error,
   * e.g. `google_compute_network.vpc_network`.
   * </pre>
   *
   * <code>string resource_address = 1;</code>
   *
   * @return The resourceAddress.
   */
  @java.lang.Override
  public java.lang.String getResourceAddress() {
    java.lang.Object ref = resourceAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Address of the resource associated with the error,
   * e.g. `google_compute_network.vpc_network`.
   * </pre>
   *
   * <code>string resource_address = 1;</code>
   *
   * @return The bytes for resourceAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceAddressBytes() {
    java.lang.Object ref = resourceAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTP_RESPONSE_CODE_FIELD_NUMBER = 2;
  private int httpResponseCode_ = 0;
  /**
   *
   *
   * <pre>
   * HTTP response code returned from Google Cloud Platform APIs when Terraform
   * fails to provision the resource. If unset or 0, no HTTP response code was
   * returned by Terraform.
   * </pre>
   *
   * <code>int32 http_response_code = 2;</code>
   *
   * @return The httpResponseCode.
   */
  @java.lang.Override
  public int getHttpResponseCode() {
    return httpResponseCode_;
  }

  public static final int ERROR_DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorDescription_ = "";
  /**
   *
   *
   * <pre>
   * A human-readable error description.
   * </pre>
   *
   * <code>string error_description = 3;</code>
   *
   * @return The errorDescription.
   */
  @java.lang.Override
  public java.lang.String getErrorDescription() {
    java.lang.Object ref = errorDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-readable error description.
   * </pre>
   *
   * <code>string error_description = 3;</code>
   *
   * @return The bytes for errorDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorDescriptionBytes() {
    java.lang.Object ref = errorDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_FIELD_NUMBER = 4;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Original error response from underlying Google API, if available.
   * </pre>
   *
   * <code>.google.rpc.Status error = 4;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Original error response from underlying Google API, if available.
   * </pre>
   *
   * <code>.google.rpc.Status error = 4;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Original error response from underlying Google API, if available.
   * </pre>
   *
   * <code>.google.rpc.Status error = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceAddress_);
    }
    if (httpResponseCode_ != 0) {
      output.writeInt32(2, httpResponseCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, errorDescription_);
    }
    if (error_ != null) {
      output.writeMessage(4, getError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceAddress_);
    }
    if (httpResponseCode_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, httpResponseCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, errorDescription_);
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.config.v1.TerraformError)) {
      return super.equals(obj);
    }
    com.google.cloud.config.v1.TerraformError other =
        (com.google.cloud.config.v1.TerraformError) obj;

    if (!getResourceAddress().equals(other.getResourceAddress())) return false;
    if (getHttpResponseCode() != other.getHttpResponseCode()) return false;
    if (!getErrorDescription().equals(other.getErrorDescription())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getResourceAddress().hashCode();
    hash = (37 * hash) + HTTP_RESPONSE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getHttpResponseCode();
    hash = (37 * hash) + ERROR_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getErrorDescription().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformError parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.TerraformError parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.config.v1.TerraformError parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.config.v1.TerraformError prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Errors encountered during actuation using Terraform
   * </pre>
   *
   * Protobuf type {@code google.cloud.config.v1.TerraformError}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.config.v1.TerraformError)
      com.google.cloud.config.v1.TerraformErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_TerraformError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_TerraformError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.config.v1.TerraformError.class,
              com.google.cloud.config.v1.TerraformError.Builder.class);
    }

    // Construct using com.google.cloud.config.v1.TerraformError.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceAddress_ = "";
      httpResponseCode_ = 0;
      errorDescription_ = "";
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.config.v1.ConfigProto
          .internal_static_google_cloud_config_v1_TerraformError_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.TerraformError getDefaultInstanceForType() {
      return com.google.cloud.config.v1.TerraformError.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.config.v1.TerraformError build() {
      com.google.cloud.config.v1.TerraformError result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.config.v1.TerraformError buildPartial() {
      com.google.cloud.config.v1.TerraformError result =
          new com.google.cloud.config.v1.TerraformError(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.config.v1.TerraformError result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceAddress_ = resourceAddress_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.httpResponseCode_ = httpResponseCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.errorDescription_ = errorDescription_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.config.v1.TerraformError) {
        return mergeFrom((com.google.cloud.config.v1.TerraformError) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.config.v1.TerraformError other) {
      if (other == com.google.cloud.config.v1.TerraformError.getDefaultInstance()) return this;
      if (!other.getResourceAddress().isEmpty()) {
        resourceAddress_ = other.resourceAddress_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getHttpResponseCode() != 0) {
        setHttpResponseCode(other.getHttpResponseCode());
      }
      if (!other.getErrorDescription().isEmpty()) {
        errorDescription_ = other.errorDescription_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                resourceAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                httpResponseCode_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                errorDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceAddress_ = "";
    /**
     *
     *
     * <pre>
     * Address of the resource associated with the error,
     * e.g. `google_compute_network.vpc_network`.
     * </pre>
     *
     * <code>string resource_address = 1;</code>
     *
     * @return The resourceAddress.
     */
    public java.lang.String getResourceAddress() {
      java.lang.Object ref = resourceAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Address of the resource associated with the error,
     * e.g. `google_compute_network.vpc_network`.
     * </pre>
     *
     * <code>string resource_address = 1;</code>
     *
     * @return The bytes for resourceAddress.
     */
    public com.google.protobuf.ByteString getResourceAddressBytes() {
      java.lang.Object ref = resourceAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Address of the resource associated with the error,
     * e.g. `google_compute_network.vpc_network`.
     * </pre>
     *
     * <code>string resource_address = 1;</code>
     *
     * @param value The resourceAddress to set.
     * @return This builder for chaining.
     */
    public Builder setResourceAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Address of the resource associated with the error,
     * e.g. `google_compute_network.vpc_network`.
     * </pre>
     *
     * <code>string resource_address = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceAddress() {
      resourceAddress_ = getDefaultInstance().getResourceAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Address of the resource associated with the error,
     * e.g. `google_compute_network.vpc_network`.
     * </pre>
     *
     * <code>string resource_address = 1;</code>
     *
     * @param value The bytes for resourceAddress to set.
     * @return This builder for chaining.
     */
    public Builder setResourceAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int httpResponseCode_;
    /**
     *
     *
     * <pre>
     * HTTP response code returned from Google Cloud Platform APIs when Terraform
     * fails to provision the resource. If unset or 0, no HTTP response code was
     * returned by Terraform.
     * </pre>
     *
     * <code>int32 http_response_code = 2;</code>
     *
     * @return The httpResponseCode.
     */
    @java.lang.Override
    public int getHttpResponseCode() {
      return httpResponseCode_;
    }
    /**
     *
     *
     * <pre>
     * HTTP response code returned from Google Cloud Platform APIs when Terraform
     * fails to provision the resource. If unset or 0, no HTTP response code was
     * returned by Terraform.
     * </pre>
     *
     * <code>int32 http_response_code = 2;</code>
     *
     * @param value The httpResponseCode to set.
     * @return This builder for chaining.
     */
    public Builder setHttpResponseCode(int value) {

      httpResponseCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP response code returned from Google Cloud Platform APIs when Terraform
     * fails to provision the resource. If unset or 0, no HTTP response code was
     * returned by Terraform.
     * </pre>
     *
     * <code>int32 http_response_code = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpResponseCode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      httpResponseCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object errorDescription_ = "";
    /**
     *
     *
     * <pre>
     * A human-readable error description.
     * </pre>
     *
     * <code>string error_description = 3;</code>
     *
     * @return The errorDescription.
     */
    public java.lang.String getErrorDescription() {
      java.lang.Object ref = errorDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable error description.
     * </pre>
     *
     * <code>string error_description = 3;</code>
     *
     * @return The bytes for errorDescription.
     */
    public com.google.protobuf.ByteString getErrorDescriptionBytes() {
      java.lang.Object ref = errorDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable error description.
     * </pre>
     *
     * <code>string error_description = 3;</code>
     *
     * @param value The errorDescription to set.
     * @return This builder for chaining.
     */
    public Builder setErrorDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorDescription_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable error description.
     * </pre>
     *
     * <code>string error_description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorDescription() {
      errorDescription_ = getDefaultInstance().getErrorDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable error description.
     * </pre>
     *
     * <code>string error_description = 3;</code>
     *
     * @param value The bytes for errorDescription to set.
     * @return This builder for chaining.
     */
    public Builder setErrorDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorDescription_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000008);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Original error response from underlying Google API, if available.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.config.v1.TerraformError)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.config.v1.TerraformError)
  private static final com.google.cloud.config.v1.TerraformError DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.config.v1.TerraformError();
  }

  public static com.google.cloud.config.v1.TerraformError getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TerraformError> PARSER =
      new com.google.protobuf.AbstractParser<TerraformError>() {
        @java.lang.Override
        public TerraformError parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TerraformError> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TerraformError> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.config.v1.TerraformError getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
