/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.DecryptResponse}
 */
public final class DecryptResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.DecryptResponse)
    DecryptResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DecryptResponse.newBuilder() to construct.
  private DecryptResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DecryptResponse() {
    plaintext_ = com.google.protobuf.ByteString.EMPTY;
    protectionLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DecryptResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_DecryptResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_DecryptResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.DecryptResponse.class,
            com.google.cloud.kms.v1.DecryptResponse.Builder.class);
  }

  public static final int PLAINTEXT_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString plaintext_;
  /**
   *
   *
   * <pre>
   * The decrypted data originally supplied in
   * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
   * </pre>
   *
   * <code>bytes plaintext = 1;</code>
   *
   * @return The plaintext.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaintext() {
    return plaintext_;
  }

  public static final int PLAINTEXT_CRC32C_FIELD_NUMBER = 2;
  private com.google.protobuf.Int64Value plaintextCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
   * An integrity check of
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
   * can be performed by computing the CRC32C checksum of
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: receiving this response message indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   *
   * @return Whether the plaintextCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasPlaintextCrc32C() {
    return plaintextCrc32C_ != null;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
   * An integrity check of
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
   * can be performed by computing the CRC32C checksum of
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: receiving this response message indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   *
   * @return The plaintextCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getPlaintextCrc32C() {
    return plaintextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : plaintextCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
   * An integrity check of
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
   * can be performed by computing the CRC32C checksum of
   * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: receiving this response message indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder() {
    return getPlaintextCrc32C();
  }

  public static final int USED_PRIMARY_FIELD_NUMBER = 3;
  private boolean usedPrimary_;
  /**
   *
   *
   * <pre>
   * Whether the Decryption was performed using the primary key version.
   * </pre>
   *
   * <code>bool used_primary = 3;</code>
   *
   * @return The usedPrimary.
   */
  @java.lang.Override
  public boolean getUsedPrimary() {
    return usedPrimary_;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 4;
  private int protectionLevel_;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * decryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 4;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * decryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 4;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!plaintext_.isEmpty()) {
      output.writeBytes(1, plaintext_);
    }
    if (plaintextCrc32C_ != null) {
      output.writeMessage(2, getPlaintextCrc32C());
    }
    if (usedPrimary_ != false) {
      output.writeBool(3, usedPrimary_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, protectionLevel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!plaintext_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, plaintext_);
    }
    if (plaintextCrc32C_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPlaintextCrc32C());
    }
    if (usedPrimary_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, usedPrimary_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, protectionLevel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.DecryptResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.DecryptResponse other = (com.google.cloud.kms.v1.DecryptResponse) obj;

    if (!getPlaintext().equals(other.getPlaintext())) return false;
    if (hasPlaintextCrc32C() != other.hasPlaintextCrc32C()) return false;
    if (hasPlaintextCrc32C()) {
      if (!getPlaintextCrc32C().equals(other.getPlaintextCrc32C())) return false;
    }
    if (getUsedPrimary() != other.getUsedPrimary()) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PLAINTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getPlaintext().hashCode();
    if (hasPlaintextCrc32C()) {
      hash = (37 * hash) + PLAINTEXT_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getPlaintextCrc32C().hashCode();
    }
    hash = (37 * hash) + USED_PRIMARY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUsedPrimary());
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.DecryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.DecryptResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.DecryptResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.DecryptResponse)
      com.google.cloud.kms.v1.DecryptResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_DecryptResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_DecryptResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.DecryptResponse.class,
              com.google.cloud.kms.v1.DecryptResponse.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.DecryptResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      plaintext_ = com.google.protobuf.ByteString.EMPTY;

      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32C_ = null;
      } else {
        plaintextCrc32C_ = null;
        plaintextCrc32CBuilder_ = null;
      }
      usedPrimary_ = false;

      protectionLevel_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_DecryptResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.DecryptResponse getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.DecryptResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.DecryptResponse build() {
      com.google.cloud.kms.v1.DecryptResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.DecryptResponse buildPartial() {
      com.google.cloud.kms.v1.DecryptResponse result =
          new com.google.cloud.kms.v1.DecryptResponse(this);
      result.plaintext_ = plaintext_;
      if (plaintextCrc32CBuilder_ == null) {
        result.plaintextCrc32C_ = plaintextCrc32C_;
      } else {
        result.plaintextCrc32C_ = plaintextCrc32CBuilder_.build();
      }
      result.usedPrimary_ = usedPrimary_;
      result.protectionLevel_ = protectionLevel_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.DecryptResponse) {
        return mergeFrom((com.google.cloud.kms.v1.DecryptResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.DecryptResponse other) {
      if (other == com.google.cloud.kms.v1.DecryptResponse.getDefaultInstance()) return this;
      if (other.getPlaintext() != com.google.protobuf.ByteString.EMPTY) {
        setPlaintext(other.getPlaintext());
      }
      if (other.hasPlaintextCrc32C()) {
        mergePlaintextCrc32C(other.getPlaintextCrc32C());
      }
      if (other.getUsedPrimary() != false) {
        setUsedPrimary(other.getUsedPrimary());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                plaintext_ = input.readBytes();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPlaintextCrc32CFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 24:
              {
                usedPrimary_ = input.readBool();

                break;
              } // case 24
            case 32:
              {
                protectionLevel_ = input.readEnum();

                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.protobuf.ByteString plaintext_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The decrypted data originally supplied in
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * </pre>
     *
     * <code>bytes plaintext = 1;</code>
     *
     * @return The plaintext.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPlaintext() {
      return plaintext_;
    }
    /**
     *
     *
     * <pre>
     * The decrypted data originally supplied in
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * </pre>
     *
     * <code>bytes plaintext = 1;</code>
     *
     * @param value The plaintext to set.
     * @return This builder for chaining.
     */
    public Builder setPlaintext(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      plaintext_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The decrypted data originally supplied in
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * </pre>
     *
     * <code>bytes plaintext = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaintext() {

      plaintext_ = getDefaultInstance().getPlaintext();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value plaintextCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        plaintextCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     *
     * @return Whether the plaintextCrc32c field is set.
     */
    public boolean hasPlaintextCrc32C() {
      return plaintextCrc32CBuilder_ != null || plaintextCrc32C_ != null;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     *
     * @return The plaintextCrc32c.
     */
    public com.google.protobuf.Int64Value getPlaintextCrc32C() {
      if (plaintextCrc32CBuilder_ == null) {
        return plaintextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : plaintextCrc32C_;
      } else {
        return plaintextCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder setPlaintextCrc32C(com.google.protobuf.Int64Value value) {
      if (plaintextCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        plaintextCrc32C_ = value;
        onChanged();
      } else {
        plaintextCrc32CBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder setPlaintextCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32C_ = builderForValue.build();
        onChanged();
      } else {
        plaintextCrc32CBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder mergePlaintextCrc32C(com.google.protobuf.Int64Value value) {
      if (plaintextCrc32CBuilder_ == null) {
        if (plaintextCrc32C_ != null) {
          plaintextCrc32C_ =
              com.google.protobuf.Int64Value.newBuilder(plaintextCrc32C_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          plaintextCrc32C_ = value;
        }
        onChanged();
      } else {
        plaintextCrc32CBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder clearPlaintextCrc32C() {
      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32C_ = null;
        onChanged();
      } else {
        plaintextCrc32C_ = null;
        plaintextCrc32CBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public com.google.protobuf.Int64Value.Builder getPlaintextCrc32CBuilder() {

      onChanged();
      return getPlaintextCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder() {
      if (plaintextCrc32CBuilder_ != null) {
        return plaintextCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return plaintextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : plaintextCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext].
     * An integrity check of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * can be performed by computing the CRC32C checksum of
     * [DecryptResponse.plaintext][google.cloud.kms.v1.DecryptResponse.plaintext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: receiving this response message indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getPlaintextCrc32CFieldBuilder() {
      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getPlaintextCrc32C(), getParentForChildren(), isClean());
        plaintextCrc32C_ = null;
      }
      return plaintextCrc32CBuilder_;
    }

    private boolean usedPrimary_;
    /**
     *
     *
     * <pre>
     * Whether the Decryption was performed using the primary key version.
     * </pre>
     *
     * <code>bool used_primary = 3;</code>
     *
     * @return The usedPrimary.
     */
    @java.lang.Override
    public boolean getUsedPrimary() {
      return usedPrimary_;
    }
    /**
     *
     *
     * <pre>
     * Whether the Decryption was performed using the primary key version.
     * </pre>
     *
     * <code>bool used_primary = 3;</code>
     *
     * @param value The usedPrimary to set.
     * @return This builder for chaining.
     */
    public Builder setUsedPrimary(boolean value) {

      usedPrimary_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the Decryption was performed using the primary key version.
     * </pre>
     *
     * <code>bool used_primary = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsedPrimary() {

      usedPrimary_ = false;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 4;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 4;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {

      protectionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 4;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 4;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {

      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.DecryptResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.DecryptResponse)
  private static final com.google.cloud.kms.v1.DecryptResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.DecryptResponse();
  }

  public static com.google.cloud.kms.v1.DecryptResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DecryptResponse> PARSER =
      new com.google.protobuf.AbstractParser<DecryptResponse>() {
        @java.lang.Override
        public DecryptResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DecryptResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DecryptResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.DecryptResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
