/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * A [CryptoKey][google.cloud.kms.v1.CryptoKey] represents a logical key that
 * can be used for cryptographic operations.
 * A [CryptoKey][google.cloud.kms.v1.CryptoKey] is made up of zero or more
 * [versions][google.cloud.kms.v1.CryptoKeyVersion], which represent the actual
 * key material used in cryptographic operations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.CryptoKey}
 */
public final class CryptoKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.CryptoKey)
    CryptoKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CryptoKey.newBuilder() to construct.
  private CryptoKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CryptoKey() {
    name_ = "";
    purpose_ = 0;
    cryptoKeyBackend_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CryptoKey();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKey_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.CryptoKey.class,
            com.google.cloud.kms.v1.CryptoKey.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose]
   * describes the cryptographic capabilities of a
   * [CryptoKey][google.cloud.kms.v1.CryptoKey]. A given key can only be used
   * for the operations allowed by its purpose. For more information, see [Key
   * purposes](https://cloud.google.com/kms/docs/algorithms#key_purposes).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose}
   */
  public enum CryptoKeyPurpose implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_PURPOSE_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_PURPOSE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
     * </pre>
     *
     * <code>ENCRYPT_DECRYPT = 1;</code>
     */
    ENCRYPT_DECRYPT(1),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with
     * [AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign]
     * and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_SIGN = 5;</code>
     */
    ASYMMETRIC_SIGN(5),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with
     * [AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt]
     * and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_DECRYPT = 6;</code>
     */
    ASYMMETRIC_DECRYPT(6),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with [MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
     * </pre>
     *
     * <code>MAC = 9;</code>
     */
    MAC(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_PURPOSE_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_PURPOSE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
     * </pre>
     *
     * <code>ENCRYPT_DECRYPT = 1;</code>
     */
    public static final int ENCRYPT_DECRYPT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with
     * [AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign]
     * and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_SIGN = 5;</code>
     */
    public static final int ASYMMETRIC_SIGN_VALUE = 5;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with
     * [AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt]
     * and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_DECRYPT = 6;</code>
     */
    public static final int ASYMMETRIC_DECRYPT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
     * with [MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
     * </pre>
     *
     * <code>MAC = 9;</code>
     */
    public static final int MAC_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyPurpose valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyPurpose forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_PURPOSE_UNSPECIFIED;
        case 1:
          return ENCRYPT_DECRYPT;
        case 5:
          return ASYMMETRIC_SIGN;
        case 6:
          return ASYMMETRIC_DECRYPT;
        case 9:
          return MAC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyPurpose> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyPurpose>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyPurpose>() {
              public CryptoKeyPurpose findValueByNumber(int number) {
                return CryptoKeyPurpose.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKey.getDescriptor().getEnumTypes().get(0);
    }

    private static final CryptoKeyPurpose[] VALUES = values();

    public static CryptoKeyPurpose valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyPurpose(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose)
  }

  private int rotationScheduleCase_ = 0;
  private java.lang.Object rotationSchedule_;

  public enum RotationScheduleCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ROTATION_PERIOD(8),
    ROTATIONSCHEDULE_NOT_SET(0);
    private final int value;

    private RotationScheduleCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RotationScheduleCase valueOf(int value) {
      return forNumber(value);
    }

    public static RotationScheduleCase forNumber(int value) {
      switch (value) {
        case 8:
          return ROTATION_PERIOD;
        case 0:
          return ROTATIONSCHEDULE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RotationScheduleCase getRotationScheduleCase() {
    return RotationScheduleCase.forNumber(rotationScheduleCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIMARY_FIELD_NUMBER = 2;
  private com.google.cloud.kms.v1.CryptoKeyVersion primary_;
  /**
   *
   *
   * <pre>
   * Output only. A copy of the "primary"
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
   * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
   * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
   * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
   * updated via
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * may have a primary. For other keys, this field will be omitted.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the primary field is set.
   */
  @java.lang.Override
  public boolean hasPrimary() {
    return primary_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. A copy of the "primary"
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
   * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
   * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
   * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
   * updated via
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * may have a primary. For other keys, this field will be omitted.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The primary.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion getPrimary() {
    return primary_ == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()
        : primary_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A copy of the "primary"
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
   * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
   * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
   * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
   * updated via
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * may have a primary. For other keys, this field will be omitted.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder getPrimaryOrBuilder() {
    return primary_ == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()
        : primary_;
  }

  public static final int PURPOSE_FIELD_NUMBER = 3;
  private int purpose_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The immutable purpose of this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for purpose.
   */
  @java.lang.Override
  public int getPurposeValue() {
    return purpose_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The immutable purpose of this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The purpose.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose getPurpose() {
    com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose result =
        com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.forNumber(purpose_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int NEXT_ROTATION_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp nextRotationTime_;
  /**
   *
   *
   * <pre>
   * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
   * the Key Management Service will automatically:
   * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * 2. Mark the new version as primary.
   * Key rotations performed manually via
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
   * and
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
   * do not affect
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * support automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
   *
   * @return Whether the nextRotationTime field is set.
   */
  @java.lang.Override
  public boolean hasNextRotationTime() {
    return nextRotationTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
   * the Key Management Service will automatically:
   * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * 2. Mark the new version as primary.
   * Key rotations performed manually via
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
   * and
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
   * do not affect
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * support automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
   *
   * @return The nextRotationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNextRotationTime() {
    return nextRotationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : nextRotationTime_;
  }
  /**
   *
   *
   * <pre>
   * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
   * the Key Management Service will automatically:
   * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * 2. Mark the new version as primary.
   * Key rotations performed manually via
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
   * and
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
   * do not affect
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * support automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNextRotationTimeOrBuilder() {
    return nextRotationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : nextRotationTime_;
  }

  public static final int ROTATION_PERIOD_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
   * will be advanced by this period when the service automatically rotates a
   * key. Must be at least 24 hours and at most 876,000 hours.
   * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
   * set,
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
   * must also be set.
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * support automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Duration rotation_period = 8;</code>
   *
   * @return Whether the rotationPeriod field is set.
   */
  @java.lang.Override
  public boolean hasRotationPeriod() {
    return rotationScheduleCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
   * will be advanced by this period when the service automatically rotates a
   * key. Must be at least 24 hours and at most 876,000 hours.
   * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
   * set,
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
   * must also be set.
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * support automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Duration rotation_period = 8;</code>
   *
   * @return The rotationPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRotationPeriod() {
    if (rotationScheduleCase_ == 8) {
      return (com.google.protobuf.Duration) rotationSchedule_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
   * will be advanced by this period when the service automatically rotates a
   * key. Must be at least 24 hours and at most 876,000 hours.
   * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
   * set,
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
   * must also be set.
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
   * support automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Duration rotation_period = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRotationPeriodOrBuilder() {
    if (rotationScheduleCase_ == 8) {
      return (com.google.protobuf.Duration) rotationSchedule_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int VERSION_TEMPLATE_FIELD_NUMBER = 11;
  private com.google.cloud.kms.v1.CryptoKeyVersionTemplate versionTemplate_;
  /**
   *
   *
   * <pre>
   * A template describing settings for new
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
   * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
   * instances created by either
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
   * or auto-rotation are controlled by this template.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
   *
   * @return Whether the versionTemplate field is set.
   */
  @java.lang.Override
  public boolean hasVersionTemplate() {
    return versionTemplate_ != null;
  }
  /**
   *
   *
   * <pre>
   * A template describing settings for new
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
   * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
   * instances created by either
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
   * or auto-rotation are controlled by this template.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
   *
   * @return The versionTemplate.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersionTemplate getVersionTemplate() {
    return versionTemplate_ == null
        ? com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()
        : versionTemplate_;
  }
  /**
   *
   *
   * <pre>
   * A template describing settings for new
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
   * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
   * instances created by either
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
   * or auto-rotation are controlled by this template.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder getVersionTemplateOrBuilder() {
    return versionTemplate_ == null
        ? com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()
        : versionTemplate_;
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.kms.v1.KmsResourcesProto
                .internal_static_google_cloud_kms_v1_CryptoKey_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IMPORT_ONLY_FIELD_NUMBER = 13;
  private boolean importOnly_ = false;
  /**
   *
   *
   * <pre>
   * Immutable. Whether this key may contain imported versions only.
   * </pre>
   *
   * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The importOnly.
   */
  @java.lang.Override
  public boolean getImportOnly() {
    return importOnly_;
  }

  public static final int DESTROY_SCHEDULED_DURATION_FIELD_NUMBER = 14;
  private com.google.protobuf.Duration destroyScheduledDuration_;
  /**
   *
   *
   * <pre>
   * Immutable. The period of time that versions of this key spend in the
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
   * state before transitioning to
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * If not specified at creation time, the default duration is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the destroyScheduledDuration field is set.
   */
  @java.lang.Override
  public boolean hasDestroyScheduledDuration() {
    return destroyScheduledDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The period of time that versions of this key spend in the
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
   * state before transitioning to
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * If not specified at creation time, the default duration is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The destroyScheduledDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDestroyScheduledDuration() {
    return destroyScheduledDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : destroyScheduledDuration_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The period of time that versions of this key spend in the
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
   * state before transitioning to
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * If not specified at creation time, the default duration is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDestroyScheduledDurationOrBuilder() {
    return destroyScheduledDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : destroyScheduledDuration_;
  }

  public static final int CRYPTO_KEY_BACKEND_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cryptoKeyBackend_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the backend environment where the key
   * material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
   * associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
   * where all related cryptographic operations are performed. Only applicable
   * if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
   * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
   * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], with the
   * resource name in the format `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
   * Note, this list is non-exhaustive and may apply to additional
   * [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
   * </pre>
   *
   * <code>
   * string crypto_key_backend = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The cryptoKeyBackend.
   */
  @java.lang.Override
  public java.lang.String getCryptoKeyBackend() {
    java.lang.Object ref = cryptoKeyBackend_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cryptoKeyBackend_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the backend environment where the key
   * material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
   * associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
   * where all related cryptographic operations are performed. Only applicable
   * if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
   * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
   * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], with the
   * resource name in the format `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
   * Note, this list is non-exhaustive and may apply to additional
   * [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
   * </pre>
   *
   * <code>
   * string crypto_key_backend = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for cryptoKeyBackend.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCryptoKeyBackendBytes() {
    java.lang.Object ref = cryptoKeyBackend_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cryptoKeyBackend_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (primary_ != null) {
      output.writeMessage(2, getPrimary());
    }
    if (purpose_
        != com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.CRYPTO_KEY_PURPOSE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, purpose_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (nextRotationTime_ != null) {
      output.writeMessage(7, getNextRotationTime());
    }
    if (rotationScheduleCase_ == 8) {
      output.writeMessage(8, (com.google.protobuf.Duration) rotationSchedule_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    if (versionTemplate_ != null) {
      output.writeMessage(11, getVersionTemplate());
    }
    if (importOnly_ != false) {
      output.writeBool(13, importOnly_);
    }
    if (destroyScheduledDuration_ != null) {
      output.writeMessage(14, getDestroyScheduledDuration());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cryptoKeyBackend_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, cryptoKeyBackend_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (primary_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPrimary());
    }
    if (purpose_
        != com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.CRYPTO_KEY_PURPOSE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, purpose_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (nextRotationTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNextRotationTime());
    }
    if (rotationScheduleCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.protobuf.Duration) rotationSchedule_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    if (versionTemplate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getVersionTemplate());
    }
    if (importOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, importOnly_);
    }
    if (destroyScheduledDuration_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, getDestroyScheduledDuration());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cryptoKeyBackend_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, cryptoKeyBackend_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.CryptoKey)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.CryptoKey other = (com.google.cloud.kms.v1.CryptoKey) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasPrimary() != other.hasPrimary()) return false;
    if (hasPrimary()) {
      if (!getPrimary().equals(other.getPrimary())) return false;
    }
    if (purpose_ != other.purpose_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasNextRotationTime() != other.hasNextRotationTime()) return false;
    if (hasNextRotationTime()) {
      if (!getNextRotationTime().equals(other.getNextRotationTime())) return false;
    }
    if (hasVersionTemplate() != other.hasVersionTemplate()) return false;
    if (hasVersionTemplate()) {
      if (!getVersionTemplate().equals(other.getVersionTemplate())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getImportOnly() != other.getImportOnly()) return false;
    if (hasDestroyScheduledDuration() != other.hasDestroyScheduledDuration()) return false;
    if (hasDestroyScheduledDuration()) {
      if (!getDestroyScheduledDuration().equals(other.getDestroyScheduledDuration())) return false;
    }
    if (!getCryptoKeyBackend().equals(other.getCryptoKeyBackend())) return false;
    if (!getRotationScheduleCase().equals(other.getRotationScheduleCase())) return false;
    switch (rotationScheduleCase_) {
      case 8:
        if (!getRotationPeriod().equals(other.getRotationPeriod())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasPrimary()) {
      hash = (37 * hash) + PRIMARY_FIELD_NUMBER;
      hash = (53 * hash) + getPrimary().hashCode();
    }
    hash = (37 * hash) + PURPOSE_FIELD_NUMBER;
    hash = (53 * hash) + purpose_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasNextRotationTime()) {
      hash = (37 * hash) + NEXT_ROTATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNextRotationTime().hashCode();
    }
    if (hasVersionTemplate()) {
      hash = (37 * hash) + VERSION_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getVersionTemplate().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + IMPORT_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportOnly());
    if (hasDestroyScheduledDuration()) {
      hash = (37 * hash) + DESTROY_SCHEDULED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyScheduledDuration().hashCode();
    }
    hash = (37 * hash) + CRYPTO_KEY_BACKEND_FIELD_NUMBER;
    hash = (53 * hash) + getCryptoKeyBackend().hashCode();
    switch (rotationScheduleCase_) {
      case 8:
        hash = (37 * hash) + ROTATION_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getRotationPeriod().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.CryptoKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [CryptoKey][google.cloud.kms.v1.CryptoKey] represents a logical key that
   * can be used for cryptographic operations.
   * A [CryptoKey][google.cloud.kms.v1.CryptoKey] is made up of zero or more
   * [versions][google.cloud.kms.v1.CryptoKeyVersion], which represent the actual
   * key material used in cryptographic operations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.CryptoKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.CryptoKey)
      com.google.cloud.kms.v1.CryptoKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKey_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.CryptoKey.class,
              com.google.cloud.kms.v1.CryptoKey.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.CryptoKey.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      primary_ = null;
      if (primaryBuilder_ != null) {
        primaryBuilder_.dispose();
        primaryBuilder_ = null;
      }
      purpose_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      nextRotationTime_ = null;
      if (nextRotationTimeBuilder_ != null) {
        nextRotationTimeBuilder_.dispose();
        nextRotationTimeBuilder_ = null;
      }
      if (rotationPeriodBuilder_ != null) {
        rotationPeriodBuilder_.clear();
      }
      versionTemplate_ = null;
      if (versionTemplateBuilder_ != null) {
        versionTemplateBuilder_.dispose();
        versionTemplateBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      importOnly_ = false;
      destroyScheduledDuration_ = null;
      if (destroyScheduledDurationBuilder_ != null) {
        destroyScheduledDurationBuilder_.dispose();
        destroyScheduledDurationBuilder_ = null;
      }
      cryptoKeyBackend_ = "";
      rotationScheduleCase_ = 0;
      rotationSchedule_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.CryptoKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey build() {
      com.google.cloud.kms.v1.CryptoKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey buildPartial() {
      com.google.cloud.kms.v1.CryptoKey result = new com.google.cloud.kms.v1.CryptoKey(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.CryptoKey result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.primary_ = primaryBuilder_ == null ? primary_ : primaryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.purpose_ = purpose_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nextRotationTime_ =
            nextRotationTimeBuilder_ == null ? nextRotationTime_ : nextRotationTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.versionTemplate_ =
            versionTemplateBuilder_ == null ? versionTemplate_ : versionTemplateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.importOnly_ = importOnly_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.destroyScheduledDuration_ =
            destroyScheduledDurationBuilder_ == null
                ? destroyScheduledDuration_
                : destroyScheduledDurationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.cryptoKeyBackend_ = cryptoKeyBackend_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.kms.v1.CryptoKey result) {
      result.rotationScheduleCase_ = rotationScheduleCase_;
      result.rotationSchedule_ = this.rotationSchedule_;
      if (rotationScheduleCase_ == 8 && rotationPeriodBuilder_ != null) {
        result.rotationSchedule_ = rotationPeriodBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.CryptoKey) {
        return mergeFrom((com.google.cloud.kms.v1.CryptoKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.CryptoKey other) {
      if (other == com.google.cloud.kms.v1.CryptoKey.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPrimary()) {
        mergePrimary(other.getPrimary());
      }
      if (other.purpose_ != 0) {
        setPurposeValue(other.getPurposeValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasNextRotationTime()) {
        mergeNextRotationTime(other.getNextRotationTime());
      }
      if (other.hasVersionTemplate()) {
        mergeVersionTemplate(other.getVersionTemplate());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (other.getImportOnly() != false) {
        setImportOnly(other.getImportOnly());
      }
      if (other.hasDestroyScheduledDuration()) {
        mergeDestroyScheduledDuration(other.getDestroyScheduledDuration());
      }
      if (!other.getCryptoKeyBackend().isEmpty()) {
        cryptoKeyBackend_ = other.cryptoKeyBackend_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getRotationScheduleCase()) {
        case ROTATION_PERIOD:
          {
            mergeRotationPeriod(other.getRotationPeriod());
            break;
          }
        case ROTATIONSCHEDULE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPrimaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                purpose_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(
                    getNextRotationTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getRotationPeriodFieldBuilder().getBuilder(), extensionRegistry);
                rotationScheduleCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getVersionTemplateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 90
            case 104:
              {
                importOnly_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(
                    getDestroyScheduledDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 114
            case 122:
              {
                cryptoKeyBackend_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int rotationScheduleCase_ = 0;
    private java.lang.Object rotationSchedule_;

    public RotationScheduleCase getRotationScheduleCase() {
      return RotationScheduleCase.forNumber(rotationScheduleCase_);
    }

    public Builder clearRotationSchedule() {
      rotationScheduleCase_ = 0;
      rotationSchedule_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.CryptoKeyVersion primary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersion,
            com.google.cloud.kms.v1.CryptoKeyVersion.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder>
        primaryBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the primary field is set.
     */
    public boolean hasPrimary() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The primary.
     */
    public com.google.cloud.kms.v1.CryptoKeyVersion getPrimary() {
      if (primaryBuilder_ == null) {
        return primary_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()
            : primary_;
      } else {
        return primaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrimary(com.google.cloud.kms.v1.CryptoKeyVersion value) {
      if (primaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        primary_ = value;
      } else {
        primaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrimary(com.google.cloud.kms.v1.CryptoKeyVersion.Builder builderForValue) {
      if (primaryBuilder_ == null) {
        primary_ = builderForValue.build();
      } else {
        primaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePrimary(com.google.cloud.kms.v1.CryptoKeyVersion value) {
      if (primaryBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && primary_ != null
            && primary_ != com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()) {
          getPrimaryBuilder().mergeFrom(value);
        } else {
          primary_ = value;
        }
      } else {
        primaryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPrimary() {
      bitField0_ = (bitField0_ & ~0x00000002);
      primary_ = null;
      if (primaryBuilder_ != null) {
        primaryBuilder_.dispose();
        primaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersion.Builder getPrimaryBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPrimaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder getPrimaryOrBuilder() {
      if (primaryBuilder_ != null) {
        return primaryBuilder_.getMessageOrBuilder();
      } else {
        return primary_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()
            : primary_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary"
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
     * [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
     * updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * may have a primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersion,
            com.google.cloud.kms.v1.CryptoKeyVersion.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder>
        getPrimaryFieldBuilder() {
      if (primaryBuilder_ == null) {
        primaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.CryptoKeyVersion,
                com.google.cloud.kms.v1.CryptoKeyVersion.Builder,
                com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder>(
                getPrimary(), getParentForChildren(), isClean());
        primary_ = null;
      }
      return primaryBuilder_;
    }

    private int purpose_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for purpose.
     */
    @java.lang.Override
    public int getPurposeValue() {
      return purpose_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurposeValue(int value) {
      purpose_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The purpose.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose getPurpose() {
      com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose result =
          com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.forNumber(purpose_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurpose(com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      purpose_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPurpose() {
      bitField0_ = (bitField0_ & ~0x00000004);
      purpose_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp nextRotationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        nextRotationTimeBuilder_;
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     *
     * @return Whether the nextRotationTime field is set.
     */
    public boolean hasNextRotationTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     *
     * @return The nextRotationTime.
     */
    public com.google.protobuf.Timestamp getNextRotationTime() {
      if (nextRotationTimeBuilder_ == null) {
        return nextRotationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRotationTime_;
      } else {
        return nextRotationTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder setNextRotationTime(com.google.protobuf.Timestamp value) {
      if (nextRotationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextRotationTime_ = value;
      } else {
        nextRotationTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder setNextRotationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTime_ = builderForValue.build();
      } else {
        nextRotationTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder mergeNextRotationTime(com.google.protobuf.Timestamp value) {
      if (nextRotationTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && nextRotationTime_ != null
            && nextRotationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getNextRotationTimeBuilder().mergeFrom(value);
        } else {
          nextRotationTime_ = value;
        }
      } else {
        nextRotationTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder clearNextRotationTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      nextRotationTime_ = null;
      if (nextRotationTimeBuilder_ != null) {
        nextRotationTimeBuilder_.dispose();
        nextRotationTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getNextRotationTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getNextRotationTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getNextRotationTimeOrBuilder() {
      if (nextRotationTimeBuilder_ != null) {
        return nextRotationTimeBuilder_.getMessageOrBuilder();
      } else {
        return nextRotationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRotationTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
     * the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNextRotationTimeFieldBuilder() {
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNextRotationTime(), getParentForChildren(), isClean());
        nextRotationTime_ = null;
      }
      return nextRotationTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        rotationPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     *
     * @return Whether the rotationPeriod field is set.
     */
    @java.lang.Override
    public boolean hasRotationPeriod() {
      return rotationScheduleCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     *
     * @return The rotationPeriod.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRotationPeriod() {
      if (rotationPeriodBuilder_ == null) {
        if (rotationScheduleCase_ == 8) {
          return (com.google.protobuf.Duration) rotationSchedule_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (rotationScheduleCase_ == 8) {
          return rotationPeriodBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder setRotationPeriod(com.google.protobuf.Duration value) {
      if (rotationPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rotationSchedule_ = value;
        onChanged();
      } else {
        rotationPeriodBuilder_.setMessage(value);
      }
      rotationScheduleCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder setRotationPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (rotationPeriodBuilder_ == null) {
        rotationSchedule_ = builderForValue.build();
        onChanged();
      } else {
        rotationPeriodBuilder_.setMessage(builderForValue.build());
      }
      rotationScheduleCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder mergeRotationPeriod(com.google.protobuf.Duration value) {
      if (rotationPeriodBuilder_ == null) {
        if (rotationScheduleCase_ == 8
            && rotationSchedule_ != com.google.protobuf.Duration.getDefaultInstance()) {
          rotationSchedule_ =
              com.google.protobuf.Duration.newBuilder(
                      (com.google.protobuf.Duration) rotationSchedule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rotationSchedule_ = value;
        }
        onChanged();
      } else {
        if (rotationScheduleCase_ == 8) {
          rotationPeriodBuilder_.mergeFrom(value);
        } else {
          rotationPeriodBuilder_.setMessage(value);
        }
      }
      rotationScheduleCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder clearRotationPeriod() {
      if (rotationPeriodBuilder_ == null) {
        if (rotationScheduleCase_ == 8) {
          rotationScheduleCase_ = 0;
          rotationSchedule_ = null;
          onChanged();
        }
      } else {
        if (rotationScheduleCase_ == 8) {
          rotationScheduleCase_ = 0;
          rotationSchedule_ = null;
        }
        rotationPeriodBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getRotationPeriodBuilder() {
      return getRotationPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRotationPeriodOrBuilder() {
      if ((rotationScheduleCase_ == 8) && (rotationPeriodBuilder_ != null)) {
        return rotationPeriodBuilder_.getMessageOrBuilder();
      } else {
        if (rotationScheduleCase_ == 8) {
          return (com.google.protobuf.Duration) rotationSchedule_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * will be advanced by this period when the service automatically rotates a
     * key. Must be at least 24 hours and at most 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
     * set,
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
     * must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
     * support automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRotationPeriodFieldBuilder() {
      if (rotationPeriodBuilder_ == null) {
        if (!(rotationScheduleCase_ == 8)) {
          rotationSchedule_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        rotationPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) rotationSchedule_,
                getParentForChildren(),
                isClean());
        rotationSchedule_ = null;
      }
      rotationScheduleCase_ = 8;
      onChanged();
      return rotationPeriodBuilder_;
    }

    private com.google.cloud.kms.v1.CryptoKeyVersionTemplate versionTemplate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder>
        versionTemplateBuilder_;
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     *
     * @return Whether the versionTemplate field is set.
     */
    public boolean hasVersionTemplate() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     *
     * @return The versionTemplate.
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionTemplate getVersionTemplate() {
      if (versionTemplateBuilder_ == null) {
        return versionTemplate_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()
            : versionTemplate_;
      } else {
        return versionTemplateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder setVersionTemplate(com.google.cloud.kms.v1.CryptoKeyVersionTemplate value) {
      if (versionTemplateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionTemplate_ = value;
      } else {
        versionTemplateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder setVersionTemplate(
        com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder builderForValue) {
      if (versionTemplateBuilder_ == null) {
        versionTemplate_ = builderForValue.build();
      } else {
        versionTemplateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder mergeVersionTemplate(com.google.cloud.kms.v1.CryptoKeyVersionTemplate value) {
      if (versionTemplateBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && versionTemplate_ != null
            && versionTemplate_
                != com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()) {
          getVersionTemplateBuilder().mergeFrom(value);
        } else {
          versionTemplate_ = value;
        }
      } else {
        versionTemplateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder clearVersionTemplate() {
      bitField0_ = (bitField0_ & ~0x00000040);
      versionTemplate_ = null;
      if (versionTemplateBuilder_ != null) {
        versionTemplateBuilder_.dispose();
        versionTemplateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder getVersionTemplateBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getVersionTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder getVersionTemplateOrBuilder() {
      if (versionTemplateBuilder_ != null) {
        return versionTemplateBuilder_.getMessageOrBuilder();
      } else {
        return versionTemplate_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()
            : versionTemplate_;
      }
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
     * properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
     * or auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder>
        getVersionTemplateFieldBuilder() {
      if (versionTemplateBuilder_ == null) {
        versionTemplateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.CryptoKeyVersionTemplate,
                com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder,
                com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder>(
                getVersionTemplate(), getParentForChildren(), isClean());
        versionTemplate_ = null;
      }
      return versionTemplateBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private boolean importOnly_;
    /**
     *
     *
     * <pre>
     * Immutable. Whether this key may contain imported versions only.
     * </pre>
     *
     * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The importOnly.
     */
    @java.lang.Override
    public boolean getImportOnly() {
      return importOnly_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Whether this key may contain imported versions only.
     * </pre>
     *
     * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The importOnly to set.
     * @return This builder for chaining.
     */
    public Builder setImportOnly(boolean value) {

      importOnly_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Whether this key may contain imported versions only.
     * </pre>
     *
     * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportOnly() {
      bitField0_ = (bitField0_ & ~0x00000100);
      importOnly_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration destroyScheduledDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        destroyScheduledDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the destroyScheduledDuration field is set.
     */
    public boolean hasDestroyScheduledDuration() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The destroyScheduledDuration.
     */
    public com.google.protobuf.Duration getDestroyScheduledDuration() {
      if (destroyScheduledDurationBuilder_ == null) {
        return destroyScheduledDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : destroyScheduledDuration_;
      } else {
        return destroyScheduledDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDestroyScheduledDuration(com.google.protobuf.Duration value) {
      if (destroyScheduledDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyScheduledDuration_ = value;
      } else {
        destroyScheduledDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDestroyScheduledDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (destroyScheduledDurationBuilder_ == null) {
        destroyScheduledDuration_ = builderForValue.build();
      } else {
        destroyScheduledDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeDestroyScheduledDuration(com.google.protobuf.Duration value) {
      if (destroyScheduledDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && destroyScheduledDuration_ != null
            && destroyScheduledDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDestroyScheduledDurationBuilder().mergeFrom(value);
        } else {
          destroyScheduledDuration_ = value;
        }
      } else {
        destroyScheduledDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearDestroyScheduledDuration() {
      bitField0_ = (bitField0_ & ~0x00000200);
      destroyScheduledDuration_ = null;
      if (destroyScheduledDurationBuilder_ != null) {
        destroyScheduledDurationBuilder_.dispose();
        destroyScheduledDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDestroyScheduledDurationBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDestroyScheduledDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDestroyScheduledDurationOrBuilder() {
      if (destroyScheduledDurationBuilder_ != null) {
        return destroyScheduledDurationBuilder_.getMessageOrBuilder();
      } else {
        return destroyScheduledDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : destroyScheduledDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * If not specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDestroyScheduledDurationFieldBuilder() {
      if (destroyScheduledDurationBuilder_ == null) {
        destroyScheduledDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDestroyScheduledDuration(), getParentForChildren(), isClean());
        destroyScheduledDuration_ = null;
      }
      return destroyScheduledDurationBuilder_;
    }

    private java.lang.Object cryptoKeyBackend_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the backend environment where the key
     * material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
     * associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
     * where all related cryptographic operations are performed. Only applicable
     * if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
     * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
     * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], with the
     * resource name in the format `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * Note, this list is non-exhaustive and may apply to additional
     * [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
     * </pre>
     *
     * <code>
     * string crypto_key_backend = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The cryptoKeyBackend.
     */
    public java.lang.String getCryptoKeyBackend() {
      java.lang.Object ref = cryptoKeyBackend_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cryptoKeyBackend_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the backend environment where the key
     * material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
     * associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
     * where all related cryptographic operations are performed. Only applicable
     * if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
     * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
     * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], with the
     * resource name in the format `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * Note, this list is non-exhaustive and may apply to additional
     * [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
     * </pre>
     *
     * <code>
     * string crypto_key_backend = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for cryptoKeyBackend.
     */
    public com.google.protobuf.ByteString getCryptoKeyBackendBytes() {
      java.lang.Object ref = cryptoKeyBackend_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cryptoKeyBackend_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the backend environment where the key
     * material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
     * associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
     * where all related cryptographic operations are performed. Only applicable
     * if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
     * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
     * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], with the
     * resource name in the format `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * Note, this list is non-exhaustive and may apply to additional
     * [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
     * </pre>
     *
     * <code>
     * string crypto_key_backend = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The cryptoKeyBackend to set.
     * @return This builder for chaining.
     */
    public Builder setCryptoKeyBackend(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cryptoKeyBackend_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the backend environment where the key
     * material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
     * associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
     * where all related cryptographic operations are performed. Only applicable
     * if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
     * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
     * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], with the
     * resource name in the format `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * Note, this list is non-exhaustive and may apply to additional
     * [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
     * </pre>
     *
     * <code>
     * string crypto_key_backend = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCryptoKeyBackend() {
      cryptoKeyBackend_ = getDefaultInstance().getCryptoKeyBackend();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the backend environment where the key
     * material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
     * associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
     * where all related cryptographic operations are performed. Only applicable
     * if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
     * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
     * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], with the
     * resource name in the format `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * Note, this list is non-exhaustive and may apply to additional
     * [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
     * </pre>
     *
     * <code>
     * string crypto_key_backend = 15 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for cryptoKeyBackend to set.
     * @return This builder for chaining.
     */
    public Builder setCryptoKeyBackendBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cryptoKeyBackend_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.CryptoKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.CryptoKey)
  private static final com.google.cloud.kms.v1.CryptoKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.CryptoKey();
  }

  public static com.google.cloud.kms.v1.CryptoKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CryptoKey> PARSER =
      new com.google.protobuf.AbstractParser<CryptoKey>() {
        @java.lang.Override
        public CryptoKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CryptoKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CryptoKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
