/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Contains an HSM-generated attestation about a key operation. For more
 * information, see [Verifying attestations]
 * (https://cloud.google.com/kms/docs/attest-key).
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.KeyOperationAttestation}
 */
public final class KeyOperationAttestation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.KeyOperationAttestation)
    KeyOperationAttestationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KeyOperationAttestation.newBuilder() to construct.
  private KeyOperationAttestation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KeyOperationAttestation() {
    format_ = 0;
    content_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KeyOperationAttestation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_KeyOperationAttestation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_KeyOperationAttestation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.KeyOperationAttestation.class,
            com.google.cloud.kms.v1.KeyOperationAttestation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Attestation formats provided by the HSM.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat}
   */
  public enum AttestationFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>ATTESTATION_FORMAT_UNSPECIFIED = 0;</code>
     */
    ATTESTATION_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Cavium HSM attestation compressed with gzip. Note that this format is
     * defined by Cavium and subject to change at any time.
     *
     * See
     * https://www.marvell.com/products/security-solutions/nitrox-hs-adapters/software-key-attestation.html.
     * </pre>
     *
     * <code>CAVIUM_V1_COMPRESSED = 3;</code>
     */
    CAVIUM_V1_COMPRESSED(3),
    /**
     *
     *
     * <pre>
     * Cavium HSM attestation V2 compressed with gzip. This is a new format
     * introduced in Cavium's version 3.2-08.
     * </pre>
     *
     * <code>CAVIUM_V2_COMPRESSED = 4;</code>
     */
    CAVIUM_V2_COMPRESSED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>ATTESTATION_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int ATTESTATION_FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Cavium HSM attestation compressed with gzip. Note that this format is
     * defined by Cavium and subject to change at any time.
     *
     * See
     * https://www.marvell.com/products/security-solutions/nitrox-hs-adapters/software-key-attestation.html.
     * </pre>
     *
     * <code>CAVIUM_V1_COMPRESSED = 3;</code>
     */
    public static final int CAVIUM_V1_COMPRESSED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Cavium HSM attestation V2 compressed with gzip. This is a new format
     * introduced in Cavium's version 3.2-08.
     * </pre>
     *
     * <code>CAVIUM_V2_COMPRESSED = 4;</code>
     */
    public static final int CAVIUM_V2_COMPRESSED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AttestationFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AttestationFormat forNumber(int value) {
      switch (value) {
        case 0:
          return ATTESTATION_FORMAT_UNSPECIFIED;
        case 3:
          return CAVIUM_V1_COMPRESSED;
        case 4:
          return CAVIUM_V2_COMPRESSED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AttestationFormat>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AttestationFormat>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AttestationFormat>() {
              public AttestationFormat findValueByNumber(int number) {
                return AttestationFormat.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.KeyOperationAttestation.getDescriptor().getEnumTypes().get(0);
    }

    private static final AttestationFormat[] VALUES = values();

    public static AttestationFormat valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AttestationFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat)
  }

  public interface CertificateChainsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.KeyOperationAttestation.CertificateChains)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @return A list containing the caviumCerts.
     */
    java.util.List<java.lang.String> getCaviumCertsList();
    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @return The count of caviumCerts.
     */
    int getCaviumCertsCount();
    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The caviumCerts at the given index.
     */
    java.lang.String getCaviumCerts(int index);
    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the caviumCerts at the given index.
     */
    com.google.protobuf.ByteString getCaviumCertsBytes(int index);

    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @return A list containing the googleCardCerts.
     */
    java.util.List<java.lang.String> getGoogleCardCertsList();
    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @return The count of googleCardCerts.
     */
    int getGoogleCardCertsCount();
    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The googleCardCerts at the given index.
     */
    java.lang.String getGoogleCardCerts(int index);
    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the googleCardCerts at the given index.
     */
    com.google.protobuf.ByteString getGoogleCardCertsBytes(int index);

    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @return A list containing the googlePartitionCerts.
     */
    java.util.List<java.lang.String> getGooglePartitionCertsList();
    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @return The count of googlePartitionCerts.
     */
    int getGooglePartitionCertsCount();
    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The googlePartitionCerts at the given index.
     */
    java.lang.String getGooglePartitionCerts(int index);
    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the googlePartitionCerts at the given index.
     */
    com.google.protobuf.ByteString getGooglePartitionCertsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Certificate chains needed to verify the attestation.
   * Certificates in chains are PEM-encoded and are ordered based on
   * https://tools.ietf.org/html/rfc5246#section-7.4.2.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.KeyOperationAttestation.CertificateChains}
   */
  public static final class CertificateChains extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.KeyOperationAttestation.CertificateChains)
      CertificateChainsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CertificateChains.newBuilder() to construct.
    private CertificateChains(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CertificateChains() {
      caviumCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      googleCardCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      googlePartitionCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CertificateChains();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyOperationAttestation_CertificateChains_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyOperationAttestation_CertificateChains_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.class,
              com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.Builder.class);
    }

    public static final int CAVIUM_CERTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList caviumCerts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @return A list containing the caviumCerts.
     */
    public com.google.protobuf.ProtocolStringList getCaviumCertsList() {
      return caviumCerts_;
    }
    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @return The count of caviumCerts.
     */
    public int getCaviumCertsCount() {
      return caviumCerts_.size();
    }
    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The caviumCerts at the given index.
     */
    public java.lang.String getCaviumCerts(int index) {
      return caviumCerts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Cavium certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string cavium_certs = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the caviumCerts at the given index.
     */
    public com.google.protobuf.ByteString getCaviumCertsBytes(int index) {
      return caviumCerts_.getByteString(index);
    }

    public static final int GOOGLE_CARD_CERTS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList googleCardCerts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @return A list containing the googleCardCerts.
     */
    public com.google.protobuf.ProtocolStringList getGoogleCardCertsList() {
      return googleCardCerts_;
    }
    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @return The count of googleCardCerts.
     */
    public int getGoogleCardCertsCount() {
      return googleCardCerts_.size();
    }
    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The googleCardCerts at the given index.
     */
    public java.lang.String getGoogleCardCerts(int index) {
      return googleCardCerts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Google card certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_card_certs = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the googleCardCerts at the given index.
     */
    public com.google.protobuf.ByteString getGoogleCardCertsBytes(int index) {
      return googleCardCerts_.getByteString(index);
    }

    public static final int GOOGLE_PARTITION_CERTS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList googlePartitionCerts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @return A list containing the googlePartitionCerts.
     */
    public com.google.protobuf.ProtocolStringList getGooglePartitionCertsList() {
      return googlePartitionCerts_;
    }
    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @return The count of googlePartitionCerts.
     */
    public int getGooglePartitionCertsCount() {
      return googlePartitionCerts_.size();
    }
    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The googlePartitionCerts at the given index.
     */
    public java.lang.String getGooglePartitionCerts(int index) {
      return googlePartitionCerts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Google partition certificate chain corresponding to the attestation.
     * </pre>
     *
     * <code>repeated string google_partition_certs = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the googlePartitionCerts at the given index.
     */
    public com.google.protobuf.ByteString getGooglePartitionCertsBytes(int index) {
      return googlePartitionCerts_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < caviumCerts_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, caviumCerts_.getRaw(i));
      }
      for (int i = 0; i < googleCardCerts_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, googleCardCerts_.getRaw(i));
      }
      for (int i = 0; i < googlePartitionCerts_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, googlePartitionCerts_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < caviumCerts_.size(); i++) {
          dataSize += computeStringSizeNoTag(caviumCerts_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCaviumCertsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < googleCardCerts_.size(); i++) {
          dataSize += computeStringSizeNoTag(googleCardCerts_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getGoogleCardCertsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < googlePartitionCerts_.size(); i++) {
          dataSize += computeStringSizeNoTag(googlePartitionCerts_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getGooglePartitionCertsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains)) {
        return super.equals(obj);
      }
      com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains other =
          (com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains) obj;

      if (!getCaviumCertsList().equals(other.getCaviumCertsList())) return false;
      if (!getGoogleCardCertsList().equals(other.getGoogleCardCertsList())) return false;
      if (!getGooglePartitionCertsList().equals(other.getGooglePartitionCertsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getCaviumCertsCount() > 0) {
        hash = (37 * hash) + CAVIUM_CERTS_FIELD_NUMBER;
        hash = (53 * hash) + getCaviumCertsList().hashCode();
      }
      if (getGoogleCardCertsCount() > 0) {
        hash = (37 * hash) + GOOGLE_CARD_CERTS_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleCardCertsList().hashCode();
      }
      if (getGooglePartitionCertsCount() > 0) {
        hash = (37 * hash) + GOOGLE_PARTITION_CERTS_FIELD_NUMBER;
        hash = (53 * hash) + getGooglePartitionCertsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Certificate chains needed to verify the attestation.
     * Certificates in chains are PEM-encoded and are ordered based on
     * https://tools.ietf.org/html/rfc5246#section-7.4.2.
     * </pre>
     *
     * Protobuf type {@code google.cloud.kms.v1.KeyOperationAttestation.CertificateChains}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.KeyOperationAttestation.CertificateChains)
        com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChainsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.kms.v1.KmsResourcesProto
            .internal_static_google_cloud_kms_v1_KeyOperationAttestation_CertificateChains_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.kms.v1.KmsResourcesProto
            .internal_static_google_cloud_kms_v1_KeyOperationAttestation_CertificateChains_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.class,
                com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.Builder.class);
      }

      // Construct using
      // com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        caviumCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        googleCardCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        googlePartitionCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.kms.v1.KmsResourcesProto
            .internal_static_google_cloud_kms_v1_KeyOperationAttestation_CertificateChains_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
          getDefaultInstanceForType() {
        return com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains build() {
        com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains buildPartial() {
        com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains result =
            new com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          caviumCerts_.makeImmutable();
          result.caviumCerts_ = caviumCerts_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          googleCardCerts_.makeImmutable();
          result.googleCardCerts_ = googleCardCerts_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          googlePartitionCerts_.makeImmutable();
          result.googlePartitionCerts_ = googlePartitionCerts_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains) {
          return mergeFrom(
              (com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains other) {
        if (other
            == com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
                .getDefaultInstance()) return this;
        if (!other.caviumCerts_.isEmpty()) {
          if (caviumCerts_.isEmpty()) {
            caviumCerts_ = other.caviumCerts_;
            bitField0_ |= 0x00000001;
          } else {
            ensureCaviumCertsIsMutable();
            caviumCerts_.addAll(other.caviumCerts_);
          }
          onChanged();
        }
        if (!other.googleCardCerts_.isEmpty()) {
          if (googleCardCerts_.isEmpty()) {
            googleCardCerts_ = other.googleCardCerts_;
            bitField0_ |= 0x00000002;
          } else {
            ensureGoogleCardCertsIsMutable();
            googleCardCerts_.addAll(other.googleCardCerts_);
          }
          onChanged();
        }
        if (!other.googlePartitionCerts_.isEmpty()) {
          if (googlePartitionCerts_.isEmpty()) {
            googlePartitionCerts_ = other.googlePartitionCerts_;
            bitField0_ |= 0x00000004;
          } else {
            ensureGooglePartitionCertsIsMutable();
            googlePartitionCerts_.addAll(other.googlePartitionCerts_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCaviumCertsIsMutable();
                  caviumCerts_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureGoogleCardCertsIsMutable();
                  googleCardCerts_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureGooglePartitionCertsIsMutable();
                  googlePartitionCerts_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList caviumCerts_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCaviumCertsIsMutable() {
        if (!caviumCerts_.isModifiable()) {
          caviumCerts_ = new com.google.protobuf.LazyStringArrayList(caviumCerts_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @return A list containing the caviumCerts.
       */
      public com.google.protobuf.ProtocolStringList getCaviumCertsList() {
        caviumCerts_.makeImmutable();
        return caviumCerts_;
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @return The count of caviumCerts.
       */
      public int getCaviumCertsCount() {
        return caviumCerts_.size();
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The caviumCerts at the given index.
       */
      public java.lang.String getCaviumCerts(int index) {
        return caviumCerts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the caviumCerts at the given index.
       */
      public com.google.protobuf.ByteString getCaviumCertsBytes(int index) {
        return caviumCerts_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The caviumCerts to set.
       * @return This builder for chaining.
       */
      public Builder setCaviumCerts(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCaviumCertsIsMutable();
        caviumCerts_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @param value The caviumCerts to add.
       * @return This builder for chaining.
       */
      public Builder addCaviumCerts(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCaviumCertsIsMutable();
        caviumCerts_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @param values The caviumCerts to add.
       * @return This builder for chaining.
       */
      public Builder addAllCaviumCerts(java.lang.Iterable<java.lang.String> values) {
        ensureCaviumCertsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, caviumCerts_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCaviumCerts() {
        caviumCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cavium certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string cavium_certs = 1;</code>
       *
       * @param value The bytes of the caviumCerts to add.
       * @return This builder for chaining.
       */
      public Builder addCaviumCertsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCaviumCertsIsMutable();
        caviumCerts_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList googleCardCerts_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureGoogleCardCertsIsMutable() {
        if (!googleCardCerts_.isModifiable()) {
          googleCardCerts_ = new com.google.protobuf.LazyStringArrayList(googleCardCerts_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @return A list containing the googleCardCerts.
       */
      public com.google.protobuf.ProtocolStringList getGoogleCardCertsList() {
        googleCardCerts_.makeImmutable();
        return googleCardCerts_;
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @return The count of googleCardCerts.
       */
      public int getGoogleCardCertsCount() {
        return googleCardCerts_.size();
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The googleCardCerts at the given index.
       */
      public java.lang.String getGoogleCardCerts(int index) {
        return googleCardCerts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the googleCardCerts at the given index.
       */
      public com.google.protobuf.ByteString getGoogleCardCertsBytes(int index) {
        return googleCardCerts_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The googleCardCerts to set.
       * @return This builder for chaining.
       */
      public Builder setGoogleCardCerts(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoogleCardCertsIsMutable();
        googleCardCerts_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @param value The googleCardCerts to add.
       * @return This builder for chaining.
       */
      public Builder addGoogleCardCerts(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGoogleCardCertsIsMutable();
        googleCardCerts_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @param values The googleCardCerts to add.
       * @return This builder for chaining.
       */
      public Builder addAllGoogleCardCerts(java.lang.Iterable<java.lang.String> values) {
        ensureGoogleCardCertsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, googleCardCerts_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGoogleCardCerts() {
        googleCardCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google card certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_card_certs = 2;</code>
       *
       * @param value The bytes of the googleCardCerts to add.
       * @return This builder for chaining.
       */
      public Builder addGoogleCardCertsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureGoogleCardCertsIsMutable();
        googleCardCerts_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList googlePartitionCerts_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureGooglePartitionCertsIsMutable() {
        if (!googlePartitionCerts_.isModifiable()) {
          googlePartitionCerts_ =
              new com.google.protobuf.LazyStringArrayList(googlePartitionCerts_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @return A list containing the googlePartitionCerts.
       */
      public com.google.protobuf.ProtocolStringList getGooglePartitionCertsList() {
        googlePartitionCerts_.makeImmutable();
        return googlePartitionCerts_;
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @return The count of googlePartitionCerts.
       */
      public int getGooglePartitionCertsCount() {
        return googlePartitionCerts_.size();
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The googlePartitionCerts at the given index.
       */
      public java.lang.String getGooglePartitionCerts(int index) {
        return googlePartitionCerts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the googlePartitionCerts at the given index.
       */
      public com.google.protobuf.ByteString getGooglePartitionCertsBytes(int index) {
        return googlePartitionCerts_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The googlePartitionCerts to set.
       * @return This builder for chaining.
       */
      public Builder setGooglePartitionCerts(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGooglePartitionCertsIsMutable();
        googlePartitionCerts_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @param value The googlePartitionCerts to add.
       * @return This builder for chaining.
       */
      public Builder addGooglePartitionCerts(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGooglePartitionCertsIsMutable();
        googlePartitionCerts_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @param values The googlePartitionCerts to add.
       * @return This builder for chaining.
       */
      public Builder addAllGooglePartitionCerts(java.lang.Iterable<java.lang.String> values) {
        ensureGooglePartitionCertsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, googlePartitionCerts_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGooglePartitionCerts() {
        googlePartitionCerts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google partition certificate chain corresponding to the attestation.
       * </pre>
       *
       * <code>repeated string google_partition_certs = 3;</code>
       *
       * @param value The bytes of the googlePartitionCerts to add.
       * @return This builder for chaining.
       */
      public Builder addGooglePartitionCertsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureGooglePartitionCertsIsMutable();
        googlePartitionCerts_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.KeyOperationAttestation.CertificateChains)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.KeyOperationAttestation.CertificateChains)
    private static final com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains();
    }

    public static com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CertificateChains> PARSER =
        new com.google.protobuf.AbstractParser<CertificateChains>() {
          @java.lang.Override
          public CertificateChains parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CertificateChains> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CertificateChains> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FORMAT_FIELD_NUMBER = 4;
  private int format_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The format of the attestation data.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat format = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for format.
   */
  @java.lang.Override
  public int getFormatValue() {
    return format_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The format of the attestation data.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat format = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The format.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat getFormat() {
    com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat result =
        com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat.forNumber(format_);
    return result == null
        ? com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat.UNRECOGNIZED
        : result;
  }

  public static final int CONTENT_FIELD_NUMBER = 5;
  private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Output only. The attestation data provided by the HSM when the key
   * operation was performed.
   * </pre>
   *
   * <code>bytes content = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContent() {
    return content_;
  }

  public static final int CERT_CHAINS_FIELD_NUMBER = 6;
  private com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains certChains_;
  /**
   *
   *
   * <pre>
   * Output only. The certificate chains needed to validate the attestation
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the certChains field is set.
   */
  @java.lang.Override
  public boolean hasCertChains() {
    return certChains_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The certificate chains needed to validate the attestation
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The certChains.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains getCertChains() {
    return certChains_ == null
        ? com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.getDefaultInstance()
        : certChains_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The certificate chains needed to validate the attestation
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChainsOrBuilder
      getCertChainsOrBuilder() {
    return certChains_ == null
        ? com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.getDefaultInstance()
        : certChains_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (format_
        != com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat
            .ATTESTATION_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, format_);
    }
    if (!content_.isEmpty()) {
      output.writeBytes(5, content_);
    }
    if (certChains_ != null) {
      output.writeMessage(6, getCertChains());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (format_
        != com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat
            .ATTESTATION_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, format_);
    }
    if (!content_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(5, content_);
    }
    if (certChains_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCertChains());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.KeyOperationAttestation)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.KeyOperationAttestation other =
        (com.google.cloud.kms.v1.KeyOperationAttestation) obj;

    if (format_ != other.format_) return false;
    if (!getContent().equals(other.getContent())) return false;
    if (hasCertChains() != other.hasCertChains()) return false;
    if (hasCertChains()) {
      if (!getCertChains().equals(other.getCertChains())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + format_;
    hash = (37 * hash) + CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getContent().hashCode();
    if (hasCertChains()) {
      hash = (37 * hash) + CERT_CHAINS_FIELD_NUMBER;
      hash = (53 * hash) + getCertChains().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.KeyOperationAttestation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains an HSM-generated attestation about a key operation. For more
   * information, see [Verifying attestations]
   * (https://cloud.google.com/kms/docs/attest-key).
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.KeyOperationAttestation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.KeyOperationAttestation)
      com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyOperationAttestation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyOperationAttestation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.KeyOperationAttestation.class,
              com.google.cloud.kms.v1.KeyOperationAttestation.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.KeyOperationAttestation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      format_ = 0;
      content_ = com.google.protobuf.ByteString.EMPTY;
      certChains_ = null;
      if (certChainsBuilder_ != null) {
        certChainsBuilder_.dispose();
        certChainsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyOperationAttestation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyOperationAttestation getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyOperationAttestation build() {
      com.google.cloud.kms.v1.KeyOperationAttestation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyOperationAttestation buildPartial() {
      com.google.cloud.kms.v1.KeyOperationAttestation result =
          new com.google.cloud.kms.v1.KeyOperationAttestation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.KeyOperationAttestation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.format_ = format_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.content_ = content_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.certChains_ = certChainsBuilder_ == null ? certChains_ : certChainsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.KeyOperationAttestation) {
        return mergeFrom((com.google.cloud.kms.v1.KeyOperationAttestation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.KeyOperationAttestation other) {
      if (other == com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance())
        return this;
      if (other.format_ != 0) {
        setFormatValue(other.getFormatValue());
      }
      if (other.getContent() != com.google.protobuf.ByteString.EMPTY) {
        setContent(other.getContent());
      }
      if (other.hasCertChains()) {
        mergeCertChains(other.getCertChains());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 32:
              {
                format_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 32
            case 42:
              {
                content_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCertChainsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int format_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The format of the attestation data.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat format = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override
    public int getFormatValue() {
      return format_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format of the attestation data.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat format = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatValue(int value) {
      format_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format of the attestation data.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat format = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The format.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat getFormat() {
      com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat result =
          com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat.forNumber(format_);
      return result == null
          ? com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format of the attestation data.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat format = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(
        com.google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      format_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The format of the attestation data.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat format = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {
      bitField0_ = (bitField0_ & ~0x00000001);
      format_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Output only. The attestation data provided by the HSM when the key
     * operation was performed.
     * </pre>
     *
     * <code>bytes content = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContent() {
      return content_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The attestation data provided by the HSM when the key
     * operation was performed.
     * </pre>
     *
     * <code>bytes content = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The content to set.
     * @return This builder for chaining.
     */
    public Builder setContent(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      content_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The attestation data provided by the HSM when the key
     * operation was performed.
     * </pre>
     *
     * <code>bytes content = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      content_ = getDefaultInstance().getContent();
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains certChains_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains,
            com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChainsOrBuilder>
        certChainsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the certChains field is set.
     */
    public boolean hasCertChains() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The certChains.
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains getCertChains() {
      if (certChainsBuilder_ == null) {
        return certChains_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.getDefaultInstance()
            : certChains_;
      } else {
        return certChainsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCertChains(
        com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains value) {
      if (certChainsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        certChains_ = value;
      } else {
        certChainsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCertChains(
        com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.Builder builderForValue) {
      if (certChainsBuilder_ == null) {
        certChains_ = builderForValue.build();
      } else {
        certChainsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCertChains(
        com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains value) {
      if (certChainsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && certChains_ != null
            && certChains_
                != com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
                    .getDefaultInstance()) {
          getCertChainsBuilder().mergeFrom(value);
        } else {
          certChains_ = value;
        }
      } else {
        certChainsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCertChains() {
      bitField0_ = (bitField0_ & ~0x00000004);
      certChains_ = null;
      if (certChainsBuilder_ != null) {
        certChainsBuilder_.dispose();
        certChainsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.Builder
        getCertChainsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCertChainsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChainsOrBuilder
        getCertChainsOrBuilder() {
      if (certChainsBuilder_ != null) {
        return certChainsBuilder_.getMessageOrBuilder();
      } else {
        return certChains_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.getDefaultInstance()
            : certChains_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate chains needed to validate the attestation
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation.CertificateChains cert_chains = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains,
            com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChainsOrBuilder>
        getCertChainsFieldBuilder() {
      if (certChainsBuilder_ == null) {
        certChainsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains,
                com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChains.Builder,
                com.google.cloud.kms.v1.KeyOperationAttestation.CertificateChainsOrBuilder>(
                getCertChains(), getParentForChildren(), isClean());
        certChains_ = null;
      }
      return certChainsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.KeyOperationAttestation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.KeyOperationAttestation)
  private static final com.google.cloud.kms.v1.KeyOperationAttestation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.KeyOperationAttestation();
  }

  public static com.google.cloud.kms.v1.KeyOperationAttestation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KeyOperationAttestation> PARSER =
      new com.google.protobuf.AbstractParser<KeyOperationAttestation>() {
        @java.lang.Override
        public KeyOperationAttestation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KeyOperationAttestation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KeyOperationAttestation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
