/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

public interface AsymmetricSignRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.AsymmetricSignRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * signing.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * signing.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. The digest of the data to sign. The digest must be produced with
   * the same digest algorithm as specified by the key version's
   * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
   *
   * This field may not be supplied if
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data]
   * is supplied.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the digest field is set.
   */
  boolean hasDigest();
  /**
   *
   *
   * <pre>
   * Optional. The digest of the data to sign. The digest must be produced with
   * the same digest algorithm as specified by the key version's
   * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
   *
   * This field may not be supplied if
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data]
   * is supplied.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The digest.
   */
  com.google.cloud.kms.v1.Digest getDigest();
  /**
   *
   *
   * <pre>
   * Optional. The digest of the data to sign. The digest must be produced with
   * the same digest algorithm as specified by the key version's
   * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
   *
   * This field may not be supplied if
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data]
   * is supplied.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  com.google.cloud.kms.v1.DigestOrBuilder getDigestOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest])
   * is equal to
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the digestCrc32c field is set.
   */
  boolean hasDigestCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest])
   * is equal to
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The digestCrc32c.
   */
  com.google.protobuf.Int64Value getDigestCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest])
   * is equal to
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getDigestCrc32COrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The data to sign.
   * It can't be supplied if
   * [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]
   * is supplied.
   * </pre>
   *
   * <code>bytes data = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The data.
   */
  com.google.protobuf.ByteString getData();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data])
   * is equal to
   * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dataCrc32c field is set.
   */
  boolean hasDataCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data])
   * is equal to
   * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataCrc32c.
   */
  com.google.protobuf.Int64Value getDataCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.data][google.cloud.kms.v1.AsymmetricSignRequest.data])
   * is equal to
   * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getDataCrc32COrBuilder();
}
