/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/ekm_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * A [Certificate][google.cloud.kms.v1.Certificate] represents an X.509
 * certificate used to authenticate HTTPS connections to EKM replicas.
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.Certificate}
 */
public final class Certificate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.Certificate)
    CertificateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Certificate.newBuilder() to construct.
  private Certificate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Certificate() {
    rawDer_ = com.google.protobuf.ByteString.EMPTY;
    issuer_ = "";
    subject_ = "";
    subjectAlternativeDnsNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serialNumber_ = "";
    sha256Fingerprint_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Certificate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.EkmServiceProto
        .internal_static_google_cloud_kms_v1_Certificate_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.EkmServiceProto
        .internal_static_google_cloud_kms_v1_Certificate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.Certificate.class,
            com.google.cloud.kms.v1.Certificate.Builder.class);
  }

  private int bitField0_;
  public static final int RAW_DER_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString rawDer_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Required. The raw certificate bytes in DER format.
   * </pre>
   *
   * <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rawDer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRawDer() {
    return rawDer_;
  }

  public static final int PARSED_FIELD_NUMBER = 2;
  private boolean parsed_ = false;
  /**
   *
   *
   * <pre>
   * Output only. True if the certificate was parsed successfully.
   * </pre>
   *
   * <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The parsed.
   */
  @java.lang.Override
  public boolean getParsed() {
    return parsed_;
  }

  public static final int ISSUER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object issuer_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The issuer distinguished name in RFC 2253 format. Only present
   * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The issuer.
   */
  @java.lang.Override
  public java.lang.String getIssuer() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issuer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The issuer distinguished name in RFC 2253 format. Only present
   * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for issuer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIssuerBytes() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      issuer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBJECT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subject_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The subject distinguished name in RFC 2253 format. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The subject.
   */
  @java.lang.Override
  public java.lang.String getSubject() {
    java.lang.Object ref = subject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subject_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The subject distinguished name in RFC 2253 format. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for subject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubjectBytes() {
    java.lang.Object ref = subject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBJECT_ALTERNATIVE_DNS_NAMES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList subjectAlternativeDnsNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the subjectAlternativeDnsNames.
   */
  public com.google.protobuf.ProtocolStringList getSubjectAlternativeDnsNamesList() {
    return subjectAlternativeDnsNames_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of subjectAlternativeDnsNames.
   */
  public int getSubjectAlternativeDnsNamesCount() {
    return subjectAlternativeDnsNames_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The subjectAlternativeDnsNames at the given index.
   */
  public java.lang.String getSubjectAlternativeDnsNames(int index) {
    return subjectAlternativeDnsNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subjectAlternativeDnsNames at the given index.
   */
  public com.google.protobuf.ByteString getSubjectAlternativeDnsNamesBytes(int index) {
    return subjectAlternativeDnsNames_.getByteString(index);
  }

  public static final int NOT_BEFORE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp notBeforeTime_;
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid before this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the notBeforeTime field is set.
   */
  @java.lang.Override
  public boolean hasNotBeforeTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid before this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notBeforeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNotBeforeTime() {
    return notBeforeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : notBeforeTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid before this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNotBeforeTimeOrBuilder() {
    return notBeforeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : notBeforeTime_;
  }

  public static final int NOT_AFTER_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp notAfterTime_;
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid after this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the notAfterTime field is set.
   */
  @java.lang.Override
  public boolean hasNotAfterTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid after this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notAfterTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNotAfterTime() {
    return notAfterTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : notAfterTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid after this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNotAfterTimeOrBuilder() {
    return notAfterTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : notAfterTime_;
  }

  public static final int SERIAL_NUMBER_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serialNumber_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The certificate serial number as a hex string. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serialNumber.
   */
  @java.lang.Override
  public java.lang.String getSerialNumber() {
    java.lang.Object ref = serialNumber_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serialNumber_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The certificate serial number as a hex string. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serialNumber.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSerialNumberBytes() {
    java.lang.Object ref = serialNumber_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serialNumber_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHA256_FINGERPRINT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sha256Fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The SHA-256 certificate fingerprint as a hex string. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sha256Fingerprint.
   */
  @java.lang.Override
  public java.lang.String getSha256Fingerprint() {
    java.lang.Object ref = sha256Fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sha256Fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The SHA-256 certificate fingerprint as a hex string. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for sha256Fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSha256FingerprintBytes() {
    java.lang.Object ref = sha256Fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sha256Fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!rawDer_.isEmpty()) {
      output.writeBytes(1, rawDer_);
    }
    if (parsed_ != false) {
      output.writeBool(2, parsed_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, subject_);
    }
    for (int i = 0; i < subjectAlternativeDnsNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, subjectAlternativeDnsNames_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getNotBeforeTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getNotAfterTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serialNumber_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, serialNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sha256Fingerprint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, sha256Fingerprint_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!rawDer_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, rawDer_);
    }
    if (parsed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, parsed_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, subject_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < subjectAlternativeDnsNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(subjectAlternativeDnsNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSubjectAlternativeDnsNamesList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getNotBeforeTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNotAfterTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serialNumber_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, serialNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sha256Fingerprint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, sha256Fingerprint_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.Certificate)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.Certificate other = (com.google.cloud.kms.v1.Certificate) obj;

    if (!getRawDer().equals(other.getRawDer())) return false;
    if (getParsed() != other.getParsed()) return false;
    if (!getIssuer().equals(other.getIssuer())) return false;
    if (!getSubject().equals(other.getSubject())) return false;
    if (!getSubjectAlternativeDnsNamesList().equals(other.getSubjectAlternativeDnsNamesList()))
      return false;
    if (hasNotBeforeTime() != other.hasNotBeforeTime()) return false;
    if (hasNotBeforeTime()) {
      if (!getNotBeforeTime().equals(other.getNotBeforeTime())) return false;
    }
    if (hasNotAfterTime() != other.hasNotAfterTime()) return false;
    if (hasNotAfterTime()) {
      if (!getNotAfterTime().equals(other.getNotAfterTime())) return false;
    }
    if (!getSerialNumber().equals(other.getSerialNumber())) return false;
    if (!getSha256Fingerprint().equals(other.getSha256Fingerprint())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RAW_DER_FIELD_NUMBER;
    hash = (53 * hash) + getRawDer().hashCode();
    hash = (37 * hash) + PARSED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getParsed());
    hash = (37 * hash) + ISSUER_FIELD_NUMBER;
    hash = (53 * hash) + getIssuer().hashCode();
    hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getSubject().hashCode();
    if (getSubjectAlternativeDnsNamesCount() > 0) {
      hash = (37 * hash) + SUBJECT_ALTERNATIVE_DNS_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getSubjectAlternativeDnsNamesList().hashCode();
    }
    if (hasNotBeforeTime()) {
      hash = (37 * hash) + NOT_BEFORE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNotBeforeTime().hashCode();
    }
    if (hasNotAfterTime()) {
      hash = (37 * hash) + NOT_AFTER_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNotAfterTime().hashCode();
    }
    hash = (37 * hash) + SERIAL_NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + getSerialNumber().hashCode();
    hash = (37 * hash) + SHA256_FINGERPRINT_FIELD_NUMBER;
    hash = (53 * hash) + getSha256Fingerprint().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.Certificate parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.Certificate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.Certificate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.Certificate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [Certificate][google.cloud.kms.v1.Certificate] represents an X.509
   * certificate used to authenticate HTTPS connections to EKM replicas.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.Certificate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.Certificate)
      com.google.cloud.kms.v1.CertificateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_Certificate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_Certificate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.Certificate.class,
              com.google.cloud.kms.v1.Certificate.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.Certificate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNotBeforeTimeFieldBuilder();
        getNotAfterTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      rawDer_ = com.google.protobuf.ByteString.EMPTY;
      parsed_ = false;
      issuer_ = "";
      subject_ = "";
      subjectAlternativeDnsNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      notBeforeTime_ = null;
      if (notBeforeTimeBuilder_ != null) {
        notBeforeTimeBuilder_.dispose();
        notBeforeTimeBuilder_ = null;
      }
      notAfterTime_ = null;
      if (notAfterTimeBuilder_ != null) {
        notAfterTimeBuilder_.dispose();
        notAfterTimeBuilder_ = null;
      }
      serialNumber_ = "";
      sha256Fingerprint_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_Certificate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.Certificate getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.Certificate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.Certificate build() {
      com.google.cloud.kms.v1.Certificate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.Certificate buildPartial() {
      com.google.cloud.kms.v1.Certificate result = new com.google.cloud.kms.v1.Certificate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.Certificate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.rawDer_ = rawDer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parsed_ = parsed_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.issuer_ = issuer_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.subject_ = subject_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        subjectAlternativeDnsNames_.makeImmutable();
        result.subjectAlternativeDnsNames_ = subjectAlternativeDnsNames_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.notBeforeTime_ =
            notBeforeTimeBuilder_ == null ? notBeforeTime_ : notBeforeTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.notAfterTime_ =
            notAfterTimeBuilder_ == null ? notAfterTime_ : notAfterTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.serialNumber_ = serialNumber_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.sha256Fingerprint_ = sha256Fingerprint_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.Certificate) {
        return mergeFrom((com.google.cloud.kms.v1.Certificate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.Certificate other) {
      if (other == com.google.cloud.kms.v1.Certificate.getDefaultInstance()) return this;
      if (other.getRawDer() != com.google.protobuf.ByteString.EMPTY) {
        setRawDer(other.getRawDer());
      }
      if (other.getParsed() != false) {
        setParsed(other.getParsed());
      }
      if (!other.getIssuer().isEmpty()) {
        issuer_ = other.issuer_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getSubject().isEmpty()) {
        subject_ = other.subject_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.subjectAlternativeDnsNames_.isEmpty()) {
        if (subjectAlternativeDnsNames_.isEmpty()) {
          subjectAlternativeDnsNames_ = other.subjectAlternativeDnsNames_;
          bitField0_ |= 0x00000010;
        } else {
          ensureSubjectAlternativeDnsNamesIsMutable();
          subjectAlternativeDnsNames_.addAll(other.subjectAlternativeDnsNames_);
        }
        onChanged();
      }
      if (other.hasNotBeforeTime()) {
        mergeNotBeforeTime(other.getNotBeforeTime());
      }
      if (other.hasNotAfterTime()) {
        mergeNotAfterTime(other.getNotAfterTime());
      }
      if (!other.getSerialNumber().isEmpty()) {
        serialNumber_ = other.serialNumber_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getSha256Fingerprint().isEmpty()) {
        sha256Fingerprint_ = other.sha256Fingerprint_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                rawDer_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                parsed_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                issuer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                subject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSubjectAlternativeDnsNamesIsMutable();
                subjectAlternativeDnsNames_.add(s);
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getNotBeforeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getNotAfterTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                serialNumber_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                sha256Fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString rawDer_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The raw certificate bytes in DER format.
     * </pre>
     *
     * <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rawDer.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRawDer() {
      return rawDer_;
    }
    /**
     *
     *
     * <pre>
     * Required. The raw certificate bytes in DER format.
     * </pre>
     *
     * <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The rawDer to set.
     * @return This builder for chaining.
     */
    public Builder setRawDer(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rawDer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The raw certificate bytes in DER format.
     * </pre>
     *
     * <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRawDer() {
      bitField0_ = (bitField0_ & ~0x00000001);
      rawDer_ = getDefaultInstance().getRawDer();
      onChanged();
      return this;
    }

    private boolean parsed_;
    /**
     *
     *
     * <pre>
     * Output only. True if the certificate was parsed successfully.
     * </pre>
     *
     * <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The parsed.
     */
    @java.lang.Override
    public boolean getParsed() {
      return parsed_;
    }
    /**
     *
     *
     * <pre>
     * Output only. True if the certificate was parsed successfully.
     * </pre>
     *
     * <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The parsed to set.
     * @return This builder for chaining.
     */
    public Builder setParsed(boolean value) {

      parsed_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. True if the certificate was parsed successfully.
     * </pre>
     *
     * <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParsed() {
      bitField0_ = (bitField0_ & ~0x00000002);
      parsed_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object issuer_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The issuer.
     */
    public java.lang.String getIssuer() {
      java.lang.Object ref = issuer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issuer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for issuer.
     */
    public com.google.protobuf.ByteString getIssuerBytes() {
      java.lang.Object ref = issuer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issuer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      issuer_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssuer() {
      issuer_ = getDefaultInstance().getIssuer();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      issuer_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object subject_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The subject.
     */
    public java.lang.String getSubject() {
      java.lang.Object ref = subject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for subject.
     */
    public com.google.protobuf.ByteString getSubjectBytes() {
      java.lang.Object ref = subject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The subject to set.
     * @return This builder for chaining.
     */
    public Builder setSubject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subject_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubject() {
      subject_ = getDefaultInstance().getSubject();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for subject to set.
     * @return This builder for chaining.
     */
    public Builder setSubjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subject_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList subjectAlternativeDnsNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSubjectAlternativeDnsNamesIsMutable() {
      if (!subjectAlternativeDnsNames_.isModifiable()) {
        subjectAlternativeDnsNames_ =
            new com.google.protobuf.LazyStringArrayList(subjectAlternativeDnsNames_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the subjectAlternativeDnsNames.
     */
    public com.google.protobuf.ProtocolStringList getSubjectAlternativeDnsNamesList() {
      subjectAlternativeDnsNames_.makeImmutable();
      return subjectAlternativeDnsNames_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of subjectAlternativeDnsNames.
     */
    public int getSubjectAlternativeDnsNamesCount() {
      return subjectAlternativeDnsNames_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The subjectAlternativeDnsNames at the given index.
     */
    public java.lang.String getSubjectAlternativeDnsNames(int index) {
      return subjectAlternativeDnsNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the subjectAlternativeDnsNames at the given index.
     */
    public com.google.protobuf.ByteString getSubjectAlternativeDnsNamesBytes(int index) {
      return subjectAlternativeDnsNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The subjectAlternativeDnsNames to set.
     * @return This builder for chaining.
     */
    public Builder setSubjectAlternativeDnsNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectAlternativeDnsNamesIsMutable();
      subjectAlternativeDnsNames_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The subjectAlternativeDnsNames to add.
     * @return This builder for chaining.
     */
    public Builder addSubjectAlternativeDnsNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectAlternativeDnsNamesIsMutable();
      subjectAlternativeDnsNames_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The subjectAlternativeDnsNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllSubjectAlternativeDnsNames(java.lang.Iterable<java.lang.String> values) {
      ensureSubjectAlternativeDnsNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subjectAlternativeDnsNames_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubjectAlternativeDnsNames() {
      subjectAlternativeDnsNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the subjectAlternativeDnsNames to add.
     * @return This builder for chaining.
     */
    public Builder addSubjectAlternativeDnsNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSubjectAlternativeDnsNamesIsMutable();
      subjectAlternativeDnsNames_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp notBeforeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        notBeforeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the notBeforeTime field is set.
     */
    public boolean hasNotBeforeTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The notBeforeTime.
     */
    public com.google.protobuf.Timestamp getNotBeforeTime() {
      if (notBeforeTimeBuilder_ == null) {
        return notBeforeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : notBeforeTime_;
      } else {
        return notBeforeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotBeforeTime(com.google.protobuf.Timestamp value) {
      if (notBeforeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notBeforeTime_ = value;
      } else {
        notBeforeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotBeforeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (notBeforeTimeBuilder_ == null) {
        notBeforeTime_ = builderForValue.build();
      } else {
        notBeforeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNotBeforeTime(com.google.protobuf.Timestamp value) {
      if (notBeforeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && notBeforeTime_ != null
            && notBeforeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getNotBeforeTimeBuilder().mergeFrom(value);
        } else {
          notBeforeTime_ = value;
        }
      } else {
        notBeforeTimeBuilder_.mergeFrom(value);
      }
      if (notBeforeTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNotBeforeTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      notBeforeTime_ = null;
      if (notBeforeTimeBuilder_ != null) {
        notBeforeTimeBuilder_.dispose();
        notBeforeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getNotBeforeTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getNotBeforeTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getNotBeforeTimeOrBuilder() {
      if (notBeforeTimeBuilder_ != null) {
        return notBeforeTimeBuilder_.getMessageOrBuilder();
      } else {
        return notBeforeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : notBeforeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNotBeforeTimeFieldBuilder() {
      if (notBeforeTimeBuilder_ == null) {
        notBeforeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNotBeforeTime(), getParentForChildren(), isClean());
        notBeforeTime_ = null;
      }
      return notBeforeTimeBuilder_;
    }

    private com.google.protobuf.Timestamp notAfterTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        notAfterTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the notAfterTime field is set.
     */
    public boolean hasNotAfterTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The notAfterTime.
     */
    public com.google.protobuf.Timestamp getNotAfterTime() {
      if (notAfterTimeBuilder_ == null) {
        return notAfterTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : notAfterTime_;
      } else {
        return notAfterTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotAfterTime(com.google.protobuf.Timestamp value) {
      if (notAfterTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notAfterTime_ = value;
      } else {
        notAfterTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNotAfterTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (notAfterTimeBuilder_ == null) {
        notAfterTime_ = builderForValue.build();
      } else {
        notAfterTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNotAfterTime(com.google.protobuf.Timestamp value) {
      if (notAfterTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && notAfterTime_ != null
            && notAfterTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getNotAfterTimeBuilder().mergeFrom(value);
        } else {
          notAfterTime_ = value;
        }
      } else {
        notAfterTimeBuilder_.mergeFrom(value);
      }
      if (notAfterTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNotAfterTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      notAfterTime_ = null;
      if (notAfterTimeBuilder_ != null) {
        notAfterTimeBuilder_.dispose();
        notAfterTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getNotAfterTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getNotAfterTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getNotAfterTimeOrBuilder() {
      if (notAfterTimeBuilder_ != null) {
        return notAfterTimeBuilder_.getMessageOrBuilder();
      } else {
        return notAfterTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : notAfterTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNotAfterTimeFieldBuilder() {
      if (notAfterTimeBuilder_ == null) {
        notAfterTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNotAfterTime(), getParentForChildren(), isClean());
        notAfterTime_ = null;
      }
      return notAfterTimeBuilder_;
    }

    private java.lang.Object serialNumber_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serialNumber.
     */
    public java.lang.String getSerialNumber() {
      java.lang.Object ref = serialNumber_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serialNumber_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serialNumber.
     */
    public com.google.protobuf.ByteString getSerialNumberBytes() {
      java.lang.Object ref = serialNumber_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serialNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serialNumber to set.
     * @return This builder for chaining.
     */
    public Builder setSerialNumber(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serialNumber_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSerialNumber() {
      serialNumber_ = getDefaultInstance().getSerialNumber();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for serialNumber to set.
     * @return This builder for chaining.
     */
    public Builder setSerialNumberBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serialNumber_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object sha256Fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sha256Fingerprint.
     */
    public java.lang.String getSha256Fingerprint() {
      java.lang.Object ref = sha256Fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sha256Fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for sha256Fingerprint.
     */
    public com.google.protobuf.ByteString getSha256FingerprintBytes() {
      java.lang.Object ref = sha256Fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sha256Fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The sha256Fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setSha256Fingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sha256Fingerprint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSha256Fingerprint() {
      sha256Fingerprint_ = getDefaultInstance().getSha256Fingerprint();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * </pre>
     *
     * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for sha256Fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setSha256FingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sha256Fingerprint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.Certificate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.Certificate)
  private static final com.google.cloud.kms.v1.Certificate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.Certificate();
  }

  public static com.google.cloud.kms.v1.Certificate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Certificate> PARSER =
      new com.google.protobuf.AbstractParser<Certificate>() {
        @java.lang.Override
        public Certificate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Certificate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Certificate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.Certificate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
