/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/ekm_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.kms.v1;

public interface CertificateOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.Certificate)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The raw certificate bytes in DER format.
   * </pre>
   *
   * <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rawDer.
   */
  com.google.protobuf.ByteString getRawDer();

  /**
   *
   *
   * <pre>
   * Output only. True if the certificate was parsed successfully.
   * </pre>
   *
   * <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The parsed.
   */
  boolean getParsed();

  /**
   *
   *
   * <pre>
   * Output only. The issuer distinguished name in RFC 2253 format. Only present
   * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The issuer.
   */
  java.lang.String getIssuer();
  /**
   *
   *
   * <pre>
   * Output only. The issuer distinguished name in RFC 2253 format. Only present
   * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for issuer.
   */
  com.google.protobuf.ByteString getIssuerBytes();

  /**
   *
   *
   * <pre>
   * Output only. The subject distinguished name in RFC 2253 format. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The subject.
   */
  java.lang.String getSubject();
  /**
   *
   *
   * <pre>
   * Output only. The subject distinguished name in RFC 2253 format. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for subject.
   */
  com.google.protobuf.ByteString getSubjectBytes();

  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the subjectAlternativeDnsNames.
   */
  java.util.List<java.lang.String> getSubjectAlternativeDnsNamesList();
  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of subjectAlternativeDnsNames.
   */
  int getSubjectAlternativeDnsNamesCount();
  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The subjectAlternativeDnsNames at the given index.
   */
  java.lang.String getSubjectAlternativeDnsNames(int index);
  /**
   *
   *
   * <pre>
   * Output only. The subject Alternative DNS names. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subjectAlternativeDnsNames at the given index.
   */
  com.google.protobuf.ByteString getSubjectAlternativeDnsNamesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid before this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the notBeforeTime field is set.
   */
  boolean hasNotBeforeTime();
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid before this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notBeforeTime.
   */
  com.google.protobuf.Timestamp getNotBeforeTime();
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid before this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getNotBeforeTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid after this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the notAfterTime field is set.
   */
  boolean hasNotAfterTime();
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid after this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notAfterTime.
   */
  com.google.protobuf.Timestamp getNotAfterTime();
  /**
   *
   *
   * <pre>
   * Output only. The certificate is not valid after this time. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getNotAfterTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The certificate serial number as a hex string. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serialNumber.
   */
  java.lang.String getSerialNumber();
  /**
   *
   *
   * <pre>
   * Output only. The certificate serial number as a hex string. Only present if
   * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serialNumber.
   */
  com.google.protobuf.ByteString getSerialNumberBytes();

  /**
   *
   *
   * <pre>
   * Output only. The SHA-256 certificate fingerprint as a hex string. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sha256Fingerprint.
   */
  java.lang.String getSha256Fingerprint();
  /**
   *
   *
   * <pre>
   * Output only. The SHA-256 certificate fingerprint as a hex string. Only
   * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
   * </pre>
   *
   * <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for sha256Fingerprint.
   */
  com.google.protobuf.ByteString getSha256FingerprintBytes();
}
