/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.EncryptRequest}
 */
public final class EncryptRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.EncryptRequest)
    EncryptRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EncryptRequest.newBuilder() to construct.
  private EncryptRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EncryptRequest() {
    name_ = "";
    plaintext_ = com.google.protobuf.ByteString.EMPTY;
    additionalAuthenticatedData_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EncryptRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_EncryptRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_EncryptRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.EncryptRequest.class,
            com.google.cloud.kms.v1.EncryptRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] or
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * encryption.
   *
   * If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
   * will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] or
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * encryption.
   *
   * If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
   * will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLAINTEXT_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString plaintext_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Required. The data to encrypt. Must be no larger than 64KiB.
   *
   * The maximum size depends on the key version's
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
   * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
   * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys, the
   * plaintext must be no larger than 64KiB. For
   * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
   * the plaintext and additional_authenticated_data fields must be no larger
   * than 8KiB.
   * </pre>
   *
   * <code>bytes plaintext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The plaintext.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaintext() {
    return plaintext_;
  }

  public static final int ADDITIONAL_AUTHENTICATED_DATA_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString additionalAuthenticatedData_ =
      com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. Optional data that, if specified, must also be provided during
   * decryption through
   * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
   *
   * The maximum size depends on the key version's
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
   * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
   * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys the
   * AAD must be no larger than 64KiB. For
   * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
   * the plaintext and additional_authenticated_data fields must be no larger
   * than 8KiB.
   * </pre>
   *
   * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The additionalAuthenticatedData.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdditionalAuthenticatedData() {
    return additionalAuthenticatedData_;
  }

  public static final int PLAINTEXT_CRC32C_FIELD_NUMBER = 7;
  private com.google.protobuf.Int64Value plaintextCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
   * is equal to
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the plaintextCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasPlaintextCrc32C() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
   * is equal to
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The plaintextCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getPlaintextCrc32C() {
    return plaintextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : plaintextCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
   * is equal to
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder() {
    return plaintextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : plaintextCrc32C_;
  }

  public static final int ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER = 8;
  private com.google.protobuf.Int64Value additionalAuthenticatedDataCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
   * is equal to
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the additionalAuthenticatedDataCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasAdditionalAuthenticatedDataCrc32C() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
   * is equal to
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The additionalAuthenticatedDataCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getAdditionalAuthenticatedDataCrc32C() {
    return additionalAuthenticatedDataCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : additionalAuthenticatedDataCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
   * is equal to
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getAdditionalAuthenticatedDataCrc32COrBuilder() {
    return additionalAuthenticatedDataCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : additionalAuthenticatedDataCrc32C_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!plaintext_.isEmpty()) {
      output.writeBytes(2, plaintext_);
    }
    if (!additionalAuthenticatedData_.isEmpty()) {
      output.writeBytes(3, additionalAuthenticatedData_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getPlaintextCrc32C());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getAdditionalAuthenticatedDataCrc32C());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!plaintext_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, plaintext_);
    }
    if (!additionalAuthenticatedData_.isEmpty()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(3, additionalAuthenticatedData_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPlaintextCrc32C());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getAdditionalAuthenticatedDataCrc32C());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.EncryptRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.EncryptRequest other = (com.google.cloud.kms.v1.EncryptRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getPlaintext().equals(other.getPlaintext())) return false;
    if (!getAdditionalAuthenticatedData().equals(other.getAdditionalAuthenticatedData()))
      return false;
    if (hasPlaintextCrc32C() != other.hasPlaintextCrc32C()) return false;
    if (hasPlaintextCrc32C()) {
      if (!getPlaintextCrc32C().equals(other.getPlaintextCrc32C())) return false;
    }
    if (hasAdditionalAuthenticatedDataCrc32C() != other.hasAdditionalAuthenticatedDataCrc32C())
      return false;
    if (hasAdditionalAuthenticatedDataCrc32C()) {
      if (!getAdditionalAuthenticatedDataCrc32C()
          .equals(other.getAdditionalAuthenticatedDataCrc32C())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PLAINTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getPlaintext().hashCode();
    hash = (37 * hash) + ADDITIONAL_AUTHENTICATED_DATA_FIELD_NUMBER;
    hash = (53 * hash) + getAdditionalAuthenticatedData().hashCode();
    if (hasPlaintextCrc32C()) {
      hash = (37 * hash) + PLAINTEXT_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getPlaintextCrc32C().hashCode();
    }
    if (hasAdditionalAuthenticatedDataCrc32C()) {
      hash = (37 * hash) + ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalAuthenticatedDataCrc32C().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EncryptRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.EncryptRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.EncryptRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.EncryptRequest)
      com.google.cloud.kms.v1.EncryptRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_EncryptRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_EncryptRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.EncryptRequest.class,
              com.google.cloud.kms.v1.EncryptRequest.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.EncryptRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPlaintextCrc32CFieldBuilder();
        getAdditionalAuthenticatedDataCrc32CFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      plaintext_ = com.google.protobuf.ByteString.EMPTY;
      additionalAuthenticatedData_ = com.google.protobuf.ByteString.EMPTY;
      plaintextCrc32C_ = null;
      if (plaintextCrc32CBuilder_ != null) {
        plaintextCrc32CBuilder_.dispose();
        plaintextCrc32CBuilder_ = null;
      }
      additionalAuthenticatedDataCrc32C_ = null;
      if (additionalAuthenticatedDataCrc32CBuilder_ != null) {
        additionalAuthenticatedDataCrc32CBuilder_.dispose();
        additionalAuthenticatedDataCrc32CBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_EncryptRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EncryptRequest getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.EncryptRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EncryptRequest build() {
      com.google.cloud.kms.v1.EncryptRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EncryptRequest buildPartial() {
      com.google.cloud.kms.v1.EncryptRequest result =
          new com.google.cloud.kms.v1.EncryptRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.EncryptRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.plaintext_ = plaintext_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.additionalAuthenticatedData_ = additionalAuthenticatedData_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.plaintextCrc32C_ =
            plaintextCrc32CBuilder_ == null ? plaintextCrc32C_ : plaintextCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.additionalAuthenticatedDataCrc32C_ =
            additionalAuthenticatedDataCrc32CBuilder_ == null
                ? additionalAuthenticatedDataCrc32C_
                : additionalAuthenticatedDataCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.EncryptRequest) {
        return mergeFrom((com.google.cloud.kms.v1.EncryptRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.EncryptRequest other) {
      if (other == com.google.cloud.kms.v1.EncryptRequest.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPlaintext() != com.google.protobuf.ByteString.EMPTY) {
        setPlaintext(other.getPlaintext());
      }
      if (other.getAdditionalAuthenticatedData() != com.google.protobuf.ByteString.EMPTY) {
        setAdditionalAuthenticatedData(other.getAdditionalAuthenticatedData());
      }
      if (other.hasPlaintextCrc32C()) {
        mergePlaintextCrc32C(other.getPlaintextCrc32C());
      }
      if (other.hasAdditionalAuthenticatedDataCrc32C()) {
        mergeAdditionalAuthenticatedDataCrc32C(other.getAdditionalAuthenticatedDataCrc32C());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                plaintext_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                additionalAuthenticatedData_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 58:
              {
                input.readMessage(getPlaintextCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getAdditionalAuthenticatedDataCrc32CFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] or
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * encryption.
     *
     * If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
     * will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] or
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * encryption.
     *
     * If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
     * will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] or
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * encryption.
     *
     * If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
     * will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] or
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * encryption.
     *
     * If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
     * will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] or
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * encryption.
     *
     * If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
     * will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString plaintext_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The data to encrypt. Must be no larger than 64KiB.
     *
     * The maximum size depends on the key version's
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
     * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
     * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys, the
     * plaintext must be no larger than 64KiB. For
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
     * the plaintext and additional_authenticated_data fields must be no larger
     * than 8KiB.
     * </pre>
     *
     * <code>bytes plaintext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The plaintext.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPlaintext() {
      return plaintext_;
    }
    /**
     *
     *
     * <pre>
     * Required. The data to encrypt. Must be no larger than 64KiB.
     *
     * The maximum size depends on the key version's
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
     * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
     * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys, the
     * plaintext must be no larger than 64KiB. For
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
     * the plaintext and additional_authenticated_data fields must be no larger
     * than 8KiB.
     * </pre>
     *
     * <code>bytes plaintext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The plaintext to set.
     * @return This builder for chaining.
     */
    public Builder setPlaintext(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      plaintext_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data to encrypt. Must be no larger than 64KiB.
     *
     * The maximum size depends on the key version's
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
     * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
     * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys, the
     * plaintext must be no larger than 64KiB. For
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
     * the plaintext and additional_authenticated_data fields must be no larger
     * than 8KiB.
     * </pre>
     *
     * <code>bytes plaintext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaintext() {
      bitField0_ = (bitField0_ & ~0x00000002);
      plaintext_ = getDefaultInstance().getPlaintext();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString additionalAuthenticatedData_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. Optional data that, if specified, must also be provided during
     * decryption through
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     *
     * The maximum size depends on the key version's
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
     * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
     * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys the
     * AAD must be no larger than 64KiB. For
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
     * the plaintext and additional_authenticated_data fields must be no larger
     * than 8KiB.
     * </pre>
     *
     * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The additionalAuthenticatedData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAdditionalAuthenticatedData() {
      return additionalAuthenticatedData_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional data that, if specified, must also be provided during
     * decryption through
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     *
     * The maximum size depends on the key version's
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
     * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
     * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys the
     * AAD must be no larger than 64KiB. For
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
     * the plaintext and additional_authenticated_data fields must be no larger
     * than 8KiB.
     * </pre>
     *
     * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The additionalAuthenticatedData to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalAuthenticatedData(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      additionalAuthenticatedData_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional data that, if specified, must also be provided during
     * decryption through
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     *
     * The maximum size depends on the key version's
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
     * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE],
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL], and
     * [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] keys the
     * AAD must be no larger than 64KiB. For
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
     * the plaintext and additional_authenticated_data fields must be no larger
     * than 8KiB.
     * </pre>
     *
     * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdditionalAuthenticatedData() {
      bitField0_ = (bitField0_ & ~0x00000004);
      additionalAuthenticatedData_ = getDefaultInstance().getAdditionalAuthenticatedData();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value plaintextCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        plaintextCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the plaintextCrc32c field is set.
     */
    public boolean hasPlaintextCrc32C() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The plaintextCrc32c.
     */
    public com.google.protobuf.Int64Value getPlaintextCrc32C() {
      if (plaintextCrc32CBuilder_ == null) {
        return plaintextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : plaintextCrc32C_;
      } else {
        return plaintextCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaintextCrc32C(com.google.protobuf.Int64Value value) {
      if (plaintextCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        plaintextCrc32C_ = value;
      } else {
        plaintextCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaintextCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32C_ = builderForValue.build();
      } else {
        plaintextCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlaintextCrc32C(com.google.protobuf.Int64Value value) {
      if (plaintextCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && plaintextCrc32C_ != null
            && plaintextCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getPlaintextCrc32CBuilder().mergeFrom(value);
        } else {
          plaintextCrc32C_ = value;
        }
      } else {
        plaintextCrc32CBuilder_.mergeFrom(value);
      }
      if (plaintextCrc32C_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlaintextCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000008);
      plaintextCrc32C_ = null;
      if (plaintextCrc32CBuilder_ != null) {
        plaintextCrc32CBuilder_.dispose();
        plaintextCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getPlaintextCrc32CBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPlaintextCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder() {
      if (plaintextCrc32CBuilder_ != null) {
        return plaintextCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return plaintextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : plaintextCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext])
     * is equal to
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value plaintext_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getPlaintextCrc32CFieldBuilder() {
      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getPlaintextCrc32C(), getParentForChildren(), isClean());
        plaintextCrc32C_ = null;
      }
      return plaintextCrc32CBuilder_;
    }

    private com.google.protobuf.Int64Value additionalAuthenticatedDataCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        additionalAuthenticatedDataCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the additionalAuthenticatedDataCrc32c field is set.
     */
    public boolean hasAdditionalAuthenticatedDataCrc32C() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The additionalAuthenticatedDataCrc32c.
     */
    public com.google.protobuf.Int64Value getAdditionalAuthenticatedDataCrc32C() {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        return additionalAuthenticatedDataCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : additionalAuthenticatedDataCrc32C_;
      } else {
        return additionalAuthenticatedDataCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdditionalAuthenticatedDataCrc32C(com.google.protobuf.Int64Value value) {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        additionalAuthenticatedDataCrc32C_ = value;
      } else {
        additionalAuthenticatedDataCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdditionalAuthenticatedDataCrc32C(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        additionalAuthenticatedDataCrc32C_ = builderForValue.build();
      } else {
        additionalAuthenticatedDataCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAdditionalAuthenticatedDataCrc32C(com.google.protobuf.Int64Value value) {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && additionalAuthenticatedDataCrc32C_ != null
            && additionalAuthenticatedDataCrc32C_
                != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getAdditionalAuthenticatedDataCrc32CBuilder().mergeFrom(value);
        } else {
          additionalAuthenticatedDataCrc32C_ = value;
        }
      } else {
        additionalAuthenticatedDataCrc32CBuilder_.mergeFrom(value);
      }
      if (additionalAuthenticatedDataCrc32C_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAdditionalAuthenticatedDataCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000010);
      additionalAuthenticatedDataCrc32C_ = null;
      if (additionalAuthenticatedDataCrc32CBuilder_ != null) {
        additionalAuthenticatedDataCrc32CBuilder_.dispose();
        additionalAuthenticatedDataCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getAdditionalAuthenticatedDataCrc32CBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAdditionalAuthenticatedDataCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getAdditionalAuthenticatedDataCrc32COrBuilder() {
      if (additionalAuthenticatedDataCrc32CBuilder_ != null) {
        return additionalAuthenticatedDataCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return additionalAuthenticatedDataCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : additionalAuthenticatedDataCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data])
     * is equal to
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getAdditionalAuthenticatedDataCrc32CFieldBuilder() {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        additionalAuthenticatedDataCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getAdditionalAuthenticatedDataCrc32C(), getParentForChildren(), isClean());
        additionalAuthenticatedDataCrc32C_ = null;
      }
      return additionalAuthenticatedDataCrc32CBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.EncryptRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.EncryptRequest)
  private static final com.google.cloud.kms.v1.EncryptRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.EncryptRequest();
  }

  public static com.google.cloud.kms.v1.EncryptRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EncryptRequest> PARSER =
      new com.google.protobuf.AbstractParser<EncryptRequest>() {
        @java.lang.Override
        public EncryptRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EncryptRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EncryptRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.EncryptRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
