/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.kms.v1;

public interface EncryptResponseOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.EncryptResponse)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption. Check this field to verify that the intended resource was used
   * for encryption.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption. Check this field to verify that the intended resource was used
   * for encryption.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The encrypted data.
   * </pre>
   *
   * <code>bytes ciphertext = 2;</code>
   *
   * @return The ciphertext.
   */
  com.google.protobuf.ByteString getCiphertext();

  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
   * An integrity check of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * can be performed by computing the CRC32C checksum of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   *
   * @return Whether the ciphertextCrc32c field is set.
   */
  boolean hasCiphertextCrc32C();
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
   * An integrity check of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * can be performed by computing the CRC32C checksum of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   *
   * @return The ciphertextCrc32c.
   */
  com.google.protobuf.Int64Value getCiphertextCrc32C();
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
   * An integrity check of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * can be performed by computing the CRC32C checksum of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   */
  com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder();

  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the
   * [plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]. A false value of
   * this field indicates either that
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_plaintext_crc32c = 5;</code>
   *
   * @return The verifiedPlaintextCrc32c.
   */
  boolean getVerifiedPlaintextCrc32C();

  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the
   * [AAD][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]. A
   * false value of this field indicates either that
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_additional_authenticated_data_crc32c = 6;</code>
   *
   * @return The verifiedAdditionalAuthenticatedDataCrc32c.
   */
  boolean getVerifiedAdditionalAuthenticatedDataCrc32C();

  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  int getProtectionLevelValue();
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
   *
   * @return The protectionLevel.
   */
  com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel();
}
