/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [KeyManagementService.RawEncrypt][google.cloud.kms.v1.KeyManagementService.RawEncrypt].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.RawEncryptResponse}
 */
public final class RawEncryptResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.RawEncryptResponse)
    RawEncryptResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RawEncryptResponse.newBuilder() to construct.
  private RawEncryptResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RawEncryptResponse() {
    ciphertext_ = com.google.protobuf.ByteString.EMPTY;
    initializationVector_ = com.google.protobuf.ByteString.EMPTY;
    name_ = "";
    protectionLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RawEncryptResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_RawEncryptResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_RawEncryptResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.RawEncryptResponse.class,
            com.google.cloud.kms.v1.RawEncryptResponse.Builder.class);
  }

  private int bitField0_;
  public static final int CIPHERTEXT_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString ciphertext_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The encrypted data. In the case of AES-GCM, the authentication tag
   * is the [tag_length][google.cloud.kms.v1.RawEncryptResponse.tag_length]
   * bytes at the end of this field.
   * </pre>
   *
   * <code>bytes ciphertext = 1;</code>
   *
   * @return The ciphertext.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCiphertext() {
    return ciphertext_;
  }

  public static final int INITIALIZATION_VECTOR_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString initializationVector_ =
      com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The initialization vector (IV) generated by the service during
   * encryption. This value must be stored and provided in
   * [RawDecryptRequest.initialization_vector][google.cloud.kms.v1.RawDecryptRequest.initialization_vector]
   * at decryption time.
   * </pre>
   *
   * <code>bytes initialization_vector = 2;</code>
   *
   * @return The initializationVector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInitializationVector() {
    return initializationVector_;
  }

  public static final int TAG_LENGTH_FIELD_NUMBER = 3;
  private int tagLength_ = 0;
  /**
   *
   *
   * <pre>
   * The length of the authentication tag that is appended to
   * the end of the ciphertext.
   * </pre>
   *
   * <code>int32 tag_length = 3;</code>
   *
   * @return The tagLength.
   */
  @java.lang.Override
  public int getTagLength() {
    return tagLength_;
  }

  public static final int CIPHERTEXT_CRC32C_FIELD_NUMBER = 4;
  private com.google.protobuf.Int64Value ciphertextCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
   * An integrity check of ciphertext can be performed by computing the CRC32C
   * checksum of ciphertext and comparing your results to this field. Discard
   * the response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: This field is defined as int64
   * for reasons of compatibility across different languages. However, it is a
   * non-negative integer, which will never exceed 2^32-1, and can be safely
   * downconverted to uint32 in languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   *
   * @return Whether the ciphertextCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasCiphertextCrc32C() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
   * An integrity check of ciphertext can be performed by computing the CRC32C
   * checksum of ciphertext and comparing your results to this field. Discard
   * the response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: This field is defined as int64
   * for reasons of compatibility across different languages. However, it is a
   * non-negative integer, which will never exceed 2^32-1, and can be safely
   * downconverted to uint32 in languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   *
   * @return The ciphertextCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getCiphertextCrc32C() {
    return ciphertextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : ciphertextCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
   * An integrity check of ciphertext can be performed by computing the CRC32C
   * checksum of ciphertext and comparing your results to this field. Discard
   * the response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: This field is defined as int64
   * for reasons of compatibility across different languages. However, it is a
   * non-negative integer, which will never exceed 2^32-1, and can be safely
   * downconverted to uint32 in languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
    return ciphertextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : ciphertextCrc32C_;
  }

  public static final int INITIALIZATION_VECTOR_CRC32C_FIELD_NUMBER = 5;
  private com.google.protobuf.Int64Value initializationVectorCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
   * An integrity check of initialization_vector can be performed by computing
   * the CRC32C checksum of initialization_vector and comparing your results to
   * this field. Discard the response in case of non-matching checksum values,
   * and perform a limited number of retries. A persistent mismatch may indicate
   * an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages.
   * However, it is a non-negative integer, which will never exceed 2^32-1, and
   * can be safely downconverted to uint32 in languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
   *
   * @return Whether the initializationVectorCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasInitializationVectorCrc32C() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
   * An integrity check of initialization_vector can be performed by computing
   * the CRC32C checksum of initialization_vector and comparing your results to
   * this field. Discard the response in case of non-matching checksum values,
   * and perform a limited number of retries. A persistent mismatch may indicate
   * an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages.
   * However, it is a non-negative integer, which will never exceed 2^32-1, and
   * can be safely downconverted to uint32 in languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
   *
   * @return The initializationVectorCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getInitializationVectorCrc32C() {
    return initializationVectorCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : initializationVectorCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
   * An integrity check of initialization_vector can be performed by computing
   * the CRC32C checksum of initialization_vector and comparing your results to
   * this field. Discard the response in case of non-matching checksum values,
   * and perform a limited number of retries. A persistent mismatch may indicate
   * an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages.
   * However, it is a non-negative integer, which will never exceed 2^32-1, and
   * can be safely downconverted to uint32 in languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getInitializationVectorCrc32COrBuilder() {
    return initializationVectorCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : initializationVectorCrc32C_;
  }

  public static final int VERIFIED_PLAINTEXT_CRC32C_FIELD_NUMBER = 6;
  private boolean verifiedPlaintextCrc32C_ = false;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the plaintext. A false value of this
   * field indicates either that
   * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_plaintext_crc32c = 6;</code>
   *
   * @return The verifiedPlaintextCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedPlaintextCrc32C() {
    return verifiedPlaintextCrc32C_;
  }

  public static final int VERIFIED_ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER = 7;
  private boolean verifiedAdditionalAuthenticatedDataCrc32C_ = false;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of additional_authenticated_data. A false
   * value of this field indicates either that //
   * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_additional_authenticated_data_crc32c = 7;</code>
   *
   * @return The verifiedAdditionalAuthenticatedDataCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedAdditionalAuthenticatedDataCrc32C() {
    return verifiedAdditionalAuthenticatedDataCrc32C_;
  }

  public static final int VERIFIED_INITIALIZATION_VECTOR_CRC32C_FIELD_NUMBER = 10;
  private boolean verifiedInitializationVectorCrc32C_ = false;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of initialization_vector. A false value of
   * this field indicates either that
   * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_initialization_vector_crc32c = 10;</code>
   *
   * @return The verifiedInitializationVectorCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedInitializationVectorCrc32C() {
    return verifiedInitializationVectorCrc32C_;
  }

  public static final int NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption. Check this field to verify that the intended resource was used
   * for encryption.
   * </pre>
   *
   * <code>string name = 8;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption. Check this field to verify that the intended resource was used
   * for encryption.
   * </pre>
   *
   * <code>string name = 8;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 9;
  private int protectionLevel_ = 0;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 9;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 9;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!ciphertext_.isEmpty()) {
      output.writeBytes(1, ciphertext_);
    }
    if (!initializationVector_.isEmpty()) {
      output.writeBytes(2, initializationVector_);
    }
    if (tagLength_ != 0) {
      output.writeInt32(3, tagLength_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCiphertextCrc32C());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getInitializationVectorCrc32C());
    }
    if (verifiedPlaintextCrc32C_ != false) {
      output.writeBool(6, verifiedPlaintextCrc32C_);
    }
    if (verifiedAdditionalAuthenticatedDataCrc32C_ != false) {
      output.writeBool(7, verifiedAdditionalAuthenticatedDataCrc32C_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, name_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, protectionLevel_);
    }
    if (verifiedInitializationVectorCrc32C_ != false) {
      output.writeBool(10, verifiedInitializationVectorCrc32C_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!ciphertext_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, ciphertext_);
    }
    if (!initializationVector_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, initializationVector_);
    }
    if (tagLength_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, tagLength_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCiphertextCrc32C());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getInitializationVectorCrc32C());
    }
    if (verifiedPlaintextCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, verifiedPlaintextCrc32C_);
    }
    if (verifiedAdditionalAuthenticatedDataCrc32C_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              7, verifiedAdditionalAuthenticatedDataCrc32C_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, name_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, protectionLevel_);
    }
    if (verifiedInitializationVectorCrc32C_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              10, verifiedInitializationVectorCrc32C_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.RawEncryptResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.RawEncryptResponse other =
        (com.google.cloud.kms.v1.RawEncryptResponse) obj;

    if (!getCiphertext().equals(other.getCiphertext())) return false;
    if (!getInitializationVector().equals(other.getInitializationVector())) return false;
    if (getTagLength() != other.getTagLength()) return false;
    if (hasCiphertextCrc32C() != other.hasCiphertextCrc32C()) return false;
    if (hasCiphertextCrc32C()) {
      if (!getCiphertextCrc32C().equals(other.getCiphertextCrc32C())) return false;
    }
    if (hasInitializationVectorCrc32C() != other.hasInitializationVectorCrc32C()) return false;
    if (hasInitializationVectorCrc32C()) {
      if (!getInitializationVectorCrc32C().equals(other.getInitializationVectorCrc32C()))
        return false;
    }
    if (getVerifiedPlaintextCrc32C() != other.getVerifiedPlaintextCrc32C()) return false;
    if (getVerifiedAdditionalAuthenticatedDataCrc32C()
        != other.getVerifiedAdditionalAuthenticatedDataCrc32C()) return false;
    if (getVerifiedInitializationVectorCrc32C() != other.getVerifiedInitializationVectorCrc32C())
      return false;
    if (!getName().equals(other.getName())) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CIPHERTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getCiphertext().hashCode();
    hash = (37 * hash) + INITIALIZATION_VECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getInitializationVector().hashCode();
    hash = (37 * hash) + TAG_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + getTagLength();
    if (hasCiphertextCrc32C()) {
      hash = (37 * hash) + CIPHERTEXT_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getCiphertextCrc32C().hashCode();
    }
    if (hasInitializationVectorCrc32C()) {
      hash = (37 * hash) + INITIALIZATION_VECTOR_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getInitializationVectorCrc32C().hashCode();
    }
    hash = (37 * hash) + VERIFIED_PLAINTEXT_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedPlaintextCrc32C());
    hash = (37 * hash) + VERIFIED_ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(
                getVerifiedAdditionalAuthenticatedDataCrc32C());
    hash = (37 * hash) + VERIFIED_INITIALIZATION_VECTOR_CRC32C_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(getVerifiedInitializationVectorCrc32C());
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.RawEncryptResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [KeyManagementService.RawEncrypt][google.cloud.kms.v1.KeyManagementService.RawEncrypt].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.RawEncryptResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.RawEncryptResponse)
      com.google.cloud.kms.v1.RawEncryptResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_RawEncryptResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_RawEncryptResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.RawEncryptResponse.class,
              com.google.cloud.kms.v1.RawEncryptResponse.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.RawEncryptResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCiphertextCrc32CFieldBuilder();
        getInitializationVectorCrc32CFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ciphertext_ = com.google.protobuf.ByteString.EMPTY;
      initializationVector_ = com.google.protobuf.ByteString.EMPTY;
      tagLength_ = 0;
      ciphertextCrc32C_ = null;
      if (ciphertextCrc32CBuilder_ != null) {
        ciphertextCrc32CBuilder_.dispose();
        ciphertextCrc32CBuilder_ = null;
      }
      initializationVectorCrc32C_ = null;
      if (initializationVectorCrc32CBuilder_ != null) {
        initializationVectorCrc32CBuilder_.dispose();
        initializationVectorCrc32CBuilder_ = null;
      }
      verifiedPlaintextCrc32C_ = false;
      verifiedAdditionalAuthenticatedDataCrc32C_ = false;
      verifiedInitializationVectorCrc32C_ = false;
      name_ = "";
      protectionLevel_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_RawEncryptResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.RawEncryptResponse getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.RawEncryptResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.RawEncryptResponse build() {
      com.google.cloud.kms.v1.RawEncryptResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.RawEncryptResponse buildPartial() {
      com.google.cloud.kms.v1.RawEncryptResponse result =
          new com.google.cloud.kms.v1.RawEncryptResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.RawEncryptResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.ciphertext_ = ciphertext_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.initializationVector_ = initializationVector_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.tagLength_ = tagLength_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ciphertextCrc32C_ =
            ciphertextCrc32CBuilder_ == null ? ciphertextCrc32C_ : ciphertextCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.initializationVectorCrc32C_ =
            initializationVectorCrc32CBuilder_ == null
                ? initializationVectorCrc32C_
                : initializationVectorCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.verifiedPlaintextCrc32C_ = verifiedPlaintextCrc32C_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.verifiedAdditionalAuthenticatedDataCrc32C_ =
            verifiedAdditionalAuthenticatedDataCrc32C_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.verifiedInitializationVectorCrc32C_ = verifiedInitializationVectorCrc32C_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.protectionLevel_ = protectionLevel_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.RawEncryptResponse) {
        return mergeFrom((com.google.cloud.kms.v1.RawEncryptResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.RawEncryptResponse other) {
      if (other == com.google.cloud.kms.v1.RawEncryptResponse.getDefaultInstance()) return this;
      if (other.getCiphertext() != com.google.protobuf.ByteString.EMPTY) {
        setCiphertext(other.getCiphertext());
      }
      if (other.getInitializationVector() != com.google.protobuf.ByteString.EMPTY) {
        setInitializationVector(other.getInitializationVector());
      }
      if (other.getTagLength() != 0) {
        setTagLength(other.getTagLength());
      }
      if (other.hasCiphertextCrc32C()) {
        mergeCiphertextCrc32C(other.getCiphertextCrc32C());
      }
      if (other.hasInitializationVectorCrc32C()) {
        mergeInitializationVectorCrc32C(other.getInitializationVectorCrc32C());
      }
      if (other.getVerifiedPlaintextCrc32C() != false) {
        setVerifiedPlaintextCrc32C(other.getVerifiedPlaintextCrc32C());
      }
      if (other.getVerifiedAdditionalAuthenticatedDataCrc32C() != false) {
        setVerifiedAdditionalAuthenticatedDataCrc32C(
            other.getVerifiedAdditionalAuthenticatedDataCrc32C());
      }
      if (other.getVerifiedInitializationVectorCrc32C() != false) {
        setVerifiedInitializationVectorCrc32C(other.getVerifiedInitializationVectorCrc32C());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                ciphertext_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                initializationVector_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                tagLength_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getCiphertextCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getInitializationVectorCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                verifiedPlaintextCrc32C_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                verifiedAdditionalAuthenticatedDataCrc32C_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 72:
              {
                protectionLevel_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 72
            case 80:
              {
                verifiedInitializationVectorCrc32C_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString ciphertext_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The encrypted data. In the case of AES-GCM, the authentication tag
     * is the [tag_length][google.cloud.kms.v1.RawEncryptResponse.tag_length]
     * bytes at the end of this field.
     * </pre>
     *
     * <code>bytes ciphertext = 1;</code>
     *
     * @return The ciphertext.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCiphertext() {
      return ciphertext_;
    }
    /**
     *
     *
     * <pre>
     * The encrypted data. In the case of AES-GCM, the authentication tag
     * is the [tag_length][google.cloud.kms.v1.RawEncryptResponse.tag_length]
     * bytes at the end of this field.
     * </pre>
     *
     * <code>bytes ciphertext = 1;</code>
     *
     * @param value The ciphertext to set.
     * @return This builder for chaining.
     */
    public Builder setCiphertext(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ciphertext_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encrypted data. In the case of AES-GCM, the authentication tag
     * is the [tag_length][google.cloud.kms.v1.RawEncryptResponse.tag_length]
     * bytes at the end of this field.
     * </pre>
     *
     * <code>bytes ciphertext = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCiphertext() {
      bitField0_ = (bitField0_ & ~0x00000001);
      ciphertext_ = getDefaultInstance().getCiphertext();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString initializationVector_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The initialization vector (IV) generated by the service during
     * encryption. This value must be stored and provided in
     * [RawDecryptRequest.initialization_vector][google.cloud.kms.v1.RawDecryptRequest.initialization_vector]
     * at decryption time.
     * </pre>
     *
     * <code>bytes initialization_vector = 2;</code>
     *
     * @return The initializationVector.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInitializationVector() {
      return initializationVector_;
    }
    /**
     *
     *
     * <pre>
     * The initialization vector (IV) generated by the service during
     * encryption. This value must be stored and provided in
     * [RawDecryptRequest.initialization_vector][google.cloud.kms.v1.RawDecryptRequest.initialization_vector]
     * at decryption time.
     * </pre>
     *
     * <code>bytes initialization_vector = 2;</code>
     *
     * @param value The initializationVector to set.
     * @return This builder for chaining.
     */
    public Builder setInitializationVector(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      initializationVector_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initialization vector (IV) generated by the service during
     * encryption. This value must be stored and provided in
     * [RawDecryptRequest.initialization_vector][google.cloud.kms.v1.RawDecryptRequest.initialization_vector]
     * at decryption time.
     * </pre>
     *
     * <code>bytes initialization_vector = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInitializationVector() {
      bitField0_ = (bitField0_ & ~0x00000002);
      initializationVector_ = getDefaultInstance().getInitializationVector();
      onChanged();
      return this;
    }

    private int tagLength_;
    /**
     *
     *
     * <pre>
     * The length of the authentication tag that is appended to
     * the end of the ciphertext.
     * </pre>
     *
     * <code>int32 tag_length = 3;</code>
     *
     * @return The tagLength.
     */
    @java.lang.Override
    public int getTagLength() {
      return tagLength_;
    }
    /**
     *
     *
     * <pre>
     * The length of the authentication tag that is appended to
     * the end of the ciphertext.
     * </pre>
     *
     * <code>int32 tag_length = 3;</code>
     *
     * @param value The tagLength to set.
     * @return This builder for chaining.
     */
    public Builder setTagLength(int value) {

      tagLength_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The length of the authentication tag that is appended to
     * the end of the ciphertext.
     * </pre>
     *
     * <code>int32 tag_length = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagLength() {
      bitField0_ = (bitField0_ & ~0x00000004);
      tagLength_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value ciphertextCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        ciphertextCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     *
     * @return Whether the ciphertextCrc32c field is set.
     */
    public boolean hasCiphertextCrc32C() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     *
     * @return The ciphertextCrc32c.
     */
    public com.google.protobuf.Int64Value getCiphertextCrc32C() {
      if (ciphertextCrc32CBuilder_ == null) {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      } else {
        return ciphertextCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ciphertextCrc32C_ = value;
      } else {
        ciphertextCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = builderForValue.build();
      } else {
        ciphertextCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder mergeCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ciphertextCrc32C_ != null
            && ciphertextCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getCiphertextCrc32CBuilder().mergeFrom(value);
        } else {
          ciphertextCrc32C_ = value;
        }
      } else {
        ciphertextCrc32CBuilder_.mergeFrom(value);
      }
      if (ciphertextCrc32C_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder clearCiphertextCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ciphertextCrc32C_ = null;
      if (ciphertextCrc32CBuilder_ != null) {
        ciphertextCrc32CBuilder_.dispose();
        ciphertextCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public com.google.protobuf.Int64Value.Builder getCiphertextCrc32CBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCiphertextCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
      if (ciphertextCrc32CBuilder_ != null) {
        return ciphertextCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
     * An integrity check of ciphertext can be performed by computing the CRC32C
     * checksum of ciphertext and comparing your results to this field. Discard
     * the response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: This field is defined as int64
     * for reasons of compatibility across different languages. However, it is a
     * non-negative integer, which will never exceed 2^32-1, and can be safely
     * downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getCiphertextCrc32CFieldBuilder() {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getCiphertextCrc32C(), getParentForChildren(), isClean());
        ciphertextCrc32C_ = null;
      }
      return ciphertextCrc32CBuilder_;
    }

    private com.google.protobuf.Int64Value initializationVectorCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        initializationVectorCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     *
     * @return Whether the initializationVectorCrc32c field is set.
     */
    public boolean hasInitializationVectorCrc32C() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     *
     * @return The initializationVectorCrc32c.
     */
    public com.google.protobuf.Int64Value getInitializationVectorCrc32C() {
      if (initializationVectorCrc32CBuilder_ == null) {
        return initializationVectorCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : initializationVectorCrc32C_;
      } else {
        return initializationVectorCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     */
    public Builder setInitializationVectorCrc32C(com.google.protobuf.Int64Value value) {
      if (initializationVectorCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        initializationVectorCrc32C_ = value;
      } else {
        initializationVectorCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     */
    public Builder setInitializationVectorCrc32C(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (initializationVectorCrc32CBuilder_ == null) {
        initializationVectorCrc32C_ = builderForValue.build();
      } else {
        initializationVectorCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     */
    public Builder mergeInitializationVectorCrc32C(com.google.protobuf.Int64Value value) {
      if (initializationVectorCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && initializationVectorCrc32C_ != null
            && initializationVectorCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getInitializationVectorCrc32CBuilder().mergeFrom(value);
        } else {
          initializationVectorCrc32C_ = value;
        }
      } else {
        initializationVectorCrc32CBuilder_.mergeFrom(value);
      }
      if (initializationVectorCrc32C_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     */
    public Builder clearInitializationVectorCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000010);
      initializationVectorCrc32C_ = null;
      if (initializationVectorCrc32CBuilder_ != null) {
        initializationVectorCrc32CBuilder_.dispose();
        initializationVectorCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     */
    public com.google.protobuf.Int64Value.Builder getInitializationVectorCrc32CBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getInitializationVectorCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getInitializationVectorCrc32COrBuilder() {
      if (initializationVectorCrc32CBuilder_ != null) {
        return initializationVectorCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return initializationVectorCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : initializationVectorCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
     * An integrity check of initialization_vector can be performed by computing
     * the CRC32C checksum of initialization_vector and comparing your results to
     * this field. Discard the response in case of non-matching checksum values,
     * and perform a limited number of retries. A persistent mismatch may indicate
     * an issue in your computation of the CRC32C checksum. Note: This field is
     * defined as int64 for reasons of compatibility across different languages.
     * However, it is a non-negative integer, which will never exceed 2^32-1, and
     * can be safely downconverted to uint32 in languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value initialization_vector_crc32c = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getInitializationVectorCrc32CFieldBuilder() {
      if (initializationVectorCrc32CBuilder_ == null) {
        initializationVectorCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getInitializationVectorCrc32C(), getParentForChildren(), isClean());
        initializationVectorCrc32C_ = null;
      }
      return initializationVectorCrc32CBuilder_;
    }

    private boolean verifiedPlaintextCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the plaintext. A false value of this
     * field indicates either that
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_plaintext_crc32c = 6;</code>
     *
     * @return The verifiedPlaintextCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedPlaintextCrc32C() {
      return verifiedPlaintextCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the plaintext. A false value of this
     * field indicates either that
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_plaintext_crc32c = 6;</code>
     *
     * @param value The verifiedPlaintextCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedPlaintextCrc32C(boolean value) {

      verifiedPlaintextCrc32C_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the plaintext. A false value of this
     * field indicates either that
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.plaintext_crc32c][google.cloud.kms.v1.RawEncryptRequest.plaintext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_plaintext_crc32c = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedPlaintextCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000020);
      verifiedPlaintextCrc32C_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedAdditionalAuthenticatedDataCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of additional_authenticated_data. A false
     * value of this field indicates either that //
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 7;</code>
     *
     * @return The verifiedAdditionalAuthenticatedDataCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedAdditionalAuthenticatedDataCrc32C() {
      return verifiedAdditionalAuthenticatedDataCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of additional_authenticated_data. A false
     * value of this field indicates either that //
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 7;</code>
     *
     * @param value The verifiedAdditionalAuthenticatedDataCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedAdditionalAuthenticatedDataCrc32C(boolean value) {

      verifiedAdditionalAuthenticatedDataCrc32C_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of additional_authenticated_data. A false
     * value of this field indicates either that //
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedAdditionalAuthenticatedDataCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000040);
      verifiedAdditionalAuthenticatedDataCrc32C_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedInitializationVectorCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of initialization_vector. A false value of
     * this field indicates either that
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_initialization_vector_crc32c = 10;</code>
     *
     * @return The verifiedInitializationVectorCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedInitializationVectorCrc32C() {
      return verifiedInitializationVectorCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of initialization_vector. A false value of
     * this field indicates either that
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_initialization_vector_crc32c = 10;</code>
     *
     * @param value The verifiedInitializationVectorCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedInitializationVectorCrc32C(boolean value) {

      verifiedInitializationVectorCrc32C_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of initialization_vector. A false value of
     * this field indicates either that
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawEncryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawEncryptRequest.initialization_vector_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_initialization_vector_crc32c = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedInitializationVectorCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000080);
      verifiedInitializationVectorCrc32C_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 9;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 9;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {
      protectionLevel_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 9;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 9;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {
      bitField0_ = (bitField0_ & ~0x00000200);
      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.RawEncryptResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.RawEncryptResponse)
  private static final com.google.cloud.kms.v1.RawEncryptResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.RawEncryptResponse();
  }

  public static com.google.cloud.kms.v1.RawEncryptResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RawEncryptResponse> PARSER =
      new com.google.protobuf.AbstractParser<RawEncryptResponse>() {
        @java.lang.Override
        public RawEncryptResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RawEncryptResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RawEncryptResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.RawEncryptResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
