/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/autokey.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.kms.v1;

public interface KeyHandleOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.KeyHandle)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
   * resource, e.g.
   * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
   * resource, e.g.
   * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
   * been provisioned for Customer Managed Encryption Key (CMEK) use in the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
   * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
   * project will reflect the value configured in the
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
   * project's ancestor folder at the time of the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
   * ancestor folder has a configured
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
   * configurations is used.
   * </pre>
   *
   * <code>
   * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKey.
   */
  java.lang.String getKmsKey();
  /**
   *
   *
   * <pre>
   * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
   * been provisioned for Customer Managed Encryption Key (CMEK) use in the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
   * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
   * project will reflect the value configured in the
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
   * project's ancestor folder at the time of the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
   * ancestor folder has a configured
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
   * configurations is used.
   * </pre>
   *
   * <code>
   * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKey.
   */
  com.google.protobuf.ByteString getKmsKeyBytes();

  /**
   *
   *
   * <pre>
   * Required. Indicates the resource type that the resulting
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
   * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
   * types.
   * </pre>
   *
   * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The resourceTypeSelector.
   */
  java.lang.String getResourceTypeSelector();
  /**
   *
   *
   * <pre>
   * Required. Indicates the resource type that the resulting
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
   * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
   * types.
   * </pre>
   *
   * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for resourceTypeSelector.
   */
  com.google.protobuf.ByteString getResourceTypeSelectorBytes();
}
