/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/autokey_admin.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Cloud KMS Autokey configuration for a folder.
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.AutokeyConfig}
 */
public final class AutokeyConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.AutokeyConfig)
    AutokeyConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutokeyConfig.newBuilder() to construct.
  private AutokeyConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutokeyConfig() {
    name_ = "";
    keyProject_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutokeyConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.AutokeyAdminProto
        .internal_static_google_cloud_kms_v1_AutokeyConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.AutokeyAdminProto
        .internal_static_google_cloud_kms_v1_AutokeyConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.AutokeyConfig.class,
            com.google.cloud.kms.v1.AutokeyConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Name of the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig]
   * resource, e.g. `folders/{FOLDER_NUMBER}/autokeyConfig`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Name of the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig]
   * resource, e.g. `folders/{FOLDER_NUMBER}/autokeyConfig`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KEY_PROJECT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyProject_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Name of the key project, e.g. `projects/{PROJECT_ID}` or
   * `projects/{PROJECT_NUMBER}`, where Cloud KMS Autokey will provision a new
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] when a
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] is created. On
   * [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig],
   * the caller will require `cloudkms.cryptoKeys.setIamPolicy` permission on
   * this key project. Once configured, for Cloud KMS Autokey to function
   * properly, this key project must have the Cloud KMS API activated and the
   * Cloud KMS Service Agent for this key project must be granted the
   * `cloudkms.admin` role (or pertinent permissions). A request with an empty
   * key project field will clear the configuration.
   * </pre>
   *
   * <code>string key_project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The keyProject.
   */
  @java.lang.Override
  public java.lang.String getKeyProject() {
    java.lang.Object ref = keyProject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyProject_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Name of the key project, e.g. `projects/{PROJECT_ID}` or
   * `projects/{PROJECT_NUMBER}`, where Cloud KMS Autokey will provision a new
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] when a
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] is created. On
   * [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig],
   * the caller will require `cloudkms.cryptoKeys.setIamPolicy` permission on
   * this key project. Once configured, for Cloud KMS Autokey to function
   * properly, this key project must have the Cloud KMS API activated and the
   * Cloud KMS Service Agent for this key project must be granted the
   * `cloudkms.admin` role (or pertinent permissions). A request with an empty
   * key project field will clear the configuration.
   * </pre>
   *
   * <code>string key_project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for keyProject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyProjectBytes() {
    java.lang.Object ref = keyProject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyProject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyProject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, keyProject_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyProject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, keyProject_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.AutokeyConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.AutokeyConfig other = (com.google.cloud.kms.v1.AutokeyConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getKeyProject().equals(other.getKeyProject())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + KEY_PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getKeyProject().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AutokeyConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.AutokeyConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Cloud KMS Autokey configuration for a folder.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.AutokeyConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.AutokeyConfig)
      com.google.cloud.kms.v1.AutokeyConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.AutokeyAdminProto
          .internal_static_google_cloud_kms_v1_AutokeyConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.AutokeyAdminProto
          .internal_static_google_cloud_kms_v1_AutokeyConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.AutokeyConfig.class,
              com.google.cloud.kms.v1.AutokeyConfig.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.AutokeyConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      keyProject_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.AutokeyAdminProto
          .internal_static_google_cloud_kms_v1_AutokeyConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AutokeyConfig getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.AutokeyConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AutokeyConfig build() {
      com.google.cloud.kms.v1.AutokeyConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AutokeyConfig buildPartial() {
      com.google.cloud.kms.v1.AutokeyConfig result =
          new com.google.cloud.kms.v1.AutokeyConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.AutokeyConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.keyProject_ = keyProject_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.AutokeyConfig) {
        return mergeFrom((com.google.cloud.kms.v1.AutokeyConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.AutokeyConfig other) {
      if (other == com.google.cloud.kms.v1.AutokeyConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getKeyProject().isEmpty()) {
        keyProject_ = other.keyProject_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                keyProject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig]
     * resource, e.g. `folders/{FOLDER_NUMBER}/autokeyConfig`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig]
     * resource, e.g. `folders/{FOLDER_NUMBER}/autokeyConfig`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig]
     * resource, e.g. `folders/{FOLDER_NUMBER}/autokeyConfig`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig]
     * resource, e.g. `folders/{FOLDER_NUMBER}/autokeyConfig`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig]
     * resource, e.g. `folders/{FOLDER_NUMBER}/autokeyConfig`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object keyProject_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the key project, e.g. `projects/{PROJECT_ID}` or
     * `projects/{PROJECT_NUMBER}`, where Cloud KMS Autokey will provision a new
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] when a
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] is created. On
     * [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig],
     * the caller will require `cloudkms.cryptoKeys.setIamPolicy` permission on
     * this key project. Once configured, for Cloud KMS Autokey to function
     * properly, this key project must have the Cloud KMS API activated and the
     * Cloud KMS Service Agent for this key project must be granted the
     * `cloudkms.admin` role (or pertinent permissions). A request with an empty
     * key project field will clear the configuration.
     * </pre>
     *
     * <code>string key_project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The keyProject.
     */
    public java.lang.String getKeyProject() {
      java.lang.Object ref = keyProject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyProject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the key project, e.g. `projects/{PROJECT_ID}` or
     * `projects/{PROJECT_NUMBER}`, where Cloud KMS Autokey will provision a new
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] when a
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] is created. On
     * [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig],
     * the caller will require `cloudkms.cryptoKeys.setIamPolicy` permission on
     * this key project. Once configured, for Cloud KMS Autokey to function
     * properly, this key project must have the Cloud KMS API activated and the
     * Cloud KMS Service Agent for this key project must be granted the
     * `cloudkms.admin` role (or pertinent permissions). A request with an empty
     * key project field will clear the configuration.
     * </pre>
     *
     * <code>string key_project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for keyProject.
     */
    public com.google.protobuf.ByteString getKeyProjectBytes() {
      java.lang.Object ref = keyProject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyProject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the key project, e.g. `projects/{PROJECT_ID}` or
     * `projects/{PROJECT_NUMBER}`, where Cloud KMS Autokey will provision a new
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] when a
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] is created. On
     * [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig],
     * the caller will require `cloudkms.cryptoKeys.setIamPolicy` permission on
     * this key project. Once configured, for Cloud KMS Autokey to function
     * properly, this key project must have the Cloud KMS API activated and the
     * Cloud KMS Service Agent for this key project must be granted the
     * `cloudkms.admin` role (or pertinent permissions). A request with an empty
     * key project field will clear the configuration.
     * </pre>
     *
     * <code>string key_project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The keyProject to set.
     * @return This builder for chaining.
     */
    public Builder setKeyProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyProject_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the key project, e.g. `projects/{PROJECT_ID}` or
     * `projects/{PROJECT_NUMBER}`, where Cloud KMS Autokey will provision a new
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] when a
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] is created. On
     * [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig],
     * the caller will require `cloudkms.cryptoKeys.setIamPolicy` permission on
     * this key project. Once configured, for Cloud KMS Autokey to function
     * properly, this key project must have the Cloud KMS API activated and the
     * Cloud KMS Service Agent for this key project must be granted the
     * `cloudkms.admin` role (or pertinent permissions). A request with an empty
     * key project field will clear the configuration.
     * </pre>
     *
     * <code>string key_project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyProject() {
      keyProject_ = getDefaultInstance().getKeyProject();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the key project, e.g. `projects/{PROJECT_ID}` or
     * `projects/{PROJECT_NUMBER}`, where Cloud KMS Autokey will provision a new
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] when a
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] is created. On
     * [UpdateAutokeyConfig][google.cloud.kms.v1.AutokeyAdmin.UpdateAutokeyConfig],
     * the caller will require `cloudkms.cryptoKeys.setIamPolicy` permission on
     * this key project. Once configured, for Cloud KMS Autokey to function
     * properly, this key project must have the Cloud KMS API activated and the
     * Cloud KMS Service Agent for this key project must be granted the
     * `cloudkms.admin` role (or pertinent permissions). A request with an empty
     * key project field will clear the configuration.
     * </pre>
     *
     * <code>string key_project = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for keyProject to set.
     * @return This builder for chaining.
     */
    public Builder setKeyProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyProject_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.AutokeyConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.AutokeyConfig)
  private static final com.google.cloud.kms.v1.AutokeyConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.AutokeyConfig();
  }

  public static com.google.cloud.kms.v1.AutokeyConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutokeyConfig> PARSER =
      new com.google.protobuf.AbstractParser<AutokeyConfig>() {
        @java.lang.Override
        public AutokeyConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutokeyConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutokeyConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.AutokeyConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
