/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [KeyManagementService.MacVerify][google.cloud.kms.v1.KeyManagementService.MacVerify].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.MacVerifyRequest}
 */
public final class MacVerifyRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.MacVerifyRequest)
    MacVerifyRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MacVerifyRequest.newBuilder() to construct.
  private MacVerifyRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MacVerifyRequest() {
    name_ = "";
    data_ = com.google.protobuf.ByteString.EMPTY;
    mac_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MacVerifyRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_MacVerifyRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_MacVerifyRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.MacVerifyRequest.class,
            com.google.cloud.kms.v1.MacVerifyRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * verification.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * verification.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Required. The data used previously as a
   * [MacSignRequest.data][google.cloud.kms.v1.MacSignRequest.data] to generate
   * the MAC tag.
   * </pre>
   *
   * <code>bytes data = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The data.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getData() {
    return data_;
  }

  public static final int DATA_CRC32C_FIELD_NUMBER = 3;
  private com.google.protobuf.Int64Value dataCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will verify the integrity of the received
   * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
   * is equal to
   * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dataCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasDataCrc32C() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will verify the integrity of the received
   * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
   * is equal to
   * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getDataCrc32C() {
    return dataCrc32C_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : dataCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will verify the integrity of the received
   * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
   * is equal to
   * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getDataCrc32COrBuilder() {
    return dataCrc32C_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : dataCrc32C_;
  }

  public static final int MAC_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString mac_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Required. The signature to verify.
   * </pre>
   *
   * <code>bytes mac = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The mac.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMac() {
    return mac_;
  }

  public static final int MAC_CRC32C_FIELD_NUMBER = 5;
  private com.google.protobuf.Int64Value macCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will verify the integrity of the received
   * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([MacVerifyRequest.tag][]) is equal to
   * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the macCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasMacCrc32C() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will verify the integrity of the received
   * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([MacVerifyRequest.tag][]) is equal to
   * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The macCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getMacCrc32C() {
    return macCrc32C_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : macCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will verify the integrity of the received
   * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([MacVerifyRequest.tag][]) is equal to
   * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getMacCrc32COrBuilder() {
    return macCrc32C_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : macCrc32C_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!data_.isEmpty()) {
      output.writeBytes(2, data_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getDataCrc32C());
    }
    if (!mac_.isEmpty()) {
      output.writeBytes(4, mac_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getMacCrc32C());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!data_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, data_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDataCrc32C());
    }
    if (!mac_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, mac_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMacCrc32C());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.MacVerifyRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.MacVerifyRequest other = (com.google.cloud.kms.v1.MacVerifyRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getData().equals(other.getData())) return false;
    if (hasDataCrc32C() != other.hasDataCrc32C()) return false;
    if (hasDataCrc32C()) {
      if (!getDataCrc32C().equals(other.getDataCrc32C())) return false;
    }
    if (!getMac().equals(other.getMac())) return false;
    if (hasMacCrc32C() != other.hasMacCrc32C()) return false;
    if (hasMacCrc32C()) {
      if (!getMacCrc32C().equals(other.getMacCrc32C())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DATA_FIELD_NUMBER;
    hash = (53 * hash) + getData().hashCode();
    if (hasDataCrc32C()) {
      hash = (37 * hash) + DATA_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getDataCrc32C().hashCode();
    }
    hash = (37 * hash) + MAC_FIELD_NUMBER;
    hash = (53 * hash) + getMac().hashCode();
    if (hasMacCrc32C()) {
      hash = (37 * hash) + MAC_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getMacCrc32C().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.MacVerifyRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [KeyManagementService.MacVerify][google.cloud.kms.v1.KeyManagementService.MacVerify].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.MacVerifyRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.MacVerifyRequest)
      com.google.cloud.kms.v1.MacVerifyRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacVerifyRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacVerifyRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.MacVerifyRequest.class,
              com.google.cloud.kms.v1.MacVerifyRequest.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.MacVerifyRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataCrc32CFieldBuilder();
        getMacCrc32CFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      data_ = com.google.protobuf.ByteString.EMPTY;
      dataCrc32C_ = null;
      if (dataCrc32CBuilder_ != null) {
        dataCrc32CBuilder_.dispose();
        dataCrc32CBuilder_ = null;
      }
      mac_ = com.google.protobuf.ByteString.EMPTY;
      macCrc32C_ = null;
      if (macCrc32CBuilder_ != null) {
        macCrc32CBuilder_.dispose();
        macCrc32CBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacVerifyRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacVerifyRequest getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.MacVerifyRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacVerifyRequest build() {
      com.google.cloud.kms.v1.MacVerifyRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacVerifyRequest buildPartial() {
      com.google.cloud.kms.v1.MacVerifyRequest result =
          new com.google.cloud.kms.v1.MacVerifyRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.MacVerifyRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.data_ = data_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataCrc32C_ = dataCrc32CBuilder_ == null ? dataCrc32C_ : dataCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mac_ = mac_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.macCrc32C_ = macCrc32CBuilder_ == null ? macCrc32C_ : macCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.MacVerifyRequest) {
        return mergeFrom((com.google.cloud.kms.v1.MacVerifyRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.MacVerifyRequest other) {
      if (other == com.google.cloud.kms.v1.MacVerifyRequest.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getData() != com.google.protobuf.ByteString.EMPTY) {
        setData(other.getData());
      }
      if (other.hasDataCrc32C()) {
        mergeDataCrc32C(other.getDataCrc32C());
      }
      if (other.getMac() != com.google.protobuf.ByteString.EMPTY) {
        setMac(other.getMac());
      }
      if (other.hasMacCrc32C()) {
        mergeMacCrc32C(other.getMacCrc32C());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                data_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDataCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                mac_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getMacCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * verification.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * verification.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * verification.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * verification.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * verification.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The data used previously as a
     * [MacSignRequest.data][google.cloud.kms.v1.MacSignRequest.data] to generate
     * the MAC tag.
     * </pre>
     *
     * <code>bytes data = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The data.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getData() {
      return data_;
    }
    /**
     *
     *
     * <pre>
     * Required. The data used previously as a
     * [MacSignRequest.data][google.cloud.kms.v1.MacSignRequest.data] to generate
     * the MAC tag.
     * </pre>
     *
     * <code>bytes data = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The data to set.
     * @return This builder for chaining.
     */
    public Builder setData(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      data_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data used previously as a
     * [MacSignRequest.data][google.cloud.kms.v1.MacSignRequest.data] to generate
     * the MAC tag.
     * </pre>
     *
     * <code>bytes data = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearData() {
      bitField0_ = (bitField0_ & ~0x00000002);
      data_ = getDefaultInstance().getData();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value dataCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        dataCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dataCrc32c field is set.
     */
    public boolean hasDataCrc32C() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dataCrc32c.
     */
    public com.google.protobuf.Int64Value getDataCrc32C() {
      if (dataCrc32CBuilder_ == null) {
        return dataCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : dataCrc32C_;
      } else {
        return dataCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataCrc32C(com.google.protobuf.Int64Value value) {
      if (dataCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataCrc32C_ = value;
      } else {
        dataCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (dataCrc32CBuilder_ == null) {
        dataCrc32C_ = builderForValue.build();
      } else {
        dataCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDataCrc32C(com.google.protobuf.Int64Value value) {
      if (dataCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && dataCrc32C_ != null
            && dataCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getDataCrc32CBuilder().mergeFrom(value);
        } else {
          dataCrc32C_ = value;
        }
      } else {
        dataCrc32CBuilder_.mergeFrom(value);
      }
      if (dataCrc32C_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDataCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dataCrc32C_ = null;
      if (dataCrc32CBuilder_ != null) {
        dataCrc32CBuilder_.dispose();
        dataCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getDataCrc32CBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDataCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getDataCrc32COrBuilder() {
      if (dataCrc32CBuilder_ != null) {
        return dataCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return dataCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : dataCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] using
     * this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data])
     * is equal to
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value data_crc32c = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getDataCrc32CFieldBuilder() {
      if (dataCrc32CBuilder_ == null) {
        dataCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getDataCrc32C(), getParentForChildren(), isClean());
        dataCrc32C_ = null;
      }
      return dataCrc32CBuilder_;
    }

    private com.google.protobuf.ByteString mac_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The signature to verify.
     * </pre>
     *
     * <code>bytes mac = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The mac.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMac() {
      return mac_;
    }
    /**
     *
     *
     * <pre>
     * Required. The signature to verify.
     * </pre>
     *
     * <code>bytes mac = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The mac to set.
     * @return This builder for chaining.
     */
    public Builder setMac(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mac_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The signature to verify.
     * </pre>
     *
     * <code>bytes mac = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMac() {
      bitField0_ = (bitField0_ & ~0x00000008);
      mac_ = getDefaultInstance().getMac();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value macCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        macCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the macCrc32c field is set.
     */
    public boolean hasMacCrc32C() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The macCrc32c.
     */
    public com.google.protobuf.Int64Value getMacCrc32C() {
      if (macCrc32CBuilder_ == null) {
        return macCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : macCrc32C_;
      } else {
        return macCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMacCrc32C(com.google.protobuf.Int64Value value) {
      if (macCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        macCrc32C_ = value;
      } else {
        macCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMacCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (macCrc32CBuilder_ == null) {
        macCrc32C_ = builderForValue.build();
      } else {
        macCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMacCrc32C(com.google.protobuf.Int64Value value) {
      if (macCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && macCrc32C_ != null
            && macCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getMacCrc32CBuilder().mergeFrom(value);
        } else {
          macCrc32C_ = value;
        }
      } else {
        macCrc32CBuilder_.mergeFrom(value);
      }
      if (macCrc32C_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMacCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000010);
      macCrc32C_ = null;
      if (macCrc32CBuilder_ != null) {
        macCrc32CBuilder_.dispose();
        macCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getMacCrc32CBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMacCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getMacCrc32COrBuilder() {
      if (macCrc32CBuilder_ != null) {
        return macCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return macCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : macCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will verify the integrity of the received
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] using this
     * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
     * will report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([MacVerifyRequest.tag][]) is equal to
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getMacCrc32CFieldBuilder() {
      if (macCrc32CBuilder_ == null) {
        macCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getMacCrc32C(), getParentForChildren(), isClean());
        macCrc32C_ = null;
      }
      return macCrc32CBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.MacVerifyRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.MacVerifyRequest)
  private static final com.google.cloud.kms.v1.MacVerifyRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.MacVerifyRequest();
  }

  public static com.google.cloud.kms.v1.MacVerifyRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MacVerifyRequest> PARSER =
      new com.google.protobuf.AbstractParser<MacVerifyRequest>() {
        @java.lang.Override
        public MacVerifyRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MacVerifyRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MacVerifyRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.MacVerifyRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
