/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Describes the reason for a data access. Please refer to
 * https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
 * for the detailed semantic meaning of justification reason codes.
 * </pre>
 *
 * Protobuf enum {@code google.cloud.kms.v1.AccessReason}
 */
public enum AccessReason implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Unspecified access reason.
   * </pre>
   *
   * <code>REASON_UNSPECIFIED = 0;</code>
   */
  REASON_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Customer-initiated support.
   * </pre>
   *
   * <code>CUSTOMER_INITIATED_SUPPORT = 1;</code>
   */
  CUSTOMER_INITIATED_SUPPORT(1),
  /**
   *
   *
   * <pre>
   * Google-initiated access for system management and troubleshooting.
   * </pre>
   *
   * <code>GOOGLE_INITIATED_SERVICE = 2;</code>
   */
  GOOGLE_INITIATED_SERVICE(2),
  /**
   *
   *
   * <pre>
   * Google-initiated access in response to a legal request or legal process.
   * </pre>
   *
   * <code>THIRD_PARTY_DATA_REQUEST = 3;</code>
   */
  THIRD_PARTY_DATA_REQUEST(3),
  /**
   *
   *
   * <pre>
   * Google-initiated access for security, fraud, abuse, or compliance purposes.
   * </pre>
   *
   * <code>GOOGLE_INITIATED_REVIEW = 4;</code>
   */
  GOOGLE_INITIATED_REVIEW(4),
  /**
   *
   *
   * <pre>
   * Customer uses their account to perform any access to their own data which
   * their IAM policy authorizes.
   * </pre>
   *
   * <code>CUSTOMER_INITIATED_ACCESS = 5;</code>
   */
  CUSTOMER_INITIATED_ACCESS(5),
  /**
   *
   *
   * <pre>
   * Google systems access customer data to help optimize the structure of the
   * data or quality for future uses by the customer.
   * </pre>
   *
   * <code>GOOGLE_INITIATED_SYSTEM_OPERATION = 6;</code>
   */
  GOOGLE_INITIATED_SYSTEM_OPERATION(6),
  /**
   *
   *
   * <pre>
   * No reason is expected for this key request.
   * </pre>
   *
   * <code>REASON_NOT_EXPECTED = 7;</code>
   */
  REASON_NOT_EXPECTED(7),
  /**
   *
   *
   * <pre>
   * Customer uses their account to perform any access to their own data which
   * their IAM policy authorizes, and one of the following is true:
   *
   * * A Google administrator has reset the root-access account associated with
   *   the user's organization within the past 7 days.
   * * A Google-initiated emergency access operation has interacted with a
   *   resource in the same project or folder as the currently accessed resource
   *   within the past 7 days.
   * </pre>
   *
   * <code>MODIFIED_CUSTOMER_INITIATED_ACCESS = 8;</code>
   */
  MODIFIED_CUSTOMER_INITIATED_ACCESS(8),
  /**
   *
   *
   * <pre>
   * Google systems access customer data to help optimize the structure of the
   * data or quality for future uses by the customer, and one of the following
   * is true:
   *
   * * A Google administrator has reset the root-access account associated with
   *   the user's organization within the past 7 days.
   * * A Google-initiated emergency access operation has interacted with a
   *   resource in the same project or folder as the currently accessed resource
   *   within the past 7 days.
   * </pre>
   *
   * <code>MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION = 9;</code>
   */
  MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION(9),
  /**
   *
   *
   * <pre>
   * Google-initiated access to maintain system reliability.
   * </pre>
   *
   * <code>GOOGLE_RESPONSE_TO_PRODUCTION_ALERT = 10;</code>
   */
  GOOGLE_RESPONSE_TO_PRODUCTION_ALERT(10),
  /**
   *
   *
   * <pre>
   * One of the following operations is being executed while simultaneously
   * encountering an internal technical issue which prevented a more precise
   * justification code from being generated:
   *
   * * Your account has been used to perform any access to your own data which
   *   your IAM policy authorizes.
   * * An automated Google system operates on encrypted customer data which your
   *   IAM policy authorizes.
   * * Customer-initiated Google support access.
   * * Google-initiated support access to protect system reliability.
   * </pre>
   *
   * <code>CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING = 11;</code>
   */
  CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING(11),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Unspecified access reason.
   * </pre>
   *
   * <code>REASON_UNSPECIFIED = 0;</code>
   */
  public static final int REASON_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Customer-initiated support.
   * </pre>
   *
   * <code>CUSTOMER_INITIATED_SUPPORT = 1;</code>
   */
  public static final int CUSTOMER_INITIATED_SUPPORT_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Google-initiated access for system management and troubleshooting.
   * </pre>
   *
   * <code>GOOGLE_INITIATED_SERVICE = 2;</code>
   */
  public static final int GOOGLE_INITIATED_SERVICE_VALUE = 2;
  /**
   *
   *
   * <pre>
   * Google-initiated access in response to a legal request or legal process.
   * </pre>
   *
   * <code>THIRD_PARTY_DATA_REQUEST = 3;</code>
   */
  public static final int THIRD_PARTY_DATA_REQUEST_VALUE = 3;
  /**
   *
   *
   * <pre>
   * Google-initiated access for security, fraud, abuse, or compliance purposes.
   * </pre>
   *
   * <code>GOOGLE_INITIATED_REVIEW = 4;</code>
   */
  public static final int GOOGLE_INITIATED_REVIEW_VALUE = 4;
  /**
   *
   *
   * <pre>
   * Customer uses their account to perform any access to their own data which
   * their IAM policy authorizes.
   * </pre>
   *
   * <code>CUSTOMER_INITIATED_ACCESS = 5;</code>
   */
  public static final int CUSTOMER_INITIATED_ACCESS_VALUE = 5;
  /**
   *
   *
   * <pre>
   * Google systems access customer data to help optimize the structure of the
   * data or quality for future uses by the customer.
   * </pre>
   *
   * <code>GOOGLE_INITIATED_SYSTEM_OPERATION = 6;</code>
   */
  public static final int GOOGLE_INITIATED_SYSTEM_OPERATION_VALUE = 6;
  /**
   *
   *
   * <pre>
   * No reason is expected for this key request.
   * </pre>
   *
   * <code>REASON_NOT_EXPECTED = 7;</code>
   */
  public static final int REASON_NOT_EXPECTED_VALUE = 7;
  /**
   *
   *
   * <pre>
   * Customer uses their account to perform any access to their own data which
   * their IAM policy authorizes, and one of the following is true:
   *
   * * A Google administrator has reset the root-access account associated with
   *   the user's organization within the past 7 days.
   * * A Google-initiated emergency access operation has interacted with a
   *   resource in the same project or folder as the currently accessed resource
   *   within the past 7 days.
   * </pre>
   *
   * <code>MODIFIED_CUSTOMER_INITIATED_ACCESS = 8;</code>
   */
  public static final int MODIFIED_CUSTOMER_INITIATED_ACCESS_VALUE = 8;
  /**
   *
   *
   * <pre>
   * Google systems access customer data to help optimize the structure of the
   * data or quality for future uses by the customer, and one of the following
   * is true:
   *
   * * A Google administrator has reset the root-access account associated with
   *   the user's organization within the past 7 days.
   * * A Google-initiated emergency access operation has interacted with a
   *   resource in the same project or folder as the currently accessed resource
   *   within the past 7 days.
   * </pre>
   *
   * <code>MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION = 9;</code>
   */
  public static final int MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION_VALUE = 9;
  /**
   *
   *
   * <pre>
   * Google-initiated access to maintain system reliability.
   * </pre>
   *
   * <code>GOOGLE_RESPONSE_TO_PRODUCTION_ALERT = 10;</code>
   */
  public static final int GOOGLE_RESPONSE_TO_PRODUCTION_ALERT_VALUE = 10;
  /**
   *
   *
   * <pre>
   * One of the following operations is being executed while simultaneously
   * encountering an internal technical issue which prevented a more precise
   * justification code from being generated:
   *
   * * Your account has been used to perform any access to your own data which
   *   your IAM policy authorizes.
   * * An automated Google system operates on encrypted customer data which your
   *   IAM policy authorizes.
   * * Customer-initiated Google support access.
   * * Google-initiated support access to protect system reliability.
   * </pre>
   *
   * <code>CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING = 11;</code>
   */
  public static final int CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING_VALUE = 11;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static AccessReason valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static AccessReason forNumber(int value) {
    switch (value) {
      case 0:
        return REASON_UNSPECIFIED;
      case 1:
        return CUSTOMER_INITIATED_SUPPORT;
      case 2:
        return GOOGLE_INITIATED_SERVICE;
      case 3:
        return THIRD_PARTY_DATA_REQUEST;
      case 4:
        return GOOGLE_INITIATED_REVIEW;
      case 5:
        return CUSTOMER_INITIATED_ACCESS;
      case 6:
        return GOOGLE_INITIATED_SYSTEM_OPERATION;
      case 7:
        return REASON_NOT_EXPECTED;
      case 8:
        return MODIFIED_CUSTOMER_INITIATED_ACCESS;
      case 9:
        return MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION;
      case 10:
        return GOOGLE_RESPONSE_TO_PRODUCTION_ALERT;
      case 11:
        return CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<AccessReason> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<AccessReason> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<AccessReason>() {
        public AccessReason findValueByNumber(int number) {
          return AccessReason.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto.getDescriptor().getEnumTypes().get(1);
  }

  private static final AccessReason[] VALUES = values();

  public static AccessReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private AccessReason(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.AccessReason)
}
