/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.kms.v1;

public interface RawDecryptResponseOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.RawDecryptResponse)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The decrypted data.
   * </pre>
   *
   * <code>bytes plaintext = 1;</code>
   *
   * @return The plaintext.
   */
  com.google.protobuf.ByteString getPlaintext();

  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
   * An integrity check of plaintext can be performed by computing the CRC32C
   * checksum of plaintext and comparing your results to this field. Discard the
   * response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: receiving this response message
   * indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   *
   * @return Whether the plaintextCrc32c field is set.
   */
  boolean hasPlaintextCrc32C();
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
   * An integrity check of plaintext can be performed by computing the CRC32C
   * checksum of plaintext and comparing your results to this field. Discard the
   * response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: receiving this response message
   * indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   *
   * @return The plaintextCrc32c.
   */
  com.google.protobuf.Int64Value getPlaintextCrc32C();
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
   * An integrity check of plaintext can be performed by computing the CRC32C
   * checksum of plaintext and comparing your results to this field. Discard the
   * response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: receiving this response message
   * indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   */
  com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder();

  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * decryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  int getProtectionLevelValue();
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * decryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
   *
   * @return The protectionLevel.
   */
  com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel();

  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the ciphertext. A false value of this
   * field indicates either that
   * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_ciphertext_crc32c = 4;</code>
   *
   * @return The verifiedCiphertextCrc32c.
   */
  boolean getVerifiedCiphertextCrc32C();

  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of additional_authenticated_data. A false
   * value of this field indicates either that //
   * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_additional_authenticated_data_crc32c = 5;</code>
   *
   * @return The verifiedAdditionalAuthenticatedDataCrc32c.
   */
  boolean getVerifiedAdditionalAuthenticatedDataCrc32C();

  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of initialization_vector. A false value of
   * this field indicates either that
   * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_initialization_vector_crc32c = 6;</code>
   *
   * @return The verifiedInitializationVectorCrc32c.
   */
  boolean getVerifiedInitializationVectorCrc32C();
}
