/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/autokey.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Resource-oriented representation of a request to Cloud KMS Autokey and the
 * resulting provisioning of a [CryptoKey][google.cloud.kms.v1.CryptoKey].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.KeyHandle}
 */
public final class KeyHandle extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.KeyHandle)
    KeyHandleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KeyHandle.newBuilder() to construct.
  private KeyHandle(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KeyHandle() {
    name_ = "";
    kmsKey_ = "";
    resourceTypeSelector_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KeyHandle();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.AutokeyProto
        .internal_static_google_cloud_kms_v1_KeyHandle_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.AutokeyProto
        .internal_static_google_cloud_kms_v1_KeyHandle_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.KeyHandle.class,
            com.google.cloud.kms.v1.KeyHandle.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
   * resource, e.g.
   * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
   * resource, e.g.
   * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
   * been provisioned for Customer Managed Encryption Key (CMEK) use in the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
   * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
   * project will reflect the value configured in the
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
   * project's ancestor folder at the time of the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
   * ancestor folder has a configured
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
   * configurations is used.
   * </pre>
   *
   * <code>
   * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
   * been provisioned for Customer Managed Encryption Key (CMEK) use in the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
   * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
   * project will reflect the value configured in the
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
   * project's ancestor folder at the time of the
   * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
   * ancestor folder has a configured
   * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
   * configurations is used.
   * </pre>
   *
   * <code>
   * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_TYPE_SELECTOR_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceTypeSelector_ = "";
  /**
   *
   *
   * <pre>
   * Required. Indicates the resource type that the resulting
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
   * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
   * types.
   * </pre>
   *
   * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The resourceTypeSelector.
   */
  @java.lang.Override
  public java.lang.String getResourceTypeSelector() {
    java.lang.Object ref = resourceTypeSelector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceTypeSelector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Indicates the resource type that the resulting
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
   * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
   * types.
   * </pre>
   *
   * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for resourceTypeSelector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceTypeSelectorBytes() {
    java.lang.Object ref = resourceTypeSelector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceTypeSelector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, kmsKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceTypeSelector_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceTypeSelector_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, kmsKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceTypeSelector_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resourceTypeSelector_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.KeyHandle)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.KeyHandle other = (com.google.cloud.kms.v1.KeyHandle) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (!getResourceTypeSelector().equals(other.getResourceTypeSelector())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getResourceTypeSelector().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyHandle parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.KeyHandle prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Resource-oriented representation of a request to Cloud KMS Autokey and the
   * resulting provisioning of a [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.KeyHandle}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.KeyHandle)
      com.google.cloud.kms.v1.KeyHandleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.AutokeyProto
          .internal_static_google_cloud_kms_v1_KeyHandle_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.AutokeyProto
          .internal_static_google_cloud_kms_v1_KeyHandle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.KeyHandle.class,
              com.google.cloud.kms.v1.KeyHandle.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.KeyHandle.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      kmsKey_ = "";
      resourceTypeSelector_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.AutokeyProto
          .internal_static_google_cloud_kms_v1_KeyHandle_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyHandle getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.KeyHandle.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyHandle build() {
      com.google.cloud.kms.v1.KeyHandle result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyHandle buildPartial() {
      com.google.cloud.kms.v1.KeyHandle result = new com.google.cloud.kms.v1.KeyHandle(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.KeyHandle result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resourceTypeSelector_ = resourceTypeSelector_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.KeyHandle) {
        return mergeFrom((com.google.cloud.kms.v1.KeyHandle) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.KeyHandle other) {
      if (other == com.google.cloud.kms.v1.KeyHandle.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getResourceTypeSelector().isEmpty()) {
        resourceTypeSelector_ = other.resourceTypeSelector_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                resourceTypeSelector_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
     * resource, e.g.
     * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
     * resource, e.g.
     * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
     * resource, e.g.
     * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
     * resource, e.g.
     * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the [KeyHandle][google.cloud.kms.v1.KeyHandle]
     * resource, e.g.
     * `projects/{PROJECT_ID}/locations/{LOCATION}/keyHandles/{KEY_HANDLE_ID}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
     * been provisioned for Customer Managed Encryption Key (CMEK) use in the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
     * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
     * project will reflect the value configured in the
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
     * project's ancestor folder at the time of the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
     * ancestor folder has a configured
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
     * configurations is used.
     * </pre>
     *
     * <code>
     * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
     * been provisioned for Customer Managed Encryption Key (CMEK) use in the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
     * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
     * project will reflect the value configured in the
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
     * project's ancestor folder at the time of the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
     * ancestor folder has a configured
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
     * configurations is used.
     * </pre>
     *
     * <code>
     * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
     * been provisioned for Customer Managed Encryption Key (CMEK) use in the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
     * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
     * project will reflect the value configured in the
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
     * project's ancestor folder at the time of the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
     * ancestor folder has a configured
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
     * configurations is used.
     * </pre>
     *
     * <code>
     * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
     * been provisioned for Customer Managed Encryption Key (CMEK) use in the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
     * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
     * project will reflect the value configured in the
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
     * project's ancestor folder at the time of the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
     * ancestor folder has a configured
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
     * configurations is used.
     * </pre>
     *
     * <code>
     * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that has
     * been provisioned for Customer Managed Encryption Key (CMEK) use in the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] project and location for the
     * requested resource type. The [CryptoKey][google.cloud.kms.v1.CryptoKey]
     * project will reflect the value configured in the
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] on the resource
     * project's ancestor folder at the time of the
     * [KeyHandle][google.cloud.kms.v1.KeyHandle] creation. If more than one
     * ancestor folder has a configured
     * [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig], the nearest of these
     * configurations is used.
     * </pre>
     *
     * <code>
     * string kms_key = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object resourceTypeSelector_ = "";
    /**
     *
     *
     * <pre>
     * Required. Indicates the resource type that the resulting
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
     * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
     * types.
     * </pre>
     *
     * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The resourceTypeSelector.
     */
    public java.lang.String getResourceTypeSelector() {
      java.lang.Object ref = resourceTypeSelector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceTypeSelector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the resource type that the resulting
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
     * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
     * types.
     * </pre>
     *
     * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for resourceTypeSelector.
     */
    public com.google.protobuf.ByteString getResourceTypeSelectorBytes() {
      java.lang.Object ref = resourceTypeSelector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceTypeSelector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the resource type that the resulting
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
     * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
     * types.
     * </pre>
     *
     * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The resourceTypeSelector to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeSelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceTypeSelector_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the resource type that the resulting
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
     * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
     * types.
     * </pre>
     *
     * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceTypeSelector() {
      resourceTypeSelector_ = getDefaultInstance().getResourceTypeSelector();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the resource type that the resulting
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] is meant to protect, e.g.
     * `{SERVICE}.googleapis.com/{TYPE}`. See documentation for supported resource
     * types.
     * </pre>
     *
     * <code>string resource_type_selector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for resourceTypeSelector to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeSelectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceTypeSelector_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.KeyHandle)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.KeyHandle)
  private static final com.google.cloud.kms.v1.KeyHandle DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.KeyHandle();
  }

  public static com.google.cloud.kms.v1.KeyHandle getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KeyHandle> PARSER =
      new com.google.protobuf.AbstractParser<KeyHandle>() {
        @java.lang.Override
        public KeyHandle parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KeyHandle> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KeyHandle> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.KeyHandle getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
