/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.kms.v1;

public interface RawDecryptRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.RawDecryptRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * decryption.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * decryption.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The encrypted data originally returned in
   * [RawEncryptResponse.ciphertext][google.cloud.kms.v1.RawEncryptResponse.ciphertext].
   * </pre>
   *
   * <code>bytes ciphertext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The ciphertext.
   */
  com.google.protobuf.ByteString getCiphertext();

  /**
   *
   *
   * <pre>
   * Optional. Optional data that must match the data originally supplied in
   * [RawEncryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data].
   * </pre>
   *
   * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The additionalAuthenticatedData.
   */
  com.google.protobuf.ByteString getAdditionalAuthenticatedData();

  /**
   *
   *
   * <pre>
   * Required. The initialization vector (IV) used during encryption, which must
   * match the data originally provided in
   * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
   * </pre>
   *
   * <code>bytes initialization_vector = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The initializationVector.
   */
  com.google.protobuf.ByteString getInitializationVector();

  /**
   *
   *
   * <pre>
   * The length of the authentication tag that is appended to the end of
   * the ciphertext. If unspecified (0), the default value for the key's
   * algorithm will be used (for AES-GCM, the default value is 16).
   * </pre>
   *
   * <code>int32 tag_length = 5;</code>
   *
   * @return The tagLength.
   */
  int getTagLength();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received ciphertext using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that CRC32C(ciphertext) is equal
   * to ciphertext_crc32c, and if so, perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ciphertextCrc32c field is set.
   */
  boolean hasCiphertextCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received ciphertext using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that CRC32C(ciphertext) is equal
   * to ciphertext_crc32c, and if so, perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ciphertextCrc32c.
   */
  com.google.protobuf.Int64Value getCiphertextCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received ciphertext using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that CRC32C(ciphertext) is equal
   * to ciphertext_crc32c, and if so, perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received additional_authenticated_data using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(additional_authenticated_data) is equal to
   * additional_authenticated_data_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the additionalAuthenticatedDataCrc32c field is set.
   */
  boolean hasAdditionalAuthenticatedDataCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received additional_authenticated_data using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(additional_authenticated_data) is equal to
   * additional_authenticated_data_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The additionalAuthenticatedDataCrc32c.
   */
  com.google.protobuf.Int64Value getAdditionalAuthenticatedDataCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received additional_authenticated_data using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(additional_authenticated_data) is equal to
   * additional_authenticated_data_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getAdditionalAuthenticatedDataCrc32COrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.initialization_vector][google.cloud.kms.v1.RawDecryptRequest.initialization_vector].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received initialization_vector using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(initialization_vector) is equal to initialization_vector_crc32c, and
   * if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value initialization_vector_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the initializationVectorCrc32c field is set.
   */
  boolean hasInitializationVectorCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.initialization_vector][google.cloud.kms.v1.RawDecryptRequest.initialization_vector].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received initialization_vector using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(initialization_vector) is equal to initialization_vector_crc32c, and
   * if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value initialization_vector_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The initializationVectorCrc32c.
   */
  com.google.protobuf.Int64Value getInitializationVectorCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawDecryptRequest.initialization_vector][google.cloud.kms.v1.RawDecryptRequest.initialization_vector].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received initialization_vector using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(initialization_vector) is equal to initialization_vector_crc32c, and
   * if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value initialization_vector_crc32c = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getInitializationVectorCrc32COrBuilder();
}
