// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

package com.google.cloud.kms.v1;

/**
 * <pre>
 * A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an individual cryptographic key, and the
 * associated key material.
 * It can be used for cryptographic operations either directly, or via its
 * parent [CryptoKey][google.cloud.kms.v1.CryptoKey], in which case the server will choose the appropriate
 * version for the operation.
 * For security reasons, the raw cryptographic key material represented by a
 * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed or exported. It can only be used to
 * encrypt or decrypt data when an authorized user or application invokes Cloud
 * KMS.
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.CryptoKeyVersion}
 */
public  final class CryptoKeyVersion extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.CryptoKeyVersion)
    CryptoKeyVersionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CryptoKeyVersion.newBuilder() to construct.
  private CryptoKeyVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CryptoKeyVersion() {
    name_ = "";
    state_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CryptoKeyVersion(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 24: {
            int rawValue = input.readEnum();

            state_ = rawValue;
            break;
          }
          case 34: {
            com.google.protobuf.Timestamp.Builder subBuilder = null;
            if (createTime_ != null) {
              subBuilder = createTime_.toBuilder();
            }
            createTime_ = input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(createTime_);
              createTime_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            com.google.protobuf.Timestamp.Builder subBuilder = null;
            if (destroyTime_ != null) {
              subBuilder = destroyTime_.toBuilder();
            }
            destroyTime_ = input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(destroyTime_);
              destroyTime_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            com.google.protobuf.Timestamp.Builder subBuilder = null;
            if (destroyEventTime_ != null) {
              subBuilder = destroyEventTime_.toBuilder();
            }
            destroyEventTime_ = input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(destroyEventTime_);
              destroyEventTime_ = subBuilder.buildPartial();
            }

            break;
          }
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto.internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto.internal_static_google_cloud_kms_v1_CryptoKeyVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.CryptoKeyVersion.class, com.google.cloud.kms.v1.CryptoKeyVersion.Builder.class);
  }

  /**
   * <pre>
   * The state of a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], indicating if it can be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState}
   */
  public enum CryptoKeyVersionState
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_VERSION_STATE_UNSPECIFIED(0),
    /**
     * <pre>
     * This version may be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt] requests.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     * <pre>
     * This version may not be used, but the key material is still available,
     * and the version can be placed back into the [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     * <pre>
     * This version is destroyed, and the key material is no longer stored.
     * A version may not leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    DESTROYED(3),
    /**
     * <pre>
     * This version is scheduled for destruction, and will be destroyed soon.
     * Call
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * to put it back into the [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] state.
     * </pre>
     *
     * <code>DESTROY_SCHEDULED = 4;</code>
     */
    DESTROY_SCHEDULED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_VERSION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * This version may be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt] requests.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     * <pre>
     * This version may not be used, but the key material is still available,
     * and the version can be placed back into the [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     * <pre>
     * This version is destroyed, and the key material is no longer stored.
     * A version may not leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    public static final int DESTROYED_VALUE = 3;
    /**
     * <pre>
     * This version is scheduled for destruction, and will be destroyed soon.
     * Call
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * to put it back into the [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] state.
     * </pre>
     *
     * <code>DESTROY_SCHEDULED = 4;</code>
     */
    public static final int DESTROY_SCHEDULED_VALUE = 4;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyVersionState valueOf(int value) {
      return forNumber(value);
    }

    public static CryptoKeyVersionState forNumber(int value) {
      switch (value) {
        case 0: return CRYPTO_KEY_VERSION_STATE_UNSPECIFIED;
        case 1: return ENABLED;
        case 2: return DISABLED;
        case 3: return DESTROYED;
        case 4: return DESTROY_SCHEDULED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        CryptoKeyVersionState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>() {
            public CryptoKeyVersionState findValueByNumber(int number) {
              return CryptoKeyVersionState.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDescriptor().getEnumTypes().get(0);
    }

    private static final CryptoKeyVersionState[] VALUES = values();

    public static CryptoKeyVersionState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyVersionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_;
  /**
   * <pre>
   * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
   */
  public int getStateValue() {
    return state_;
  }
  /**
   * <pre>
   * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
   */
  public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState result = com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.valueOf(state_);
    return result == null ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   * <pre>
   * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int DESTROY_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp destroyTime_;
  /**
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
   * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
   */
  public boolean hasDestroyTime() {
    return destroyTime_ != null;
  }
  /**
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
   * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
   */
  public com.google.protobuf.Timestamp getDestroyTime() {
    return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
  }
  /**
   * <pre>
   * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
   * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
    return getDestroyTime();
  }

  public static final int DESTROY_EVENT_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp destroyEventTime_;
  /**
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
   */
  public boolean hasDestroyEventTime() {
    return destroyEventTime_ != null;
  }
  /**
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
   */
  public com.google.protobuf.Timestamp getDestroyEventTime() {
    return destroyEventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyEventTime_;
  }
  /**
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getDestroyEventTimeOrBuilder() {
    return getDestroyEventTime();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_ != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.CRYPTO_KEY_VERSION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (destroyTime_ != null) {
      output.writeMessage(5, getDestroyTime());
    }
    if (destroyEventTime_ != null) {
      output.writeMessage(6, getDestroyEventTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_ != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.CRYPTO_KEY_VERSION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getCreateTime());
    }
    if (destroyTime_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getDestroyTime());
    }
    if (destroyEventTime_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getDestroyEventTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.CryptoKeyVersion)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.CryptoKeyVersion other = (com.google.cloud.kms.v1.CryptoKeyVersion) obj;

    boolean result = true;
    result = result && getName()
        .equals(other.getName());
    result = result && state_ == other.state_;
    result = result && (hasCreateTime() == other.hasCreateTime());
    if (hasCreateTime()) {
      result = result && getCreateTime()
          .equals(other.getCreateTime());
    }
    result = result && (hasDestroyTime() == other.hasDestroyTime());
    if (hasDestroyTime()) {
      result = result && getDestroyTime()
          .equals(other.getDestroyTime());
    }
    result = result && (hasDestroyEventTime() == other.hasDestroyEventTime());
    if (hasDestroyEventTime()) {
      result = result && getDestroyEventTime()
          .equals(other.getDestroyEventTime());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDestroyTime()) {
      hash = (37 * hash) + DESTROY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyTime().hashCode();
    }
    if (hasDestroyEventTime()) {
      hash = (37 * hash) + DESTROY_EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyEventTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.cloud.kms.v1.CryptoKeyVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an individual cryptographic key, and the
   * associated key material.
   * It can be used for cryptographic operations either directly, or via its
   * parent [CryptoKey][google.cloud.kms.v1.CryptoKey], in which case the server will choose the appropriate
   * version for the operation.
   * For security reasons, the raw cryptographic key material represented by a
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed or exported. It can only be used to
   * encrypt or decrypt data when an authorized user or application invokes Cloud
   * KMS.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.CryptoKeyVersion}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.CryptoKeyVersion)
      com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto.internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto.internal_static_google_cloud_kms_v1_CryptoKeyVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.CryptoKeyVersion.class, com.google.cloud.kms.v1.CryptoKeyVersion.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.CryptoKeyVersion.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      state_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = null;
      } else {
        destroyTime_ = null;
        destroyTimeBuilder_ = null;
      }
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTime_ = null;
      } else {
        destroyEventTime_ = null;
        destroyEventTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto.internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion build() {
      com.google.cloud.kms.v1.CryptoKeyVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion buildPartial() {
      com.google.cloud.kms.v1.CryptoKeyVersion result = new com.google.cloud.kms.v1.CryptoKeyVersion(this);
      result.name_ = name_;
      result.state_ = state_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (destroyTimeBuilder_ == null) {
        result.destroyTime_ = destroyTime_;
      } else {
        result.destroyTime_ = destroyTimeBuilder_.build();
      }
      if (destroyEventTimeBuilder_ == null) {
        result.destroyEventTime_ = destroyEventTime_;
      } else {
        result.destroyEventTime_ = destroyEventTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.CryptoKeyVersion) {
        return mergeFrom((com.google.cloud.kms.v1.CryptoKeyVersion)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.CryptoKeyVersion other) {
      if (other == com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDestroyTime()) {
        mergeDestroyTime(other.getDestroyTime());
      }
      if (other.hasDestroyEventTime()) {
        mergeDestroyEventTime(other.getDestroyEventTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.CryptoKeyVersion parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.CryptoKeyVersion) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name for this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     */
    public int getStateValue() {
      return state_;
    }
    /**
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     */
    public Builder setStateValue(int value) {
      state_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState result = com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.valueOf(state_);
      return result == null ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     */
    public Builder setState(com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The current state of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     */
    public Builder clearState() {
      
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> createTimeBuilder_;
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
            com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null ?
            com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
      }
    }
    /**
     * <pre>
     * Output only. The time at which this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(),
                getParentForChildren(),
                isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyTime_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> destroyTimeBuilder_;
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public boolean hasDestroyTime() {
      return destroyTimeBuilder_ != null || destroyTime_ != null;
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public com.google.protobuf.Timestamp getDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
      } else {
        return destroyTimeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyTime_ = value;
        onChanged();
      } else {
        destroyTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public Builder setDestroyTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = builderForValue.build();
        onChanged();
      } else {
        destroyTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public Builder mergeDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (destroyTime_ != null) {
          destroyTime_ =
            com.google.protobuf.Timestamp.newBuilder(destroyTime_).mergeFrom(value).buildPartial();
        } else {
          destroyTime_ = value;
        }
        onChanged();
      } else {
        destroyTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public Builder clearDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = null;
        onChanged();
      } else {
        destroyTime_ = null;
        destroyTimeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyTimeBuilder() {
      
      onChanged();
      return getDestroyTimeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
      if (destroyTimeBuilder_ != null) {
        return destroyTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyTime_ == null ?
            com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
      }
    }
    /**
     * <pre>
     * Output only. The time this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is scheduled
     * for destruction. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
        getDestroyTimeFieldBuilder() {
      if (destroyTimeBuilder_ == null) {
        destroyTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                getDestroyTime(),
                getParentForChildren(),
                isClean());
        destroyTime_ = null;
      }
      return destroyTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyEventTime_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> destroyEventTimeBuilder_;
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public boolean hasDestroyEventTime() {
      return destroyEventTimeBuilder_ != null || destroyEventTime_ != null;
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public com.google.protobuf.Timestamp getDestroyEventTime() {
      if (destroyEventTimeBuilder_ == null) {
        return destroyEventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyEventTime_;
      } else {
        return destroyEventTimeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public Builder setDestroyEventTime(com.google.protobuf.Timestamp value) {
      if (destroyEventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyEventTime_ = value;
        onChanged();
      } else {
        destroyEventTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public Builder setDestroyEventTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTime_ = builderForValue.build();
        onChanged();
      } else {
        destroyEventTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public Builder mergeDestroyEventTime(com.google.protobuf.Timestamp value) {
      if (destroyEventTimeBuilder_ == null) {
        if (destroyEventTime_ != null) {
          destroyEventTime_ =
            com.google.protobuf.Timestamp.newBuilder(destroyEventTime_).mergeFrom(value).buildPartial();
        } else {
          destroyEventTime_ = value;
        }
        onChanged();
      } else {
        destroyEventTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public Builder clearDestroyEventTime() {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTime_ = null;
        onChanged();
      } else {
        destroyEventTime_ = null;
        destroyEventTimeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyEventTimeBuilder() {
      
      onChanged();
      return getDestroyEventTimeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyEventTimeOrBuilder() {
      if (destroyEventTimeBuilder_ != null) {
        return destroyEventTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyEventTime_ == null ?
            com.google.protobuf.Timestamp.getDefaultInstance() : destroyEventTime_;
      }
    }
    /**
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp destroy_event_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
        getDestroyEventTimeFieldBuilder() {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                getDestroyEventTime(),
                getParentForChildren(),
                isClean());
        destroyEventTime_ = null;
      }
      return destroyEventTimeBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.CryptoKeyVersion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.CryptoKeyVersion)
  private static final com.google.cloud.kms.v1.CryptoKeyVersion DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.CryptoKeyVersion();
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CryptoKeyVersion>
      PARSER = new com.google.protobuf.AbstractParser<CryptoKeyVersion>() {
    @java.lang.Override
    public CryptoKeyVersion parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CryptoKeyVersion(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CryptoKeyVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CryptoKeyVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

