/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Request message for [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.AsymmetricSignRequest}
 */
public final class AsymmetricSignRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.AsymmetricSignRequest)
    AsymmetricSignRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AsymmetricSignRequest.newBuilder() to construct.
  private AsymmetricSignRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AsymmetricSignRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AsymmetricSignRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AsymmetricSignRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 26:
            {
              com.google.cloud.kms.v1.Digest.Builder subBuilder = null;
              if (digest_ != null) {
                subBuilder = digest_.toBuilder();
              }
              digest_ =
                  input.readMessage(com.google.cloud.kms.v1.Digest.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(digest_);
                digest_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.protobuf.Int64Value.Builder subBuilder = null;
              if (digestCrc32C_ != null) {
                subBuilder = digestCrc32C_.toBuilder();
              }
              digestCrc32C_ =
                  input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(digestCrc32C_);
                digestCrc32C_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_AsymmetricSignRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_AsymmetricSignRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.AsymmetricSignRequest.class,
            com.google.cloud.kms.v1.AsymmetricSignRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIGEST_FIELD_NUMBER = 3;
  private com.google.cloud.kms.v1.Digest digest_;
  /**
   *
   *
   * <pre>
   * Required. The digest of the data to sign. The digest must be produced with
   * the same digest algorithm as specified by the key version's
   * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the digest field is set.
   */
  @java.lang.Override
  public boolean hasDigest() {
    return digest_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The digest of the data to sign. The digest must be produced with
   * the same digest algorithm as specified by the key version's
   * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The digest.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.Digest getDigest() {
    return digest_ == null ? com.google.cloud.kms.v1.Digest.getDefaultInstance() : digest_;
  }
  /**
   *
   *
   * <pre>
   * Required. The digest of the data to sign. The digest must be produced with
   * the same digest algorithm as specified by the key version's
   * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.DigestOrBuilder getDigestOrBuilder() {
    return getDigest();
  }

  public static final int DIGEST_CRC32C_FIELD_NUMBER = 4;
  private com.google.protobuf.Int64Value digestCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
   * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
   * fails. If you receive a checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the digestCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasDigestCrc32C() {
    return digestCrc32C_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
   * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
   * fails. If you receive a checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The digestCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getDigestCrc32C() {
    return digestCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : digestCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
   * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
   * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
   * fails. If you receive a checksum error, your client should verify that
   * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getDigestCrc32COrBuilder() {
    return getDigestCrc32C();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (digest_ != null) {
      output.writeMessage(3, getDigest());
    }
    if (digestCrc32C_ != null) {
      output.writeMessage(4, getDigestCrc32C());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (digest_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDigest());
    }
    if (digestCrc32C_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDigestCrc32C());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.AsymmetricSignRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.AsymmetricSignRequest other =
        (com.google.cloud.kms.v1.AsymmetricSignRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDigest() != other.hasDigest()) return false;
    if (hasDigest()) {
      if (!getDigest().equals(other.getDigest())) return false;
    }
    if (hasDigestCrc32C() != other.hasDigestCrc32C()) return false;
    if (hasDigestCrc32C()) {
      if (!getDigestCrc32C().equals(other.getDigestCrc32C())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDigest()) {
      hash = (37 * hash) + DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getDigest().hashCode();
    }
    if (hasDigestCrc32C()) {
      hash = (37 * hash) + DIGEST_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getDigestCrc32C().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.AsymmetricSignRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.AsymmetricSignRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.AsymmetricSignRequest)
      com.google.cloud.kms.v1.AsymmetricSignRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricSignRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricSignRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.AsymmetricSignRequest.class,
              com.google.cloud.kms.v1.AsymmetricSignRequest.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.AsymmetricSignRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (digestBuilder_ == null) {
        digest_ = null;
      } else {
        digest_ = null;
        digestBuilder_ = null;
      }
      if (digestCrc32CBuilder_ == null) {
        digestCrc32C_ = null;
      } else {
        digestCrc32C_ = null;
        digestCrc32CBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricSignRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricSignRequest getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.AsymmetricSignRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricSignRequest build() {
      com.google.cloud.kms.v1.AsymmetricSignRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricSignRequest buildPartial() {
      com.google.cloud.kms.v1.AsymmetricSignRequest result =
          new com.google.cloud.kms.v1.AsymmetricSignRequest(this);
      result.name_ = name_;
      if (digestBuilder_ == null) {
        result.digest_ = digest_;
      } else {
        result.digest_ = digestBuilder_.build();
      }
      if (digestCrc32CBuilder_ == null) {
        result.digestCrc32C_ = digestCrc32C_;
      } else {
        result.digestCrc32C_ = digestCrc32CBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.AsymmetricSignRequest) {
        return mergeFrom((com.google.cloud.kms.v1.AsymmetricSignRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.AsymmetricSignRequest other) {
      if (other == com.google.cloud.kms.v1.AsymmetricSignRequest.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasDigest()) {
        mergeDigest(other.getDigest());
      }
      if (other.hasDigestCrc32C()) {
        mergeDigestCrc32C(other.getDigestCrc32C());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.AsymmetricSignRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.AsymmetricSignRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.Digest digest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.Digest,
            com.google.cloud.kms.v1.Digest.Builder,
            com.google.cloud.kms.v1.DigestOrBuilder>
        digestBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the digest field is set.
     */
    public boolean hasDigest() {
      return digestBuilder_ != null || digest_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The digest.
     */
    public com.google.cloud.kms.v1.Digest getDigest() {
      if (digestBuilder_ == null) {
        return digest_ == null ? com.google.cloud.kms.v1.Digest.getDefaultInstance() : digest_;
      } else {
        return digestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDigest(com.google.cloud.kms.v1.Digest value) {
      if (digestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        digest_ = value;
        onChanged();
      } else {
        digestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDigest(com.google.cloud.kms.v1.Digest.Builder builderForValue) {
      if (digestBuilder_ == null) {
        digest_ = builderForValue.build();
        onChanged();
      } else {
        digestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDigest(com.google.cloud.kms.v1.Digest value) {
      if (digestBuilder_ == null) {
        if (digest_ != null) {
          digest_ =
              com.google.cloud.kms.v1.Digest.newBuilder(digest_).mergeFrom(value).buildPartial();
        } else {
          digest_ = value;
        }
        onChanged();
      } else {
        digestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDigest() {
      if (digestBuilder_ == null) {
        digest_ = null;
        onChanged();
      } else {
        digest_ = null;
        digestBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.kms.v1.Digest.Builder getDigestBuilder() {

      onChanged();
      return getDigestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.kms.v1.DigestOrBuilder getDigestOrBuilder() {
      if (digestBuilder_ != null) {
        return digestBuilder_.getMessageOrBuilder();
      } else {
        return digest_ == null ? com.google.cloud.kms.v1.Digest.getDefaultInstance() : digest_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The digest of the data to sign. The digest must be produced with
     * the same digest algorithm as specified by the key version's
     * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.Digest digest = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.Digest,
            com.google.cloud.kms.v1.Digest.Builder,
            com.google.cloud.kms.v1.DigestOrBuilder>
        getDigestFieldBuilder() {
      if (digestBuilder_ == null) {
        digestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.Digest,
                com.google.cloud.kms.v1.Digest.Builder,
                com.google.cloud.kms.v1.DigestOrBuilder>(
                getDigest(), getParentForChildren(), isClean());
        digest_ = null;
      }
      return digestBuilder_;
    }

    private com.google.protobuf.Int64Value digestCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        digestCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the digestCrc32c field is set.
     */
    public boolean hasDigestCrc32C() {
      return digestCrc32CBuilder_ != null || digestCrc32C_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The digestCrc32c.
     */
    public com.google.protobuf.Int64Value getDigestCrc32C() {
      if (digestCrc32CBuilder_ == null) {
        return digestCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : digestCrc32C_;
      } else {
        return digestCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDigestCrc32C(com.google.protobuf.Int64Value value) {
      if (digestCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        digestCrc32C_ = value;
        onChanged();
      } else {
        digestCrc32CBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDigestCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (digestCrc32CBuilder_ == null) {
        digestCrc32C_ = builderForValue.build();
        onChanged();
      } else {
        digestCrc32CBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDigestCrc32C(com.google.protobuf.Int64Value value) {
      if (digestCrc32CBuilder_ == null) {
        if (digestCrc32C_ != null) {
          digestCrc32C_ =
              com.google.protobuf.Int64Value.newBuilder(digestCrc32C_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          digestCrc32C_ = value;
        }
        onChanged();
      } else {
        digestCrc32CBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDigestCrc32C() {
      if (digestCrc32CBuilder_ == null) {
        digestCrc32C_ = null;
        onChanged();
      } else {
        digestCrc32C_ = null;
        digestCrc32CBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getDigestCrc32CBuilder() {

      onChanged();
      return getDigestCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getDigestCrc32COrBuilder() {
      if (digestCrc32CBuilder_ != null) {
        return digestCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return digestCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : digestCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. If
     * specified, [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will verify the integrity of the
     * received [AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest] using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will report an error if the checksum verification
     * fails. If you receive a checksum error, your client should verify that
     * CRC32C([AsymmetricSignRequest.digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]) is equal to
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c], and if so, perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value digest_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getDigestCrc32CFieldBuilder() {
      if (digestCrc32CBuilder_ == null) {
        digestCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getDigestCrc32C(), getParentForChildren(), isClean());
        digestCrc32C_ = null;
      }
      return digestCrc32CBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.AsymmetricSignRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.AsymmetricSignRequest)
  private static final com.google.cloud.kms.v1.AsymmetricSignRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.AsymmetricSignRequest();
  }

  public static com.google.cloud.kms.v1.AsymmetricSignRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AsymmetricSignRequest> PARSER =
      new com.google.protobuf.AbstractParser<AsymmetricSignRequest>() {
        @java.lang.Override
        public AsymmetricSignRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AsymmetricSignRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AsymmetricSignRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AsymmetricSignRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.AsymmetricSignRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
