/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Request message for [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.ImportCryptoKeyVersionRequest}
 */
public final class ImportCryptoKeyVersionRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.ImportCryptoKeyVersionRequest)
    ImportCryptoKeyVersionRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportCryptoKeyVersionRequest.newBuilder() to construct.
  private ImportCryptoKeyVersionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportCryptoKeyVersionRequest() {
    parent_ = "";
    algorithm_ = 0;
    importJob_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportCryptoKeyVersionRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportCryptoKeyVersionRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              algorithm_ = rawValue;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              importJob_ = s;
              break;
            }
          case 42:
            {
              wrappedKeyMaterialCase_ = 5;
              wrappedKeyMaterial_ = input.readBytes();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_ImportCryptoKeyVersionRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_ImportCryptoKeyVersionRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest.class,
            com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest.Builder.class);
  }

  private int wrappedKeyMaterialCase_ = 0;
  private java.lang.Object wrappedKeyMaterial_;

  public enum WrappedKeyMaterialCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RSA_AES_WRAPPED_KEY(5),
    WRAPPEDKEYMATERIAL_NOT_SET(0);
    private final int value;

    private WrappedKeyMaterialCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WrappedKeyMaterialCase valueOf(int value) {
      return forNumber(value);
    }

    public static WrappedKeyMaterialCase forNumber(int value) {
      switch (value) {
        case 5:
          return RSA_AES_WRAPPED_KEY;
        case 0:
          return WRAPPEDKEYMATERIAL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public WrappedKeyMaterialCase getWrappedKeyMaterialCase() {
    return WrappedKeyMaterialCase.forNumber(wrappedKeyMaterialCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
   * be imported into.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
   * be imported into.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALGORITHM_FIELD_NUMBER = 2;
  private int algorithm_;
  /**
   *
   *
   * <pre>
   * Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
   * the key being imported. This does not need to match the
   * [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
   * version imports into.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for algorithm.
   */
  @java.lang.Override
  public int getAlgorithmValue() {
    return algorithm_;
  }
  /**
   *
   *
   * <pre>
   * Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
   * the key being imported. This does not need to match the
   * [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
   * version imports into.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The algorithm.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.valueOf(algorithm_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
        : result;
  }

  public static final int IMPORT_JOB_FIELD_NUMBER = 4;
  private volatile java.lang.Object importJob_;
  /**
   *
   *
   * <pre>
   * Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
   * wrap this key material.
   * </pre>
   *
   * <code>string import_job = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The importJob.
   */
  @java.lang.Override
  public java.lang.String getImportJob() {
    java.lang.Object ref = importJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      importJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
   * wrap this key material.
   * </pre>
   *
   * <code>string import_job = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for importJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImportJobBytes() {
    java.lang.Object ref = importJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      importJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RSA_AES_WRAPPED_KEY_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Wrapped key material produced with
   * [RSA_OAEP_3072_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_3072_SHA1_AES_256]
   * or
   * [RSA_OAEP_4096_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_4096_SHA1_AES_256].
   * This field contains the concatenation of two wrapped keys:
   * &lt;ol&gt;
   *   &lt;li&gt;An ephemeral AES-256 wrapping key wrapped with the
   *       [public_key][google.cloud.kms.v1.ImportJob.public_key] using RSAES-OAEP with SHA-1,
   *       MGF1 with SHA-1, and an empty label.
   *   &lt;/li&gt;
   *   &lt;li&gt;The key to be imported, wrapped with the ephemeral AES-256 key
   *       using AES-KWP (RFC 5649).
   *   &lt;/li&gt;
   * &lt;/ol&gt;
   * If importing symmetric key material, it is expected that the unwrapped
   * key contains plain bytes. If importing asymmetric key material, it is
   * expected that the unwrapped key is in PKCS#8-encoded DER format (the
   * PrivateKeyInfo structure from RFC 5208).
   * This format is the same as the format produced by PKCS#11 mechanism
   * CKM_RSA_AES_KEY_WRAP.
   * </pre>
   *
   * <code>bytes rsa_aes_wrapped_key = 5;</code>
   *
   * @return Whether the rsaAesWrappedKey field is set.
   */
  @java.lang.Override
  public boolean hasRsaAesWrappedKey() {
    return wrappedKeyMaterialCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Wrapped key material produced with
   * [RSA_OAEP_3072_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_3072_SHA1_AES_256]
   * or
   * [RSA_OAEP_4096_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_4096_SHA1_AES_256].
   * This field contains the concatenation of two wrapped keys:
   * &lt;ol&gt;
   *   &lt;li&gt;An ephemeral AES-256 wrapping key wrapped with the
   *       [public_key][google.cloud.kms.v1.ImportJob.public_key] using RSAES-OAEP with SHA-1,
   *       MGF1 with SHA-1, and an empty label.
   *   &lt;/li&gt;
   *   &lt;li&gt;The key to be imported, wrapped with the ephemeral AES-256 key
   *       using AES-KWP (RFC 5649).
   *   &lt;/li&gt;
   * &lt;/ol&gt;
   * If importing symmetric key material, it is expected that the unwrapped
   * key contains plain bytes. If importing asymmetric key material, it is
   * expected that the unwrapped key is in PKCS#8-encoded DER format (the
   * PrivateKeyInfo structure from RFC 5208).
   * This format is the same as the format produced by PKCS#11 mechanism
   * CKM_RSA_AES_KEY_WRAP.
   * </pre>
   *
   * <code>bytes rsa_aes_wrapped_key = 5;</code>
   *
   * @return The rsaAesWrappedKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRsaAesWrappedKey() {
    if (wrappedKeyMaterialCase_ == 5) {
      return (com.google.protobuf.ByteString) wrappedKeyMaterial_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getParentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, algorithm_);
    }
    if (!getImportJobBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, importJob_);
    }
    if (wrappedKeyMaterialCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) wrappedKeyMaterial_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getParentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, algorithm_);
    }
    if (!getImportJobBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, importJob_);
    }
    if (wrappedKeyMaterialCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) wrappedKeyMaterial_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest other =
        (com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (algorithm_ != other.algorithm_) return false;
    if (!getImportJob().equals(other.getImportJob())) return false;
    if (!getWrappedKeyMaterialCase().equals(other.getWrappedKeyMaterialCase())) return false;
    switch (wrappedKeyMaterialCase_) {
      case 5:
        if (!getRsaAesWrappedKey().equals(other.getRsaAesWrappedKey())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + algorithm_;
    hash = (37 * hash) + IMPORT_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getImportJob().hashCode();
    switch (wrappedKeyMaterialCase_) {
      case 5:
        hash = (37 * hash) + RSA_AES_WRAPPED_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getRsaAesWrappedKey().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.ImportCryptoKeyVersionRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.ImportCryptoKeyVersionRequest)
      com.google.cloud.kms.v1.ImportCryptoKeyVersionRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_ImportCryptoKeyVersionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_ImportCryptoKeyVersionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest.class,
              com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      algorithm_ = 0;

      importJob_ = "";

      wrappedKeyMaterialCase_ = 0;
      wrappedKeyMaterial_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_ImportCryptoKeyVersionRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest build() {
      com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest buildPartial() {
      com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest result =
          new com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest(this);
      result.parent_ = parent_;
      result.algorithm_ = algorithm_;
      result.importJob_ = importJob_;
      if (wrappedKeyMaterialCase_ == 5) {
        result.wrappedKeyMaterial_ = wrappedKeyMaterial_;
      }
      result.wrappedKeyMaterialCase_ = wrappedKeyMaterialCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest) {
        return mergeFrom((com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest other) {
      if (other == com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.algorithm_ != 0) {
        setAlgorithmValue(other.getAlgorithmValue());
      }
      if (!other.getImportJob().isEmpty()) {
        importJob_ = other.importJob_;
        onChanged();
      }
      switch (other.getWrappedKeyMaterialCase()) {
        case RSA_AES_WRAPPED_KEY:
          {
            setRsaAesWrappedKey(other.getRsaAesWrappedKey());
            break;
          }
        case WRAPPEDKEYMATERIAL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int wrappedKeyMaterialCase_ = 0;
    private java.lang.Object wrappedKeyMaterial_;

    public WrappedKeyMaterialCase getWrappedKeyMaterialCase() {
      return WrappedKeyMaterialCase.forNumber(wrappedKeyMaterialCase_);
    }

    public Builder clearWrappedKeyMaterial() {
      wrappedKeyMaterialCase_ = 0;
      wrappedKeyMaterial_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
     * be imported into.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
     * be imported into.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
     * be imported into.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
     * be imported into.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
     * be imported into.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private int algorithm_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
     * the key being imported. This does not need to match the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
     * version imports into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    @java.lang.Override
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     *
     *
     * <pre>
     * Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
     * the key being imported. This does not need to match the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
     * version imports into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmValue(int value) {

      algorithm_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
     * the key being imported. This does not need to match the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
     * version imports into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The algorithm.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
          com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.valueOf(algorithm_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
     * the key being imported. This does not need to match the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
     * version imports into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }

      algorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
     * the key being imported. This does not need to match the
     * [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
     * version imports into.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {

      algorithm_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object importJob_ = "";
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
     * wrap this key material.
     * </pre>
     *
     * <code>string import_job = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The importJob.
     */
    public java.lang.String getImportJob() {
      java.lang.Object ref = importJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        importJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
     * wrap this key material.
     * </pre>
     *
     * <code>string import_job = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for importJob.
     */
    public com.google.protobuf.ByteString getImportJobBytes() {
      java.lang.Object ref = importJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        importJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
     * wrap this key material.
     * </pre>
     *
     * <code>string import_job = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The importJob to set.
     * @return This builder for chaining.
     */
    public Builder setImportJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      importJob_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
     * wrap this key material.
     * </pre>
     *
     * <code>string import_job = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportJob() {

      importJob_ = getDefaultInstance().getImportJob();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
     * wrap this key material.
     * </pre>
     *
     * <code>string import_job = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for importJob to set.
     * @return This builder for chaining.
     */
    public Builder setImportJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      importJob_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Wrapped key material produced with
     * [RSA_OAEP_3072_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_3072_SHA1_AES_256]
     * or
     * [RSA_OAEP_4096_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_4096_SHA1_AES_256].
     * This field contains the concatenation of two wrapped keys:
     * &lt;ol&gt;
     *   &lt;li&gt;An ephemeral AES-256 wrapping key wrapped with the
     *       [public_key][google.cloud.kms.v1.ImportJob.public_key] using RSAES-OAEP with SHA-1,
     *       MGF1 with SHA-1, and an empty label.
     *   &lt;/li&gt;
     *   &lt;li&gt;The key to be imported, wrapped with the ephemeral AES-256 key
     *       using AES-KWP (RFC 5649).
     *   &lt;/li&gt;
     * &lt;/ol&gt;
     * If importing symmetric key material, it is expected that the unwrapped
     * key contains plain bytes. If importing asymmetric key material, it is
     * expected that the unwrapped key is in PKCS#8-encoded DER format (the
     * PrivateKeyInfo structure from RFC 5208).
     * This format is the same as the format produced by PKCS#11 mechanism
     * CKM_RSA_AES_KEY_WRAP.
     * </pre>
     *
     * <code>bytes rsa_aes_wrapped_key = 5;</code>
     *
     * @return Whether the rsaAesWrappedKey field is set.
     */
    public boolean hasRsaAesWrappedKey() {
      return wrappedKeyMaterialCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Wrapped key material produced with
     * [RSA_OAEP_3072_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_3072_SHA1_AES_256]
     * or
     * [RSA_OAEP_4096_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_4096_SHA1_AES_256].
     * This field contains the concatenation of two wrapped keys:
     * &lt;ol&gt;
     *   &lt;li&gt;An ephemeral AES-256 wrapping key wrapped with the
     *       [public_key][google.cloud.kms.v1.ImportJob.public_key] using RSAES-OAEP with SHA-1,
     *       MGF1 with SHA-1, and an empty label.
     *   &lt;/li&gt;
     *   &lt;li&gt;The key to be imported, wrapped with the ephemeral AES-256 key
     *       using AES-KWP (RFC 5649).
     *   &lt;/li&gt;
     * &lt;/ol&gt;
     * If importing symmetric key material, it is expected that the unwrapped
     * key contains plain bytes. If importing asymmetric key material, it is
     * expected that the unwrapped key is in PKCS#8-encoded DER format (the
     * PrivateKeyInfo structure from RFC 5208).
     * This format is the same as the format produced by PKCS#11 mechanism
     * CKM_RSA_AES_KEY_WRAP.
     * </pre>
     *
     * <code>bytes rsa_aes_wrapped_key = 5;</code>
     *
     * @return The rsaAesWrappedKey.
     */
    public com.google.protobuf.ByteString getRsaAesWrappedKey() {
      if (wrappedKeyMaterialCase_ == 5) {
        return (com.google.protobuf.ByteString) wrappedKeyMaterial_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Wrapped key material produced with
     * [RSA_OAEP_3072_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_3072_SHA1_AES_256]
     * or
     * [RSA_OAEP_4096_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_4096_SHA1_AES_256].
     * This field contains the concatenation of two wrapped keys:
     * &lt;ol&gt;
     *   &lt;li&gt;An ephemeral AES-256 wrapping key wrapped with the
     *       [public_key][google.cloud.kms.v1.ImportJob.public_key] using RSAES-OAEP with SHA-1,
     *       MGF1 with SHA-1, and an empty label.
     *   &lt;/li&gt;
     *   &lt;li&gt;The key to be imported, wrapped with the ephemeral AES-256 key
     *       using AES-KWP (RFC 5649).
     *   &lt;/li&gt;
     * &lt;/ol&gt;
     * If importing symmetric key material, it is expected that the unwrapped
     * key contains plain bytes. If importing asymmetric key material, it is
     * expected that the unwrapped key is in PKCS#8-encoded DER format (the
     * PrivateKeyInfo structure from RFC 5208).
     * This format is the same as the format produced by PKCS#11 mechanism
     * CKM_RSA_AES_KEY_WRAP.
     * </pre>
     *
     * <code>bytes rsa_aes_wrapped_key = 5;</code>
     *
     * @param value The rsaAesWrappedKey to set.
     * @return This builder for chaining.
     */
    public Builder setRsaAesWrappedKey(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      wrappedKeyMaterialCase_ = 5;
      wrappedKeyMaterial_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Wrapped key material produced with
     * [RSA_OAEP_3072_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_3072_SHA1_AES_256]
     * or
     * [RSA_OAEP_4096_SHA1_AES_256][google.cloud.kms.v1.ImportJob.ImportMethod.RSA_OAEP_4096_SHA1_AES_256].
     * This field contains the concatenation of two wrapped keys:
     * &lt;ol&gt;
     *   &lt;li&gt;An ephemeral AES-256 wrapping key wrapped with the
     *       [public_key][google.cloud.kms.v1.ImportJob.public_key] using RSAES-OAEP with SHA-1,
     *       MGF1 with SHA-1, and an empty label.
     *   &lt;/li&gt;
     *   &lt;li&gt;The key to be imported, wrapped with the ephemeral AES-256 key
     *       using AES-KWP (RFC 5649).
     *   &lt;/li&gt;
     * &lt;/ol&gt;
     * If importing symmetric key material, it is expected that the unwrapped
     * key contains plain bytes. If importing asymmetric key material, it is
     * expected that the unwrapped key is in PKCS#8-encoded DER format (the
     * PrivateKeyInfo structure from RFC 5208).
     * This format is the same as the format produced by PKCS#11 mechanism
     * CKM_RSA_AES_KEY_WRAP.
     * </pre>
     *
     * <code>bytes rsa_aes_wrapped_key = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRsaAesWrappedKey() {
      if (wrappedKeyMaterialCase_ == 5) {
        wrappedKeyMaterialCase_ = 0;
        wrappedKeyMaterial_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.ImportCryptoKeyVersionRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.ImportCryptoKeyVersionRequest)
  private static final com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest();
  }

  public static com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportCryptoKeyVersionRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportCryptoKeyVersionRequest>() {
        @java.lang.Override
        public ImportCryptoKeyVersionRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportCryptoKeyVersionRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportCryptoKeyVersionRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportCryptoKeyVersionRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
