/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * A [CryptoKey][google.cloud.kms.v1.CryptoKey] represents a logical key that can be used for cryptographic
 * operations.
 * A [CryptoKey][google.cloud.kms.v1.CryptoKey] is made up of zero or more [versions][google.cloud.kms.v1.CryptoKeyVersion],
 * which represent the actual key material used in cryptographic operations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.CryptoKey}
 */
public final class CryptoKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.CryptoKey)
    CryptoKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CryptoKey.newBuilder() to construct.
  private CryptoKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CryptoKey() {
    name_ = "";
    purpose_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CryptoKey();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CryptoKey(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.kms.v1.CryptoKeyVersion.Builder subBuilder = null;
              if (primary_ != null) {
                subBuilder = primary_.toBuilder();
              }
              primary_ =
                  input.readMessage(
                      com.google.cloud.kms.v1.CryptoKeyVersion.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(primary_);
                primary_ = subBuilder.buildPartial();
              }

              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              purpose_ = rawValue;
              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (nextRotationTime_ != null) {
                subBuilder = nextRotationTime_.toBuilder();
              }
              nextRotationTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(nextRotationTime_);
                nextRotationTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (rotationScheduleCase_ == 8) {
                subBuilder = ((com.google.protobuf.Duration) rotationSchedule_).toBuilder();
              }
              rotationSchedule_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.protobuf.Duration) rotationSchedule_);
                rotationSchedule_ = subBuilder.buildPartial();
              }
              rotationScheduleCase_ = 8;
              break;
            }
          case 82:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 90:
            {
              com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder subBuilder = null;
              if (versionTemplate_ != null) {
                subBuilder = versionTemplate_.toBuilder();
              }
              versionTemplate_ =
                  input.readMessage(
                      com.google.cloud.kms.v1.CryptoKeyVersionTemplate.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(versionTemplate_);
                versionTemplate_ = subBuilder.buildPartial();
              }

              break;
            }
          case 104:
            {
              importOnly_ = input.readBool();
              break;
            }
          case 114:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (destroyScheduledDuration_ != null) {
                subBuilder = destroyScheduledDuration_.toBuilder();
              }
              destroyScheduledDuration_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(destroyScheduledDuration_);
                destroyScheduledDuration_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKey_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.CryptoKey.class,
            com.google.cloud.kms.v1.CryptoKey.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose] describes the cryptographic capabilities of a
   * [CryptoKey][google.cloud.kms.v1.CryptoKey]. A given key can only be used for the operations allowed by
   * its purpose. For more information, see
   * [Key purposes](https://cloud.google.com/kms/docs/algorithms#key_purposes).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose}
   */
  public enum CryptoKeyPurpose implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_PURPOSE_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_PURPOSE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
     * </pre>
     *
     * <code>ENCRYPT_DECRYPT = 1;</code>
     */
    ENCRYPT_DECRYPT(1),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign] and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_SIGN = 5;</code>
     */
    ASYMMETRIC_SIGN(5),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt] and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_DECRYPT = 6;</code>
     */
    ASYMMETRIC_DECRYPT(6),
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
     * </pre>
     *
     * <code>MAC = 9;</code>
     */
    MAC(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_PURPOSE_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_PURPOSE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
     * [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
     * </pre>
     *
     * <code>ENCRYPT_DECRYPT = 1;</code>
     */
    public static final int ENCRYPT_DECRYPT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign] and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_SIGN = 5;</code>
     */
    public static final int ASYMMETRIC_SIGN_VALUE = 5;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt] and
     * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
     * </pre>
     *
     * <code>ASYMMETRIC_DECRYPT = 6;</code>
     */
    public static final int ASYMMETRIC_DECRYPT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used with
     * [MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
     * </pre>
     *
     * <code>MAC = 9;</code>
     */
    public static final int MAC_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyPurpose valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyPurpose forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_PURPOSE_UNSPECIFIED;
        case 1:
          return ENCRYPT_DECRYPT;
        case 5:
          return ASYMMETRIC_SIGN;
        case 6:
          return ASYMMETRIC_DECRYPT;
        case 9:
          return MAC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyPurpose> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyPurpose>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyPurpose>() {
              public CryptoKeyPurpose findValueByNumber(int number) {
                return CryptoKeyPurpose.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKey.getDescriptor().getEnumTypes().get(0);
    }

    private static final CryptoKeyPurpose[] VALUES = values();

    public static CryptoKeyPurpose valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyPurpose(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose)
  }

  private int rotationScheduleCase_ = 0;
  private java.lang.Object rotationSchedule_;

  public enum RotationScheduleCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ROTATION_PERIOD(8),
    ROTATIONSCHEDULE_NOT_SET(0);
    private final int value;

    private RotationScheduleCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RotationScheduleCase valueOf(int value) {
      return forNumber(value);
    }

    public static RotationScheduleCase forNumber(int value) {
      switch (value) {
        case 8:
          return ROTATION_PERIOD;
        case 0:
          return ROTATIONSCHEDULE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RotationScheduleCase getRotationScheduleCase() {
    return RotationScheduleCase.forNumber(rotationScheduleCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIMARY_FIELD_NUMBER = 2;
  private com.google.cloud.kms.v1.CryptoKeyVersion primary_;
  /**
   *
   *
   * <pre>
   * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
   * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
   * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
   * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
   * primary. For other keys, this field will be omitted.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the primary field is set.
   */
  @java.lang.Override
  public boolean hasPrimary() {
    return primary_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
   * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
   * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
   * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
   * primary. For other keys, this field will be omitted.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The primary.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion getPrimary() {
    return primary_ == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()
        : primary_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
   * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
   * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
   * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
   * primary. For other keys, this field will be omitted.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder getPrimaryOrBuilder() {
    return getPrimary();
  }

  public static final int PURPOSE_FIELD_NUMBER = 3;
  private int purpose_;
  /**
   *
   *
   * <pre>
   * Immutable. The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for purpose.
   */
  @java.lang.Override
  public int getPurposeValue() {
    return purpose_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The purpose.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose getPurpose() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose result =
        com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.valueOf(purpose_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int NEXT_ROTATION_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp nextRotationTime_;
  /**
   *
   *
   * <pre>
   * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
   * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * 2. Mark the new version as primary.
   * Key rotations performed manually via
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
   * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
   * automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
   *
   * @return Whether the nextRotationTime field is set.
   */
  @java.lang.Override
  public boolean hasNextRotationTime() {
    return nextRotationTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
   * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * 2. Mark the new version as primary.
   * Key rotations performed manually via
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
   * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
   * automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
   *
   * @return The nextRotationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNextRotationTime() {
    return nextRotationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : nextRotationTime_;
  }
  /**
   *
   *
   * <pre>
   * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
   * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * 2. Mark the new version as primary.
   * Key rotations performed manually via
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
   * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
   * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
   * automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNextRotationTimeOrBuilder() {
    return getNextRotationTime();
  }

  public static final int ROTATION_PERIOD_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
   * automatically rotates a key. Must be at least 24 hours and at most
   * 876,000 hours.
   * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
   * automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Duration rotation_period = 8;</code>
   *
   * @return Whether the rotationPeriod field is set.
   */
  @java.lang.Override
  public boolean hasRotationPeriod() {
    return rotationScheduleCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
   * automatically rotates a key. Must be at least 24 hours and at most
   * 876,000 hours.
   * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
   * automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Duration rotation_period = 8;</code>
   *
   * @return The rotationPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRotationPeriod() {
    if (rotationScheduleCase_ == 8) {
      return (com.google.protobuf.Duration) rotationSchedule_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
   * automatically rotates a key. Must be at least 24 hours and at most
   * 876,000 hours.
   * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
   * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
   * automatic rotation. For other keys, this field must be omitted.
   * </pre>
   *
   * <code>.google.protobuf.Duration rotation_period = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRotationPeriodOrBuilder() {
    if (rotationScheduleCase_ == 8) {
      return (com.google.protobuf.Duration) rotationSchedule_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int VERSION_TEMPLATE_FIELD_NUMBER = 11;
  private com.google.cloud.kms.v1.CryptoKeyVersionTemplate versionTemplate_;
  /**
   *
   *
   * <pre>
   * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
   * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
   * auto-rotation are controlled by this template.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
   *
   * @return Whether the versionTemplate field is set.
   */
  @java.lang.Override
  public boolean hasVersionTemplate() {
    return versionTemplate_ != null;
  }
  /**
   *
   *
   * <pre>
   * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
   * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
   * auto-rotation are controlled by this template.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
   *
   * @return The versionTemplate.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersionTemplate getVersionTemplate() {
    return versionTemplate_ == null
        ? com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()
        : versionTemplate_;
  }
  /**
   *
   *
   * <pre>
   * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
   * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
   * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
   * auto-rotation are controlled by this template.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder getVersionTemplateOrBuilder() {
    return getVersionTemplate();
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.kms.v1.KmsResourcesProto
                .internal_static_google_cloud_kms_v1_CryptoKey_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels with user-defined metadata. For more information, see
   * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IMPORT_ONLY_FIELD_NUMBER = 13;
  private boolean importOnly_;
  /**
   *
   *
   * <pre>
   * Immutable. Whether this key may contain imported versions only.
   * </pre>
   *
   * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The importOnly.
   */
  @java.lang.Override
  public boolean getImportOnly() {
    return importOnly_;
  }

  public static final int DESTROY_SCHEDULED_DURATION_FIELD_NUMBER = 14;
  private com.google.protobuf.Duration destroyScheduledDuration_;
  /**
   *
   *
   * <pre>
   * Immutable. The period of time that versions of this key spend in the
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
   * state before transitioning to
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
   * specified at creation time, the default duration is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the destroyScheduledDuration field is set.
   */
  @java.lang.Override
  public boolean hasDestroyScheduledDuration() {
    return destroyScheduledDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The period of time that versions of this key spend in the
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
   * state before transitioning to
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
   * specified at creation time, the default duration is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The destroyScheduledDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDestroyScheduledDuration() {
    return destroyScheduledDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : destroyScheduledDuration_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The period of time that versions of this key spend in the
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
   * state before transitioning to
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
   * specified at creation time, the default duration is 24 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDestroyScheduledDurationOrBuilder() {
    return getDestroyScheduledDuration();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (primary_ != null) {
      output.writeMessage(2, getPrimary());
    }
    if (purpose_
        != com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.CRYPTO_KEY_PURPOSE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, purpose_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (nextRotationTime_ != null) {
      output.writeMessage(7, getNextRotationTime());
    }
    if (rotationScheduleCase_ == 8) {
      output.writeMessage(8, (com.google.protobuf.Duration) rotationSchedule_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    if (versionTemplate_ != null) {
      output.writeMessage(11, getVersionTemplate());
    }
    if (importOnly_ != false) {
      output.writeBool(13, importOnly_);
    }
    if (destroyScheduledDuration_ != null) {
      output.writeMessage(14, getDestroyScheduledDuration());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (primary_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPrimary());
    }
    if (purpose_
        != com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.CRYPTO_KEY_PURPOSE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, purpose_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (nextRotationTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNextRotationTime());
    }
    if (rotationScheduleCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.protobuf.Duration) rotationSchedule_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    if (versionTemplate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getVersionTemplate());
    }
    if (importOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, importOnly_);
    }
    if (destroyScheduledDuration_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, getDestroyScheduledDuration());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.CryptoKey)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.CryptoKey other = (com.google.cloud.kms.v1.CryptoKey) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasPrimary() != other.hasPrimary()) return false;
    if (hasPrimary()) {
      if (!getPrimary().equals(other.getPrimary())) return false;
    }
    if (purpose_ != other.purpose_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasNextRotationTime() != other.hasNextRotationTime()) return false;
    if (hasNextRotationTime()) {
      if (!getNextRotationTime().equals(other.getNextRotationTime())) return false;
    }
    if (hasVersionTemplate() != other.hasVersionTemplate()) return false;
    if (hasVersionTemplate()) {
      if (!getVersionTemplate().equals(other.getVersionTemplate())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getImportOnly() != other.getImportOnly()) return false;
    if (hasDestroyScheduledDuration() != other.hasDestroyScheduledDuration()) return false;
    if (hasDestroyScheduledDuration()) {
      if (!getDestroyScheduledDuration().equals(other.getDestroyScheduledDuration())) return false;
    }
    if (!getRotationScheduleCase().equals(other.getRotationScheduleCase())) return false;
    switch (rotationScheduleCase_) {
      case 8:
        if (!getRotationPeriod().equals(other.getRotationPeriod())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasPrimary()) {
      hash = (37 * hash) + PRIMARY_FIELD_NUMBER;
      hash = (53 * hash) + getPrimary().hashCode();
    }
    hash = (37 * hash) + PURPOSE_FIELD_NUMBER;
    hash = (53 * hash) + purpose_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasNextRotationTime()) {
      hash = (37 * hash) + NEXT_ROTATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNextRotationTime().hashCode();
    }
    if (hasVersionTemplate()) {
      hash = (37 * hash) + VERSION_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getVersionTemplate().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + IMPORT_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportOnly());
    if (hasDestroyScheduledDuration()) {
      hash = (37 * hash) + DESTROY_SCHEDULED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyScheduledDuration().hashCode();
    }
    switch (rotationScheduleCase_) {
      case 8:
        hash = (37 * hash) + ROTATION_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getRotationPeriod().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.CryptoKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [CryptoKey][google.cloud.kms.v1.CryptoKey] represents a logical key that can be used for cryptographic
   * operations.
   * A [CryptoKey][google.cloud.kms.v1.CryptoKey] is made up of zero or more [versions][google.cloud.kms.v1.CryptoKeyVersion],
   * which represent the actual key material used in cryptographic operations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.CryptoKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.CryptoKey)
      com.google.cloud.kms.v1.CryptoKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKey_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.CryptoKey.class,
              com.google.cloud.kms.v1.CryptoKey.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.CryptoKey.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (primaryBuilder_ == null) {
        primary_ = null;
      } else {
        primary_ = null;
        primaryBuilder_ = null;
      }
      purpose_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTime_ = null;
      } else {
        nextRotationTime_ = null;
        nextRotationTimeBuilder_ = null;
      }
      if (versionTemplateBuilder_ == null) {
        versionTemplate_ = null;
      } else {
        versionTemplate_ = null;
        versionTemplateBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      importOnly_ = false;

      if (destroyScheduledDurationBuilder_ == null) {
        destroyScheduledDuration_ = null;
      } else {
        destroyScheduledDuration_ = null;
        destroyScheduledDurationBuilder_ = null;
      }
      rotationScheduleCase_ = 0;
      rotationSchedule_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.CryptoKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey build() {
      com.google.cloud.kms.v1.CryptoKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey buildPartial() {
      com.google.cloud.kms.v1.CryptoKey result = new com.google.cloud.kms.v1.CryptoKey(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (primaryBuilder_ == null) {
        result.primary_ = primary_;
      } else {
        result.primary_ = primaryBuilder_.build();
      }
      result.purpose_ = purpose_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (nextRotationTimeBuilder_ == null) {
        result.nextRotationTime_ = nextRotationTime_;
      } else {
        result.nextRotationTime_ = nextRotationTimeBuilder_.build();
      }
      if (rotationScheduleCase_ == 8) {
        if (rotationPeriodBuilder_ == null) {
          result.rotationSchedule_ = rotationSchedule_;
        } else {
          result.rotationSchedule_ = rotationPeriodBuilder_.build();
        }
      }
      if (versionTemplateBuilder_ == null) {
        result.versionTemplate_ = versionTemplate_;
      } else {
        result.versionTemplate_ = versionTemplateBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.importOnly_ = importOnly_;
      if (destroyScheduledDurationBuilder_ == null) {
        result.destroyScheduledDuration_ = destroyScheduledDuration_;
      } else {
        result.destroyScheduledDuration_ = destroyScheduledDurationBuilder_.build();
      }
      result.rotationScheduleCase_ = rotationScheduleCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.CryptoKey) {
        return mergeFrom((com.google.cloud.kms.v1.CryptoKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.CryptoKey other) {
      if (other == com.google.cloud.kms.v1.CryptoKey.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasPrimary()) {
        mergePrimary(other.getPrimary());
      }
      if (other.purpose_ != 0) {
        setPurposeValue(other.getPurposeValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasNextRotationTime()) {
        mergeNextRotationTime(other.getNextRotationTime());
      }
      if (other.hasVersionTemplate()) {
        mergeVersionTemplate(other.getVersionTemplate());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.getImportOnly() != false) {
        setImportOnly(other.getImportOnly());
      }
      if (other.hasDestroyScheduledDuration()) {
        mergeDestroyScheduledDuration(other.getDestroyScheduledDuration());
      }
      switch (other.getRotationScheduleCase()) {
        case ROTATION_PERIOD:
          {
            mergeRotationPeriod(other.getRotationPeriod());
            break;
          }
        case ROTATIONSCHEDULE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.CryptoKey parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.CryptoKey) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int rotationScheduleCase_ = 0;
    private java.lang.Object rotationSchedule_;

    public RotationScheduleCase getRotationScheduleCase() {
      return RotationScheduleCase.forNumber(rotationScheduleCase_);
    }

    public Builder clearRotationSchedule() {
      rotationScheduleCase_ = 0;
      rotationSchedule_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.CryptoKeyVersion primary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersion,
            com.google.cloud.kms.v1.CryptoKeyVersion.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder>
        primaryBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the primary field is set.
     */
    public boolean hasPrimary() {
      return primaryBuilder_ != null || primary_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The primary.
     */
    public com.google.cloud.kms.v1.CryptoKeyVersion getPrimary() {
      if (primaryBuilder_ == null) {
        return primary_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()
            : primary_;
      } else {
        return primaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrimary(com.google.cloud.kms.v1.CryptoKeyVersion value) {
      if (primaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        primary_ = value;
        onChanged();
      } else {
        primaryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrimary(com.google.cloud.kms.v1.CryptoKeyVersion.Builder builderForValue) {
      if (primaryBuilder_ == null) {
        primary_ = builderForValue.build();
        onChanged();
      } else {
        primaryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePrimary(com.google.cloud.kms.v1.CryptoKeyVersion value) {
      if (primaryBuilder_ == null) {
        if (primary_ != null) {
          primary_ =
              com.google.cloud.kms.v1.CryptoKeyVersion.newBuilder(primary_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          primary_ = value;
        }
        onChanged();
      } else {
        primaryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPrimary() {
      if (primaryBuilder_ == null) {
        primary_ = null;
        onChanged();
      } else {
        primary_ = null;
        primaryBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersion.Builder getPrimaryBuilder() {

      onChanged();
      return getPrimaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder getPrimaryOrBuilder() {
      if (primaryBuilder_ != null) {
        return primaryBuilder_.getMessageOrBuilder();
      } else {
        return primary_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()
            : primary_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A copy of the "primary" [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
     * by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this [CryptoKey][google.cloud.kms.v1.CryptoKey] is given
     * in [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
     * The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be updated via
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] may have a
     * primary. For other keys, this field will be omitted.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion primary = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersion,
            com.google.cloud.kms.v1.CryptoKeyVersion.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder>
        getPrimaryFieldBuilder() {
      if (primaryBuilder_ == null) {
        primaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.CryptoKeyVersion,
                com.google.cloud.kms.v1.CryptoKeyVersion.Builder,
                com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder>(
                getPrimary(), getParentForChildren(), isClean());
        primary_ = null;
      }
      return primaryBuilder_;
    }

    private int purpose_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for purpose.
     */
    @java.lang.Override
    public int getPurposeValue() {
      return purpose_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurposeValue(int value) {

      purpose_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The purpose.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose getPurpose() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose result =
          com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.valueOf(purpose_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurpose(com.google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose value) {
      if (value == null) {
        throw new NullPointerException();
      }

      purpose_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose purpose = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPurpose() {

      purpose_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp nextRotationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        nextRotationTimeBuilder_;
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     *
     * @return Whether the nextRotationTime field is set.
     */
    public boolean hasNextRotationTime() {
      return nextRotationTimeBuilder_ != null || nextRotationTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     *
     * @return The nextRotationTime.
     */
    public com.google.protobuf.Timestamp getNextRotationTime() {
      if (nextRotationTimeBuilder_ == null) {
        return nextRotationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRotationTime_;
      } else {
        return nextRotationTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder setNextRotationTime(com.google.protobuf.Timestamp value) {
      if (nextRotationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextRotationTime_ = value;
        onChanged();
      } else {
        nextRotationTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder setNextRotationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTime_ = builderForValue.build();
        onChanged();
      } else {
        nextRotationTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder mergeNextRotationTime(com.google.protobuf.Timestamp value) {
      if (nextRotationTimeBuilder_ == null) {
        if (nextRotationTime_ != null) {
          nextRotationTime_ =
              com.google.protobuf.Timestamp.newBuilder(nextRotationTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          nextRotationTime_ = value;
        }
        onChanged();
      } else {
        nextRotationTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public Builder clearNextRotationTime() {
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTime_ = null;
        onChanged();
      } else {
        nextRotationTime_ = null;
        nextRotationTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getNextRotationTimeBuilder() {

      onChanged();
      return getNextRotationTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getNextRotationTimeOrBuilder() {
      if (nextRotationTimeBuilder_ != null) {
        return nextRotationTimeBuilder_.getMessageOrBuilder();
      } else {
        return nextRotationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRotationTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time], the Key Management Service will automatically:
     * 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
     * 2. Mark the new version as primary.
     * Key rotations performed manually via
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] and
     * [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
     * do not affect [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp next_rotation_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNextRotationTimeFieldBuilder() {
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNextRotationTime(), getParentForChildren(), isClean());
        nextRotationTime_ = null;
      }
      return nextRotationTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        rotationPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     *
     * @return Whether the rotationPeriod field is set.
     */
    @java.lang.Override
    public boolean hasRotationPeriod() {
      return rotationScheduleCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     *
     * @return The rotationPeriod.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRotationPeriod() {
      if (rotationPeriodBuilder_ == null) {
        if (rotationScheduleCase_ == 8) {
          return (com.google.protobuf.Duration) rotationSchedule_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (rotationScheduleCase_ == 8) {
          return rotationPeriodBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder setRotationPeriod(com.google.protobuf.Duration value) {
      if (rotationPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rotationSchedule_ = value;
        onChanged();
      } else {
        rotationPeriodBuilder_.setMessage(value);
      }
      rotationScheduleCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder setRotationPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (rotationPeriodBuilder_ == null) {
        rotationSchedule_ = builderForValue.build();
        onChanged();
      } else {
        rotationPeriodBuilder_.setMessage(builderForValue.build());
      }
      rotationScheduleCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder mergeRotationPeriod(com.google.protobuf.Duration value) {
      if (rotationPeriodBuilder_ == null) {
        if (rotationScheduleCase_ == 8
            && rotationSchedule_ != com.google.protobuf.Duration.getDefaultInstance()) {
          rotationSchedule_ =
              com.google.protobuf.Duration.newBuilder(
                      (com.google.protobuf.Duration) rotationSchedule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rotationSchedule_ = value;
        }
        onChanged();
      } else {
        if (rotationScheduleCase_ == 8) {
          rotationPeriodBuilder_.mergeFrom(value);
        }
        rotationPeriodBuilder_.setMessage(value);
      }
      rotationScheduleCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public Builder clearRotationPeriod() {
      if (rotationPeriodBuilder_ == null) {
        if (rotationScheduleCase_ == 8) {
          rotationScheduleCase_ = 0;
          rotationSchedule_ = null;
          onChanged();
        }
      } else {
        if (rotationScheduleCase_ == 8) {
          rotationScheduleCase_ = 0;
          rotationSchedule_ = null;
        }
        rotationPeriodBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getRotationPeriodBuilder() {
      return getRotationPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRotationPeriodOrBuilder() {
      if ((rotationScheduleCase_ == 8) && (rotationPeriodBuilder_ != null)) {
        return rotationPeriodBuilder_.getMessageOrBuilder();
      } else {
        if (rotationScheduleCase_ == 8) {
          return (com.google.protobuf.Duration) rotationSchedule_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] will be advanced by this period when the service
     * automatically rotates a key. Must be at least 24 hours and at most
     * 876,000 hours.
     * If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is set, [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time] must also be set.
     * Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
     * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT] support
     * automatic rotation. For other keys, this field must be omitted.
     * </pre>
     *
     * <code>.google.protobuf.Duration rotation_period = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRotationPeriodFieldBuilder() {
      if (rotationPeriodBuilder_ == null) {
        if (!(rotationScheduleCase_ == 8)) {
          rotationSchedule_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        rotationPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) rotationSchedule_,
                getParentForChildren(),
                isClean());
        rotationSchedule_ = null;
      }
      rotationScheduleCase_ = 8;
      onChanged();
      ;
      return rotationPeriodBuilder_;
    }

    private com.google.cloud.kms.v1.CryptoKeyVersionTemplate versionTemplate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder>
        versionTemplateBuilder_;
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     *
     * @return Whether the versionTemplate field is set.
     */
    public boolean hasVersionTemplate() {
      return versionTemplateBuilder_ != null || versionTemplate_ != null;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     *
     * @return The versionTemplate.
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionTemplate getVersionTemplate() {
      if (versionTemplateBuilder_ == null) {
        return versionTemplate_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()
            : versionTemplate_;
      } else {
        return versionTemplateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder setVersionTemplate(com.google.cloud.kms.v1.CryptoKeyVersionTemplate value) {
      if (versionTemplateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionTemplate_ = value;
        onChanged();
      } else {
        versionTemplateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder setVersionTemplate(
        com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder builderForValue) {
      if (versionTemplateBuilder_ == null) {
        versionTemplate_ = builderForValue.build();
        onChanged();
      } else {
        versionTemplateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder mergeVersionTemplate(com.google.cloud.kms.v1.CryptoKeyVersionTemplate value) {
      if (versionTemplateBuilder_ == null) {
        if (versionTemplate_ != null) {
          versionTemplate_ =
              com.google.cloud.kms.v1.CryptoKeyVersionTemplate.newBuilder(versionTemplate_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          versionTemplate_ = value;
        }
        onChanged();
      } else {
        versionTemplateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public Builder clearVersionTemplate() {
      if (versionTemplateBuilder_ == null) {
        versionTemplate_ = null;
        onChanged();
      } else {
        versionTemplate_ = null;
        versionTemplateBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder getVersionTemplateBuilder() {

      onChanged();
      return getVersionTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    public com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder getVersionTemplateOrBuilder() {
      if (versionTemplateBuilder_ != null) {
        return versionTemplateBuilder_.getMessageOrBuilder();
      } else {
        return versionTemplate_ == null
            ? com.google.cloud.kms.v1.CryptoKeyVersionTemplate.getDefaultInstance()
            : versionTemplate_;
      }
    }
    /**
     *
     *
     * <pre>
     * A template describing settings for new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances.
     * The properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances created by either
     * [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
     * auto-rotation are controlled by this template.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersionTemplate version_template = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder,
            com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder>
        getVersionTemplateFieldBuilder() {
      if (versionTemplateBuilder_ == null) {
        versionTemplateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.CryptoKeyVersionTemplate,
                com.google.cloud.kms.v1.CryptoKeyVersionTemplate.Builder,
                com.google.cloud.kms.v1.CryptoKeyVersionTemplateOrBuilder>(
                getVersionTemplate(), getParentForChildren(), isClean());
        versionTemplate_ = null;
      }
      return versionTemplateBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels with user-defined metadata. For more information, see
     * [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private boolean importOnly_;
    /**
     *
     *
     * <pre>
     * Immutable. Whether this key may contain imported versions only.
     * </pre>
     *
     * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The importOnly.
     */
    @java.lang.Override
    public boolean getImportOnly() {
      return importOnly_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Whether this key may contain imported versions only.
     * </pre>
     *
     * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The importOnly to set.
     * @return This builder for chaining.
     */
    public Builder setImportOnly(boolean value) {

      importOnly_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Whether this key may contain imported versions only.
     * </pre>
     *
     * <code>bool import_only = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportOnly() {

      importOnly_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration destroyScheduledDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        destroyScheduledDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the destroyScheduledDuration field is set.
     */
    public boolean hasDestroyScheduledDuration() {
      return destroyScheduledDurationBuilder_ != null || destroyScheduledDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The destroyScheduledDuration.
     */
    public com.google.protobuf.Duration getDestroyScheduledDuration() {
      if (destroyScheduledDurationBuilder_ == null) {
        return destroyScheduledDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : destroyScheduledDuration_;
      } else {
        return destroyScheduledDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDestroyScheduledDuration(com.google.protobuf.Duration value) {
      if (destroyScheduledDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyScheduledDuration_ = value;
        onChanged();
      } else {
        destroyScheduledDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setDestroyScheduledDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (destroyScheduledDurationBuilder_ == null) {
        destroyScheduledDuration_ = builderForValue.build();
        onChanged();
      } else {
        destroyScheduledDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeDestroyScheduledDuration(com.google.protobuf.Duration value) {
      if (destroyScheduledDurationBuilder_ == null) {
        if (destroyScheduledDuration_ != null) {
          destroyScheduledDuration_ =
              com.google.protobuf.Duration.newBuilder(destroyScheduledDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destroyScheduledDuration_ = value;
        }
        onChanged();
      } else {
        destroyScheduledDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearDestroyScheduledDuration() {
      if (destroyScheduledDurationBuilder_ == null) {
        destroyScheduledDuration_ = null;
        onChanged();
      } else {
        destroyScheduledDuration_ = null;
        destroyScheduledDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDestroyScheduledDurationBuilder() {

      onChanged();
      return getDestroyScheduledDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDestroyScheduledDurationOrBuilder() {
      if (destroyScheduledDurationBuilder_ != null) {
        return destroyScheduledDurationBuilder_.getMessageOrBuilder();
      } else {
        return destroyScheduledDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : destroyScheduledDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The period of time that versions of this key spend in the
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
     * state before transitioning to
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED]. If not
     * specified at creation time, the default duration is 24 hours.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration destroy_scheduled_duration = 14 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDestroyScheduledDurationFieldBuilder() {
      if (destroyScheduledDurationBuilder_ == null) {
        destroyScheduledDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDestroyScheduledDuration(), getParentForChildren(), isClean());
        destroyScheduledDuration_ = null;
      }
      return destroyScheduledDurationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.CryptoKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.CryptoKey)
  private static final com.google.cloud.kms.v1.CryptoKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.CryptoKey();
  }

  public static com.google.cloud.kms.v1.CryptoKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CryptoKey> PARSER =
      new com.google.protobuf.AbstractParser<CryptoKey>() {
        @java.lang.Override
        public CryptoKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CryptoKey(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CryptoKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CryptoKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
