/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Response message for [KeyManagementService.MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.MacSignResponse}
 */
public final class MacSignResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.MacSignResponse)
    MacSignResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MacSignResponse.newBuilder() to construct.
  private MacSignResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MacSignResponse() {
    name_ = "";
    mac_ = com.google.protobuf.ByteString.EMPTY;
    protectionLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MacSignResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private MacSignResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              mac_ = input.readBytes();
              break;
            }
          case 26:
            {
              com.google.protobuf.Int64Value.Builder subBuilder = null;
              if (macCrc32C_ != null) {
                subBuilder = macCrc32C_.toBuilder();
              }
              macCrc32C_ =
                  input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(macCrc32C_);
                macCrc32C_ = subBuilder.buildPartial();
              }

              break;
            }
          case 32:
            {
              verifiedDataCrc32C_ = input.readBool();
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              protectionLevel_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_MacSignResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_MacSignResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.MacSignResponse.class,
            com.google.cloud.kms.v1.MacSignResponse.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing. Check
   * this field to verify that the intended resource was used for signing.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing. Check
   * this field to verify that the intended resource was used for signing.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAC_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString mac_;
  /**
   *
   *
   * <pre>
   * The created signature.
   * </pre>
   *
   * <code>bytes mac = 2;</code>
   *
   * @return The mac.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMac() {
    return mac_;
  }

  public static final int MAC_CRC32C_FIELD_NUMBER = 3;
  private com.google.protobuf.Int64Value macCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
   * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
   * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
   * results to this field. Discard the response in case of non-matching
   * checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
   *
   * @return Whether the macCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasMacCrc32C() {
    return macCrc32C_ != null;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
   * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
   * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
   * results to this field. Discard the response in case of non-matching
   * checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
   *
   * @return The macCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getMacCrc32C() {
    return macCrc32C_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : macCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
   * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
   * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
   * results to this field. Discard the response in case of non-matching
   * checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getMacCrc32COrBuilder() {
    return getMacCrc32C();
  }

  public static final int VERIFIED_DATA_CRC32C_FIELD_NUMBER = 4;
  private boolean verifiedDataCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
   * [data][google.cloud.kms.v1.MacSignRequest.data]. A false value of this field
   * indicates either that [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was left
   * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] but this field is still false,
   * discard the response and perform a limited number of retries.
   * </pre>
   *
   * <code>bool verified_data_crc32c = 4;</code>
   *
   * @return The verifiedDataCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedDataCrc32C() {
    return verifiedDataCrc32C_;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 5;
  private int protectionLevel_;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!mac_.isEmpty()) {
      output.writeBytes(2, mac_);
    }
    if (macCrc32C_ != null) {
      output.writeMessage(3, getMacCrc32C());
    }
    if (verifiedDataCrc32C_ != false) {
      output.writeBool(4, verifiedDataCrc32C_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, protectionLevel_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!mac_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, mac_);
    }
    if (macCrc32C_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMacCrc32C());
    }
    if (verifiedDataCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, verifiedDataCrc32C_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, protectionLevel_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.MacSignResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.MacSignResponse other = (com.google.cloud.kms.v1.MacSignResponse) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getMac().equals(other.getMac())) return false;
    if (hasMacCrc32C() != other.hasMacCrc32C()) return false;
    if (hasMacCrc32C()) {
      if (!getMacCrc32C().equals(other.getMacCrc32C())) return false;
    }
    if (getVerifiedDataCrc32C() != other.getVerifiedDataCrc32C()) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + MAC_FIELD_NUMBER;
    hash = (53 * hash) + getMac().hashCode();
    if (hasMacCrc32C()) {
      hash = (37 * hash) + MAC_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getMacCrc32C().hashCode();
    }
    hash = (37 * hash) + VERIFIED_DATA_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedDataCrc32C());
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacSignResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.MacSignResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for [KeyManagementService.MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.MacSignResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.MacSignResponse)
      com.google.cloud.kms.v1.MacSignResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacSignResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacSignResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.MacSignResponse.class,
              com.google.cloud.kms.v1.MacSignResponse.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.MacSignResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      mac_ = com.google.protobuf.ByteString.EMPTY;

      if (macCrc32CBuilder_ == null) {
        macCrc32C_ = null;
      } else {
        macCrc32C_ = null;
        macCrc32CBuilder_ = null;
      }
      verifiedDataCrc32C_ = false;

      protectionLevel_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacSignResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacSignResponse getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.MacSignResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacSignResponse build() {
      com.google.cloud.kms.v1.MacSignResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacSignResponse buildPartial() {
      com.google.cloud.kms.v1.MacSignResponse result =
          new com.google.cloud.kms.v1.MacSignResponse(this);
      result.name_ = name_;
      result.mac_ = mac_;
      if (macCrc32CBuilder_ == null) {
        result.macCrc32C_ = macCrc32C_;
      } else {
        result.macCrc32C_ = macCrc32CBuilder_.build();
      }
      result.verifiedDataCrc32C_ = verifiedDataCrc32C_;
      result.protectionLevel_ = protectionLevel_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.MacSignResponse) {
        return mergeFrom((com.google.cloud.kms.v1.MacSignResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.MacSignResponse other) {
      if (other == com.google.cloud.kms.v1.MacSignResponse.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getMac() != com.google.protobuf.ByteString.EMPTY) {
        setMac(other.getMac());
      }
      if (other.hasMacCrc32C()) {
        mergeMacCrc32C(other.getMacCrc32C());
      }
      if (other.getVerifiedDataCrc32C() != false) {
        setVerifiedDataCrc32C(other.getVerifiedDataCrc32C());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.MacSignResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.MacSignResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing. Check
     * this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing. Check
     * this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing. Check
     * this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing. Check
     * this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing. Check
     * this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString mac_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The created signature.
     * </pre>
     *
     * <code>bytes mac = 2;</code>
     *
     * @return The mac.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMac() {
      return mac_;
    }
    /**
     *
     *
     * <pre>
     * The created signature.
     * </pre>
     *
     * <code>bytes mac = 2;</code>
     *
     * @param value The mac to set.
     * @return This builder for chaining.
     */
    public Builder setMac(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      mac_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The created signature.
     * </pre>
     *
     * <code>bytes mac = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMac() {

      mac_ = getDefaultInstance().getMac();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value macCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        macCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     *
     * @return Whether the macCrc32c field is set.
     */
    public boolean hasMacCrc32C() {
      return macCrc32CBuilder_ != null || macCrc32C_ != null;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     *
     * @return The macCrc32c.
     */
    public com.google.protobuf.Int64Value getMacCrc32C() {
      if (macCrc32CBuilder_ == null) {
        return macCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : macCrc32C_;
      } else {
        return macCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     */
    public Builder setMacCrc32C(com.google.protobuf.Int64Value value) {
      if (macCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        macCrc32C_ = value;
        onChanged();
      } else {
        macCrc32CBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     */
    public Builder setMacCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (macCrc32CBuilder_ == null) {
        macCrc32C_ = builderForValue.build();
        onChanged();
      } else {
        macCrc32CBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     */
    public Builder mergeMacCrc32C(com.google.protobuf.Int64Value value) {
      if (macCrc32CBuilder_ == null) {
        if (macCrc32C_ != null) {
          macCrc32C_ =
              com.google.protobuf.Int64Value.newBuilder(macCrc32C_).mergeFrom(value).buildPartial();
        } else {
          macCrc32C_ = value;
        }
        onChanged();
      } else {
        macCrc32CBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     */
    public Builder clearMacCrc32C() {
      if (macCrc32CBuilder_ == null) {
        macCrc32C_ = null;
        onChanged();
      } else {
        macCrc32C_ = null;
        macCrc32CBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     */
    public com.google.protobuf.Int64Value.Builder getMacCrc32CBuilder() {

      onChanged();
      return getMacCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getMacCrc32COrBuilder() {
      if (macCrc32CBuilder_ != null) {
        return macCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return macCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : macCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac]. An integrity check of
     * [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] can be performed by computing the
     * CRC32C checksum of [MacSignResponse.mac][google.cloud.kms.v1.MacSignResponse.mac] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value mac_crc32c = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getMacCrc32CFieldBuilder() {
      if (macCrc32CBuilder_ == null) {
        macCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getMacCrc32C(), getParentForChildren(), isClean());
        macCrc32C_ = null;
      }
      return macCrc32CBuilder_;
    }

    private boolean verifiedDataCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacSignRequest.data]. A false value of this field
     * indicates either that [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 4;</code>
     *
     * @return The verifiedDataCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedDataCrc32C() {
      return verifiedDataCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacSignRequest.data]. A false value of this field
     * indicates either that [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 4;</code>
     *
     * @param value The verifiedDataCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedDataCrc32C(boolean value) {

      verifiedDataCrc32C_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacSignRequest.data]. A false value of this field
     * indicates either that [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacSignRequest.data_crc32c][google.cloud.kms.v1.MacSignRequest.data_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedDataCrc32C() {

      verifiedDataCrc32C_ = false;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {

      protectionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {

      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.MacSignResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.MacSignResponse)
  private static final com.google.cloud.kms.v1.MacSignResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.MacSignResponse();
  }

  public static com.google.cloud.kms.v1.MacSignResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MacSignResponse> PARSER =
      new com.google.protobuf.AbstractParser<MacSignResponse>() {
        @java.lang.Override
        public MacSignResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new MacSignResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<MacSignResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MacSignResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.MacSignResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
