/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Response message for [KeyManagementService.MacVerify][google.cloud.kms.v1.KeyManagementService.MacVerify].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.MacVerifyResponse}
 */
public final class MacVerifyResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.MacVerifyResponse)
    MacVerifyResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MacVerifyResponse.newBuilder() to construct.
  private MacVerifyResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MacVerifyResponse() {
    name_ = "";
    protectionLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MacVerifyResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private MacVerifyResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 16:
            {
              success_ = input.readBool();
              break;
            }
          case 24:
            {
              verifiedDataCrc32C_ = input.readBool();
              break;
            }
          case 32:
            {
              verifiedMacCrc32C_ = input.readBool();
              break;
            }
          case 40:
            {
              verifiedSuccessIntegrity_ = input.readBool();
              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              protectionLevel_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_MacVerifyResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_MacVerifyResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.MacVerifyResponse.class,
            com.google.cloud.kms.v1.MacVerifyResponse.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
   * Check this field to verify that the intended resource was used for
   * verification.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
   * Check this field to verify that the intended resource was used for
   * verification.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUCCESS_FIELD_NUMBER = 2;
  private boolean success_;
  /**
   *
   *
   * <pre>
   * This field indicates whether or not the verification operation for
   * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] over [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] was successful.
   * </pre>
   *
   * <code>bool success = 2;</code>
   *
   * @return The success.
   */
  @java.lang.Override
  public boolean getSuccess() {
    return success_;
  }

  public static final int VERIFIED_DATA_CRC32C_FIELD_NUMBER = 3;
  private boolean verifiedDataCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
   * [data][google.cloud.kms.v1.MacVerifyRequest.data]. A false value of this field
   * indicates either that [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was left
   * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] but this field is still false,
   * discard the response and perform a limited number of retries.
   * </pre>
   *
   * <code>bool verified_data_crc32c = 3;</code>
   *
   * @return The verifiedDataCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedDataCrc32C() {
    return verifiedDataCrc32C_;
  }

  public static final int VERIFIED_MAC_CRC32C_FIELD_NUMBER = 4;
  private boolean verifiedMacCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
   * [data][google.cloud.kms.v1.MacVerifyRequest.mac]. A false value of this field
   * indicates either that [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was left
   * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] but this field is still false,
   * discard the response and perform a limited number of retries.
   * </pre>
   *
   * <code>bool verified_mac_crc32c = 4;</code>
   *
   * @return The verifiedMacCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedMacCrc32C() {
    return verifiedMacCrc32C_;
  }

  public static final int VERIFIED_SUCCESS_INTEGRITY_FIELD_NUMBER = 5;
  private boolean verifiedSuccessIntegrity_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. This value is used for the integrity
   * verification of [MacVerifyResponse.success]. If the value of this field
   * contradicts the value of [MacVerifyResponse.success], discard the response
   * and perform a limited number of retries.
   * </pre>
   *
   * <code>bool verified_success_integrity = 5;</code>
   *
   * @return The verifiedSuccessIntegrity.
   */
  @java.lang.Override
  public boolean getVerifiedSuccessIntegrity() {
    return verifiedSuccessIntegrity_;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 6;
  private int protectionLevel_;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (success_ != false) {
      output.writeBool(2, success_);
    }
    if (verifiedDataCrc32C_ != false) {
      output.writeBool(3, verifiedDataCrc32C_);
    }
    if (verifiedMacCrc32C_ != false) {
      output.writeBool(4, verifiedMacCrc32C_);
    }
    if (verifiedSuccessIntegrity_ != false) {
      output.writeBool(5, verifiedSuccessIntegrity_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, protectionLevel_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (success_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, success_);
    }
    if (verifiedDataCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, verifiedDataCrc32C_);
    }
    if (verifiedMacCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, verifiedMacCrc32C_);
    }
    if (verifiedSuccessIntegrity_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, verifiedSuccessIntegrity_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, protectionLevel_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.MacVerifyResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.MacVerifyResponse other =
        (com.google.cloud.kms.v1.MacVerifyResponse) obj;

    if (!getName().equals(other.getName())) return false;
    if (getSuccess() != other.getSuccess()) return false;
    if (getVerifiedDataCrc32C() != other.getVerifiedDataCrc32C()) return false;
    if (getVerifiedMacCrc32C() != other.getVerifiedMacCrc32C()) return false;
    if (getVerifiedSuccessIntegrity() != other.getVerifiedSuccessIntegrity()) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SUCCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSuccess());
    hash = (37 * hash) + VERIFIED_DATA_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedDataCrc32C());
    hash = (37 * hash) + VERIFIED_MAC_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedMacCrc32C());
    hash = (37 * hash) + VERIFIED_SUCCESS_INTEGRITY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedSuccessIntegrity());
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.MacVerifyResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for [KeyManagementService.MacVerify][google.cloud.kms.v1.KeyManagementService.MacVerify].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.MacVerifyResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.MacVerifyResponse)
      com.google.cloud.kms.v1.MacVerifyResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacVerifyResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacVerifyResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.MacVerifyResponse.class,
              com.google.cloud.kms.v1.MacVerifyResponse.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.MacVerifyResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      success_ = false;

      verifiedDataCrc32C_ = false;

      verifiedMacCrc32C_ = false;

      verifiedSuccessIntegrity_ = false;

      protectionLevel_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_MacVerifyResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacVerifyResponse getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.MacVerifyResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacVerifyResponse build() {
      com.google.cloud.kms.v1.MacVerifyResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.MacVerifyResponse buildPartial() {
      com.google.cloud.kms.v1.MacVerifyResponse result =
          new com.google.cloud.kms.v1.MacVerifyResponse(this);
      result.name_ = name_;
      result.success_ = success_;
      result.verifiedDataCrc32C_ = verifiedDataCrc32C_;
      result.verifiedMacCrc32C_ = verifiedMacCrc32C_;
      result.verifiedSuccessIntegrity_ = verifiedSuccessIntegrity_;
      result.protectionLevel_ = protectionLevel_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.MacVerifyResponse) {
        return mergeFrom((com.google.cloud.kms.v1.MacVerifyResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.MacVerifyResponse other) {
      if (other == com.google.cloud.kms.v1.MacVerifyResponse.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getSuccess() != false) {
        setSuccess(other.getSuccess());
      }
      if (other.getVerifiedDataCrc32C() != false) {
        setVerifiedDataCrc32C(other.getVerifiedDataCrc32C());
      }
      if (other.getVerifiedMacCrc32C() != false) {
        setVerifiedMacCrc32C(other.getVerifiedMacCrc32C());
      }
      if (other.getVerifiedSuccessIntegrity() != false) {
        setVerifiedSuccessIntegrity(other.getVerifiedSuccessIntegrity());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.MacVerifyResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.MacVerifyResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * Check this field to verify that the intended resource was used for
     * verification.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * Check this field to verify that the intended resource was used for
     * verification.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * Check this field to verify that the intended resource was used for
     * verification.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * Check this field to verify that the intended resource was used for
     * verification.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * Check this field to verify that the intended resource was used for
     * verification.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private boolean success_;
    /**
     *
     *
     * <pre>
     * This field indicates whether or not the verification operation for
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] over [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] was successful.
     * </pre>
     *
     * <code>bool success = 2;</code>
     *
     * @return The success.
     */
    @java.lang.Override
    public boolean getSuccess() {
      return success_;
    }
    /**
     *
     *
     * <pre>
     * This field indicates whether or not the verification operation for
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] over [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] was successful.
     * </pre>
     *
     * <code>bool success = 2;</code>
     *
     * @param value The success to set.
     * @return This builder for chaining.
     */
    public Builder setSuccess(boolean value) {

      success_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field indicates whether or not the verification operation for
     * [MacVerifyRequest.mac][google.cloud.kms.v1.MacVerifyRequest.mac] over [MacVerifyRequest.data][google.cloud.kms.v1.MacVerifyRequest.data] was successful.
     * </pre>
     *
     * <code>bool success = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccess() {

      success_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedDataCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacVerifyRequest.data]. A false value of this field
     * indicates either that [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 3;</code>
     *
     * @return The verifiedDataCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedDataCrc32C() {
      return verifiedDataCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacVerifyRequest.data]. A false value of this field
     * indicates either that [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 3;</code>
     *
     * @param value The verifiedDataCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedDataCrc32C(boolean value) {

      verifiedDataCrc32C_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacVerifyRequest.data]. A false value of this field
     * indicates either that [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacVerifyRequest.data_crc32c][google.cloud.kms.v1.MacVerifyRequest.data_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedDataCrc32C() {

      verifiedDataCrc32C_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedMacCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacVerifyRequest.mac]. A false value of this field
     * indicates either that [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_mac_crc32c = 4;</code>
     *
     * @return The verifiedMacCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedMacCrc32C() {
      return verifiedMacCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacVerifyRequest.mac]. A false value of this field
     * indicates either that [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_mac_crc32c = 4;</code>
     *
     * @param value The verifiedMacCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedMacCrc32C(boolean value) {

      verifiedMacCrc32C_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used for the integrity verification of the
     * [data][google.cloud.kms.v1.MacVerifyRequest.mac]. A false value of this field
     * indicates either that [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] was left
     * unset or that it was not delivered to [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set [MacVerifyRequest.mac_crc32c][google.cloud.kms.v1.MacVerifyRequest.mac_crc32c] but this field is still false,
     * discard the response and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_mac_crc32c = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedMacCrc32C() {

      verifiedMacCrc32C_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedSuccessIntegrity_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. This value is used for the integrity
     * verification of [MacVerifyResponse.success]. If the value of this field
     * contradicts the value of [MacVerifyResponse.success], discard the response
     * and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_success_integrity = 5;</code>
     *
     * @return The verifiedSuccessIntegrity.
     */
    @java.lang.Override
    public boolean getVerifiedSuccessIntegrity() {
      return verifiedSuccessIntegrity_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. This value is used for the integrity
     * verification of [MacVerifyResponse.success]. If the value of this field
     * contradicts the value of [MacVerifyResponse.success], discard the response
     * and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_success_integrity = 5;</code>
     *
     * @param value The verifiedSuccessIntegrity to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedSuccessIntegrity(boolean value) {

      verifiedSuccessIntegrity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. This value is used for the integrity
     * verification of [MacVerifyResponse.success]. If the value of this field
     * contradicts the value of [MacVerifyResponse.success], discard the response
     * and perform a limited number of retries.
     * </pre>
     *
     * <code>bool verified_success_integrity = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedSuccessIntegrity() {

      verifiedSuccessIntegrity_ = false;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {

      protectionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for verification.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {

      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.MacVerifyResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.MacVerifyResponse)
  private static final com.google.cloud.kms.v1.MacVerifyResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.MacVerifyResponse();
  }

  public static com.google.cloud.kms.v1.MacVerifyResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MacVerifyResponse> PARSER =
      new com.google.protobuf.AbstractParser<MacVerifyResponse>() {
        @java.lang.Override
        public MacVerifyResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new MacVerifyResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<MacVerifyResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MacVerifyResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.MacVerifyResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
