/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/ekm_service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * An [EkmConnection][google.cloud.kms.v1.EkmConnection] represents an
 * individual EKM connection. It can be used for creating
 * [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
 * [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] with a
 * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
 * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], as well as
 * performing cryptographic operations using keys created within the
 * [EkmConnection][google.cloud.kms.v1.EkmConnection].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.EkmConnection}
 */
public final class EkmConnection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.EkmConnection)
    EkmConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EkmConnection.newBuilder() to construct.
  private EkmConnection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EkmConnection() {
    name_ = "";
    serviceResolvers_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EkmConnection();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private EkmConnection(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                serviceResolvers_ =
                    new java.util.ArrayList<
                        com.google.cloud.kms.v1.EkmConnection.ServiceResolver>();
                mutable_bitField0_ |= 0x00000001;
              }
              serviceResolvers_.add(
                  input.readMessage(
                      com.google.cloud.kms.v1.EkmConnection.ServiceResolver.parser(),
                      extensionRegistry));
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              etag_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        serviceResolvers_ = java.util.Collections.unmodifiableList(serviceResolvers_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.EkmServiceProto
        .internal_static_google_cloud_kms_v1_EkmConnection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.EkmServiceProto
        .internal_static_google_cloud_kms_v1_EkmConnection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.EkmConnection.class,
            com.google.cloud.kms.v1.EkmConnection.Builder.class);
  }

  public interface ServiceResolverOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.EkmConnection.ServiceResolver)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Service Directory service pointing to
     * an EKM replica, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
     * </pre>
     *
     * <code>
     * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The serviceDirectoryService.
     */
    java.lang.String getServiceDirectoryService();
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Service Directory service pointing to
     * an EKM replica, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
     * </pre>
     *
     * <code>
     * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for serviceDirectoryService.
     */
    com.google.protobuf.ByteString getServiceDirectoryServiceBytes();

    /**
     *
     *
     * <pre>
     * Optional. The filter applied to the endpoints of the resolved service. If
     * no filter is specified, all endpoints will be considered. An endpoint
     * will be chosen arbitrarily from the filtered list for each request.
     * For endpoint filter syntax and examples, see
     * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
     * </pre>
     *
     * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The endpointFilter.
     */
    java.lang.String getEndpointFilter();
    /**
     *
     *
     * <pre>
     * Optional. The filter applied to the endpoints of the resolved service. If
     * no filter is specified, all endpoints will be considered. An endpoint
     * will be chosen arbitrarily from the filtered list for each request.
     * For endpoint filter syntax and examples, see
     * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
     * </pre>
     *
     * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for endpointFilter.
     */
    com.google.protobuf.ByteString getEndpointFilterBytes();

    /**
     *
     *
     * <pre>
     * Required. The hostname of the EKM replica used at TLS and HTTP layers.
     * </pre>
     *
     * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The hostname.
     */
    java.lang.String getHostname();
    /**
     *
     *
     * <pre>
     * Required. The hostname of the EKM replica used at TLS and HTTP layers.
     * </pre>
     *
     * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for hostname.
     */
    com.google.protobuf.ByteString getHostnameBytes();

    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.kms.v1.Certificate> getServerCertificatesList();
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.kms.v1.Certificate getServerCertificates(int index);
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getServerCertificatesCount();
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.kms.v1.CertificateOrBuilder>
        getServerCertificatesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.kms.v1.CertificateOrBuilder getServerCertificatesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver]
   * represents an EKM replica that can be reached within an
   * [EkmConnection][google.cloud.kms.v1.EkmConnection].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.EkmConnection.ServiceResolver}
   */
  public static final class ServiceResolver extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.EkmConnection.ServiceResolver)
      ServiceResolverOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServiceResolver.newBuilder() to construct.
    private ServiceResolver(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServiceResolver() {
      serviceDirectoryService_ = "";
      endpointFilter_ = "";
      hostname_ = "";
      serverCertificates_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServiceResolver();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ServiceResolver(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                serviceDirectoryService_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                endpointFilter_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                hostname_ = s;
                break;
              }
            case 34:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  serverCertificates_ =
                      new java.util.ArrayList<com.google.cloud.kms.v1.Certificate>();
                  mutable_bitField0_ |= 0x00000001;
                }
                serverCertificates_.add(
                    input.readMessage(
                        com.google.cloud.kms.v1.Certificate.parser(), extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          serverCertificates_ = java.util.Collections.unmodifiableList(serverCertificates_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_EkmConnection_ServiceResolver_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_EkmConnection_ServiceResolver_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.EkmConnection.ServiceResolver.class,
              com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder.class);
    }

    public static final int SERVICE_DIRECTORY_SERVICE_FIELD_NUMBER = 1;
    private volatile java.lang.Object serviceDirectoryService_;
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Service Directory service pointing to
     * an EKM replica, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
     * </pre>
     *
     * <code>
     * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The serviceDirectoryService.
     */
    @java.lang.Override
    public java.lang.String getServiceDirectoryService() {
      java.lang.Object ref = serviceDirectoryService_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceDirectoryService_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Service Directory service pointing to
     * an EKM replica, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
     * </pre>
     *
     * <code>
     * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for serviceDirectoryService.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceDirectoryServiceBytes() {
      java.lang.Object ref = serviceDirectoryService_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceDirectoryService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENDPOINT_FILTER_FIELD_NUMBER = 2;
    private volatile java.lang.Object endpointFilter_;
    /**
     *
     *
     * <pre>
     * Optional. The filter applied to the endpoints of the resolved service. If
     * no filter is specified, all endpoints will be considered. An endpoint
     * will be chosen arbitrarily from the filtered list for each request.
     * For endpoint filter syntax and examples, see
     * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
     * </pre>
     *
     * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The endpointFilter.
     */
    @java.lang.Override
    public java.lang.String getEndpointFilter() {
      java.lang.Object ref = endpointFilter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointFilter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The filter applied to the endpoints of the resolved service. If
     * no filter is specified, all endpoints will be considered. An endpoint
     * will be chosen arbitrarily from the filtered list for each request.
     * For endpoint filter syntax and examples, see
     * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
     * </pre>
     *
     * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for endpointFilter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointFilterBytes() {
      java.lang.Object ref = endpointFilter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HOSTNAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object hostname_;
    /**
     *
     *
     * <pre>
     * Required. The hostname of the EKM replica used at TLS and HTTP layers.
     * </pre>
     *
     * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The hostname.
     */
    @java.lang.Override
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostname_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The hostname of the EKM replica used at TLS and HTTP layers.
     * </pre>
     *
     * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for hostname.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVER_CERTIFICATES_FIELD_NUMBER = 4;
    private java.util.List<com.google.cloud.kms.v1.Certificate> serverCertificates_;
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.kms.v1.Certificate> getServerCertificatesList() {
      return serverCertificates_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.kms.v1.CertificateOrBuilder>
        getServerCertificatesOrBuilderList() {
      return serverCertificates_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getServerCertificatesCount() {
      return serverCertificates_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.Certificate getServerCertificates(int index) {
      return serverCertificates_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of leaf server certificates used to authenticate HTTPS
     * connections to the EKM replica.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.CertificateOrBuilder getServerCertificatesOrBuilder(int index) {
      return serverCertificates_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceDirectoryService_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceDirectoryService_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointFilter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, endpointFilter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, hostname_);
      }
      for (int i = 0; i < serverCertificates_.size(); i++) {
        output.writeMessage(4, serverCertificates_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceDirectoryService_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceDirectoryService_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointFilter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, endpointFilter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, hostname_);
      }
      for (int i = 0; i < serverCertificates_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, serverCertificates_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.kms.v1.EkmConnection.ServiceResolver)) {
        return super.equals(obj);
      }
      com.google.cloud.kms.v1.EkmConnection.ServiceResolver other =
          (com.google.cloud.kms.v1.EkmConnection.ServiceResolver) obj;

      if (!getServiceDirectoryService().equals(other.getServiceDirectoryService())) return false;
      if (!getEndpointFilter().equals(other.getEndpointFilter())) return false;
      if (!getHostname().equals(other.getHostname())) return false;
      if (!getServerCertificatesList().equals(other.getServerCertificatesList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_DIRECTORY_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getServiceDirectoryService().hashCode();
      hash = (37 * hash) + ENDPOINT_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointFilter().hashCode();
      hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
      hash = (53 * hash) + getHostname().hashCode();
      if (getServerCertificatesCount() > 0) {
        hash = (37 * hash) + SERVER_CERTIFICATES_FIELD_NUMBER;
        hash = (53 * hash) + getServerCertificatesList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.kms.v1.EkmConnection.ServiceResolver prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver]
     * represents an EKM replica that can be reached within an
     * [EkmConnection][google.cloud.kms.v1.EkmConnection].
     * </pre>
     *
     * Protobuf type {@code google.cloud.kms.v1.EkmConnection.ServiceResolver}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.EkmConnection.ServiceResolver)
        com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.kms.v1.EkmServiceProto
            .internal_static_google_cloud_kms_v1_EkmConnection_ServiceResolver_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.kms.v1.EkmServiceProto
            .internal_static_google_cloud_kms_v1_EkmConnection_ServiceResolver_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.kms.v1.EkmConnection.ServiceResolver.class,
                com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder.class);
      }

      // Construct using com.google.cloud.kms.v1.EkmConnection.ServiceResolver.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getServerCertificatesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        serviceDirectoryService_ = "";

        endpointFilter_ = "";

        hostname_ = "";

        if (serverCertificatesBuilder_ == null) {
          serverCertificates_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          serverCertificatesBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.kms.v1.EkmServiceProto
            .internal_static_google_cloud_kms_v1_EkmConnection_ServiceResolver_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.EkmConnection.ServiceResolver getDefaultInstanceForType() {
        return com.google.cloud.kms.v1.EkmConnection.ServiceResolver.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.EkmConnection.ServiceResolver build() {
        com.google.cloud.kms.v1.EkmConnection.ServiceResolver result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.kms.v1.EkmConnection.ServiceResolver buildPartial() {
        com.google.cloud.kms.v1.EkmConnection.ServiceResolver result =
            new com.google.cloud.kms.v1.EkmConnection.ServiceResolver(this);
        int from_bitField0_ = bitField0_;
        result.serviceDirectoryService_ = serviceDirectoryService_;
        result.endpointFilter_ = endpointFilter_;
        result.hostname_ = hostname_;
        if (serverCertificatesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            serverCertificates_ = java.util.Collections.unmodifiableList(serverCertificates_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.serverCertificates_ = serverCertificates_;
        } else {
          result.serverCertificates_ = serverCertificatesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.kms.v1.EkmConnection.ServiceResolver) {
          return mergeFrom((com.google.cloud.kms.v1.EkmConnection.ServiceResolver) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.kms.v1.EkmConnection.ServiceResolver other) {
        if (other == com.google.cloud.kms.v1.EkmConnection.ServiceResolver.getDefaultInstance())
          return this;
        if (!other.getServiceDirectoryService().isEmpty()) {
          serviceDirectoryService_ = other.serviceDirectoryService_;
          onChanged();
        }
        if (!other.getEndpointFilter().isEmpty()) {
          endpointFilter_ = other.endpointFilter_;
          onChanged();
        }
        if (!other.getHostname().isEmpty()) {
          hostname_ = other.hostname_;
          onChanged();
        }
        if (serverCertificatesBuilder_ == null) {
          if (!other.serverCertificates_.isEmpty()) {
            if (serverCertificates_.isEmpty()) {
              serverCertificates_ = other.serverCertificates_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureServerCertificatesIsMutable();
              serverCertificates_.addAll(other.serverCertificates_);
            }
            onChanged();
          }
        } else {
          if (!other.serverCertificates_.isEmpty()) {
            if (serverCertificatesBuilder_.isEmpty()) {
              serverCertificatesBuilder_.dispose();
              serverCertificatesBuilder_ = null;
              serverCertificates_ = other.serverCertificates_;
              bitField0_ = (bitField0_ & ~0x00000001);
              serverCertificatesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getServerCertificatesFieldBuilder()
                      : null;
            } else {
              serverCertificatesBuilder_.addAllMessages(other.serverCertificates_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.kms.v1.EkmConnection.ServiceResolver parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.kms.v1.EkmConnection.ServiceResolver) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object serviceDirectoryService_ = "";
      /**
       *
       *
       * <pre>
       * Required. The resource name of the Service Directory service pointing to
       * an EKM replica, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
       * </pre>
       *
       * <code>
       * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The serviceDirectoryService.
       */
      public java.lang.String getServiceDirectoryService() {
        java.lang.Object ref = serviceDirectoryService_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceDirectoryService_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the Service Directory service pointing to
       * an EKM replica, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
       * </pre>
       *
       * <code>
       * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for serviceDirectoryService.
       */
      public com.google.protobuf.ByteString getServiceDirectoryServiceBytes() {
        java.lang.Object ref = serviceDirectoryService_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceDirectoryService_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the Service Directory service pointing to
       * an EKM replica, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
       * </pre>
       *
       * <code>
       * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The serviceDirectoryService to set.
       * @return This builder for chaining.
       */
      public Builder setServiceDirectoryService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        serviceDirectoryService_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the Service Directory service pointing to
       * an EKM replica, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
       * </pre>
       *
       * <code>
       * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceDirectoryService() {

        serviceDirectoryService_ = getDefaultInstance().getServiceDirectoryService();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the Service Directory service pointing to
       * an EKM replica, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;`.
       * </pre>
       *
       * <code>
       * string service_directory_service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for serviceDirectoryService to set.
       * @return This builder for chaining.
       */
      public Builder setServiceDirectoryServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        serviceDirectoryService_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object endpointFilter_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The filter applied to the endpoints of the resolved service. If
       * no filter is specified, all endpoints will be considered. An endpoint
       * will be chosen arbitrarily from the filtered list for each request.
       * For endpoint filter syntax and examples, see
       * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
       * </pre>
       *
       * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The endpointFilter.
       */
      public java.lang.String getEndpointFilter() {
        java.lang.Object ref = endpointFilter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpointFilter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter applied to the endpoints of the resolved service. If
       * no filter is specified, all endpoints will be considered. An endpoint
       * will be chosen arbitrarily from the filtered list for each request.
       * For endpoint filter syntax and examples, see
       * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
       * </pre>
       *
       * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for endpointFilter.
       */
      public com.google.protobuf.ByteString getEndpointFilterBytes() {
        java.lang.Object ref = endpointFilter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpointFilter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter applied to the endpoints of the resolved service. If
       * no filter is specified, all endpoints will be considered. An endpoint
       * will be chosen arbitrarily from the filtered list for each request.
       * For endpoint filter syntax and examples, see
       * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
       * </pre>
       *
       * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The endpointFilter to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        endpointFilter_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter applied to the endpoints of the resolved service. If
       * no filter is specified, all endpoints will be considered. An endpoint
       * will be chosen arbitrarily from the filtered list for each request.
       * For endpoint filter syntax and examples, see
       * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
       * </pre>
       *
       * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpointFilter() {

        endpointFilter_ = getDefaultInstance().getEndpointFilter();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The filter applied to the endpoints of the resolved service. If
       * no filter is specified, all endpoints will be considered. An endpoint
       * will be chosen arbitrarily from the filtered list for each request.
       * For endpoint filter syntax and examples, see
       * https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
       * </pre>
       *
       * <code>string endpoint_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for endpointFilter to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        endpointFilter_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object hostname_ = "";
      /**
       *
       *
       * <pre>
       * Required. The hostname of the EKM replica used at TLS and HTTP layers.
       * </pre>
       *
       * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The hostname.
       */
      public java.lang.String getHostname() {
        java.lang.Object ref = hostname_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostname_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The hostname of the EKM replica used at TLS and HTTP layers.
       * </pre>
       *
       * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for hostname.
       */
      public com.google.protobuf.ByteString getHostnameBytes() {
        java.lang.Object ref = hostname_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          hostname_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The hostname of the EKM replica used at TLS and HTTP layers.
       * </pre>
       *
       * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The hostname to set.
       * @return This builder for chaining.
       */
      public Builder setHostname(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        hostname_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The hostname of the EKM replica used at TLS and HTTP layers.
       * </pre>
       *
       * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHostname() {

        hostname_ = getDefaultInstance().getHostname();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The hostname of the EKM replica used at TLS and HTTP layers.
       * </pre>
       *
       * <code>string hostname = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for hostname to set.
       * @return This builder for chaining.
       */
      public Builder setHostnameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        hostname_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.kms.v1.Certificate> serverCertificates_ =
          java.util.Collections.emptyList();

      private void ensureServerCertificatesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          serverCertificates_ =
              new java.util.ArrayList<com.google.cloud.kms.v1.Certificate>(serverCertificates_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.kms.v1.Certificate,
              com.google.cloud.kms.v1.Certificate.Builder,
              com.google.cloud.kms.v1.CertificateOrBuilder>
          serverCertificatesBuilder_;

      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.kms.v1.Certificate> getServerCertificatesList() {
        if (serverCertificatesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(serverCertificates_);
        } else {
          return serverCertificatesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getServerCertificatesCount() {
        if (serverCertificatesBuilder_ == null) {
          return serverCertificates_.size();
        } else {
          return serverCertificatesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.kms.v1.Certificate getServerCertificates(int index) {
        if (serverCertificatesBuilder_ == null) {
          return serverCertificates_.get(index);
        } else {
          return serverCertificatesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setServerCertificates(int index, com.google.cloud.kms.v1.Certificate value) {
        if (serverCertificatesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureServerCertificatesIsMutable();
          serverCertificates_.set(index, value);
          onChanged();
        } else {
          serverCertificatesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setServerCertificates(
          int index, com.google.cloud.kms.v1.Certificate.Builder builderForValue) {
        if (serverCertificatesBuilder_ == null) {
          ensureServerCertificatesIsMutable();
          serverCertificates_.set(index, builderForValue.build());
          onChanged();
        } else {
          serverCertificatesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addServerCertificates(com.google.cloud.kms.v1.Certificate value) {
        if (serverCertificatesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureServerCertificatesIsMutable();
          serverCertificates_.add(value);
          onChanged();
        } else {
          serverCertificatesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addServerCertificates(int index, com.google.cloud.kms.v1.Certificate value) {
        if (serverCertificatesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureServerCertificatesIsMutable();
          serverCertificates_.add(index, value);
          onChanged();
        } else {
          serverCertificatesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addServerCertificates(
          com.google.cloud.kms.v1.Certificate.Builder builderForValue) {
        if (serverCertificatesBuilder_ == null) {
          ensureServerCertificatesIsMutable();
          serverCertificates_.add(builderForValue.build());
          onChanged();
        } else {
          serverCertificatesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addServerCertificates(
          int index, com.google.cloud.kms.v1.Certificate.Builder builderForValue) {
        if (serverCertificatesBuilder_ == null) {
          ensureServerCertificatesIsMutable();
          serverCertificates_.add(index, builderForValue.build());
          onChanged();
        } else {
          serverCertificatesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllServerCertificates(
          java.lang.Iterable<? extends com.google.cloud.kms.v1.Certificate> values) {
        if (serverCertificatesBuilder_ == null) {
          ensureServerCertificatesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serverCertificates_);
          onChanged();
        } else {
          serverCertificatesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearServerCertificates() {
        if (serverCertificatesBuilder_ == null) {
          serverCertificates_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          serverCertificatesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeServerCertificates(int index) {
        if (serverCertificatesBuilder_ == null) {
          ensureServerCertificatesIsMutable();
          serverCertificates_.remove(index);
          onChanged();
        } else {
          serverCertificatesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.kms.v1.Certificate.Builder getServerCertificatesBuilder(int index) {
        return getServerCertificatesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.kms.v1.CertificateOrBuilder getServerCertificatesOrBuilder(
          int index) {
        if (serverCertificatesBuilder_ == null) {
          return serverCertificates_.get(index);
        } else {
          return serverCertificatesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.kms.v1.CertificateOrBuilder>
          getServerCertificatesOrBuilderList() {
        if (serverCertificatesBuilder_ != null) {
          return serverCertificatesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(serverCertificates_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.kms.v1.Certificate.Builder addServerCertificatesBuilder() {
        return getServerCertificatesFieldBuilder()
            .addBuilder(com.google.cloud.kms.v1.Certificate.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.kms.v1.Certificate.Builder addServerCertificatesBuilder(int index) {
        return getServerCertificatesFieldBuilder()
            .addBuilder(index, com.google.cloud.kms.v1.Certificate.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of leaf server certificates used to authenticate HTTPS
       * connections to the EKM replica.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.kms.v1.Certificate server_certificates = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.kms.v1.Certificate.Builder>
          getServerCertificatesBuilderList() {
        return getServerCertificatesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.kms.v1.Certificate,
              com.google.cloud.kms.v1.Certificate.Builder,
              com.google.cloud.kms.v1.CertificateOrBuilder>
          getServerCertificatesFieldBuilder() {
        if (serverCertificatesBuilder_ == null) {
          serverCertificatesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.kms.v1.Certificate,
                  com.google.cloud.kms.v1.Certificate.Builder,
                  com.google.cloud.kms.v1.CertificateOrBuilder>(
                  serverCertificates_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          serverCertificates_ = null;
        }
        return serverCertificatesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.EkmConnection.ServiceResolver)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.EkmConnection.ServiceResolver)
    private static final com.google.cloud.kms.v1.EkmConnection.ServiceResolver DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.kms.v1.EkmConnection.ServiceResolver();
    }

    public static com.google.cloud.kms.v1.EkmConnection.ServiceResolver getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServiceResolver> PARSER =
        new com.google.protobuf.AbstractParser<ServiceResolver>() {
          @java.lang.Override
          public ServiceResolver parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ServiceResolver(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ServiceResolver> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServiceResolver> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EkmConnection.ServiceResolver getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the
   * [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the
   * [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int SERVICE_RESOLVERS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.kms.v1.EkmConnection.ServiceResolver> serviceResolvers_;
  /**
   *
   *
   * <pre>
   * A list of
   * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
   * the EKM can be reached. There should be one ServiceResolver per EKM
   * replica. Currently, only a single
   * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
   * supported.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.kms.v1.EkmConnection.ServiceResolver>
      getServiceResolversList() {
    return serviceResolvers_;
  }
  /**
   *
   *
   * <pre>
   * A list of
   * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
   * the EKM can be reached. There should be one ServiceResolver per EKM
   * replica. Currently, only a single
   * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
   * supported.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder>
      getServiceResolversOrBuilderList() {
    return serviceResolvers_;
  }
  /**
   *
   *
   * <pre>
   * A list of
   * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
   * the EKM can be reached. There should be one ServiceResolver per EKM
   * replica. Currently, only a single
   * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
   * supported.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;</code>
   */
  @java.lang.Override
  public int getServiceResolversCount() {
    return serviceResolvers_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of
   * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
   * the EKM can be reached. There should be one ServiceResolver per EKM
   * replica. Currently, only a single
   * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
   * supported.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.EkmConnection.ServiceResolver getServiceResolvers(int index) {
    return serviceResolvers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of
   * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
   * the EKM can be reached. There should be one ServiceResolver per EKM
   * replica. Currently, only a single
   * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
   * supported.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder
      getServiceResolversOrBuilder(int index) {
    return serviceResolvers_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 5;
  private volatile java.lang.Object etag_;
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other fields,
   * and may be sent on update requests to ensure the client has an up-to-date
   * value before proceeding.
   * </pre>
   *
   * <code>string etag = 5;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other fields,
   * and may be sent on update requests to ensure the client has an up-to-date
   * value before proceeding.
   * </pre>
   *
   * <code>string etag = 5;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    for (int i = 0; i < serviceResolvers_.size(); i++) {
      output.writeMessage(3, serviceResolvers_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, etag_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    for (int i = 0; i < serviceResolvers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, serviceResolvers_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, etag_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.EkmConnection)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.EkmConnection other = (com.google.cloud.kms.v1.EkmConnection) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getServiceResolversList().equals(other.getServiceResolversList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getServiceResolversCount() > 0) {
      hash = (37 * hash) + SERVICE_RESOLVERS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceResolversList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EkmConnection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.EkmConnection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An [EkmConnection][google.cloud.kms.v1.EkmConnection] represents an
   * individual EKM connection. It can be used for creating
   * [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
   * [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] with a
   * [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
   * [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], as well as
   * performing cryptographic operations using keys created within the
   * [EkmConnection][google.cloud.kms.v1.EkmConnection].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.EkmConnection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.EkmConnection)
      com.google.cloud.kms.v1.EkmConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_EkmConnection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_EkmConnection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.EkmConnection.class,
              com.google.cloud.kms.v1.EkmConnection.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.EkmConnection.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getServiceResolversFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (serviceResolversBuilder_ == null) {
        serviceResolvers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        serviceResolversBuilder_.clear();
      }
      etag_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.EkmServiceProto
          .internal_static_google_cloud_kms_v1_EkmConnection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EkmConnection getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.EkmConnection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EkmConnection build() {
      com.google.cloud.kms.v1.EkmConnection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EkmConnection buildPartial() {
      com.google.cloud.kms.v1.EkmConnection result =
          new com.google.cloud.kms.v1.EkmConnection(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (serviceResolversBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          serviceResolvers_ = java.util.Collections.unmodifiableList(serviceResolvers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.serviceResolvers_ = serviceResolvers_;
      } else {
        result.serviceResolvers_ = serviceResolversBuilder_.build();
      }
      result.etag_ = etag_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.EkmConnection) {
        return mergeFrom((com.google.cloud.kms.v1.EkmConnection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.EkmConnection other) {
      if (other == com.google.cloud.kms.v1.EkmConnection.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (serviceResolversBuilder_ == null) {
        if (!other.serviceResolvers_.isEmpty()) {
          if (serviceResolvers_.isEmpty()) {
            serviceResolvers_ = other.serviceResolvers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureServiceResolversIsMutable();
            serviceResolvers_.addAll(other.serviceResolvers_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceResolvers_.isEmpty()) {
          if (serviceResolversBuilder_.isEmpty()) {
            serviceResolversBuilder_.dispose();
            serviceResolversBuilder_ = null;
            serviceResolvers_ = other.serviceResolvers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            serviceResolversBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceResolversFieldBuilder()
                    : null;
          } else {
            serviceResolversBuilder_.addAllMessages(other.serviceResolvers_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.EkmConnection parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.EkmConnection) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;ekmConnections/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [EkmConnection][google.cloud.kms.v1.EkmConnection] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.util.List<com.google.cloud.kms.v1.EkmConnection.ServiceResolver>
        serviceResolvers_ = java.util.Collections.emptyList();

    private void ensureServiceResolversIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        serviceResolvers_ =
            new java.util.ArrayList<com.google.cloud.kms.v1.EkmConnection.ServiceResolver>(
                serviceResolvers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.kms.v1.EkmConnection.ServiceResolver,
            com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder,
            com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder>
        serviceResolversBuilder_;

    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.kms.v1.EkmConnection.ServiceResolver>
        getServiceResolversList() {
      if (serviceResolversBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceResolvers_);
      } else {
        return serviceResolversBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public int getServiceResolversCount() {
      if (serviceResolversBuilder_ == null) {
        return serviceResolvers_.size();
      } else {
        return serviceResolversBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public com.google.cloud.kms.v1.EkmConnection.ServiceResolver getServiceResolvers(int index) {
      if (serviceResolversBuilder_ == null) {
        return serviceResolvers_.get(index);
      } else {
        return serviceResolversBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder setServiceResolvers(
        int index, com.google.cloud.kms.v1.EkmConnection.ServiceResolver value) {
      if (serviceResolversBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceResolversIsMutable();
        serviceResolvers_.set(index, value);
        onChanged();
      } else {
        serviceResolversBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder setServiceResolvers(
        int index, com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder builderForValue) {
      if (serviceResolversBuilder_ == null) {
        ensureServiceResolversIsMutable();
        serviceResolvers_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceResolversBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder addServiceResolvers(
        com.google.cloud.kms.v1.EkmConnection.ServiceResolver value) {
      if (serviceResolversBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceResolversIsMutable();
        serviceResolvers_.add(value);
        onChanged();
      } else {
        serviceResolversBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder addServiceResolvers(
        int index, com.google.cloud.kms.v1.EkmConnection.ServiceResolver value) {
      if (serviceResolversBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceResolversIsMutable();
        serviceResolvers_.add(index, value);
        onChanged();
      } else {
        serviceResolversBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder addServiceResolvers(
        com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder builderForValue) {
      if (serviceResolversBuilder_ == null) {
        ensureServiceResolversIsMutable();
        serviceResolvers_.add(builderForValue.build());
        onChanged();
      } else {
        serviceResolversBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder addServiceResolvers(
        int index, com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder builderForValue) {
      if (serviceResolversBuilder_ == null) {
        ensureServiceResolversIsMutable();
        serviceResolvers_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceResolversBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder addAllServiceResolvers(
        java.lang.Iterable<? extends com.google.cloud.kms.v1.EkmConnection.ServiceResolver>
            values) {
      if (serviceResolversBuilder_ == null) {
        ensureServiceResolversIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceResolvers_);
        onChanged();
      } else {
        serviceResolversBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder clearServiceResolvers() {
      if (serviceResolversBuilder_ == null) {
        serviceResolvers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        serviceResolversBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public Builder removeServiceResolvers(int index) {
      if (serviceResolversBuilder_ == null) {
        ensureServiceResolversIsMutable();
        serviceResolvers_.remove(index);
        onChanged();
      } else {
        serviceResolversBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder getServiceResolversBuilder(
        int index) {
      return getServiceResolversFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder
        getServiceResolversOrBuilder(int index) {
      if (serviceResolversBuilder_ == null) {
        return serviceResolvers_.get(index);
      } else {
        return serviceResolversBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder>
        getServiceResolversOrBuilderList() {
      if (serviceResolversBuilder_ != null) {
        return serviceResolversBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceResolvers_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder
        addServiceResolversBuilder() {
      return getServiceResolversFieldBuilder()
          .addBuilder(com.google.cloud.kms.v1.EkmConnection.ServiceResolver.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder addServiceResolversBuilder(
        int index) {
      return getServiceResolversFieldBuilder()
          .addBuilder(
              index, com.google.cloud.kms.v1.EkmConnection.ServiceResolver.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of
     * [ServiceResolvers][google.cloud.kms.v1.EkmConnection.ServiceResolver] where
     * the EKM can be reached. There should be one ServiceResolver per EKM
     * replica. Currently, only a single
     * [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver] is
     * supported.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.EkmConnection.ServiceResolver service_resolvers = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder>
        getServiceResolversBuilderList() {
      return getServiceResolversFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.kms.v1.EkmConnection.ServiceResolver,
            com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder,
            com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder>
        getServiceResolversFieldBuilder() {
      if (serviceResolversBuilder_ == null) {
        serviceResolversBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.kms.v1.EkmConnection.ServiceResolver,
                com.google.cloud.kms.v1.EkmConnection.ServiceResolver.Builder,
                com.google.cloud.kms.v1.EkmConnection.ServiceResolverOrBuilder>(
                serviceResolvers_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        serviceResolvers_ = null;
      }
      return serviceResolversBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other fields,
     * and may be sent on update requests to ensure the client has an up-to-date
     * value before proceeding.
     * </pre>
     *
     * <code>string etag = 5;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other fields,
     * and may be sent on update requests to ensure the client has an up-to-date
     * value before proceeding.
     * </pre>
     *
     * <code>string etag = 5;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other fields,
     * and may be sent on update requests to ensure the client has an up-to-date
     * value before proceeding.
     * </pre>
     *
     * <code>string etag = 5;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      etag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other fields,
     * and may be sent on update requests to ensure the client has an up-to-date
     * value before proceeding.
     * </pre>
     *
     * <code>string etag = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {

      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other fields,
     * and may be sent on update requests to ensure the client has an up-to-date
     * value before proceeding.
     * </pre>
     *
     * <code>string etag = 5;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      etag_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.EkmConnection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.EkmConnection)
  private static final com.google.cloud.kms.v1.EkmConnection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.EkmConnection();
  }

  public static com.google.cloud.kms.v1.EkmConnection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EkmConnection> PARSER =
      new com.google.protobuf.AbstractParser<EkmConnection>() {
        @java.lang.Override
        public EkmConnection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new EkmConnection(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<EkmConnection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EkmConnection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.EkmConnection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
