/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.EncryptResponse}
 */
public final class EncryptResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.EncryptResponse)
    EncryptResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EncryptResponse.newBuilder() to construct.
  private EncryptResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EncryptResponse() {
    name_ = "";
    ciphertext_ = com.google.protobuf.ByteString.EMPTY;
    protectionLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EncryptResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private EncryptResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              ciphertext_ = input.readBytes();
              break;
            }
          case 34:
            {
              com.google.protobuf.Int64Value.Builder subBuilder = null;
              if (ciphertextCrc32C_ != null) {
                subBuilder = ciphertextCrc32C_.toBuilder();
              }
              ciphertextCrc32C_ =
                  input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ciphertextCrc32C_);
                ciphertextCrc32C_ = subBuilder.buildPartial();
              }

              break;
            }
          case 40:
            {
              verifiedPlaintextCrc32C_ = input.readBool();
              break;
            }
          case 48:
            {
              verifiedAdditionalAuthenticatedDataCrc32C_ = input.readBool();
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              protectionLevel_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_EncryptResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_EncryptResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.EncryptResponse.class,
            com.google.cloud.kms.v1.EncryptResponse.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption. Check this field to verify that the intended resource was used
   * for encryption.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption. Check this field to verify that the intended resource was used
   * for encryption.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CIPHERTEXT_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString ciphertext_;
  /**
   *
   *
   * <pre>
   * The encrypted data.
   * </pre>
   *
   * <code>bytes ciphertext = 2;</code>
   *
   * @return The ciphertext.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCiphertext() {
    return ciphertext_;
  }

  public static final int CIPHERTEXT_CRC32C_FIELD_NUMBER = 4;
  private com.google.protobuf.Int64Value ciphertextCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
   * An integrity check of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * can be performed by computing the CRC32C checksum of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   *
   * @return Whether the ciphertextCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasCiphertextCrc32C() {
    return ciphertextCrc32C_ != null;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
   * An integrity check of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * can be performed by computing the CRC32C checksum of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   *
   * @return The ciphertextCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getCiphertextCrc32C() {
    return ciphertextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : ciphertextCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
   * An integrity check of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * can be performed by computing the CRC32C checksum of
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
    return getCiphertextCrc32C();
  }

  public static final int VERIFIED_PLAINTEXT_CRC32C_FIELD_NUMBER = 5;
  private boolean verifiedPlaintextCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the
   * [plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]. A false value of
   * this field indicates either that
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_plaintext_crc32c = 5;</code>
   *
   * @return The verifiedPlaintextCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedPlaintextCrc32C() {
    return verifiedPlaintextCrc32C_;
  }

  public static final int VERIFIED_ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER = 6;
  private boolean verifiedAdditionalAuthenticatedDataCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the
   * [AAD][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]. A
   * false value of this field indicates either that
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_additional_authenticated_data_crc32c = 6;</code>
   *
   * @return The verifiedAdditionalAuthenticatedDataCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedAdditionalAuthenticatedDataCrc32C() {
    return verifiedAdditionalAuthenticatedDataCrc32C_;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 7;
  private int protectionLevel_;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * encryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!ciphertext_.isEmpty()) {
      output.writeBytes(2, ciphertext_);
    }
    if (ciphertextCrc32C_ != null) {
      output.writeMessage(4, getCiphertextCrc32C());
    }
    if (verifiedPlaintextCrc32C_ != false) {
      output.writeBool(5, verifiedPlaintextCrc32C_);
    }
    if (verifiedAdditionalAuthenticatedDataCrc32C_ != false) {
      output.writeBool(6, verifiedAdditionalAuthenticatedDataCrc32C_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, protectionLevel_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!ciphertext_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, ciphertext_);
    }
    if (ciphertextCrc32C_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCiphertextCrc32C());
    }
    if (verifiedPlaintextCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, verifiedPlaintextCrc32C_);
    }
    if (verifiedAdditionalAuthenticatedDataCrc32C_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              6, verifiedAdditionalAuthenticatedDataCrc32C_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, protectionLevel_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.EncryptResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.EncryptResponse other = (com.google.cloud.kms.v1.EncryptResponse) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCiphertext().equals(other.getCiphertext())) return false;
    if (hasCiphertextCrc32C() != other.hasCiphertextCrc32C()) return false;
    if (hasCiphertextCrc32C()) {
      if (!getCiphertextCrc32C().equals(other.getCiphertextCrc32C())) return false;
    }
    if (getVerifiedPlaintextCrc32C() != other.getVerifiedPlaintextCrc32C()) return false;
    if (getVerifiedAdditionalAuthenticatedDataCrc32C()
        != other.getVerifiedAdditionalAuthenticatedDataCrc32C()) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CIPHERTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getCiphertext().hashCode();
    if (hasCiphertextCrc32C()) {
      hash = (37 * hash) + CIPHERTEXT_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getCiphertextCrc32C().hashCode();
    }
    hash = (37 * hash) + VERIFIED_PLAINTEXT_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedPlaintextCrc32C());
    hash = (37 * hash) + VERIFIED_ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(
                getVerifiedAdditionalAuthenticatedDataCrc32C());
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.EncryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.EncryptResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.EncryptResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.EncryptResponse)
      com.google.cloud.kms.v1.EncryptResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_EncryptResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_EncryptResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.EncryptResponse.class,
              com.google.cloud.kms.v1.EncryptResponse.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.EncryptResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      ciphertext_ = com.google.protobuf.ByteString.EMPTY;

      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = null;
      } else {
        ciphertextCrc32C_ = null;
        ciphertextCrc32CBuilder_ = null;
      }
      verifiedPlaintextCrc32C_ = false;

      verifiedAdditionalAuthenticatedDataCrc32C_ = false;

      protectionLevel_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_EncryptResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EncryptResponse getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.EncryptResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EncryptResponse build() {
      com.google.cloud.kms.v1.EncryptResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.EncryptResponse buildPartial() {
      com.google.cloud.kms.v1.EncryptResponse result =
          new com.google.cloud.kms.v1.EncryptResponse(this);
      result.name_ = name_;
      result.ciphertext_ = ciphertext_;
      if (ciphertextCrc32CBuilder_ == null) {
        result.ciphertextCrc32C_ = ciphertextCrc32C_;
      } else {
        result.ciphertextCrc32C_ = ciphertextCrc32CBuilder_.build();
      }
      result.verifiedPlaintextCrc32C_ = verifiedPlaintextCrc32C_;
      result.verifiedAdditionalAuthenticatedDataCrc32C_ =
          verifiedAdditionalAuthenticatedDataCrc32C_;
      result.protectionLevel_ = protectionLevel_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.EncryptResponse) {
        return mergeFrom((com.google.cloud.kms.v1.EncryptResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.EncryptResponse other) {
      if (other == com.google.cloud.kms.v1.EncryptResponse.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getCiphertext() != com.google.protobuf.ByteString.EMPTY) {
        setCiphertext(other.getCiphertext());
      }
      if (other.hasCiphertextCrc32C()) {
        mergeCiphertextCrc32C(other.getCiphertextCrc32C());
      }
      if (other.getVerifiedPlaintextCrc32C() != false) {
        setVerifiedPlaintextCrc32C(other.getVerifiedPlaintextCrc32C());
      }
      if (other.getVerifiedAdditionalAuthenticatedDataCrc32C() != false) {
        setVerifiedAdditionalAuthenticatedDataCrc32C(
            other.getVerifiedAdditionalAuthenticatedDataCrc32C());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.EncryptResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.EncryptResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption. Check this field to verify that the intended resource was used
     * for encryption.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString ciphertext_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The encrypted data.
     * </pre>
     *
     * <code>bytes ciphertext = 2;</code>
     *
     * @return The ciphertext.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCiphertext() {
      return ciphertext_;
    }
    /**
     *
     *
     * <pre>
     * The encrypted data.
     * </pre>
     *
     * <code>bytes ciphertext = 2;</code>
     *
     * @param value The ciphertext to set.
     * @return This builder for chaining.
     */
    public Builder setCiphertext(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      ciphertext_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encrypted data.
     * </pre>
     *
     * <code>bytes ciphertext = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCiphertext() {

      ciphertext_ = getDefaultInstance().getCiphertext();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value ciphertextCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        ciphertextCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     *
     * @return Whether the ciphertextCrc32c field is set.
     */
    public boolean hasCiphertextCrc32C() {
      return ciphertextCrc32CBuilder_ != null || ciphertextCrc32C_ != null;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     *
     * @return The ciphertextCrc32c.
     */
    public com.google.protobuf.Int64Value getCiphertextCrc32C() {
      if (ciphertextCrc32CBuilder_ == null) {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      } else {
        return ciphertextCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ciphertextCrc32C_ = value;
        onChanged();
      } else {
        ciphertextCrc32CBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = builderForValue.build();
        onChanged();
      } else {
        ciphertextCrc32CBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder mergeCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (ciphertextCrc32C_ != null) {
          ciphertextCrc32C_ =
              com.google.protobuf.Int64Value.newBuilder(ciphertextCrc32C_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ciphertextCrc32C_ = value;
        }
        onChanged();
      } else {
        ciphertextCrc32CBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public Builder clearCiphertextCrc32C() {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = null;
        onChanged();
      } else {
        ciphertextCrc32C_ = null;
        ciphertextCrc32CBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public com.google.protobuf.Int64Value.Builder getCiphertextCrc32CBuilder() {

      onChanged();
      return getCiphertextCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
      if (ciphertextCrc32CBuilder_ != null) {
        return ciphertextCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * An integrity check of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * can be performed by computing the CRC32C checksum of
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value ciphertext_crc32c = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getCiphertextCrc32CFieldBuilder() {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getCiphertextCrc32C(), getParentForChildren(), isClean());
        ciphertextCrc32C_ = null;
      }
      return ciphertextCrc32CBuilder_;
    }

    private boolean verifiedPlaintextCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]. A false value of
     * this field indicates either that
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_plaintext_crc32c = 5;</code>
     *
     * @return The verifiedPlaintextCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedPlaintextCrc32C() {
      return verifiedPlaintextCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]. A false value of
     * this field indicates either that
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_plaintext_crc32c = 5;</code>
     *
     * @param value The verifiedPlaintextCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedPlaintextCrc32C(boolean value) {

      verifiedPlaintextCrc32C_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [plaintext][google.cloud.kms.v1.EncryptRequest.plaintext]. A false value of
     * this field indicates either that
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [EncryptRequest.plaintext_crc32c][google.cloud.kms.v1.EncryptRequest.plaintext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_plaintext_crc32c = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedPlaintextCrc32C() {

      verifiedPlaintextCrc32C_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedAdditionalAuthenticatedDataCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [AAD][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]. A
     * false value of this field indicates either that
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 6;</code>
     *
     * @return The verifiedAdditionalAuthenticatedDataCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedAdditionalAuthenticatedDataCrc32C() {
      return verifiedAdditionalAuthenticatedDataCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [AAD][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]. A
     * false value of this field indicates either that
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 6;</code>
     *
     * @param value The verifiedAdditionalAuthenticatedDataCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedAdditionalAuthenticatedDataCrc32C(boolean value) {

      verifiedAdditionalAuthenticatedDataCrc32C_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [AAD][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data]. A
     * false value of this field indicates either that
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [EncryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedAdditionalAuthenticatedDataCrc32C() {

      verifiedAdditionalAuthenticatedDataCrc32C_ = false;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {

      protectionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * encryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {

      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.EncryptResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.EncryptResponse)
  private static final com.google.cloud.kms.v1.EncryptResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.EncryptResponse();
  }

  public static com.google.cloud.kms.v1.EncryptResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EncryptResponse> PARSER =
      new com.google.protobuf.AbstractParser<EncryptResponse>() {
        @java.lang.Override
        public EncryptResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new EncryptResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<EncryptResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EncryptResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.EncryptResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
