/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.AsymmetricSignResponse}
 */
public final class AsymmetricSignResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.AsymmetricSignResponse)
    AsymmetricSignResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AsymmetricSignResponse.newBuilder() to construct.
  private AsymmetricSignResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AsymmetricSignResponse() {
    signature_ = com.google.protobuf.ByteString.EMPTY;
    name_ = "";
    protectionLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AsymmetricSignResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_AsymmetricSignResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_AsymmetricSignResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.AsymmetricSignResponse.class,
            com.google.cloud.kms.v1.AsymmetricSignResponse.Builder.class);
  }

  public static final int SIGNATURE_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString signature_;
  /**
   *
   *
   * <pre>
   * The created signature.
   * </pre>
   *
   * <code>bytes signature = 1;</code>
   *
   * @return The signature.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSignature() {
    return signature_;
  }

  public static final int SIGNATURE_CRC32C_FIELD_NUMBER = 2;
  private com.google.protobuf.Int64Value signatureCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
   * An integrity check of
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
   * can be performed by computing the CRC32C checksum of
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
   *
   * @return Whether the signatureCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasSignatureCrc32C() {
    return signatureCrc32C_ != null;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
   * An integrity check of
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
   * can be performed by computing the CRC32C checksum of
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
   *
   * @return The signatureCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getSignatureCrc32C() {
    return signatureCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : signatureCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
   * An integrity check of
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
   * can be performed by computing the CRC32C checksum of
   * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
   * and comparing your results to this field. Discard the response in case of
   * non-matching checksum values, and perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getSignatureCrc32COrBuilder() {
    return getSignatureCrc32C();
  }

  public static final int VERIFIED_DIGEST_CRC32C_FIELD_NUMBER = 3;
  private boolean verifiedDigestCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the
   * [digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. A false value
   * of this field indicates either that
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_digest_crc32c = 3;</code>
   *
   * @return The verifiedDigestCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedDigestCrc32C() {
    return verifiedDigestCrc32C_;
  }

  public static final int NAME_FIELD_NUMBER = 4;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
   * Check this field to verify that the intended resource was used for signing.
   * </pre>
   *
   * <code>string name = 4;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
   * Check this field to verify that the intended resource was used for signing.
   * </pre>
   *
   * <code>string name = 4;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERIFIED_DATA_CRC32C_FIELD_NUMBER = 5;
  private boolean verifiedDataCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the
   * [data][google.cloud.kms.v1.AsymmetricSignRequest.data]. A false value of
   * this field indicates either that
   * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_data_crc32c = 5;</code>
   *
   * @return The verifiedDataCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedDataCrc32C() {
    return verifiedDataCrc32C_;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 6;
  private int protectionLevel_;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!signature_.isEmpty()) {
      output.writeBytes(1, signature_);
    }
    if (signatureCrc32C_ != null) {
      output.writeMessage(2, getSignatureCrc32C());
    }
    if (verifiedDigestCrc32C_ != false) {
      output.writeBool(3, verifiedDigestCrc32C_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, name_);
    }
    if (verifiedDataCrc32C_ != false) {
      output.writeBool(5, verifiedDataCrc32C_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, protectionLevel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!signature_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, signature_);
    }
    if (signatureCrc32C_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSignatureCrc32C());
    }
    if (verifiedDigestCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, verifiedDigestCrc32C_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, name_);
    }
    if (verifiedDataCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, verifiedDataCrc32C_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, protectionLevel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.AsymmetricSignResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.AsymmetricSignResponse other =
        (com.google.cloud.kms.v1.AsymmetricSignResponse) obj;

    if (!getSignature().equals(other.getSignature())) return false;
    if (hasSignatureCrc32C() != other.hasSignatureCrc32C()) return false;
    if (hasSignatureCrc32C()) {
      if (!getSignatureCrc32C().equals(other.getSignatureCrc32C())) return false;
    }
    if (getVerifiedDigestCrc32C() != other.getVerifiedDigestCrc32C()) return false;
    if (!getName().equals(other.getName())) return false;
    if (getVerifiedDataCrc32C() != other.getVerifiedDataCrc32C()) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SIGNATURE_FIELD_NUMBER;
    hash = (53 * hash) + getSignature().hashCode();
    if (hasSignatureCrc32C()) {
      hash = (37 * hash) + SIGNATURE_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getSignatureCrc32C().hashCode();
    }
    hash = (37 * hash) + VERIFIED_DIGEST_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedDigestCrc32C());
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + VERIFIED_DATA_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedDataCrc32C());
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.AsymmetricSignResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.AsymmetricSignResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.AsymmetricSignResponse)
      com.google.cloud.kms.v1.AsymmetricSignResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricSignResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricSignResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.AsymmetricSignResponse.class,
              com.google.cloud.kms.v1.AsymmetricSignResponse.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.AsymmetricSignResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      signature_ = com.google.protobuf.ByteString.EMPTY;

      if (signatureCrc32CBuilder_ == null) {
        signatureCrc32C_ = null;
      } else {
        signatureCrc32C_ = null;
        signatureCrc32CBuilder_ = null;
      }
      verifiedDigestCrc32C_ = false;

      name_ = "";

      verifiedDataCrc32C_ = false;

      protectionLevel_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricSignResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricSignResponse getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.AsymmetricSignResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricSignResponse build() {
      com.google.cloud.kms.v1.AsymmetricSignResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricSignResponse buildPartial() {
      com.google.cloud.kms.v1.AsymmetricSignResponse result =
          new com.google.cloud.kms.v1.AsymmetricSignResponse(this);
      result.signature_ = signature_;
      if (signatureCrc32CBuilder_ == null) {
        result.signatureCrc32C_ = signatureCrc32C_;
      } else {
        result.signatureCrc32C_ = signatureCrc32CBuilder_.build();
      }
      result.verifiedDigestCrc32C_ = verifiedDigestCrc32C_;
      result.name_ = name_;
      result.verifiedDataCrc32C_ = verifiedDataCrc32C_;
      result.protectionLevel_ = protectionLevel_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.AsymmetricSignResponse) {
        return mergeFrom((com.google.cloud.kms.v1.AsymmetricSignResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.AsymmetricSignResponse other) {
      if (other == com.google.cloud.kms.v1.AsymmetricSignResponse.getDefaultInstance()) return this;
      if (other.getSignature() != com.google.protobuf.ByteString.EMPTY) {
        setSignature(other.getSignature());
      }
      if (other.hasSignatureCrc32C()) {
        mergeSignatureCrc32C(other.getSignatureCrc32C());
      }
      if (other.getVerifiedDigestCrc32C() != false) {
        setVerifiedDigestCrc32C(other.getVerifiedDigestCrc32C());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getVerifiedDataCrc32C() != false) {
        setVerifiedDataCrc32C(other.getVerifiedDataCrc32C());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                signature_ = input.readBytes();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSignatureCrc32CFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 24:
              {
                verifiedDigestCrc32C_ = input.readBool();

                break;
              } // case 24
            case 34:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 40:
              {
                verifiedDataCrc32C_ = input.readBool();

                break;
              } // case 40
            case 48:
              {
                protectionLevel_ = input.readEnum();

                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.protobuf.ByteString signature_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The created signature.
     * </pre>
     *
     * <code>bytes signature = 1;</code>
     *
     * @return The signature.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSignature() {
      return signature_;
    }
    /**
     *
     *
     * <pre>
     * The created signature.
     * </pre>
     *
     * <code>bytes signature = 1;</code>
     *
     * @param value The signature to set.
     * @return This builder for chaining.
     */
    public Builder setSignature(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      signature_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The created signature.
     * </pre>
     *
     * <code>bytes signature = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSignature() {

      signature_ = getDefaultInstance().getSignature();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value signatureCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        signatureCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     *
     * @return Whether the signatureCrc32c field is set.
     */
    public boolean hasSignatureCrc32C() {
      return signatureCrc32CBuilder_ != null || signatureCrc32C_ != null;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     *
     * @return The signatureCrc32c.
     */
    public com.google.protobuf.Int64Value getSignatureCrc32C() {
      if (signatureCrc32CBuilder_ == null) {
        return signatureCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : signatureCrc32C_;
      } else {
        return signatureCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     */
    public Builder setSignatureCrc32C(com.google.protobuf.Int64Value value) {
      if (signatureCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signatureCrc32C_ = value;
        onChanged();
      } else {
        signatureCrc32CBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     */
    public Builder setSignatureCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (signatureCrc32CBuilder_ == null) {
        signatureCrc32C_ = builderForValue.build();
        onChanged();
      } else {
        signatureCrc32CBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     */
    public Builder mergeSignatureCrc32C(com.google.protobuf.Int64Value value) {
      if (signatureCrc32CBuilder_ == null) {
        if (signatureCrc32C_ != null) {
          signatureCrc32C_ =
              com.google.protobuf.Int64Value.newBuilder(signatureCrc32C_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          signatureCrc32C_ = value;
        }
        onChanged();
      } else {
        signatureCrc32CBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     */
    public Builder clearSignatureCrc32C() {
      if (signatureCrc32CBuilder_ == null) {
        signatureCrc32C_ = null;
        onChanged();
      } else {
        signatureCrc32C_ = null;
        signatureCrc32CBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     */
    public com.google.protobuf.Int64Value.Builder getSignatureCrc32CBuilder() {

      onChanged();
      return getSignatureCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getSignatureCrc32COrBuilder() {
      if (signatureCrc32CBuilder_ != null) {
        return signatureCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return signatureCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : signatureCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature].
     * An integrity check of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * can be performed by computing the CRC32C checksum of
     * [AsymmetricSignResponse.signature][google.cloud.kms.v1.AsymmetricSignResponse.signature]
     * and comparing your results to this field. Discard the response in case of
     * non-matching checksum values, and perform a limited number of retries. A
     * persistent mismatch may indicate an issue in your computation of the CRC32C
     * checksum. Note: This field is defined as int64 for reasons of compatibility
     * across different languages. However, it is a non-negative integer, which
     * will never exceed 2^32-1, and can be safely downconverted to uint32 in
     * languages that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value signature_crc32c = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getSignatureCrc32CFieldBuilder() {
      if (signatureCrc32CBuilder_ == null) {
        signatureCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getSignatureCrc32C(), getParentForChildren(), isClean());
        signatureCrc32C_ = null;
      }
      return signatureCrc32CBuilder_;
    }

    private boolean verifiedDigestCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. A false value
     * of this field indicates either that
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_digest_crc32c = 3;</code>
     *
     * @return The verifiedDigestCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedDigestCrc32C() {
      return verifiedDigestCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. A false value
     * of this field indicates either that
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_digest_crc32c = 3;</code>
     *
     * @param value The verifiedDigestCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedDigestCrc32C(boolean value) {

      verifiedDigestCrc32C_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [digest][google.cloud.kms.v1.AsymmetricSignRequest.digest]. A false value
     * of this field indicates either that
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [AsymmetricSignRequest.digest_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.digest_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_digest_crc32c = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedDigestCrc32C() {

      verifiedDigestCrc32C_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * Check this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * Check this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * Check this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * Check this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * Check this field to verify that the intended resource was used for signing.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private boolean verifiedDataCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [data][google.cloud.kms.v1.AsymmetricSignRequest.data]. A false value of
     * this field indicates either that
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 5;</code>
     *
     * @return The verifiedDataCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedDataCrc32C() {
      return verifiedDataCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [data][google.cloud.kms.v1.AsymmetricSignRequest.data]. A false value of
     * this field indicates either that
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 5;</code>
     *
     * @param value The verifiedDataCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedDataCrc32C(boolean value) {

      verifiedDataCrc32C_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the
     * [data][google.cloud.kms.v1.AsymmetricSignRequest.data]. A false value of
     * this field indicates either that
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [AsymmetricSignRequest.data_crc32c][google.cloud.kms.v1.AsymmetricSignRequest.data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_data_crc32c = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedDataCrc32C() {

      verifiedDataCrc32C_ = false;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {

      protectionLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.valueOf(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used for signing.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {

      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.AsymmetricSignResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.AsymmetricSignResponse)
  private static final com.google.cloud.kms.v1.AsymmetricSignResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.AsymmetricSignResponse();
  }

  public static com.google.cloud.kms.v1.AsymmetricSignResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AsymmetricSignResponse> PARSER =
      new com.google.protobuf.AbstractParser<AsymmetricSignResponse>() {
        @java.lang.Override
        public AsymmetricSignResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AsymmetricSignResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AsymmetricSignResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.AsymmetricSignResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
