/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/language/v1/language_service.proto

package com.google.cloud.language.v1;

/**
 *
 *
 * <pre>
 * Represents part of speech information for a token. Parts of speech
 * are as defined in
 * http://www.lrec-conf.org/proceedings/lrec2012/pdf/274_Paper.pdf
 * </pre>
 *
 * Protobuf type {@code google.cloud.language.v1.PartOfSpeech}
 */
public final class PartOfSpeech extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.language.v1.PartOfSpeech)
    PartOfSpeechOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PartOfSpeech.newBuilder() to construct.
  private PartOfSpeech(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartOfSpeech() {
    tag_ = 0;
    aspect_ = 0;
    case_ = 0;
    form_ = 0;
    gender_ = 0;
    mood_ = 0;
    number_ = 0;
    person_ = 0;
    proper_ = 0;
    reciprocity_ = 0;
    tense_ = 0;
    voice_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartOfSpeech();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PartOfSpeech(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              tag_ = rawValue;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              aspect_ = rawValue;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              case_ = rawValue;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              form_ = rawValue;
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              gender_ = rawValue;
              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              mood_ = rawValue;
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              number_ = rawValue;
              break;
            }
          case 64:
            {
              int rawValue = input.readEnum();

              person_ = rawValue;
              break;
            }
          case 72:
            {
              int rawValue = input.readEnum();

              proper_ = rawValue;
              break;
            }
          case 80:
            {
              int rawValue = input.readEnum();

              reciprocity_ = rawValue;
              break;
            }
          case 88:
            {
              int rawValue = input.readEnum();

              tense_ = rawValue;
              break;
            }
          case 96:
            {
              int rawValue = input.readEnum();

              voice_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.language.v1.LanguageServiceProto
        .internal_static_google_cloud_language_v1_PartOfSpeech_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.language.v1.LanguageServiceProto
        .internal_static_google_cloud_language_v1_PartOfSpeech_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.language.v1.PartOfSpeech.class,
            com.google.cloud.language.v1.PartOfSpeech.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The part of speech tags enum.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Tag}
   */
  public enum Tag implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Adjective
     * </pre>
     *
     * <code>ADJ = 1;</code>
     */
    ADJ(1),
    /**
     *
     *
     * <pre>
     * Adposition (preposition and postposition)
     * </pre>
     *
     * <code>ADP = 2;</code>
     */
    ADP(2),
    /**
     *
     *
     * <pre>
     * Adverb
     * </pre>
     *
     * <code>ADV = 3;</code>
     */
    ADV(3),
    /**
     *
     *
     * <pre>
     * Conjunction
     * </pre>
     *
     * <code>CONJ = 4;</code>
     */
    CONJ(4),
    /**
     *
     *
     * <pre>
     * Determiner
     * </pre>
     *
     * <code>DET = 5;</code>
     */
    DET(5),
    /**
     *
     *
     * <pre>
     * Noun (common and proper)
     * </pre>
     *
     * <code>NOUN = 6;</code>
     */
    NOUN(6),
    /**
     *
     *
     * <pre>
     * Cardinal number
     * </pre>
     *
     * <code>NUM = 7;</code>
     */
    NUM(7),
    /**
     *
     *
     * <pre>
     * Pronoun
     * </pre>
     *
     * <code>PRON = 8;</code>
     */
    PRON(8),
    /**
     *
     *
     * <pre>
     * Particle or other function word
     * </pre>
     *
     * <code>PRT = 9;</code>
     */
    PRT(9),
    /**
     *
     *
     * <pre>
     * Punctuation
     * </pre>
     *
     * <code>PUNCT = 10;</code>
     */
    PUNCT(10),
    /**
     *
     *
     * <pre>
     * Verb (all tenses and modes)
     * </pre>
     *
     * <code>VERB = 11;</code>
     */
    VERB(11),
    /**
     *
     *
     * <pre>
     * Other: foreign words, typos, abbreviations
     * </pre>
     *
     * <code>X = 12;</code>
     */
    X(12),
    /**
     *
     *
     * <pre>
     * Affix
     * </pre>
     *
     * <code>AFFIX = 13;</code>
     */
    AFFIX(13),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Adjective
     * </pre>
     *
     * <code>ADJ = 1;</code>
     */
    public static final int ADJ_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Adposition (preposition and postposition)
     * </pre>
     *
     * <code>ADP = 2;</code>
     */
    public static final int ADP_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Adverb
     * </pre>
     *
     * <code>ADV = 3;</code>
     */
    public static final int ADV_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Conjunction
     * </pre>
     *
     * <code>CONJ = 4;</code>
     */
    public static final int CONJ_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Determiner
     * </pre>
     *
     * <code>DET = 5;</code>
     */
    public static final int DET_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Noun (common and proper)
     * </pre>
     *
     * <code>NOUN = 6;</code>
     */
    public static final int NOUN_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Cardinal number
     * </pre>
     *
     * <code>NUM = 7;</code>
     */
    public static final int NUM_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Pronoun
     * </pre>
     *
     * <code>PRON = 8;</code>
     */
    public static final int PRON_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Particle or other function word
     * </pre>
     *
     * <code>PRT = 9;</code>
     */
    public static final int PRT_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Punctuation
     * </pre>
     *
     * <code>PUNCT = 10;</code>
     */
    public static final int PUNCT_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Verb (all tenses and modes)
     * </pre>
     *
     * <code>VERB = 11;</code>
     */
    public static final int VERB_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Other: foreign words, typos, abbreviations
     * </pre>
     *
     * <code>X = 12;</code>
     */
    public static final int X_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Affix
     * </pre>
     *
     * <code>AFFIX = 13;</code>
     */
    public static final int AFFIX_VALUE = 13;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tag valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tag forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return ADJ;
        case 2:
          return ADP;
        case 3:
          return ADV;
        case 4:
          return CONJ;
        case 5:
          return DET;
        case 6:
          return NOUN;
        case 7:
          return NUM;
        case 8:
          return PRON;
        case 9:
          return PRT;
        case 10:
          return PUNCT;
        case 11:
          return VERB;
        case 12:
          return X;
        case 13:
          return AFFIX;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tag> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tag> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tag>() {
          public Tag findValueByNumber(int number) {
            return Tag.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(0);
    }

    private static final Tag[] VALUES = values();

    public static Tag valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tag(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Tag)
  }

  /**
   *
   *
   * <pre>
   * The characteristic of a verb that expresses time flow during an event.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Aspect}
   */
  public enum Aspect implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Aspect is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>ASPECT_UNKNOWN = 0;</code>
     */
    ASPECT_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Perfective
     * </pre>
     *
     * <code>PERFECTIVE = 1;</code>
     */
    PERFECTIVE(1),
    /**
     *
     *
     * <pre>
     * Imperfective
     * </pre>
     *
     * <code>IMPERFECTIVE = 2;</code>
     */
    IMPERFECTIVE(2),
    /**
     *
     *
     * <pre>
     * Progressive
     * </pre>
     *
     * <code>PROGRESSIVE = 3;</code>
     */
    PROGRESSIVE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Aspect is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>ASPECT_UNKNOWN = 0;</code>
     */
    public static final int ASPECT_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Perfective
     * </pre>
     *
     * <code>PERFECTIVE = 1;</code>
     */
    public static final int PERFECTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Imperfective
     * </pre>
     *
     * <code>IMPERFECTIVE = 2;</code>
     */
    public static final int IMPERFECTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Progressive
     * </pre>
     *
     * <code>PROGRESSIVE = 3;</code>
     */
    public static final int PROGRESSIVE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Aspect valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Aspect forNumber(int value) {
      switch (value) {
        case 0:
          return ASPECT_UNKNOWN;
        case 1:
          return PERFECTIVE;
        case 2:
          return IMPERFECTIVE;
        case 3:
          return PROGRESSIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Aspect> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Aspect> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Aspect>() {
          public Aspect findValueByNumber(int number) {
            return Aspect.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(1);
    }

    private static final Aspect[] VALUES = values();

    public static Aspect valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Aspect(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Aspect)
  }

  /**
   *
   *
   * <pre>
   * The grammatical function performed by a noun or pronoun in a phrase,
   * clause, or sentence. In some languages, other parts of speech, such as
   * adjective and determiner, take case inflection in agreement with the noun.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Case}
   */
  public enum Case implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Case is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>CASE_UNKNOWN = 0;</code>
     */
    CASE_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Accusative
     * </pre>
     *
     * <code>ACCUSATIVE = 1;</code>
     */
    ACCUSATIVE(1),
    /**
     *
     *
     * <pre>
     * Adverbial
     * </pre>
     *
     * <code>ADVERBIAL = 2;</code>
     */
    ADVERBIAL(2),
    /**
     *
     *
     * <pre>
     * Complementive
     * </pre>
     *
     * <code>COMPLEMENTIVE = 3;</code>
     */
    COMPLEMENTIVE(3),
    /**
     *
     *
     * <pre>
     * Dative
     * </pre>
     *
     * <code>DATIVE = 4;</code>
     */
    DATIVE(4),
    /**
     *
     *
     * <pre>
     * Genitive
     * </pre>
     *
     * <code>GENITIVE = 5;</code>
     */
    GENITIVE(5),
    /**
     *
     *
     * <pre>
     * Instrumental
     * </pre>
     *
     * <code>INSTRUMENTAL = 6;</code>
     */
    INSTRUMENTAL(6),
    /**
     *
     *
     * <pre>
     * Locative
     * </pre>
     *
     * <code>LOCATIVE = 7;</code>
     */
    LOCATIVE(7),
    /**
     *
     *
     * <pre>
     * Nominative
     * </pre>
     *
     * <code>NOMINATIVE = 8;</code>
     */
    NOMINATIVE(8),
    /**
     *
     *
     * <pre>
     * Oblique
     * </pre>
     *
     * <code>OBLIQUE = 9;</code>
     */
    OBLIQUE(9),
    /**
     *
     *
     * <pre>
     * Partitive
     * </pre>
     *
     * <code>PARTITIVE = 10;</code>
     */
    PARTITIVE(10),
    /**
     *
     *
     * <pre>
     * Prepositional
     * </pre>
     *
     * <code>PREPOSITIONAL = 11;</code>
     */
    PREPOSITIONAL(11),
    /**
     *
     *
     * <pre>
     * Reflexive
     * </pre>
     *
     * <code>REFLEXIVE_CASE = 12;</code>
     */
    REFLEXIVE_CASE(12),
    /**
     *
     *
     * <pre>
     * Relative
     * </pre>
     *
     * <code>RELATIVE_CASE = 13;</code>
     */
    RELATIVE_CASE(13),
    /**
     *
     *
     * <pre>
     * Vocative
     * </pre>
     *
     * <code>VOCATIVE = 14;</code>
     */
    VOCATIVE(14),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Case is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>CASE_UNKNOWN = 0;</code>
     */
    public static final int CASE_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Accusative
     * </pre>
     *
     * <code>ACCUSATIVE = 1;</code>
     */
    public static final int ACCUSATIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Adverbial
     * </pre>
     *
     * <code>ADVERBIAL = 2;</code>
     */
    public static final int ADVERBIAL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Complementive
     * </pre>
     *
     * <code>COMPLEMENTIVE = 3;</code>
     */
    public static final int COMPLEMENTIVE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Dative
     * </pre>
     *
     * <code>DATIVE = 4;</code>
     */
    public static final int DATIVE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Genitive
     * </pre>
     *
     * <code>GENITIVE = 5;</code>
     */
    public static final int GENITIVE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Instrumental
     * </pre>
     *
     * <code>INSTRUMENTAL = 6;</code>
     */
    public static final int INSTRUMENTAL_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Locative
     * </pre>
     *
     * <code>LOCATIVE = 7;</code>
     */
    public static final int LOCATIVE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Nominative
     * </pre>
     *
     * <code>NOMINATIVE = 8;</code>
     */
    public static final int NOMINATIVE_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Oblique
     * </pre>
     *
     * <code>OBLIQUE = 9;</code>
     */
    public static final int OBLIQUE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Partitive
     * </pre>
     *
     * <code>PARTITIVE = 10;</code>
     */
    public static final int PARTITIVE_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Prepositional
     * </pre>
     *
     * <code>PREPOSITIONAL = 11;</code>
     */
    public static final int PREPOSITIONAL_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Reflexive
     * </pre>
     *
     * <code>REFLEXIVE_CASE = 12;</code>
     */
    public static final int REFLEXIVE_CASE_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Relative
     * </pre>
     *
     * <code>RELATIVE_CASE = 13;</code>
     */
    public static final int RELATIVE_CASE_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Vocative
     * </pre>
     *
     * <code>VOCATIVE = 14;</code>
     */
    public static final int VOCATIVE_VALUE = 14;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Case valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Case forNumber(int value) {
      switch (value) {
        case 0:
          return CASE_UNKNOWN;
        case 1:
          return ACCUSATIVE;
        case 2:
          return ADVERBIAL;
        case 3:
          return COMPLEMENTIVE;
        case 4:
          return DATIVE;
        case 5:
          return GENITIVE;
        case 6:
          return INSTRUMENTAL;
        case 7:
          return LOCATIVE;
        case 8:
          return NOMINATIVE;
        case 9:
          return OBLIQUE;
        case 10:
          return PARTITIVE;
        case 11:
          return PREPOSITIONAL;
        case 12:
          return REFLEXIVE_CASE;
        case 13:
          return RELATIVE_CASE;
        case 14:
          return VOCATIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Case> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Case> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Case>() {
          public Case findValueByNumber(int number) {
            return Case.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(2);
    }

    private static final Case[] VALUES = values();

    public static Case valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Case(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Case)
  }

  /**
   *
   *
   * <pre>
   * Depending on the language, Form can be categorizing different forms of
   * verbs, adjectives, adverbs, etc. For example, categorizing inflected
   * endings of verbs and adjectives or distinguishing between short and long
   * forms of adjectives and participles
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Form}
   */
  public enum Form implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Form is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>FORM_UNKNOWN = 0;</code>
     */
    FORM_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Adnomial
     * </pre>
     *
     * <code>ADNOMIAL = 1;</code>
     */
    ADNOMIAL(1),
    /**
     *
     *
     * <pre>
     * Auxiliary
     * </pre>
     *
     * <code>AUXILIARY = 2;</code>
     */
    AUXILIARY(2),
    /**
     *
     *
     * <pre>
     * Complementizer
     * </pre>
     *
     * <code>COMPLEMENTIZER = 3;</code>
     */
    COMPLEMENTIZER(3),
    /**
     *
     *
     * <pre>
     * Final ending
     * </pre>
     *
     * <code>FINAL_ENDING = 4;</code>
     */
    FINAL_ENDING(4),
    /**
     *
     *
     * <pre>
     * Gerund
     * </pre>
     *
     * <code>GERUND = 5;</code>
     */
    GERUND(5),
    /**
     *
     *
     * <pre>
     * Realis
     * </pre>
     *
     * <code>REALIS = 6;</code>
     */
    REALIS(6),
    /**
     *
     *
     * <pre>
     * Irrealis
     * </pre>
     *
     * <code>IRREALIS = 7;</code>
     */
    IRREALIS(7),
    /**
     *
     *
     * <pre>
     * Short form
     * </pre>
     *
     * <code>SHORT = 8;</code>
     */
    SHORT(8),
    /**
     *
     *
     * <pre>
     * Long form
     * </pre>
     *
     * <code>LONG = 9;</code>
     */
    LONG(9),
    /**
     *
     *
     * <pre>
     * Order form
     * </pre>
     *
     * <code>ORDER = 10;</code>
     */
    ORDER(10),
    /**
     *
     *
     * <pre>
     * Specific form
     * </pre>
     *
     * <code>SPECIFIC = 11;</code>
     */
    SPECIFIC(11),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Form is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>FORM_UNKNOWN = 0;</code>
     */
    public static final int FORM_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Adnomial
     * </pre>
     *
     * <code>ADNOMIAL = 1;</code>
     */
    public static final int ADNOMIAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Auxiliary
     * </pre>
     *
     * <code>AUXILIARY = 2;</code>
     */
    public static final int AUXILIARY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Complementizer
     * </pre>
     *
     * <code>COMPLEMENTIZER = 3;</code>
     */
    public static final int COMPLEMENTIZER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Final ending
     * </pre>
     *
     * <code>FINAL_ENDING = 4;</code>
     */
    public static final int FINAL_ENDING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Gerund
     * </pre>
     *
     * <code>GERUND = 5;</code>
     */
    public static final int GERUND_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Realis
     * </pre>
     *
     * <code>REALIS = 6;</code>
     */
    public static final int REALIS_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Irrealis
     * </pre>
     *
     * <code>IRREALIS = 7;</code>
     */
    public static final int IRREALIS_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Short form
     * </pre>
     *
     * <code>SHORT = 8;</code>
     */
    public static final int SHORT_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Long form
     * </pre>
     *
     * <code>LONG = 9;</code>
     */
    public static final int LONG_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Order form
     * </pre>
     *
     * <code>ORDER = 10;</code>
     */
    public static final int ORDER_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Specific form
     * </pre>
     *
     * <code>SPECIFIC = 11;</code>
     */
    public static final int SPECIFIC_VALUE = 11;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Form valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Form forNumber(int value) {
      switch (value) {
        case 0:
          return FORM_UNKNOWN;
        case 1:
          return ADNOMIAL;
        case 2:
          return AUXILIARY;
        case 3:
          return COMPLEMENTIZER;
        case 4:
          return FINAL_ENDING;
        case 5:
          return GERUND;
        case 6:
          return REALIS;
        case 7:
          return IRREALIS;
        case 8:
          return SHORT;
        case 9:
          return LONG;
        case 10:
          return ORDER;
        case 11:
          return SPECIFIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Form> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Form> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Form>() {
          public Form findValueByNumber(int number) {
            return Form.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(3);
    }

    private static final Form[] VALUES = values();

    public static Form valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Form(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Form)
  }

  /**
   *
   *
   * <pre>
   * Gender classes of nouns reflected in the behaviour of associated words.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Gender}
   */
  public enum Gender implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Gender is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>GENDER_UNKNOWN = 0;</code>
     */
    GENDER_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Feminine
     * </pre>
     *
     * <code>FEMININE = 1;</code>
     */
    FEMININE(1),
    /**
     *
     *
     * <pre>
     * Masculine
     * </pre>
     *
     * <code>MASCULINE = 2;</code>
     */
    MASCULINE(2),
    /**
     *
     *
     * <pre>
     * Neuter
     * </pre>
     *
     * <code>NEUTER = 3;</code>
     */
    NEUTER(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Gender is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>GENDER_UNKNOWN = 0;</code>
     */
    public static final int GENDER_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Feminine
     * </pre>
     *
     * <code>FEMININE = 1;</code>
     */
    public static final int FEMININE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Masculine
     * </pre>
     *
     * <code>MASCULINE = 2;</code>
     */
    public static final int MASCULINE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Neuter
     * </pre>
     *
     * <code>NEUTER = 3;</code>
     */
    public static final int NEUTER_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Gender valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Gender forNumber(int value) {
      switch (value) {
        case 0:
          return GENDER_UNKNOWN;
        case 1:
          return FEMININE;
        case 2:
          return MASCULINE;
        case 3:
          return NEUTER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Gender> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Gender> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Gender>() {
          public Gender findValueByNumber(int number) {
            return Gender.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(4);
    }

    private static final Gender[] VALUES = values();

    public static Gender valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Gender(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Gender)
  }

  /**
   *
   *
   * <pre>
   * The grammatical feature of verbs, used for showing modality and attitude.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Mood}
   */
  public enum Mood implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Mood is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>MOOD_UNKNOWN = 0;</code>
     */
    MOOD_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Conditional
     * </pre>
     *
     * <code>CONDITIONAL_MOOD = 1;</code>
     */
    CONDITIONAL_MOOD(1),
    /**
     *
     *
     * <pre>
     * Imperative
     * </pre>
     *
     * <code>IMPERATIVE = 2;</code>
     */
    IMPERATIVE(2),
    /**
     *
     *
     * <pre>
     * Indicative
     * </pre>
     *
     * <code>INDICATIVE = 3;</code>
     */
    INDICATIVE(3),
    /**
     *
     *
     * <pre>
     * Interrogative
     * </pre>
     *
     * <code>INTERROGATIVE = 4;</code>
     */
    INTERROGATIVE(4),
    /**
     *
     *
     * <pre>
     * Jussive
     * </pre>
     *
     * <code>JUSSIVE = 5;</code>
     */
    JUSSIVE(5),
    /**
     *
     *
     * <pre>
     * Subjunctive
     * </pre>
     *
     * <code>SUBJUNCTIVE = 6;</code>
     */
    SUBJUNCTIVE(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Mood is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>MOOD_UNKNOWN = 0;</code>
     */
    public static final int MOOD_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Conditional
     * </pre>
     *
     * <code>CONDITIONAL_MOOD = 1;</code>
     */
    public static final int CONDITIONAL_MOOD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Imperative
     * </pre>
     *
     * <code>IMPERATIVE = 2;</code>
     */
    public static final int IMPERATIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Indicative
     * </pre>
     *
     * <code>INDICATIVE = 3;</code>
     */
    public static final int INDICATIVE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Interrogative
     * </pre>
     *
     * <code>INTERROGATIVE = 4;</code>
     */
    public static final int INTERROGATIVE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Jussive
     * </pre>
     *
     * <code>JUSSIVE = 5;</code>
     */
    public static final int JUSSIVE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Subjunctive
     * </pre>
     *
     * <code>SUBJUNCTIVE = 6;</code>
     */
    public static final int SUBJUNCTIVE_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mood valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mood forNumber(int value) {
      switch (value) {
        case 0:
          return MOOD_UNKNOWN;
        case 1:
          return CONDITIONAL_MOOD;
        case 2:
          return IMPERATIVE;
        case 3:
          return INDICATIVE;
        case 4:
          return INTERROGATIVE;
        case 5:
          return JUSSIVE;
        case 6:
          return SUBJUNCTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mood> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mood> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mood>() {
          public Mood findValueByNumber(int number) {
            return Mood.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(5);
    }

    private static final Mood[] VALUES = values();

    public static Mood valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mood(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Mood)
  }

  /**
   *
   *
   * <pre>
   * Count distinctions.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Number}
   */
  public enum Number implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Number is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>NUMBER_UNKNOWN = 0;</code>
     */
    NUMBER_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Singular
     * </pre>
     *
     * <code>SINGULAR = 1;</code>
     */
    SINGULAR(1),
    /**
     *
     *
     * <pre>
     * Plural
     * </pre>
     *
     * <code>PLURAL = 2;</code>
     */
    PLURAL(2),
    /**
     *
     *
     * <pre>
     * Dual
     * </pre>
     *
     * <code>DUAL = 3;</code>
     */
    DUAL(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Number is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>NUMBER_UNKNOWN = 0;</code>
     */
    public static final int NUMBER_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Singular
     * </pre>
     *
     * <code>SINGULAR = 1;</code>
     */
    public static final int SINGULAR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Plural
     * </pre>
     *
     * <code>PLURAL = 2;</code>
     */
    public static final int PLURAL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Dual
     * </pre>
     *
     * <code>DUAL = 3;</code>
     */
    public static final int DUAL_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Number valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Number forNumber(int value) {
      switch (value) {
        case 0:
          return NUMBER_UNKNOWN;
        case 1:
          return SINGULAR;
        case 2:
          return PLURAL;
        case 3:
          return DUAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Number> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Number> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Number>() {
          public Number findValueByNumber(int number) {
            return Number.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(6);
    }

    private static final Number[] VALUES = values();

    public static Number valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Number(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Number)
  }

  /**
   *
   *
   * <pre>
   * The distinction between the speaker, second person, third person, etc.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Person}
   */
  public enum Person implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Person is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>PERSON_UNKNOWN = 0;</code>
     */
    PERSON_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * First
     * </pre>
     *
     * <code>FIRST = 1;</code>
     */
    FIRST(1),
    /**
     *
     *
     * <pre>
     * Second
     * </pre>
     *
     * <code>SECOND = 2;</code>
     */
    SECOND(2),
    /**
     *
     *
     * <pre>
     * Third
     * </pre>
     *
     * <code>THIRD = 3;</code>
     */
    THIRD(3),
    /**
     *
     *
     * <pre>
     * Reflexive
     * </pre>
     *
     * <code>REFLEXIVE_PERSON = 4;</code>
     */
    REFLEXIVE_PERSON(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Person is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>PERSON_UNKNOWN = 0;</code>
     */
    public static final int PERSON_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * First
     * </pre>
     *
     * <code>FIRST = 1;</code>
     */
    public static final int FIRST_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Second
     * </pre>
     *
     * <code>SECOND = 2;</code>
     */
    public static final int SECOND_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Third
     * </pre>
     *
     * <code>THIRD = 3;</code>
     */
    public static final int THIRD_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Reflexive
     * </pre>
     *
     * <code>REFLEXIVE_PERSON = 4;</code>
     */
    public static final int REFLEXIVE_PERSON_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Person valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Person forNumber(int value) {
      switch (value) {
        case 0:
          return PERSON_UNKNOWN;
        case 1:
          return FIRST;
        case 2:
          return SECOND;
        case 3:
          return THIRD;
        case 4:
          return REFLEXIVE_PERSON;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Person> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Person> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Person>() {
          public Person findValueByNumber(int number) {
            return Person.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(7);
    }

    private static final Person[] VALUES = values();

    public static Person valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Person(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Person)
  }

  /**
   *
   *
   * <pre>
   * This category shows if the token is part of a proper name.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Proper}
   */
  public enum Proper implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Proper is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>PROPER_UNKNOWN = 0;</code>
     */
    PROPER_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Proper
     * </pre>
     *
     * <code>PROPER = 1;</code>
     */
    PROPER(1),
    /**
     *
     *
     * <pre>
     * Not proper
     * </pre>
     *
     * <code>NOT_PROPER = 2;</code>
     */
    NOT_PROPER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Proper is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>PROPER_UNKNOWN = 0;</code>
     */
    public static final int PROPER_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Proper
     * </pre>
     *
     * <code>PROPER = 1;</code>
     */
    public static final int PROPER_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Not proper
     * </pre>
     *
     * <code>NOT_PROPER = 2;</code>
     */
    public static final int NOT_PROPER_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Proper valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Proper forNumber(int value) {
      switch (value) {
        case 0:
          return PROPER_UNKNOWN;
        case 1:
          return PROPER;
        case 2:
          return NOT_PROPER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Proper> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Proper> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Proper>() {
          public Proper findValueByNumber(int number) {
            return Proper.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(8);
    }

    private static final Proper[] VALUES = values();

    public static Proper valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Proper(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Proper)
  }

  /**
   *
   *
   * <pre>
   * Reciprocal features of a pronoun.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Reciprocity}
   */
  public enum Reciprocity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reciprocity is not applicable in the analyzed language or is not
     * predicted.
     * </pre>
     *
     * <code>RECIPROCITY_UNKNOWN = 0;</code>
     */
    RECIPROCITY_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Reciprocal
     * </pre>
     *
     * <code>RECIPROCAL = 1;</code>
     */
    RECIPROCAL(1),
    /**
     *
     *
     * <pre>
     * Non-reciprocal
     * </pre>
     *
     * <code>NON_RECIPROCAL = 2;</code>
     */
    NON_RECIPROCAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reciprocity is not applicable in the analyzed language or is not
     * predicted.
     * </pre>
     *
     * <code>RECIPROCITY_UNKNOWN = 0;</code>
     */
    public static final int RECIPROCITY_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Reciprocal
     * </pre>
     *
     * <code>RECIPROCAL = 1;</code>
     */
    public static final int RECIPROCAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Non-reciprocal
     * </pre>
     *
     * <code>NON_RECIPROCAL = 2;</code>
     */
    public static final int NON_RECIPROCAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Reciprocity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Reciprocity forNumber(int value) {
      switch (value) {
        case 0:
          return RECIPROCITY_UNKNOWN;
        case 1:
          return RECIPROCAL;
        case 2:
          return NON_RECIPROCAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Reciprocity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Reciprocity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Reciprocity>() {
          public Reciprocity findValueByNumber(int number) {
            return Reciprocity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(9);
    }

    private static final Reciprocity[] VALUES = values();

    public static Reciprocity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Reciprocity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Reciprocity)
  }

  /**
   *
   *
   * <pre>
   * Time reference.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Tense}
   */
  public enum Tense implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Tense is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>TENSE_UNKNOWN = 0;</code>
     */
    TENSE_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Conditional
     * </pre>
     *
     * <code>CONDITIONAL_TENSE = 1;</code>
     */
    CONDITIONAL_TENSE(1),
    /**
     *
     *
     * <pre>
     * Future
     * </pre>
     *
     * <code>FUTURE = 2;</code>
     */
    FUTURE(2),
    /**
     *
     *
     * <pre>
     * Past
     * </pre>
     *
     * <code>PAST = 3;</code>
     */
    PAST(3),
    /**
     *
     *
     * <pre>
     * Present
     * </pre>
     *
     * <code>PRESENT = 4;</code>
     */
    PRESENT(4),
    /**
     *
     *
     * <pre>
     * Imperfect
     * </pre>
     *
     * <code>IMPERFECT = 5;</code>
     */
    IMPERFECT(5),
    /**
     *
     *
     * <pre>
     * Pluperfect
     * </pre>
     *
     * <code>PLUPERFECT = 6;</code>
     */
    PLUPERFECT(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Tense is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>TENSE_UNKNOWN = 0;</code>
     */
    public static final int TENSE_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Conditional
     * </pre>
     *
     * <code>CONDITIONAL_TENSE = 1;</code>
     */
    public static final int CONDITIONAL_TENSE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Future
     * </pre>
     *
     * <code>FUTURE = 2;</code>
     */
    public static final int FUTURE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Past
     * </pre>
     *
     * <code>PAST = 3;</code>
     */
    public static final int PAST_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Present
     * </pre>
     *
     * <code>PRESENT = 4;</code>
     */
    public static final int PRESENT_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Imperfect
     * </pre>
     *
     * <code>IMPERFECT = 5;</code>
     */
    public static final int IMPERFECT_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Pluperfect
     * </pre>
     *
     * <code>PLUPERFECT = 6;</code>
     */
    public static final int PLUPERFECT_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tense valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tense forNumber(int value) {
      switch (value) {
        case 0:
          return TENSE_UNKNOWN;
        case 1:
          return CONDITIONAL_TENSE;
        case 2:
          return FUTURE;
        case 3:
          return PAST;
        case 4:
          return PRESENT;
        case 5:
          return IMPERFECT;
        case 6:
          return PLUPERFECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tense> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tense> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tense>() {
          public Tense findValueByNumber(int number) {
            return Tense.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(10);
    }

    private static final Tense[] VALUES = values();

    public static Tense valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tense(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Tense)
  }

  /**
   *
   *
   * <pre>
   * The relationship between the action that a verb expresses and the
   * participants identified by its arguments.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.PartOfSpeech.Voice}
   */
  public enum Voice implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Voice is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>VOICE_UNKNOWN = 0;</code>
     */
    VOICE_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Active
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Causative
     * </pre>
     *
     * <code>CAUSATIVE = 2;</code>
     */
    CAUSATIVE(2),
    /**
     *
     *
     * <pre>
     * Passive
     * </pre>
     *
     * <code>PASSIVE = 3;</code>
     */
    PASSIVE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Voice is not applicable in the analyzed language or is not predicted.
     * </pre>
     *
     * <code>VOICE_UNKNOWN = 0;</code>
     */
    public static final int VOICE_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Active
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Causative
     * </pre>
     *
     * <code>CAUSATIVE = 2;</code>
     */
    public static final int CAUSATIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Passive
     * </pre>
     *
     * <code>PASSIVE = 3;</code>
     */
    public static final int PASSIVE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Voice valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Voice forNumber(int value) {
      switch (value) {
        case 0:
          return VOICE_UNKNOWN;
        case 1:
          return ACTIVE;
        case 2:
          return CAUSATIVE;
        case 3:
          return PASSIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Voice> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Voice> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Voice>() {
          public Voice findValueByNumber(int number) {
            return Voice.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.PartOfSpeech.getDescriptor().getEnumTypes().get(11);
    }

    private static final Voice[] VALUES = values();

    public static Voice valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Voice(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.PartOfSpeech.Voice)
  }

  public static final int TAG_FIELD_NUMBER = 1;
  private int tag_;
  /**
   *
   *
   * <pre>
   * The part of speech tag.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Tag tag = 1;</code>
   *
   * @return The enum numeric value on the wire for tag.
   */
  public int getTagValue() {
    return tag_;
  }
  /**
   *
   *
   * <pre>
   * The part of speech tag.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Tag tag = 1;</code>
   *
   * @return The tag.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Tag getTag() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Tag result =
        com.google.cloud.language.v1.PartOfSpeech.Tag.valueOf(tag_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Tag.UNRECOGNIZED : result;
  }

  public static final int ASPECT_FIELD_NUMBER = 2;
  private int aspect_;
  /**
   *
   *
   * <pre>
   * The grammatical aspect.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Aspect aspect = 2;</code>
   *
   * @return The enum numeric value on the wire for aspect.
   */
  public int getAspectValue() {
    return aspect_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical aspect.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Aspect aspect = 2;</code>
   *
   * @return The aspect.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Aspect getAspect() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Aspect result =
        com.google.cloud.language.v1.PartOfSpeech.Aspect.valueOf(aspect_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Aspect.UNRECOGNIZED : result;
  }

  public static final int CASE_FIELD_NUMBER = 3;
  private int case_;
  /**
   *
   *
   * <pre>
   * The grammatical case.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Case case = 3;</code>
   *
   * @return The enum numeric value on the wire for case.
   */
  public int getCaseValue() {
    return case_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical case.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Case case = 3;</code>
   *
   * @return The case.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Case getCase() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Case result =
        com.google.cloud.language.v1.PartOfSpeech.Case.valueOf(case_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Case.UNRECOGNIZED : result;
  }

  public static final int FORM_FIELD_NUMBER = 4;
  private int form_;
  /**
   *
   *
   * <pre>
   * The grammatical form.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Form form = 4;</code>
   *
   * @return The enum numeric value on the wire for form.
   */
  public int getFormValue() {
    return form_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical form.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Form form = 4;</code>
   *
   * @return The form.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Form getForm() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Form result =
        com.google.cloud.language.v1.PartOfSpeech.Form.valueOf(form_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Form.UNRECOGNIZED : result;
  }

  public static final int GENDER_FIELD_NUMBER = 5;
  private int gender_;
  /**
   *
   *
   * <pre>
   * The grammatical gender.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Gender gender = 5;</code>
   *
   * @return The enum numeric value on the wire for gender.
   */
  public int getGenderValue() {
    return gender_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical gender.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Gender gender = 5;</code>
   *
   * @return The gender.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Gender getGender() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Gender result =
        com.google.cloud.language.v1.PartOfSpeech.Gender.valueOf(gender_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Gender.UNRECOGNIZED : result;
  }

  public static final int MOOD_FIELD_NUMBER = 6;
  private int mood_;
  /**
   *
   *
   * <pre>
   * The grammatical mood.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Mood mood = 6;</code>
   *
   * @return The enum numeric value on the wire for mood.
   */
  public int getMoodValue() {
    return mood_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical mood.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Mood mood = 6;</code>
   *
   * @return The mood.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Mood getMood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Mood result =
        com.google.cloud.language.v1.PartOfSpeech.Mood.valueOf(mood_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Mood.UNRECOGNIZED : result;
  }

  public static final int NUMBER_FIELD_NUMBER = 7;
  private int number_;
  /**
   *
   *
   * <pre>
   * The grammatical number.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Number number = 7;</code>
   *
   * @return The enum numeric value on the wire for number.
   */
  public int getNumberValue() {
    return number_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical number.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Number number = 7;</code>
   *
   * @return The number.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Number getNumber() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Number result =
        com.google.cloud.language.v1.PartOfSpeech.Number.valueOf(number_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Number.UNRECOGNIZED : result;
  }

  public static final int PERSON_FIELD_NUMBER = 8;
  private int person_;
  /**
   *
   *
   * <pre>
   * The grammatical person.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Person person = 8;</code>
   *
   * @return The enum numeric value on the wire for person.
   */
  public int getPersonValue() {
    return person_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical person.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Person person = 8;</code>
   *
   * @return The person.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Person getPerson() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Person result =
        com.google.cloud.language.v1.PartOfSpeech.Person.valueOf(person_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Person.UNRECOGNIZED : result;
  }

  public static final int PROPER_FIELD_NUMBER = 9;
  private int proper_;
  /**
   *
   *
   * <pre>
   * The grammatical properness.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Proper proper = 9;</code>
   *
   * @return The enum numeric value on the wire for proper.
   */
  public int getProperValue() {
    return proper_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical properness.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Proper proper = 9;</code>
   *
   * @return The proper.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Proper getProper() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Proper result =
        com.google.cloud.language.v1.PartOfSpeech.Proper.valueOf(proper_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Proper.UNRECOGNIZED : result;
  }

  public static final int RECIPROCITY_FIELD_NUMBER = 10;
  private int reciprocity_;
  /**
   *
   *
   * <pre>
   * The grammatical reciprocity.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Reciprocity reciprocity = 10;</code>
   *
   * @return The enum numeric value on the wire for reciprocity.
   */
  public int getReciprocityValue() {
    return reciprocity_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical reciprocity.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Reciprocity reciprocity = 10;</code>
   *
   * @return The reciprocity.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Reciprocity getReciprocity() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Reciprocity result =
        com.google.cloud.language.v1.PartOfSpeech.Reciprocity.valueOf(reciprocity_);
    return result == null
        ? com.google.cloud.language.v1.PartOfSpeech.Reciprocity.UNRECOGNIZED
        : result;
  }

  public static final int TENSE_FIELD_NUMBER = 11;
  private int tense_;
  /**
   *
   *
   * <pre>
   * The grammatical tense.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Tense tense = 11;</code>
   *
   * @return The enum numeric value on the wire for tense.
   */
  public int getTenseValue() {
    return tense_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical tense.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Tense tense = 11;</code>
   *
   * @return The tense.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Tense getTense() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Tense result =
        com.google.cloud.language.v1.PartOfSpeech.Tense.valueOf(tense_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Tense.UNRECOGNIZED : result;
  }

  public static final int VOICE_FIELD_NUMBER = 12;
  private int voice_;
  /**
   *
   *
   * <pre>
   * The grammatical voice.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Voice voice = 12;</code>
   *
   * @return The enum numeric value on the wire for voice.
   */
  public int getVoiceValue() {
    return voice_;
  }
  /**
   *
   *
   * <pre>
   * The grammatical voice.
   * </pre>
   *
   * <code>.google.cloud.language.v1.PartOfSpeech.Voice voice = 12;</code>
   *
   * @return The voice.
   */
  public com.google.cloud.language.v1.PartOfSpeech.Voice getVoice() {
    @SuppressWarnings("deprecation")
    com.google.cloud.language.v1.PartOfSpeech.Voice result =
        com.google.cloud.language.v1.PartOfSpeech.Voice.valueOf(voice_);
    return result == null ? com.google.cloud.language.v1.PartOfSpeech.Voice.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (tag_ != com.google.cloud.language.v1.PartOfSpeech.Tag.UNKNOWN.getNumber()) {
      output.writeEnum(1, tag_);
    }
    if (aspect_ != com.google.cloud.language.v1.PartOfSpeech.Aspect.ASPECT_UNKNOWN.getNumber()) {
      output.writeEnum(2, aspect_);
    }
    if (case_ != com.google.cloud.language.v1.PartOfSpeech.Case.CASE_UNKNOWN.getNumber()) {
      output.writeEnum(3, case_);
    }
    if (form_ != com.google.cloud.language.v1.PartOfSpeech.Form.FORM_UNKNOWN.getNumber()) {
      output.writeEnum(4, form_);
    }
    if (gender_ != com.google.cloud.language.v1.PartOfSpeech.Gender.GENDER_UNKNOWN.getNumber()) {
      output.writeEnum(5, gender_);
    }
    if (mood_ != com.google.cloud.language.v1.PartOfSpeech.Mood.MOOD_UNKNOWN.getNumber()) {
      output.writeEnum(6, mood_);
    }
    if (number_ != com.google.cloud.language.v1.PartOfSpeech.Number.NUMBER_UNKNOWN.getNumber()) {
      output.writeEnum(7, number_);
    }
    if (person_ != com.google.cloud.language.v1.PartOfSpeech.Person.PERSON_UNKNOWN.getNumber()) {
      output.writeEnum(8, person_);
    }
    if (proper_ != com.google.cloud.language.v1.PartOfSpeech.Proper.PROPER_UNKNOWN.getNumber()) {
      output.writeEnum(9, proper_);
    }
    if (reciprocity_
        != com.google.cloud.language.v1.PartOfSpeech.Reciprocity.RECIPROCITY_UNKNOWN.getNumber()) {
      output.writeEnum(10, reciprocity_);
    }
    if (tense_ != com.google.cloud.language.v1.PartOfSpeech.Tense.TENSE_UNKNOWN.getNumber()) {
      output.writeEnum(11, tense_);
    }
    if (voice_ != com.google.cloud.language.v1.PartOfSpeech.Voice.VOICE_UNKNOWN.getNumber()) {
      output.writeEnum(12, voice_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (tag_ != com.google.cloud.language.v1.PartOfSpeech.Tag.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, tag_);
    }
    if (aspect_ != com.google.cloud.language.v1.PartOfSpeech.Aspect.ASPECT_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, aspect_);
    }
    if (case_ != com.google.cloud.language.v1.PartOfSpeech.Case.CASE_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, case_);
    }
    if (form_ != com.google.cloud.language.v1.PartOfSpeech.Form.FORM_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, form_);
    }
    if (gender_ != com.google.cloud.language.v1.PartOfSpeech.Gender.GENDER_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, gender_);
    }
    if (mood_ != com.google.cloud.language.v1.PartOfSpeech.Mood.MOOD_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, mood_);
    }
    if (number_ != com.google.cloud.language.v1.PartOfSpeech.Number.NUMBER_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, number_);
    }
    if (person_ != com.google.cloud.language.v1.PartOfSpeech.Person.PERSON_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, person_);
    }
    if (proper_ != com.google.cloud.language.v1.PartOfSpeech.Proper.PROPER_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, proper_);
    }
    if (reciprocity_
        != com.google.cloud.language.v1.PartOfSpeech.Reciprocity.RECIPROCITY_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, reciprocity_);
    }
    if (tense_ != com.google.cloud.language.v1.PartOfSpeech.Tense.TENSE_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, tense_);
    }
    if (voice_ != com.google.cloud.language.v1.PartOfSpeech.Voice.VOICE_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, voice_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.language.v1.PartOfSpeech)) {
      return super.equals(obj);
    }
    com.google.cloud.language.v1.PartOfSpeech other =
        (com.google.cloud.language.v1.PartOfSpeech) obj;

    if (tag_ != other.tag_) return false;
    if (aspect_ != other.aspect_) return false;
    if (case_ != other.case_) return false;
    if (form_ != other.form_) return false;
    if (gender_ != other.gender_) return false;
    if (mood_ != other.mood_) return false;
    if (number_ != other.number_) return false;
    if (person_ != other.person_) return false;
    if (proper_ != other.proper_) return false;
    if (reciprocity_ != other.reciprocity_) return false;
    if (tense_ != other.tense_) return false;
    if (voice_ != other.voice_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TAG_FIELD_NUMBER;
    hash = (53 * hash) + tag_;
    hash = (37 * hash) + ASPECT_FIELD_NUMBER;
    hash = (53 * hash) + aspect_;
    hash = (37 * hash) + CASE_FIELD_NUMBER;
    hash = (53 * hash) + case_;
    hash = (37 * hash) + FORM_FIELD_NUMBER;
    hash = (53 * hash) + form_;
    hash = (37 * hash) + GENDER_FIELD_NUMBER;
    hash = (53 * hash) + gender_;
    hash = (37 * hash) + MOOD_FIELD_NUMBER;
    hash = (53 * hash) + mood_;
    hash = (37 * hash) + NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + number_;
    hash = (37 * hash) + PERSON_FIELD_NUMBER;
    hash = (53 * hash) + person_;
    hash = (37 * hash) + PROPER_FIELD_NUMBER;
    hash = (53 * hash) + proper_;
    hash = (37 * hash) + RECIPROCITY_FIELD_NUMBER;
    hash = (53 * hash) + reciprocity_;
    hash = (37 * hash) + TENSE_FIELD_NUMBER;
    hash = (53 * hash) + tense_;
    hash = (37 * hash) + VOICE_FIELD_NUMBER;
    hash = (53 * hash) + voice_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.PartOfSpeech parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.language.v1.PartOfSpeech prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents part of speech information for a token. Parts of speech
   * are as defined in
   * http://www.lrec-conf.org/proceedings/lrec2012/pdf/274_Paper.pdf
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1.PartOfSpeech}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.language.v1.PartOfSpeech)
      com.google.cloud.language.v1.PartOfSpeechOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_PartOfSpeech_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_PartOfSpeech_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1.PartOfSpeech.class,
              com.google.cloud.language.v1.PartOfSpeech.Builder.class);
    }

    // Construct using com.google.cloud.language.v1.PartOfSpeech.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      tag_ = 0;

      aspect_ = 0;

      case_ = 0;

      form_ = 0;

      gender_ = 0;

      mood_ = 0;

      number_ = 0;

      person_ = 0;

      proper_ = 0;

      reciprocity_ = 0;

      tense_ = 0;

      voice_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_PartOfSpeech_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.language.v1.PartOfSpeech getDefaultInstanceForType() {
      return com.google.cloud.language.v1.PartOfSpeech.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.language.v1.PartOfSpeech build() {
      com.google.cloud.language.v1.PartOfSpeech result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.language.v1.PartOfSpeech buildPartial() {
      com.google.cloud.language.v1.PartOfSpeech result =
          new com.google.cloud.language.v1.PartOfSpeech(this);
      result.tag_ = tag_;
      result.aspect_ = aspect_;
      result.case_ = case_;
      result.form_ = form_;
      result.gender_ = gender_;
      result.mood_ = mood_;
      result.number_ = number_;
      result.person_ = person_;
      result.proper_ = proper_;
      result.reciprocity_ = reciprocity_;
      result.tense_ = tense_;
      result.voice_ = voice_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.language.v1.PartOfSpeech) {
        return mergeFrom((com.google.cloud.language.v1.PartOfSpeech) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.language.v1.PartOfSpeech other) {
      if (other == com.google.cloud.language.v1.PartOfSpeech.getDefaultInstance()) return this;
      if (other.tag_ != 0) {
        setTagValue(other.getTagValue());
      }
      if (other.aspect_ != 0) {
        setAspectValue(other.getAspectValue());
      }
      if (other.case_ != 0) {
        setCaseValue(other.getCaseValue());
      }
      if (other.form_ != 0) {
        setFormValue(other.getFormValue());
      }
      if (other.gender_ != 0) {
        setGenderValue(other.getGenderValue());
      }
      if (other.mood_ != 0) {
        setMoodValue(other.getMoodValue());
      }
      if (other.number_ != 0) {
        setNumberValue(other.getNumberValue());
      }
      if (other.person_ != 0) {
        setPersonValue(other.getPersonValue());
      }
      if (other.proper_ != 0) {
        setProperValue(other.getProperValue());
      }
      if (other.reciprocity_ != 0) {
        setReciprocityValue(other.getReciprocityValue());
      }
      if (other.tense_ != 0) {
        setTenseValue(other.getTenseValue());
      }
      if (other.voice_ != 0) {
        setVoiceValue(other.getVoiceValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.language.v1.PartOfSpeech parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.language.v1.PartOfSpeech) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int tag_ = 0;
    /**
     *
     *
     * <pre>
     * The part of speech tag.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tag tag = 1;</code>
     *
     * @return The enum numeric value on the wire for tag.
     */
    public int getTagValue() {
      return tag_;
    }
    /**
     *
     *
     * <pre>
     * The part of speech tag.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tag tag = 1;</code>
     *
     * @param value The enum numeric value on the wire for tag to set.
     * @return This builder for chaining.
     */
    public Builder setTagValue(int value) {
      tag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The part of speech tag.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tag tag = 1;</code>
     *
     * @return The tag.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Tag getTag() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Tag result =
          com.google.cloud.language.v1.PartOfSpeech.Tag.valueOf(tag_);
      return result == null ? com.google.cloud.language.v1.PartOfSpeech.Tag.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The part of speech tag.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tag tag = 1;</code>
     *
     * @param value The tag to set.
     * @return This builder for chaining.
     */
    public Builder setTag(com.google.cloud.language.v1.PartOfSpeech.Tag value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tag_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The part of speech tag.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tag tag = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTag() {

      tag_ = 0;
      onChanged();
      return this;
    }

    private int aspect_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical aspect.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Aspect aspect = 2;</code>
     *
     * @return The enum numeric value on the wire for aspect.
     */
    public int getAspectValue() {
      return aspect_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical aspect.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Aspect aspect = 2;</code>
     *
     * @param value The enum numeric value on the wire for aspect to set.
     * @return This builder for chaining.
     */
    public Builder setAspectValue(int value) {
      aspect_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical aspect.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Aspect aspect = 2;</code>
     *
     * @return The aspect.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Aspect getAspect() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Aspect result =
          com.google.cloud.language.v1.PartOfSpeech.Aspect.valueOf(aspect_);
      return result == null
          ? com.google.cloud.language.v1.PartOfSpeech.Aspect.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical aspect.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Aspect aspect = 2;</code>
     *
     * @param value The aspect to set.
     * @return This builder for chaining.
     */
    public Builder setAspect(com.google.cloud.language.v1.PartOfSpeech.Aspect value) {
      if (value == null) {
        throw new NullPointerException();
      }

      aspect_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical aspect.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Aspect aspect = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAspect() {

      aspect_ = 0;
      onChanged();
      return this;
    }

    private int case_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical case.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Case case = 3;</code>
     *
     * @return The enum numeric value on the wire for case.
     */
    public int getCaseValue() {
      return case_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical case.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Case case = 3;</code>
     *
     * @param value The enum numeric value on the wire for case to set.
     * @return This builder for chaining.
     */
    public Builder setCaseValue(int value) {
      case_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical case.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Case case = 3;</code>
     *
     * @return The case.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Case getCase() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Case result =
          com.google.cloud.language.v1.PartOfSpeech.Case.valueOf(case_);
      return result == null ? com.google.cloud.language.v1.PartOfSpeech.Case.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical case.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Case case = 3;</code>
     *
     * @param value The case to set.
     * @return This builder for chaining.
     */
    public Builder setCase(com.google.cloud.language.v1.PartOfSpeech.Case value) {
      if (value == null) {
        throw new NullPointerException();
      }

      case_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical case.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Case case = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCase() {

      case_ = 0;
      onChanged();
      return this;
    }

    private int form_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical form.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Form form = 4;</code>
     *
     * @return The enum numeric value on the wire for form.
     */
    public int getFormValue() {
      return form_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical form.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Form form = 4;</code>
     *
     * @param value The enum numeric value on the wire for form to set.
     * @return This builder for chaining.
     */
    public Builder setFormValue(int value) {
      form_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical form.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Form form = 4;</code>
     *
     * @return The form.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Form getForm() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Form result =
          com.google.cloud.language.v1.PartOfSpeech.Form.valueOf(form_);
      return result == null ? com.google.cloud.language.v1.PartOfSpeech.Form.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical form.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Form form = 4;</code>
     *
     * @param value The form to set.
     * @return This builder for chaining.
     */
    public Builder setForm(com.google.cloud.language.v1.PartOfSpeech.Form value) {
      if (value == null) {
        throw new NullPointerException();
      }

      form_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical form.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Form form = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForm() {

      form_ = 0;
      onChanged();
      return this;
    }

    private int gender_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical gender.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Gender gender = 5;</code>
     *
     * @return The enum numeric value on the wire for gender.
     */
    public int getGenderValue() {
      return gender_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical gender.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Gender gender = 5;</code>
     *
     * @param value The enum numeric value on the wire for gender to set.
     * @return This builder for chaining.
     */
    public Builder setGenderValue(int value) {
      gender_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical gender.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Gender gender = 5;</code>
     *
     * @return The gender.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Gender getGender() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Gender result =
          com.google.cloud.language.v1.PartOfSpeech.Gender.valueOf(gender_);
      return result == null
          ? com.google.cloud.language.v1.PartOfSpeech.Gender.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical gender.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Gender gender = 5;</code>
     *
     * @param value The gender to set.
     * @return This builder for chaining.
     */
    public Builder setGender(com.google.cloud.language.v1.PartOfSpeech.Gender value) {
      if (value == null) {
        throw new NullPointerException();
      }

      gender_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical gender.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Gender gender = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGender() {

      gender_ = 0;
      onChanged();
      return this;
    }

    private int mood_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical mood.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Mood mood = 6;</code>
     *
     * @return The enum numeric value on the wire for mood.
     */
    public int getMoodValue() {
      return mood_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical mood.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Mood mood = 6;</code>
     *
     * @param value The enum numeric value on the wire for mood to set.
     * @return This builder for chaining.
     */
    public Builder setMoodValue(int value) {
      mood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical mood.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Mood mood = 6;</code>
     *
     * @return The mood.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Mood getMood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Mood result =
          com.google.cloud.language.v1.PartOfSpeech.Mood.valueOf(mood_);
      return result == null ? com.google.cloud.language.v1.PartOfSpeech.Mood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical mood.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Mood mood = 6;</code>
     *
     * @param value The mood to set.
     * @return This builder for chaining.
     */
    public Builder setMood(com.google.cloud.language.v1.PartOfSpeech.Mood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      mood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical mood.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Mood mood = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMood() {

      mood_ = 0;
      onChanged();
      return this;
    }

    private int number_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical number.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Number number = 7;</code>
     *
     * @return The enum numeric value on the wire for number.
     */
    public int getNumberValue() {
      return number_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical number.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Number number = 7;</code>
     *
     * @param value The enum numeric value on the wire for number to set.
     * @return This builder for chaining.
     */
    public Builder setNumberValue(int value) {
      number_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical number.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Number number = 7;</code>
     *
     * @return The number.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Number getNumber() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Number result =
          com.google.cloud.language.v1.PartOfSpeech.Number.valueOf(number_);
      return result == null
          ? com.google.cloud.language.v1.PartOfSpeech.Number.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical number.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Number number = 7;</code>
     *
     * @param value The number to set.
     * @return This builder for chaining.
     */
    public Builder setNumber(com.google.cloud.language.v1.PartOfSpeech.Number value) {
      if (value == null) {
        throw new NullPointerException();
      }

      number_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical number.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Number number = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumber() {

      number_ = 0;
      onChanged();
      return this;
    }

    private int person_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical person.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Person person = 8;</code>
     *
     * @return The enum numeric value on the wire for person.
     */
    public int getPersonValue() {
      return person_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical person.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Person person = 8;</code>
     *
     * @param value The enum numeric value on the wire for person to set.
     * @return This builder for chaining.
     */
    public Builder setPersonValue(int value) {
      person_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical person.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Person person = 8;</code>
     *
     * @return The person.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Person getPerson() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Person result =
          com.google.cloud.language.v1.PartOfSpeech.Person.valueOf(person_);
      return result == null
          ? com.google.cloud.language.v1.PartOfSpeech.Person.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical person.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Person person = 8;</code>
     *
     * @param value The person to set.
     * @return This builder for chaining.
     */
    public Builder setPerson(com.google.cloud.language.v1.PartOfSpeech.Person value) {
      if (value == null) {
        throw new NullPointerException();
      }

      person_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical person.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Person person = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPerson() {

      person_ = 0;
      onChanged();
      return this;
    }

    private int proper_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical properness.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Proper proper = 9;</code>
     *
     * @return The enum numeric value on the wire for proper.
     */
    public int getProperValue() {
      return proper_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical properness.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Proper proper = 9;</code>
     *
     * @param value The enum numeric value on the wire for proper to set.
     * @return This builder for chaining.
     */
    public Builder setProperValue(int value) {
      proper_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical properness.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Proper proper = 9;</code>
     *
     * @return The proper.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Proper getProper() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Proper result =
          com.google.cloud.language.v1.PartOfSpeech.Proper.valueOf(proper_);
      return result == null
          ? com.google.cloud.language.v1.PartOfSpeech.Proper.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical properness.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Proper proper = 9;</code>
     *
     * @param value The proper to set.
     * @return This builder for chaining.
     */
    public Builder setProper(com.google.cloud.language.v1.PartOfSpeech.Proper value) {
      if (value == null) {
        throw new NullPointerException();
      }

      proper_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical properness.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Proper proper = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProper() {

      proper_ = 0;
      onChanged();
      return this;
    }

    private int reciprocity_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical reciprocity.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Reciprocity reciprocity = 10;</code>
     *
     * @return The enum numeric value on the wire for reciprocity.
     */
    public int getReciprocityValue() {
      return reciprocity_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical reciprocity.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Reciprocity reciprocity = 10;</code>
     *
     * @param value The enum numeric value on the wire for reciprocity to set.
     * @return This builder for chaining.
     */
    public Builder setReciprocityValue(int value) {
      reciprocity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical reciprocity.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Reciprocity reciprocity = 10;</code>
     *
     * @return The reciprocity.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Reciprocity getReciprocity() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Reciprocity result =
          com.google.cloud.language.v1.PartOfSpeech.Reciprocity.valueOf(reciprocity_);
      return result == null
          ? com.google.cloud.language.v1.PartOfSpeech.Reciprocity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical reciprocity.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Reciprocity reciprocity = 10;</code>
     *
     * @param value The reciprocity to set.
     * @return This builder for chaining.
     */
    public Builder setReciprocity(com.google.cloud.language.v1.PartOfSpeech.Reciprocity value) {
      if (value == null) {
        throw new NullPointerException();
      }

      reciprocity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical reciprocity.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Reciprocity reciprocity = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReciprocity() {

      reciprocity_ = 0;
      onChanged();
      return this;
    }

    private int tense_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical tense.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tense tense = 11;</code>
     *
     * @return The enum numeric value on the wire for tense.
     */
    public int getTenseValue() {
      return tense_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical tense.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tense tense = 11;</code>
     *
     * @param value The enum numeric value on the wire for tense to set.
     * @return This builder for chaining.
     */
    public Builder setTenseValue(int value) {
      tense_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical tense.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tense tense = 11;</code>
     *
     * @return The tense.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Tense getTense() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Tense result =
          com.google.cloud.language.v1.PartOfSpeech.Tense.valueOf(tense_);
      return result == null ? com.google.cloud.language.v1.PartOfSpeech.Tense.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical tense.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tense tense = 11;</code>
     *
     * @param value The tense to set.
     * @return This builder for chaining.
     */
    public Builder setTense(com.google.cloud.language.v1.PartOfSpeech.Tense value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tense_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical tense.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Tense tense = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTense() {

      tense_ = 0;
      onChanged();
      return this;
    }

    private int voice_ = 0;
    /**
     *
     *
     * <pre>
     * The grammatical voice.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Voice voice = 12;</code>
     *
     * @return The enum numeric value on the wire for voice.
     */
    public int getVoiceValue() {
      return voice_;
    }
    /**
     *
     *
     * <pre>
     * The grammatical voice.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Voice voice = 12;</code>
     *
     * @param value The enum numeric value on the wire for voice to set.
     * @return This builder for chaining.
     */
    public Builder setVoiceValue(int value) {
      voice_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical voice.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Voice voice = 12;</code>
     *
     * @return The voice.
     */
    public com.google.cloud.language.v1.PartOfSpeech.Voice getVoice() {
      @SuppressWarnings("deprecation")
      com.google.cloud.language.v1.PartOfSpeech.Voice result =
          com.google.cloud.language.v1.PartOfSpeech.Voice.valueOf(voice_);
      return result == null ? com.google.cloud.language.v1.PartOfSpeech.Voice.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The grammatical voice.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Voice voice = 12;</code>
     *
     * @param value The voice to set.
     * @return This builder for chaining.
     */
    public Builder setVoice(com.google.cloud.language.v1.PartOfSpeech.Voice value) {
      if (value == null) {
        throw new NullPointerException();
      }

      voice_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The grammatical voice.
     * </pre>
     *
     * <code>.google.cloud.language.v1.PartOfSpeech.Voice voice = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVoice() {

      voice_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.language.v1.PartOfSpeech)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.language.v1.PartOfSpeech)
  private static final com.google.cloud.language.v1.PartOfSpeech DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.language.v1.PartOfSpeech();
  }

  public static com.google.cloud.language.v1.PartOfSpeech getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartOfSpeech> PARSER =
      new com.google.protobuf.AbstractParser<PartOfSpeech>() {
        @java.lang.Override
        public PartOfSpeech parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PartOfSpeech(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PartOfSpeech> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartOfSpeech> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.language.v1.PartOfSpeech getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
