/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/language/v1/language_service.proto

package com.google.cloud.language.v1;

/**
 *
 *
 * <pre>
 * The text annotations response message.
 * </pre>
 *
 * Protobuf type {@code google.cloud.language.v1.AnnotateTextResponse}
 */
public final class AnnotateTextResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.language.v1.AnnotateTextResponse)
    AnnotateTextResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotateTextResponse.newBuilder() to construct.
  private AnnotateTextResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotateTextResponse() {
    sentences_ = java.util.Collections.emptyList();
    tokens_ = java.util.Collections.emptyList();
    entities_ = java.util.Collections.emptyList();
    language_ = "";
    categories_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotateTextResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnnotateTextResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                sentences_ = new java.util.ArrayList<com.google.cloud.language.v1.Sentence>();
                mutable_bitField0_ |= 0x00000001;
              }
              sentences_.add(
                  input.readMessage(
                      com.google.cloud.language.v1.Sentence.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                tokens_ = new java.util.ArrayList<com.google.cloud.language.v1.Token>();
                mutable_bitField0_ |= 0x00000002;
              }
              tokens_.add(
                  input.readMessage(
                      com.google.cloud.language.v1.Token.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                entities_ = new java.util.ArrayList<com.google.cloud.language.v1.Entity>();
                mutable_bitField0_ |= 0x00000004;
              }
              entities_.add(
                  input.readMessage(
                      com.google.cloud.language.v1.Entity.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              com.google.cloud.language.v1.Sentiment.Builder subBuilder = null;
              if (documentSentiment_ != null) {
                subBuilder = documentSentiment_.toBuilder();
              }
              documentSentiment_ =
                  input.readMessage(
                      com.google.cloud.language.v1.Sentiment.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(documentSentiment_);
                documentSentiment_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              language_ = s;
              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                categories_ =
                    new java.util.ArrayList<com.google.cloud.language.v1.ClassificationCategory>();
                mutable_bitField0_ |= 0x00000008;
              }
              categories_.add(
                  input.readMessage(
                      com.google.cloud.language.v1.ClassificationCategory.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        sentences_ = java.util.Collections.unmodifiableList(sentences_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        tokens_ = java.util.Collections.unmodifiableList(tokens_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        entities_ = java.util.Collections.unmodifiableList(entities_);
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        categories_ = java.util.Collections.unmodifiableList(categories_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.language.v1.LanguageServiceProto
        .internal_static_google_cloud_language_v1_AnnotateTextResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.language.v1.LanguageServiceProto
        .internal_static_google_cloud_language_v1_AnnotateTextResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.language.v1.AnnotateTextResponse.class,
            com.google.cloud.language.v1.AnnotateTextResponse.Builder.class);
  }

  public static final int SENTENCES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.language.v1.Sentence> sentences_;
  /**
   *
   *
   * <pre>
   * Sentences in the input document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.language.v1.Sentence> getSentencesList() {
    return sentences_;
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.language.v1.SentenceOrBuilder>
      getSentencesOrBuilderList() {
    return sentences_;
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public int getSentencesCount() {
    return sentences_.size();
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.Sentence getSentences(int index) {
    return sentences_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.SentenceOrBuilder getSentencesOrBuilder(int index) {
    return sentences_.get(index);
  }

  public static final int TOKENS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.language.v1.Token> tokens_;
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.language.v1.Token> getTokensList() {
    return tokens_;
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.language.v1.TokenOrBuilder>
      getTokensOrBuilderList() {
    return tokens_;
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
   */
  @java.lang.Override
  public int getTokensCount() {
    return tokens_.size();
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.Token getTokens(int index) {
    return tokens_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.TokenOrBuilder getTokensOrBuilder(int index) {
    return tokens_.get(index);
  }

  public static final int ENTITIES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.language.v1.Entity> entities_;
  /**
   *
   *
   * <pre>
   * Entities, along with their semantic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.language.v1.Entity> getEntitiesList() {
    return entities_;
  }
  /**
   *
   *
   * <pre>
   * Entities, along with their semantic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.language.v1.EntityOrBuilder>
      getEntitiesOrBuilderList() {
    return entities_;
  }
  /**
   *
   *
   * <pre>
   * Entities, along with their semantic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
   */
  @java.lang.Override
  public int getEntitiesCount() {
    return entities_.size();
  }
  /**
   *
   *
   * <pre>
   * Entities, along with their semantic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.Entity getEntities(int index) {
    return entities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Entities, along with their semantic information, in the input document.
   * Populated if the user enables
   * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.EntityOrBuilder getEntitiesOrBuilder(int index) {
    return entities_.get(index);
  }

  public static final int DOCUMENT_SENTIMENT_FIELD_NUMBER = 4;
  private com.google.cloud.language.v1.Sentiment documentSentiment_;
  /**
   *
   *
   * <pre>
   * The overall sentiment for the document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
   * </pre>
   *
   * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
   *
   * @return Whether the documentSentiment field is set.
   */
  @java.lang.Override
  public boolean hasDocumentSentiment() {
    return documentSentiment_ != null;
  }
  /**
   *
   *
   * <pre>
   * The overall sentiment for the document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
   * </pre>
   *
   * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
   *
   * @return The documentSentiment.
   */
  @java.lang.Override
  public com.google.cloud.language.v1.Sentiment getDocumentSentiment() {
    return documentSentiment_ == null
        ? com.google.cloud.language.v1.Sentiment.getDefaultInstance()
        : documentSentiment_;
  }
  /**
   *
   *
   * <pre>
   * The overall sentiment for the document. Populated if the user enables
   * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
   * </pre>
   *
   * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.SentimentOrBuilder getDocumentSentimentOrBuilder() {
    return getDocumentSentiment();
  }

  public static final int LANGUAGE_FIELD_NUMBER = 5;
  private volatile java.lang.Object language_;
  /**
   *
   *
   * <pre>
   * The language of the text, which will be the same as the language specified
   * in the request or, if not specified, the automatically-detected language.
   * See [Document.language][google.cloud.language.v1.Document.language] field for more details.
   * </pre>
   *
   * <code>string language = 5;</code>
   *
   * @return The language.
   */
  @java.lang.Override
  public java.lang.String getLanguage() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      language_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language of the text, which will be the same as the language specified
   * in the request or, if not specified, the automatically-detected language.
   * See [Document.language][google.cloud.language.v1.Document.language] field for more details.
   * </pre>
   *
   * <code>string language = 5;</code>
   *
   * @return The bytes for language.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageBytes() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      language_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORIES_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.language.v1.ClassificationCategory> categories_;
  /**
   *
   *
   * <pre>
   * Categories identified in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.language.v1.ClassificationCategory> getCategoriesList() {
    return categories_;
  }
  /**
   *
   *
   * <pre>
   * Categories identified in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.language.v1.ClassificationCategoryOrBuilder>
      getCategoriesOrBuilderList() {
    return categories_;
  }
  /**
   *
   *
   * <pre>
   * Categories identified in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
   */
  @java.lang.Override
  public int getCategoriesCount() {
    return categories_.size();
  }
  /**
   *
   *
   * <pre>
   * Categories identified in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.ClassificationCategory getCategories(int index) {
    return categories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Categories identified in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1.ClassificationCategoryOrBuilder getCategoriesOrBuilder(
      int index) {
    return categories_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < sentences_.size(); i++) {
      output.writeMessage(1, sentences_.get(i));
    }
    for (int i = 0; i < tokens_.size(); i++) {
      output.writeMessage(2, tokens_.get(i));
    }
    for (int i = 0; i < entities_.size(); i++) {
      output.writeMessage(3, entities_.get(i));
    }
    if (documentSentiment_ != null) {
      output.writeMessage(4, getDocumentSentiment());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(language_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, language_);
    }
    for (int i = 0; i < categories_.size(); i++) {
      output.writeMessage(6, categories_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < sentences_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, sentences_.get(i));
    }
    for (int i = 0; i < tokens_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, tokens_.get(i));
    }
    for (int i = 0; i < entities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, entities_.get(i));
    }
    if (documentSentiment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDocumentSentiment());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(language_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, language_);
    }
    for (int i = 0; i < categories_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, categories_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.language.v1.AnnotateTextResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.language.v1.AnnotateTextResponse other =
        (com.google.cloud.language.v1.AnnotateTextResponse) obj;

    if (!getSentencesList().equals(other.getSentencesList())) return false;
    if (!getTokensList().equals(other.getTokensList())) return false;
    if (!getEntitiesList().equals(other.getEntitiesList())) return false;
    if (hasDocumentSentiment() != other.hasDocumentSentiment()) return false;
    if (hasDocumentSentiment()) {
      if (!getDocumentSentiment().equals(other.getDocumentSentiment())) return false;
    }
    if (!getLanguage().equals(other.getLanguage())) return false;
    if (!getCategoriesList().equals(other.getCategoriesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSentencesCount() > 0) {
      hash = (37 * hash) + SENTENCES_FIELD_NUMBER;
      hash = (53 * hash) + getSentencesList().hashCode();
    }
    if (getTokensCount() > 0) {
      hash = (37 * hash) + TOKENS_FIELD_NUMBER;
      hash = (53 * hash) + getTokensList().hashCode();
    }
    if (getEntitiesCount() > 0) {
      hash = (37 * hash) + ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntitiesList().hashCode();
    }
    if (hasDocumentSentiment()) {
      hash = (37 * hash) + DOCUMENT_SENTIMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentSentiment().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguage().hashCode();
    if (getCategoriesCount() > 0) {
      hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + getCategoriesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.language.v1.AnnotateTextResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The text annotations response message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1.AnnotateTextResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.language.v1.AnnotateTextResponse)
      com.google.cloud.language.v1.AnnotateTextResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_AnnotateTextResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_AnnotateTextResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1.AnnotateTextResponse.class,
              com.google.cloud.language.v1.AnnotateTextResponse.Builder.class);
    }

    // Construct using com.google.cloud.language.v1.AnnotateTextResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSentencesFieldBuilder();
        getTokensFieldBuilder();
        getEntitiesFieldBuilder();
        getCategoriesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (sentencesBuilder_ == null) {
        sentences_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        sentencesBuilder_.clear();
      }
      if (tokensBuilder_ == null) {
        tokens_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        tokensBuilder_.clear();
      }
      if (entitiesBuilder_ == null) {
        entities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        entitiesBuilder_.clear();
      }
      if (documentSentimentBuilder_ == null) {
        documentSentiment_ = null;
      } else {
        documentSentiment_ = null;
        documentSentimentBuilder_ = null;
      }
      language_ = "";

      if (categoriesBuilder_ == null) {
        categories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        categoriesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_AnnotateTextResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.language.v1.AnnotateTextResponse getDefaultInstanceForType() {
      return com.google.cloud.language.v1.AnnotateTextResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.language.v1.AnnotateTextResponse build() {
      com.google.cloud.language.v1.AnnotateTextResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.language.v1.AnnotateTextResponse buildPartial() {
      com.google.cloud.language.v1.AnnotateTextResponse result =
          new com.google.cloud.language.v1.AnnotateTextResponse(this);
      int from_bitField0_ = bitField0_;
      if (sentencesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          sentences_ = java.util.Collections.unmodifiableList(sentences_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.sentences_ = sentences_;
      } else {
        result.sentences_ = sentencesBuilder_.build();
      }
      if (tokensBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          tokens_ = java.util.Collections.unmodifiableList(tokens_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.tokens_ = tokens_;
      } else {
        result.tokens_ = tokensBuilder_.build();
      }
      if (entitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          entities_ = java.util.Collections.unmodifiableList(entities_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.entities_ = entities_;
      } else {
        result.entities_ = entitiesBuilder_.build();
      }
      if (documentSentimentBuilder_ == null) {
        result.documentSentiment_ = documentSentiment_;
      } else {
        result.documentSentiment_ = documentSentimentBuilder_.build();
      }
      result.language_ = language_;
      if (categoriesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          categories_ = java.util.Collections.unmodifiableList(categories_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.categories_ = categories_;
      } else {
        result.categories_ = categoriesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.language.v1.AnnotateTextResponse) {
        return mergeFrom((com.google.cloud.language.v1.AnnotateTextResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.language.v1.AnnotateTextResponse other) {
      if (other == com.google.cloud.language.v1.AnnotateTextResponse.getDefaultInstance())
        return this;
      if (sentencesBuilder_ == null) {
        if (!other.sentences_.isEmpty()) {
          if (sentences_.isEmpty()) {
            sentences_ = other.sentences_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSentencesIsMutable();
            sentences_.addAll(other.sentences_);
          }
          onChanged();
        }
      } else {
        if (!other.sentences_.isEmpty()) {
          if (sentencesBuilder_.isEmpty()) {
            sentencesBuilder_.dispose();
            sentencesBuilder_ = null;
            sentences_ = other.sentences_;
            bitField0_ = (bitField0_ & ~0x00000001);
            sentencesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSentencesFieldBuilder()
                    : null;
          } else {
            sentencesBuilder_.addAllMessages(other.sentences_);
          }
        }
      }
      if (tokensBuilder_ == null) {
        if (!other.tokens_.isEmpty()) {
          if (tokens_.isEmpty()) {
            tokens_ = other.tokens_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTokensIsMutable();
            tokens_.addAll(other.tokens_);
          }
          onChanged();
        }
      } else {
        if (!other.tokens_.isEmpty()) {
          if (tokensBuilder_.isEmpty()) {
            tokensBuilder_.dispose();
            tokensBuilder_ = null;
            tokens_ = other.tokens_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tokensBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTokensFieldBuilder()
                    : null;
          } else {
            tokensBuilder_.addAllMessages(other.tokens_);
          }
        }
      }
      if (entitiesBuilder_ == null) {
        if (!other.entities_.isEmpty()) {
          if (entities_.isEmpty()) {
            entities_ = other.entities_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEntitiesIsMutable();
            entities_.addAll(other.entities_);
          }
          onChanged();
        }
      } else {
        if (!other.entities_.isEmpty()) {
          if (entitiesBuilder_.isEmpty()) {
            entitiesBuilder_.dispose();
            entitiesBuilder_ = null;
            entities_ = other.entities_;
            bitField0_ = (bitField0_ & ~0x00000004);
            entitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntitiesFieldBuilder()
                    : null;
          } else {
            entitiesBuilder_.addAllMessages(other.entities_);
          }
        }
      }
      if (other.hasDocumentSentiment()) {
        mergeDocumentSentiment(other.getDocumentSentiment());
      }
      if (!other.getLanguage().isEmpty()) {
        language_ = other.language_;
        onChanged();
      }
      if (categoriesBuilder_ == null) {
        if (!other.categories_.isEmpty()) {
          if (categories_.isEmpty()) {
            categories_ = other.categories_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureCategoriesIsMutable();
            categories_.addAll(other.categories_);
          }
          onChanged();
        }
      } else {
        if (!other.categories_.isEmpty()) {
          if (categoriesBuilder_.isEmpty()) {
            categoriesBuilder_.dispose();
            categoriesBuilder_ = null;
            categories_ = other.categories_;
            bitField0_ = (bitField0_ & ~0x00000008);
            categoriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCategoriesFieldBuilder()
                    : null;
          } else {
            categoriesBuilder_.addAllMessages(other.categories_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.language.v1.AnnotateTextResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.language.v1.AnnotateTextResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.language.v1.Sentence> sentences_ =
        java.util.Collections.emptyList();

    private void ensureSentencesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sentences_ = new java.util.ArrayList<com.google.cloud.language.v1.Sentence>(sentences_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.Sentence,
            com.google.cloud.language.v1.Sentence.Builder,
            com.google.cloud.language.v1.SentenceOrBuilder>
        sentencesBuilder_;

    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public java.util.List<com.google.cloud.language.v1.Sentence> getSentencesList() {
      if (sentencesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sentences_);
      } else {
        return sentencesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public int getSentencesCount() {
      if (sentencesBuilder_ == null) {
        return sentences_.size();
      } else {
        return sentencesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1.Sentence getSentences(int index) {
      if (sentencesBuilder_ == null) {
        return sentences_.get(index);
      } else {
        return sentencesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder setSentences(int index, com.google.cloud.language.v1.Sentence value) {
      if (sentencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSentencesIsMutable();
        sentences_.set(index, value);
        onChanged();
      } else {
        sentencesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder setSentences(
        int index, com.google.cloud.language.v1.Sentence.Builder builderForValue) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.set(index, builderForValue.build());
        onChanged();
      } else {
        sentencesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder addSentences(com.google.cloud.language.v1.Sentence value) {
      if (sentencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSentencesIsMutable();
        sentences_.add(value);
        onChanged();
      } else {
        sentencesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder addSentences(int index, com.google.cloud.language.v1.Sentence value) {
      if (sentencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSentencesIsMutable();
        sentences_.add(index, value);
        onChanged();
      } else {
        sentencesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder addSentences(com.google.cloud.language.v1.Sentence.Builder builderForValue) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.add(builderForValue.build());
        onChanged();
      } else {
        sentencesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder addSentences(
        int index, com.google.cloud.language.v1.Sentence.Builder builderForValue) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.add(index, builderForValue.build());
        onChanged();
      } else {
        sentencesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder addAllSentences(
        java.lang.Iterable<? extends com.google.cloud.language.v1.Sentence> values) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sentences_);
        onChanged();
      } else {
        sentencesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder clearSentences() {
      if (sentencesBuilder_ == null) {
        sentences_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        sentencesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public Builder removeSentences(int index) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.remove(index);
        onChanged();
      } else {
        sentencesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1.Sentence.Builder getSentencesBuilder(int index) {
      return getSentencesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1.SentenceOrBuilder getSentencesOrBuilder(int index) {
      if (sentencesBuilder_ == null) {
        return sentences_.get(index);
      } else {
        return sentencesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.language.v1.SentenceOrBuilder>
        getSentencesOrBuilderList() {
      if (sentencesBuilder_ != null) {
        return sentencesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sentences_);
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1.Sentence.Builder addSentencesBuilder() {
      return getSentencesFieldBuilder()
          .addBuilder(com.google.cloud.language.v1.Sentence.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1.Sentence.Builder addSentencesBuilder(int index) {
      return getSentencesFieldBuilder()
          .addBuilder(index, com.google.cloud.language.v1.Sentence.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Sentence sentences = 1;</code>
     */
    public java.util.List<com.google.cloud.language.v1.Sentence.Builder> getSentencesBuilderList() {
      return getSentencesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.Sentence,
            com.google.cloud.language.v1.Sentence.Builder,
            com.google.cloud.language.v1.SentenceOrBuilder>
        getSentencesFieldBuilder() {
      if (sentencesBuilder_ == null) {
        sentencesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.language.v1.Sentence,
                com.google.cloud.language.v1.Sentence.Builder,
                com.google.cloud.language.v1.SentenceOrBuilder>(
                sentences_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        sentences_ = null;
      }
      return sentencesBuilder_;
    }

    private java.util.List<com.google.cloud.language.v1.Token> tokens_ =
        java.util.Collections.emptyList();

    private void ensureTokensIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        tokens_ = new java.util.ArrayList<com.google.cloud.language.v1.Token>(tokens_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.Token,
            com.google.cloud.language.v1.Token.Builder,
            com.google.cloud.language.v1.TokenOrBuilder>
        tokensBuilder_;

    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public java.util.List<com.google.cloud.language.v1.Token> getTokensList() {
      if (tokensBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tokens_);
      } else {
        return tokensBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public int getTokensCount() {
      if (tokensBuilder_ == null) {
        return tokens_.size();
      } else {
        return tokensBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1.Token getTokens(int index) {
      if (tokensBuilder_ == null) {
        return tokens_.get(index);
      } else {
        return tokensBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder setTokens(int index, com.google.cloud.language.v1.Token value) {
      if (tokensBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTokensIsMutable();
        tokens_.set(index, value);
        onChanged();
      } else {
        tokensBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder setTokens(
        int index, com.google.cloud.language.v1.Token.Builder builderForValue) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.set(index, builderForValue.build());
        onChanged();
      } else {
        tokensBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder addTokens(com.google.cloud.language.v1.Token value) {
      if (tokensBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTokensIsMutable();
        tokens_.add(value);
        onChanged();
      } else {
        tokensBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder addTokens(int index, com.google.cloud.language.v1.Token value) {
      if (tokensBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTokensIsMutable();
        tokens_.add(index, value);
        onChanged();
      } else {
        tokensBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder addTokens(com.google.cloud.language.v1.Token.Builder builderForValue) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.add(builderForValue.build());
        onChanged();
      } else {
        tokensBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder addTokens(
        int index, com.google.cloud.language.v1.Token.Builder builderForValue) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.add(index, builderForValue.build());
        onChanged();
      } else {
        tokensBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder addAllTokens(
        java.lang.Iterable<? extends com.google.cloud.language.v1.Token> values) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tokens_);
        onChanged();
      } else {
        tokensBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder clearTokens() {
      if (tokensBuilder_ == null) {
        tokens_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tokensBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public Builder removeTokens(int index) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.remove(index);
        onChanged();
      } else {
        tokensBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1.Token.Builder getTokensBuilder(int index) {
      return getTokensFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1.TokenOrBuilder getTokensOrBuilder(int index) {
      if (tokensBuilder_ == null) {
        return tokens_.get(index);
      } else {
        return tokensBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.language.v1.TokenOrBuilder>
        getTokensOrBuilderList() {
      if (tokensBuilder_ != null) {
        return tokensBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tokens_);
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1.Token.Builder addTokensBuilder() {
      return getTokensFieldBuilder()
          .addBuilder(com.google.cloud.language.v1.Token.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1.Token.Builder addTokensBuilder(int index) {
      return getTokensFieldBuilder()
          .addBuilder(index, com.google.cloud.language.v1.Token.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1.AnnotateTextRequest.Features.extract_syntax].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Token tokens = 2;</code>
     */
    public java.util.List<com.google.cloud.language.v1.Token.Builder> getTokensBuilderList() {
      return getTokensFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.Token,
            com.google.cloud.language.v1.Token.Builder,
            com.google.cloud.language.v1.TokenOrBuilder>
        getTokensFieldBuilder() {
      if (tokensBuilder_ == null) {
        tokensBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.language.v1.Token,
                com.google.cloud.language.v1.Token.Builder,
                com.google.cloud.language.v1.TokenOrBuilder>(
                tokens_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        tokens_ = null;
      }
      return tokensBuilder_;
    }

    private java.util.List<com.google.cloud.language.v1.Entity> entities_ =
        java.util.Collections.emptyList();

    private void ensureEntitiesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        entities_ = new java.util.ArrayList<com.google.cloud.language.v1.Entity>(entities_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.Entity,
            com.google.cloud.language.v1.Entity.Builder,
            com.google.cloud.language.v1.EntityOrBuilder>
        entitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public java.util.List<com.google.cloud.language.v1.Entity> getEntitiesList() {
      if (entitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entities_);
      } else {
        return entitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public int getEntitiesCount() {
      if (entitiesBuilder_ == null) {
        return entities_.size();
      } else {
        return entitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public com.google.cloud.language.v1.Entity getEntities(int index) {
      if (entitiesBuilder_ == null) {
        return entities_.get(index);
      } else {
        return entitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder setEntities(int index, com.google.cloud.language.v1.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.set(index, value);
        onChanged();
      } else {
        entitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder setEntities(
        int index, com.google.cloud.language.v1.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.set(index, builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder addEntities(com.google.cloud.language.v1.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.add(value);
        onChanged();
      } else {
        entitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder addEntities(int index, com.google.cloud.language.v1.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.add(index, value);
        onChanged();
      } else {
        entitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder addEntities(com.google.cloud.language.v1.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.add(builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder addEntities(
        int index, com.google.cloud.language.v1.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.add(index, builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder addAllEntities(
        java.lang.Iterable<? extends com.google.cloud.language.v1.Entity> values) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entities_);
        onChanged();
      } else {
        entitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder clearEntities() {
      if (entitiesBuilder_ == null) {
        entities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        entitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public Builder removeEntities(int index) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.remove(index);
        onChanged();
      } else {
        entitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public com.google.cloud.language.v1.Entity.Builder getEntitiesBuilder(int index) {
      return getEntitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public com.google.cloud.language.v1.EntityOrBuilder getEntitiesOrBuilder(int index) {
      if (entitiesBuilder_ == null) {
        return entities_.get(index);
      } else {
        return entitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.language.v1.EntityOrBuilder>
        getEntitiesOrBuilderList() {
      if (entitiesBuilder_ != null) {
        return entitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public com.google.cloud.language.v1.Entity.Builder addEntitiesBuilder() {
      return getEntitiesFieldBuilder()
          .addBuilder(com.google.cloud.language.v1.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public com.google.cloud.language.v1.Entity.Builder addEntitiesBuilder(int index) {
      return getEntitiesFieldBuilder()
          .addBuilder(index, com.google.cloud.language.v1.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Entities, along with their semantic information, in the input document.
     * Populated if the user enables
     * [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entities].
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.Entity entities = 3;</code>
     */
    public java.util.List<com.google.cloud.language.v1.Entity.Builder> getEntitiesBuilderList() {
      return getEntitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.Entity,
            com.google.cloud.language.v1.Entity.Builder,
            com.google.cloud.language.v1.EntityOrBuilder>
        getEntitiesFieldBuilder() {
      if (entitiesBuilder_ == null) {
        entitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.language.v1.Entity,
                com.google.cloud.language.v1.Entity.Builder,
                com.google.cloud.language.v1.EntityOrBuilder>(
                entities_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        entities_ = null;
      }
      return entitiesBuilder_;
    }

    private com.google.cloud.language.v1.Sentiment documentSentiment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1.Sentiment,
            com.google.cloud.language.v1.Sentiment.Builder,
            com.google.cloud.language.v1.SentimentOrBuilder>
        documentSentimentBuilder_;
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     *
     * @return Whether the documentSentiment field is set.
     */
    public boolean hasDocumentSentiment() {
      return documentSentimentBuilder_ != null || documentSentiment_ != null;
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     *
     * @return The documentSentiment.
     */
    public com.google.cloud.language.v1.Sentiment getDocumentSentiment() {
      if (documentSentimentBuilder_ == null) {
        return documentSentiment_ == null
            ? com.google.cloud.language.v1.Sentiment.getDefaultInstance()
            : documentSentiment_;
      } else {
        return documentSentimentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     */
    public Builder setDocumentSentiment(com.google.cloud.language.v1.Sentiment value) {
      if (documentSentimentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentSentiment_ = value;
        onChanged();
      } else {
        documentSentimentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     */
    public Builder setDocumentSentiment(
        com.google.cloud.language.v1.Sentiment.Builder builderForValue) {
      if (documentSentimentBuilder_ == null) {
        documentSentiment_ = builderForValue.build();
        onChanged();
      } else {
        documentSentimentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     */
    public Builder mergeDocumentSentiment(com.google.cloud.language.v1.Sentiment value) {
      if (documentSentimentBuilder_ == null) {
        if (documentSentiment_ != null) {
          documentSentiment_ =
              com.google.cloud.language.v1.Sentiment.newBuilder(documentSentiment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentSentiment_ = value;
        }
        onChanged();
      } else {
        documentSentimentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     */
    public Builder clearDocumentSentiment() {
      if (documentSentimentBuilder_ == null) {
        documentSentiment_ = null;
        onChanged();
      } else {
        documentSentiment_ = null;
        documentSentimentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     */
    public com.google.cloud.language.v1.Sentiment.Builder getDocumentSentimentBuilder() {

      onChanged();
      return getDocumentSentimentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     */
    public com.google.cloud.language.v1.SentimentOrBuilder getDocumentSentimentOrBuilder() {
      if (documentSentimentBuilder_ != null) {
        return documentSentimentBuilder_.getMessageOrBuilder();
      } else {
        return documentSentiment_ == null
            ? com.google.cloud.language.v1.Sentiment.getDefaultInstance()
            : documentSentiment_;
      }
    }
    /**
     *
     *
     * <pre>
     * The overall sentiment for the document. Populated if the user enables
     * [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_document_sentiment].
     * </pre>
     *
     * <code>.google.cloud.language.v1.Sentiment document_sentiment = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1.Sentiment,
            com.google.cloud.language.v1.Sentiment.Builder,
            com.google.cloud.language.v1.SentimentOrBuilder>
        getDocumentSentimentFieldBuilder() {
      if (documentSentimentBuilder_ == null) {
        documentSentimentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.language.v1.Sentiment,
                com.google.cloud.language.v1.Sentiment.Builder,
                com.google.cloud.language.v1.SentimentOrBuilder>(
                getDocumentSentiment(), getParentForChildren(), isClean());
        documentSentiment_ = null;
      }
      return documentSentimentBuilder_;
    }

    private java.lang.Object language_ = "";
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 5;</code>
     *
     * @return The language.
     */
    public java.lang.String getLanguage() {
      java.lang.Object ref = language_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        language_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 5;</code>
     *
     * @return The bytes for language.
     */
    public com.google.protobuf.ByteString getLanguageBytes() {
      java.lang.Object ref = language_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        language_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 5;</code>
     *
     * @param value The language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      language_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguage() {

      language_ = getDefaultInstance().getLanguage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 5;</code>
     *
     * @param value The bytes for language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      language_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.language.v1.ClassificationCategory> categories_ =
        java.util.Collections.emptyList();

    private void ensureCategoriesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        categories_ =
            new java.util.ArrayList<com.google.cloud.language.v1.ClassificationCategory>(
                categories_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.ClassificationCategory,
            com.google.cloud.language.v1.ClassificationCategory.Builder,
            com.google.cloud.language.v1.ClassificationCategoryOrBuilder>
        categoriesBuilder_;

    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public java.util.List<com.google.cloud.language.v1.ClassificationCategory> getCategoriesList() {
      if (categoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(categories_);
      } else {
        return categoriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public int getCategoriesCount() {
      if (categoriesBuilder_ == null) {
        return categories_.size();
      } else {
        return categoriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public com.google.cloud.language.v1.ClassificationCategory getCategories(int index) {
      if (categoriesBuilder_ == null) {
        return categories_.get(index);
      } else {
        return categoriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder setCategories(
        int index, com.google.cloud.language.v1.ClassificationCategory value) {
      if (categoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.set(index, value);
        onChanged();
      } else {
        categoriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder setCategories(
        int index, com.google.cloud.language.v1.ClassificationCategory.Builder builderForValue) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.set(index, builderForValue.build());
        onChanged();
      } else {
        categoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder addCategories(com.google.cloud.language.v1.ClassificationCategory value) {
      if (categoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.add(value);
        onChanged();
      } else {
        categoriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder addCategories(
        int index, com.google.cloud.language.v1.ClassificationCategory value) {
      if (categoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.add(index, value);
        onChanged();
      } else {
        categoriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder addCategories(
        com.google.cloud.language.v1.ClassificationCategory.Builder builderForValue) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.add(builderForValue.build());
        onChanged();
      } else {
        categoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder addCategories(
        int index, com.google.cloud.language.v1.ClassificationCategory.Builder builderForValue) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.add(index, builderForValue.build());
        onChanged();
      } else {
        categoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder addAllCategories(
        java.lang.Iterable<? extends com.google.cloud.language.v1.ClassificationCategory> values) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categories_);
        onChanged();
      } else {
        categoriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder clearCategories() {
      if (categoriesBuilder_ == null) {
        categories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        categoriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public Builder removeCategories(int index) {
      if (categoriesBuilder_ == null) {
        ensureCategoriesIsMutable();
        categories_.remove(index);
        onChanged();
      } else {
        categoriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public com.google.cloud.language.v1.ClassificationCategory.Builder getCategoriesBuilder(
        int index) {
      return getCategoriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public com.google.cloud.language.v1.ClassificationCategoryOrBuilder getCategoriesOrBuilder(
        int index) {
      if (categoriesBuilder_ == null) {
        return categories_.get(index);
      } else {
        return categoriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.language.v1.ClassificationCategoryOrBuilder>
        getCategoriesOrBuilderList() {
      if (categoriesBuilder_ != null) {
        return categoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(categories_);
      }
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public com.google.cloud.language.v1.ClassificationCategory.Builder addCategoriesBuilder() {
      return getCategoriesFieldBuilder()
          .addBuilder(com.google.cloud.language.v1.ClassificationCategory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public com.google.cloud.language.v1.ClassificationCategory.Builder addCategoriesBuilder(
        int index) {
      return getCategoriesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.language.v1.ClassificationCategory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Categories identified in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1.ClassificationCategory categories = 6;</code>
     */
    public java.util.List<com.google.cloud.language.v1.ClassificationCategory.Builder>
        getCategoriesBuilderList() {
      return getCategoriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1.ClassificationCategory,
            com.google.cloud.language.v1.ClassificationCategory.Builder,
            com.google.cloud.language.v1.ClassificationCategoryOrBuilder>
        getCategoriesFieldBuilder() {
      if (categoriesBuilder_ == null) {
        categoriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.language.v1.ClassificationCategory,
                com.google.cloud.language.v1.ClassificationCategory.Builder,
                com.google.cloud.language.v1.ClassificationCategoryOrBuilder>(
                categories_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        categories_ = null;
      }
      return categoriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.language.v1.AnnotateTextResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.language.v1.AnnotateTextResponse)
  private static final com.google.cloud.language.v1.AnnotateTextResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.language.v1.AnnotateTextResponse();
  }

  public static com.google.cloud.language.v1.AnnotateTextResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotateTextResponse> PARSER =
      new com.google.protobuf.AbstractParser<AnnotateTextResponse>() {
        @java.lang.Override
        public AnnotateTextResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnnotateTextResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnnotateTextResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotateTextResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.language.v1.AnnotateTextResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
