/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/language/v1/language_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.language.v1;

/**
 *
 *
 * <pre>
 * Represents dependency parse tree information for a token. (For more
 * information on dependency labels, see
 * http://www.aclweb.org/anthology/P13-2017
 * </pre>
 *
 * Protobuf type {@code google.cloud.language.v1.DependencyEdge}
 */
public final class DependencyEdge extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.language.v1.DependencyEdge)
    DependencyEdgeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DependencyEdge.newBuilder() to construct.
  private DependencyEdge(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DependencyEdge() {
    label_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DependencyEdge();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.language.v1.LanguageServiceProto
        .internal_static_google_cloud_language_v1_DependencyEdge_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.language.v1.LanguageServiceProto
        .internal_static_google_cloud_language_v1_DependencyEdge_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.language.v1.DependencyEdge.class,
            com.google.cloud.language.v1.DependencyEdge.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The parse label enum for the token.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1.DependencyEdge.Label}
   */
  public enum Label implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Abbreviation modifier
     * </pre>
     *
     * <code>ABBREV = 1;</code>
     */
    ABBREV(1),
    /**
     *
     *
     * <pre>
     * Adjectival complement
     * </pre>
     *
     * <code>ACOMP = 2;</code>
     */
    ACOMP(2),
    /**
     *
     *
     * <pre>
     * Adverbial clause modifier
     * </pre>
     *
     * <code>ADVCL = 3;</code>
     */
    ADVCL(3),
    /**
     *
     *
     * <pre>
     * Adverbial modifier
     * </pre>
     *
     * <code>ADVMOD = 4;</code>
     */
    ADVMOD(4),
    /**
     *
     *
     * <pre>
     * Adjectival modifier of an NP
     * </pre>
     *
     * <code>AMOD = 5;</code>
     */
    AMOD(5),
    /**
     *
     *
     * <pre>
     * Appositional modifier of an NP
     * </pre>
     *
     * <code>APPOS = 6;</code>
     */
    APPOS(6),
    /**
     *
     *
     * <pre>
     * Attribute dependent of a copular verb
     * </pre>
     *
     * <code>ATTR = 7;</code>
     */
    ATTR(7),
    /**
     *
     *
     * <pre>
     * Auxiliary (non-main) verb
     * </pre>
     *
     * <code>AUX = 8;</code>
     */
    AUX(8),
    /**
     *
     *
     * <pre>
     * Passive auxiliary
     * </pre>
     *
     * <code>AUXPASS = 9;</code>
     */
    AUXPASS(9),
    /**
     *
     *
     * <pre>
     * Coordinating conjunction
     * </pre>
     *
     * <code>CC = 10;</code>
     */
    CC(10),
    /**
     *
     *
     * <pre>
     * Clausal complement of a verb or adjective
     * </pre>
     *
     * <code>CCOMP = 11;</code>
     */
    CCOMP(11),
    /**
     *
     *
     * <pre>
     * Conjunct
     * </pre>
     *
     * <code>CONJ = 12;</code>
     */
    CONJ(12),
    /**
     *
     *
     * <pre>
     * Clausal subject
     * </pre>
     *
     * <code>CSUBJ = 13;</code>
     */
    CSUBJ(13),
    /**
     *
     *
     * <pre>
     * Clausal passive subject
     * </pre>
     *
     * <code>CSUBJPASS = 14;</code>
     */
    CSUBJPASS(14),
    /**
     *
     *
     * <pre>
     * Dependency (unable to determine)
     * </pre>
     *
     * <code>DEP = 15;</code>
     */
    DEP(15),
    /**
     *
     *
     * <pre>
     * Determiner
     * </pre>
     *
     * <code>DET = 16;</code>
     */
    DET(16),
    /**
     *
     *
     * <pre>
     * Discourse
     * </pre>
     *
     * <code>DISCOURSE = 17;</code>
     */
    DISCOURSE(17),
    /**
     *
     *
     * <pre>
     * Direct object
     * </pre>
     *
     * <code>DOBJ = 18;</code>
     */
    DOBJ(18),
    /**
     *
     *
     * <pre>
     * Expletive
     * </pre>
     *
     * <code>EXPL = 19;</code>
     */
    EXPL(19),
    /**
     *
     *
     * <pre>
     * Goes with (part of a word in a text not well edited)
     * </pre>
     *
     * <code>GOESWITH = 20;</code>
     */
    GOESWITH(20),
    /**
     *
     *
     * <pre>
     * Indirect object
     * </pre>
     *
     * <code>IOBJ = 21;</code>
     */
    IOBJ(21),
    /**
     *
     *
     * <pre>
     * Marker (word introducing a subordinate clause)
     * </pre>
     *
     * <code>MARK = 22;</code>
     */
    MARK(22),
    /**
     *
     *
     * <pre>
     * Multi-word expression
     * </pre>
     *
     * <code>MWE = 23;</code>
     */
    MWE(23),
    /**
     *
     *
     * <pre>
     * Multi-word verbal expression
     * </pre>
     *
     * <code>MWV = 24;</code>
     */
    MWV(24),
    /**
     *
     *
     * <pre>
     * Negation modifier
     * </pre>
     *
     * <code>NEG = 25;</code>
     */
    NEG(25),
    /**
     *
     *
     * <pre>
     * Noun compound modifier
     * </pre>
     *
     * <code>NN = 26;</code>
     */
    NN(26),
    /**
     *
     *
     * <pre>
     * Noun phrase used as an adverbial modifier
     * </pre>
     *
     * <code>NPADVMOD = 27;</code>
     */
    NPADVMOD(27),
    /**
     *
     *
     * <pre>
     * Nominal subject
     * </pre>
     *
     * <code>NSUBJ = 28;</code>
     */
    NSUBJ(28),
    /**
     *
     *
     * <pre>
     * Passive nominal subject
     * </pre>
     *
     * <code>NSUBJPASS = 29;</code>
     */
    NSUBJPASS(29),
    /**
     *
     *
     * <pre>
     * Numeric modifier of a noun
     * </pre>
     *
     * <code>NUM = 30;</code>
     */
    NUM(30),
    /**
     *
     *
     * <pre>
     * Element of compound number
     * </pre>
     *
     * <code>NUMBER = 31;</code>
     */
    NUMBER(31),
    /**
     *
     *
     * <pre>
     * Punctuation mark
     * </pre>
     *
     * <code>P = 32;</code>
     */
    P(32),
    /**
     *
     *
     * <pre>
     * Parataxis relation
     * </pre>
     *
     * <code>PARATAXIS = 33;</code>
     */
    PARATAXIS(33),
    /**
     *
     *
     * <pre>
     * Participial modifier
     * </pre>
     *
     * <code>PARTMOD = 34;</code>
     */
    PARTMOD(34),
    /**
     *
     *
     * <pre>
     * The complement of a preposition is a clause
     * </pre>
     *
     * <code>PCOMP = 35;</code>
     */
    PCOMP(35),
    /**
     *
     *
     * <pre>
     * Object of a preposition
     * </pre>
     *
     * <code>POBJ = 36;</code>
     */
    POBJ(36),
    /**
     *
     *
     * <pre>
     * Possession modifier
     * </pre>
     *
     * <code>POSS = 37;</code>
     */
    POSS(37),
    /**
     *
     *
     * <pre>
     * Postverbal negative particle
     * </pre>
     *
     * <code>POSTNEG = 38;</code>
     */
    POSTNEG(38),
    /**
     *
     *
     * <pre>
     * Predicate complement
     * </pre>
     *
     * <code>PRECOMP = 39;</code>
     */
    PRECOMP(39),
    /**
     *
     *
     * <pre>
     * Preconjunt
     * </pre>
     *
     * <code>PRECONJ = 40;</code>
     */
    PRECONJ(40),
    /**
     *
     *
     * <pre>
     * Predeterminer
     * </pre>
     *
     * <code>PREDET = 41;</code>
     */
    PREDET(41),
    /**
     *
     *
     * <pre>
     * Prefix
     * </pre>
     *
     * <code>PREF = 42;</code>
     */
    PREF(42),
    /**
     *
     *
     * <pre>
     * Prepositional modifier
     * </pre>
     *
     * <code>PREP = 43;</code>
     */
    PREP(43),
    /**
     *
     *
     * <pre>
     * The relationship between a verb and verbal morpheme
     * </pre>
     *
     * <code>PRONL = 44;</code>
     */
    PRONL(44),
    /**
     *
     *
     * <pre>
     * Particle
     * </pre>
     *
     * <code>PRT = 45;</code>
     */
    PRT(45),
    /**
     *
     *
     * <pre>
     * Associative or possessive marker
     * </pre>
     *
     * <code>PS = 46;</code>
     */
    PS(46),
    /**
     *
     *
     * <pre>
     * Quantifier phrase modifier
     * </pre>
     *
     * <code>QUANTMOD = 47;</code>
     */
    QUANTMOD(47),
    /**
     *
     *
     * <pre>
     * Relative clause modifier
     * </pre>
     *
     * <code>RCMOD = 48;</code>
     */
    RCMOD(48),
    /**
     *
     *
     * <pre>
     * Complementizer in relative clause
     * </pre>
     *
     * <code>RCMODREL = 49;</code>
     */
    RCMODREL(49),
    /**
     *
     *
     * <pre>
     * Ellipsis without a preceding predicate
     * </pre>
     *
     * <code>RDROP = 50;</code>
     */
    RDROP(50),
    /**
     *
     *
     * <pre>
     * Referent
     * </pre>
     *
     * <code>REF = 51;</code>
     */
    REF(51),
    /**
     *
     *
     * <pre>
     * Remnant
     * </pre>
     *
     * <code>REMNANT = 52;</code>
     */
    REMNANT(52),
    /**
     *
     *
     * <pre>
     * Reparandum
     * </pre>
     *
     * <code>REPARANDUM = 53;</code>
     */
    REPARANDUM(53),
    /**
     *
     *
     * <pre>
     * Root
     * </pre>
     *
     * <code>ROOT = 54;</code>
     */
    ROOT(54),
    /**
     *
     *
     * <pre>
     * Suffix specifying a unit of number
     * </pre>
     *
     * <code>SNUM = 55;</code>
     */
    SNUM(55),
    /**
     *
     *
     * <pre>
     * Suffix
     * </pre>
     *
     * <code>SUFF = 56;</code>
     */
    SUFF(56),
    /**
     *
     *
     * <pre>
     * Temporal modifier
     * </pre>
     *
     * <code>TMOD = 57;</code>
     */
    TMOD(57),
    /**
     *
     *
     * <pre>
     * Topic marker
     * </pre>
     *
     * <code>TOPIC = 58;</code>
     */
    TOPIC(58),
    /**
     *
     *
     * <pre>
     * Clause headed by an infinite form of the verb that modifies a noun
     * </pre>
     *
     * <code>VMOD = 59;</code>
     */
    VMOD(59),
    /**
     *
     *
     * <pre>
     * Vocative
     * </pre>
     *
     * <code>VOCATIVE = 60;</code>
     */
    VOCATIVE(60),
    /**
     *
     *
     * <pre>
     * Open clausal complement
     * </pre>
     *
     * <code>XCOMP = 61;</code>
     */
    XCOMP(61),
    /**
     *
     *
     * <pre>
     * Name suffix
     * </pre>
     *
     * <code>SUFFIX = 62;</code>
     */
    SUFFIX(62),
    /**
     *
     *
     * <pre>
     * Name title
     * </pre>
     *
     * <code>TITLE = 63;</code>
     */
    TITLE(63),
    /**
     *
     *
     * <pre>
     * Adverbial phrase modifier
     * </pre>
     *
     * <code>ADVPHMOD = 64;</code>
     */
    ADVPHMOD(64),
    /**
     *
     *
     * <pre>
     * Causative auxiliary
     * </pre>
     *
     * <code>AUXCAUS = 65;</code>
     */
    AUXCAUS(65),
    /**
     *
     *
     * <pre>
     * Helper auxiliary
     * </pre>
     *
     * <code>AUXVV = 66;</code>
     */
    AUXVV(66),
    /**
     *
     *
     * <pre>
     * Rentaishi (Prenominal modifier)
     * </pre>
     *
     * <code>DTMOD = 67;</code>
     */
    DTMOD(67),
    /**
     *
     *
     * <pre>
     * Foreign words
     * </pre>
     *
     * <code>FOREIGN = 68;</code>
     */
    FOREIGN(68),
    /**
     *
     *
     * <pre>
     * Keyword
     * </pre>
     *
     * <code>KW = 69;</code>
     */
    KW(69),
    /**
     *
     *
     * <pre>
     * List for chains of comparable items
     * </pre>
     *
     * <code>LIST = 70;</code>
     */
    LIST(70),
    /**
     *
     *
     * <pre>
     * Nominalized clause
     * </pre>
     *
     * <code>NOMC = 71;</code>
     */
    NOMC(71),
    /**
     *
     *
     * <pre>
     * Nominalized clausal subject
     * </pre>
     *
     * <code>NOMCSUBJ = 72;</code>
     */
    NOMCSUBJ(72),
    /**
     *
     *
     * <pre>
     * Nominalized clausal passive
     * </pre>
     *
     * <code>NOMCSUBJPASS = 73;</code>
     */
    NOMCSUBJPASS(73),
    /**
     *
     *
     * <pre>
     * Compound of numeric modifier
     * </pre>
     *
     * <code>NUMC = 74;</code>
     */
    NUMC(74),
    /**
     *
     *
     * <pre>
     * Copula
     * </pre>
     *
     * <code>COP = 75;</code>
     */
    COP(75),
    /**
     *
     *
     * <pre>
     * Dislocated relation (for fronted/topicalized elements)
     * </pre>
     *
     * <code>DISLOCATED = 76;</code>
     */
    DISLOCATED(76),
    /**
     *
     *
     * <pre>
     * Aspect marker
     * </pre>
     *
     * <code>ASP = 77;</code>
     */
    ASP(77),
    /**
     *
     *
     * <pre>
     * Genitive modifier
     * </pre>
     *
     * <code>GMOD = 78;</code>
     */
    GMOD(78),
    /**
     *
     *
     * <pre>
     * Genitive object
     * </pre>
     *
     * <code>GOBJ = 79;</code>
     */
    GOBJ(79),
    /**
     *
     *
     * <pre>
     * Infinitival modifier
     * </pre>
     *
     * <code>INFMOD = 80;</code>
     */
    INFMOD(80),
    /**
     *
     *
     * <pre>
     * Measure
     * </pre>
     *
     * <code>MES = 81;</code>
     */
    MES(81),
    /**
     *
     *
     * <pre>
     * Nominal complement of a noun
     * </pre>
     *
     * <code>NCOMP = 82;</code>
     */
    NCOMP(82),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Abbreviation modifier
     * </pre>
     *
     * <code>ABBREV = 1;</code>
     */
    public static final int ABBREV_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Adjectival complement
     * </pre>
     *
     * <code>ACOMP = 2;</code>
     */
    public static final int ACOMP_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Adverbial clause modifier
     * </pre>
     *
     * <code>ADVCL = 3;</code>
     */
    public static final int ADVCL_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Adverbial modifier
     * </pre>
     *
     * <code>ADVMOD = 4;</code>
     */
    public static final int ADVMOD_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Adjectival modifier of an NP
     * </pre>
     *
     * <code>AMOD = 5;</code>
     */
    public static final int AMOD_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Appositional modifier of an NP
     * </pre>
     *
     * <code>APPOS = 6;</code>
     */
    public static final int APPOS_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Attribute dependent of a copular verb
     * </pre>
     *
     * <code>ATTR = 7;</code>
     */
    public static final int ATTR_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Auxiliary (non-main) verb
     * </pre>
     *
     * <code>AUX = 8;</code>
     */
    public static final int AUX_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Passive auxiliary
     * </pre>
     *
     * <code>AUXPASS = 9;</code>
     */
    public static final int AUXPASS_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Coordinating conjunction
     * </pre>
     *
     * <code>CC = 10;</code>
     */
    public static final int CC_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Clausal complement of a verb or adjective
     * </pre>
     *
     * <code>CCOMP = 11;</code>
     */
    public static final int CCOMP_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Conjunct
     * </pre>
     *
     * <code>CONJ = 12;</code>
     */
    public static final int CONJ_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Clausal subject
     * </pre>
     *
     * <code>CSUBJ = 13;</code>
     */
    public static final int CSUBJ_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Clausal passive subject
     * </pre>
     *
     * <code>CSUBJPASS = 14;</code>
     */
    public static final int CSUBJPASS_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Dependency (unable to determine)
     * </pre>
     *
     * <code>DEP = 15;</code>
     */
    public static final int DEP_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Determiner
     * </pre>
     *
     * <code>DET = 16;</code>
     */
    public static final int DET_VALUE = 16;
    /**
     *
     *
     * <pre>
     * Discourse
     * </pre>
     *
     * <code>DISCOURSE = 17;</code>
     */
    public static final int DISCOURSE_VALUE = 17;
    /**
     *
     *
     * <pre>
     * Direct object
     * </pre>
     *
     * <code>DOBJ = 18;</code>
     */
    public static final int DOBJ_VALUE = 18;
    /**
     *
     *
     * <pre>
     * Expletive
     * </pre>
     *
     * <code>EXPL = 19;</code>
     */
    public static final int EXPL_VALUE = 19;
    /**
     *
     *
     * <pre>
     * Goes with (part of a word in a text not well edited)
     * </pre>
     *
     * <code>GOESWITH = 20;</code>
     */
    public static final int GOESWITH_VALUE = 20;
    /**
     *
     *
     * <pre>
     * Indirect object
     * </pre>
     *
     * <code>IOBJ = 21;</code>
     */
    public static final int IOBJ_VALUE = 21;
    /**
     *
     *
     * <pre>
     * Marker (word introducing a subordinate clause)
     * </pre>
     *
     * <code>MARK = 22;</code>
     */
    public static final int MARK_VALUE = 22;
    /**
     *
     *
     * <pre>
     * Multi-word expression
     * </pre>
     *
     * <code>MWE = 23;</code>
     */
    public static final int MWE_VALUE = 23;
    /**
     *
     *
     * <pre>
     * Multi-word verbal expression
     * </pre>
     *
     * <code>MWV = 24;</code>
     */
    public static final int MWV_VALUE = 24;
    /**
     *
     *
     * <pre>
     * Negation modifier
     * </pre>
     *
     * <code>NEG = 25;</code>
     */
    public static final int NEG_VALUE = 25;
    /**
     *
     *
     * <pre>
     * Noun compound modifier
     * </pre>
     *
     * <code>NN = 26;</code>
     */
    public static final int NN_VALUE = 26;
    /**
     *
     *
     * <pre>
     * Noun phrase used as an adverbial modifier
     * </pre>
     *
     * <code>NPADVMOD = 27;</code>
     */
    public static final int NPADVMOD_VALUE = 27;
    /**
     *
     *
     * <pre>
     * Nominal subject
     * </pre>
     *
     * <code>NSUBJ = 28;</code>
     */
    public static final int NSUBJ_VALUE = 28;
    /**
     *
     *
     * <pre>
     * Passive nominal subject
     * </pre>
     *
     * <code>NSUBJPASS = 29;</code>
     */
    public static final int NSUBJPASS_VALUE = 29;
    /**
     *
     *
     * <pre>
     * Numeric modifier of a noun
     * </pre>
     *
     * <code>NUM = 30;</code>
     */
    public static final int NUM_VALUE = 30;
    /**
     *
     *
     * <pre>
     * Element of compound number
     * </pre>
     *
     * <code>NUMBER = 31;</code>
     */
    public static final int NUMBER_VALUE = 31;
    /**
     *
     *
     * <pre>
     * Punctuation mark
     * </pre>
     *
     * <code>P = 32;</code>
     */
    public static final int P_VALUE = 32;
    /**
     *
     *
     * <pre>
     * Parataxis relation
     * </pre>
     *
     * <code>PARATAXIS = 33;</code>
     */
    public static final int PARATAXIS_VALUE = 33;
    /**
     *
     *
     * <pre>
     * Participial modifier
     * </pre>
     *
     * <code>PARTMOD = 34;</code>
     */
    public static final int PARTMOD_VALUE = 34;
    /**
     *
     *
     * <pre>
     * The complement of a preposition is a clause
     * </pre>
     *
     * <code>PCOMP = 35;</code>
     */
    public static final int PCOMP_VALUE = 35;
    /**
     *
     *
     * <pre>
     * Object of a preposition
     * </pre>
     *
     * <code>POBJ = 36;</code>
     */
    public static final int POBJ_VALUE = 36;
    /**
     *
     *
     * <pre>
     * Possession modifier
     * </pre>
     *
     * <code>POSS = 37;</code>
     */
    public static final int POSS_VALUE = 37;
    /**
     *
     *
     * <pre>
     * Postverbal negative particle
     * </pre>
     *
     * <code>POSTNEG = 38;</code>
     */
    public static final int POSTNEG_VALUE = 38;
    /**
     *
     *
     * <pre>
     * Predicate complement
     * </pre>
     *
     * <code>PRECOMP = 39;</code>
     */
    public static final int PRECOMP_VALUE = 39;
    /**
     *
     *
     * <pre>
     * Preconjunt
     * </pre>
     *
     * <code>PRECONJ = 40;</code>
     */
    public static final int PRECONJ_VALUE = 40;
    /**
     *
     *
     * <pre>
     * Predeterminer
     * </pre>
     *
     * <code>PREDET = 41;</code>
     */
    public static final int PREDET_VALUE = 41;
    /**
     *
     *
     * <pre>
     * Prefix
     * </pre>
     *
     * <code>PREF = 42;</code>
     */
    public static final int PREF_VALUE = 42;
    /**
     *
     *
     * <pre>
     * Prepositional modifier
     * </pre>
     *
     * <code>PREP = 43;</code>
     */
    public static final int PREP_VALUE = 43;
    /**
     *
     *
     * <pre>
     * The relationship between a verb and verbal morpheme
     * </pre>
     *
     * <code>PRONL = 44;</code>
     */
    public static final int PRONL_VALUE = 44;
    /**
     *
     *
     * <pre>
     * Particle
     * </pre>
     *
     * <code>PRT = 45;</code>
     */
    public static final int PRT_VALUE = 45;
    /**
     *
     *
     * <pre>
     * Associative or possessive marker
     * </pre>
     *
     * <code>PS = 46;</code>
     */
    public static final int PS_VALUE = 46;
    /**
     *
     *
     * <pre>
     * Quantifier phrase modifier
     * </pre>
     *
     * <code>QUANTMOD = 47;</code>
     */
    public static final int QUANTMOD_VALUE = 47;
    /**
     *
     *
     * <pre>
     * Relative clause modifier
     * </pre>
     *
     * <code>RCMOD = 48;</code>
     */
    public static final int RCMOD_VALUE = 48;
    /**
     *
     *
     * <pre>
     * Complementizer in relative clause
     * </pre>
     *
     * <code>RCMODREL = 49;</code>
     */
    public static final int RCMODREL_VALUE = 49;
    /**
     *
     *
     * <pre>
     * Ellipsis without a preceding predicate
     * </pre>
     *
     * <code>RDROP = 50;</code>
     */
    public static final int RDROP_VALUE = 50;
    /**
     *
     *
     * <pre>
     * Referent
     * </pre>
     *
     * <code>REF = 51;</code>
     */
    public static final int REF_VALUE = 51;
    /**
     *
     *
     * <pre>
     * Remnant
     * </pre>
     *
     * <code>REMNANT = 52;</code>
     */
    public static final int REMNANT_VALUE = 52;
    /**
     *
     *
     * <pre>
     * Reparandum
     * </pre>
     *
     * <code>REPARANDUM = 53;</code>
     */
    public static final int REPARANDUM_VALUE = 53;
    /**
     *
     *
     * <pre>
     * Root
     * </pre>
     *
     * <code>ROOT = 54;</code>
     */
    public static final int ROOT_VALUE = 54;
    /**
     *
     *
     * <pre>
     * Suffix specifying a unit of number
     * </pre>
     *
     * <code>SNUM = 55;</code>
     */
    public static final int SNUM_VALUE = 55;
    /**
     *
     *
     * <pre>
     * Suffix
     * </pre>
     *
     * <code>SUFF = 56;</code>
     */
    public static final int SUFF_VALUE = 56;
    /**
     *
     *
     * <pre>
     * Temporal modifier
     * </pre>
     *
     * <code>TMOD = 57;</code>
     */
    public static final int TMOD_VALUE = 57;
    /**
     *
     *
     * <pre>
     * Topic marker
     * </pre>
     *
     * <code>TOPIC = 58;</code>
     */
    public static final int TOPIC_VALUE = 58;
    /**
     *
     *
     * <pre>
     * Clause headed by an infinite form of the verb that modifies a noun
     * </pre>
     *
     * <code>VMOD = 59;</code>
     */
    public static final int VMOD_VALUE = 59;
    /**
     *
     *
     * <pre>
     * Vocative
     * </pre>
     *
     * <code>VOCATIVE = 60;</code>
     */
    public static final int VOCATIVE_VALUE = 60;
    /**
     *
     *
     * <pre>
     * Open clausal complement
     * </pre>
     *
     * <code>XCOMP = 61;</code>
     */
    public static final int XCOMP_VALUE = 61;
    /**
     *
     *
     * <pre>
     * Name suffix
     * </pre>
     *
     * <code>SUFFIX = 62;</code>
     */
    public static final int SUFFIX_VALUE = 62;
    /**
     *
     *
     * <pre>
     * Name title
     * </pre>
     *
     * <code>TITLE = 63;</code>
     */
    public static final int TITLE_VALUE = 63;
    /**
     *
     *
     * <pre>
     * Adverbial phrase modifier
     * </pre>
     *
     * <code>ADVPHMOD = 64;</code>
     */
    public static final int ADVPHMOD_VALUE = 64;
    /**
     *
     *
     * <pre>
     * Causative auxiliary
     * </pre>
     *
     * <code>AUXCAUS = 65;</code>
     */
    public static final int AUXCAUS_VALUE = 65;
    /**
     *
     *
     * <pre>
     * Helper auxiliary
     * </pre>
     *
     * <code>AUXVV = 66;</code>
     */
    public static final int AUXVV_VALUE = 66;
    /**
     *
     *
     * <pre>
     * Rentaishi (Prenominal modifier)
     * </pre>
     *
     * <code>DTMOD = 67;</code>
     */
    public static final int DTMOD_VALUE = 67;
    /**
     *
     *
     * <pre>
     * Foreign words
     * </pre>
     *
     * <code>FOREIGN = 68;</code>
     */
    public static final int FOREIGN_VALUE = 68;
    /**
     *
     *
     * <pre>
     * Keyword
     * </pre>
     *
     * <code>KW = 69;</code>
     */
    public static final int KW_VALUE = 69;
    /**
     *
     *
     * <pre>
     * List for chains of comparable items
     * </pre>
     *
     * <code>LIST = 70;</code>
     */
    public static final int LIST_VALUE = 70;
    /**
     *
     *
     * <pre>
     * Nominalized clause
     * </pre>
     *
     * <code>NOMC = 71;</code>
     */
    public static final int NOMC_VALUE = 71;
    /**
     *
     *
     * <pre>
     * Nominalized clausal subject
     * </pre>
     *
     * <code>NOMCSUBJ = 72;</code>
     */
    public static final int NOMCSUBJ_VALUE = 72;
    /**
     *
     *
     * <pre>
     * Nominalized clausal passive
     * </pre>
     *
     * <code>NOMCSUBJPASS = 73;</code>
     */
    public static final int NOMCSUBJPASS_VALUE = 73;
    /**
     *
     *
     * <pre>
     * Compound of numeric modifier
     * </pre>
     *
     * <code>NUMC = 74;</code>
     */
    public static final int NUMC_VALUE = 74;
    /**
     *
     *
     * <pre>
     * Copula
     * </pre>
     *
     * <code>COP = 75;</code>
     */
    public static final int COP_VALUE = 75;
    /**
     *
     *
     * <pre>
     * Dislocated relation (for fronted/topicalized elements)
     * </pre>
     *
     * <code>DISLOCATED = 76;</code>
     */
    public static final int DISLOCATED_VALUE = 76;
    /**
     *
     *
     * <pre>
     * Aspect marker
     * </pre>
     *
     * <code>ASP = 77;</code>
     */
    public static final int ASP_VALUE = 77;
    /**
     *
     *
     * <pre>
     * Genitive modifier
     * </pre>
     *
     * <code>GMOD = 78;</code>
     */
    public static final int GMOD_VALUE = 78;
    /**
     *
     *
     * <pre>
     * Genitive object
     * </pre>
     *
     * <code>GOBJ = 79;</code>
     */
    public static final int GOBJ_VALUE = 79;
    /**
     *
     *
     * <pre>
     * Infinitival modifier
     * </pre>
     *
     * <code>INFMOD = 80;</code>
     */
    public static final int INFMOD_VALUE = 80;
    /**
     *
     *
     * <pre>
     * Measure
     * </pre>
     *
     * <code>MES = 81;</code>
     */
    public static final int MES_VALUE = 81;
    /**
     *
     *
     * <pre>
     * Nominal complement of a noun
     * </pre>
     *
     * <code>NCOMP = 82;</code>
     */
    public static final int NCOMP_VALUE = 82;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Label valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Label forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return ABBREV;
        case 2:
          return ACOMP;
        case 3:
          return ADVCL;
        case 4:
          return ADVMOD;
        case 5:
          return AMOD;
        case 6:
          return APPOS;
        case 7:
          return ATTR;
        case 8:
          return AUX;
        case 9:
          return AUXPASS;
        case 10:
          return CC;
        case 11:
          return CCOMP;
        case 12:
          return CONJ;
        case 13:
          return CSUBJ;
        case 14:
          return CSUBJPASS;
        case 15:
          return DEP;
        case 16:
          return DET;
        case 17:
          return DISCOURSE;
        case 18:
          return DOBJ;
        case 19:
          return EXPL;
        case 20:
          return GOESWITH;
        case 21:
          return IOBJ;
        case 22:
          return MARK;
        case 23:
          return MWE;
        case 24:
          return MWV;
        case 25:
          return NEG;
        case 26:
          return NN;
        case 27:
          return NPADVMOD;
        case 28:
          return NSUBJ;
        case 29:
          return NSUBJPASS;
        case 30:
          return NUM;
        case 31:
          return NUMBER;
        case 32:
          return P;
        case 33:
          return PARATAXIS;
        case 34:
          return PARTMOD;
        case 35:
          return PCOMP;
        case 36:
          return POBJ;
        case 37:
          return POSS;
        case 38:
          return POSTNEG;
        case 39:
          return PRECOMP;
        case 40:
          return PRECONJ;
        case 41:
          return PREDET;
        case 42:
          return PREF;
        case 43:
          return PREP;
        case 44:
          return PRONL;
        case 45:
          return PRT;
        case 46:
          return PS;
        case 47:
          return QUANTMOD;
        case 48:
          return RCMOD;
        case 49:
          return RCMODREL;
        case 50:
          return RDROP;
        case 51:
          return REF;
        case 52:
          return REMNANT;
        case 53:
          return REPARANDUM;
        case 54:
          return ROOT;
        case 55:
          return SNUM;
        case 56:
          return SUFF;
        case 57:
          return TMOD;
        case 58:
          return TOPIC;
        case 59:
          return VMOD;
        case 60:
          return VOCATIVE;
        case 61:
          return XCOMP;
        case 62:
          return SUFFIX;
        case 63:
          return TITLE;
        case 64:
          return ADVPHMOD;
        case 65:
          return AUXCAUS;
        case 66:
          return AUXVV;
        case 67:
          return DTMOD;
        case 68:
          return FOREIGN;
        case 69:
          return KW;
        case 70:
          return LIST;
        case 71:
          return NOMC;
        case 72:
          return NOMCSUBJ;
        case 73:
          return NOMCSUBJPASS;
        case 74:
          return NUMC;
        case 75:
          return COP;
        case 76:
          return DISLOCATED;
        case 77:
          return ASP;
        case 78:
          return GMOD;
        case 79:
          return GOBJ;
        case 80:
          return INFMOD;
        case 81:
          return MES;
        case 82:
          return NCOMP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Label> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Label> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Label>() {
          public Label findValueByNumber(int number) {
            return Label.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1.DependencyEdge.getDescriptor().getEnumTypes().get(0);
    }

    private static final Label[] VALUES = values();

    public static Label valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Label(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1.DependencyEdge.Label)
  }

  public static final int HEAD_TOKEN_INDEX_FIELD_NUMBER = 1;
  private int headTokenIndex_ = 0;
  /**
   *
   *
   * <pre>
   * Represents the head of this token in the dependency tree.
   * This is the index of the token which has an arc going to this token.
   * The index is the position of the token in the array of tokens returned
   * by the API method. If this token is a root token, then the
   * `head_token_index` is its own index.
   * </pre>
   *
   * <code>int32 head_token_index = 1;</code>
   *
   * @return The headTokenIndex.
   */
  @java.lang.Override
  public int getHeadTokenIndex() {
    return headTokenIndex_;
  }

  public static final int LABEL_FIELD_NUMBER = 2;
  private int label_ = 0;
  /**
   *
   *
   * <pre>
   * The parse label for the token.
   * </pre>
   *
   * <code>.google.cloud.language.v1.DependencyEdge.Label label = 2;</code>
   *
   * @return The enum numeric value on the wire for label.
   */
  @java.lang.Override
  public int getLabelValue() {
    return label_;
  }
  /**
   *
   *
   * <pre>
   * The parse label for the token.
   * </pre>
   *
   * <code>.google.cloud.language.v1.DependencyEdge.Label label = 2;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public com.google.cloud.language.v1.DependencyEdge.Label getLabel() {
    com.google.cloud.language.v1.DependencyEdge.Label result =
        com.google.cloud.language.v1.DependencyEdge.Label.forNumber(label_);
    return result == null ? com.google.cloud.language.v1.DependencyEdge.Label.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (headTokenIndex_ != 0) {
      output.writeInt32(1, headTokenIndex_);
    }
    if (label_ != com.google.cloud.language.v1.DependencyEdge.Label.UNKNOWN.getNumber()) {
      output.writeEnum(2, label_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (headTokenIndex_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, headTokenIndex_);
    }
    if (label_ != com.google.cloud.language.v1.DependencyEdge.Label.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, label_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.language.v1.DependencyEdge)) {
      return super.equals(obj);
    }
    com.google.cloud.language.v1.DependencyEdge other =
        (com.google.cloud.language.v1.DependencyEdge) obj;

    if (getHeadTokenIndex() != other.getHeadTokenIndex()) return false;
    if (label_ != other.label_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HEAD_TOKEN_INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getHeadTokenIndex();
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + label_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1.DependencyEdge parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.language.v1.DependencyEdge prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents dependency parse tree information for a token. (For more
   * information on dependency labels, see
   * http://www.aclweb.org/anthology/P13-2017
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1.DependencyEdge}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.language.v1.DependencyEdge)
      com.google.cloud.language.v1.DependencyEdgeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_DependencyEdge_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_DependencyEdge_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1.DependencyEdge.class,
              com.google.cloud.language.v1.DependencyEdge.Builder.class);
    }

    // Construct using com.google.cloud.language.v1.DependencyEdge.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      headTokenIndex_ = 0;
      label_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.language.v1.LanguageServiceProto
          .internal_static_google_cloud_language_v1_DependencyEdge_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.language.v1.DependencyEdge getDefaultInstanceForType() {
      return com.google.cloud.language.v1.DependencyEdge.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.language.v1.DependencyEdge build() {
      com.google.cloud.language.v1.DependencyEdge result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.language.v1.DependencyEdge buildPartial() {
      com.google.cloud.language.v1.DependencyEdge result =
          new com.google.cloud.language.v1.DependencyEdge(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.language.v1.DependencyEdge result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.headTokenIndex_ = headTokenIndex_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.label_ = label_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.language.v1.DependencyEdge) {
        return mergeFrom((com.google.cloud.language.v1.DependencyEdge) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.language.v1.DependencyEdge other) {
      if (other == com.google.cloud.language.v1.DependencyEdge.getDefaultInstance()) return this;
      if (other.getHeadTokenIndex() != 0) {
        setHeadTokenIndex(other.getHeadTokenIndex());
      }
      if (other.label_ != 0) {
        setLabelValue(other.getLabelValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                headTokenIndex_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                label_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int headTokenIndex_;
    /**
     *
     *
     * <pre>
     * Represents the head of this token in the dependency tree.
     * This is the index of the token which has an arc going to this token.
     * The index is the position of the token in the array of tokens returned
     * by the API method. If this token is a root token, then the
     * `head_token_index` is its own index.
     * </pre>
     *
     * <code>int32 head_token_index = 1;</code>
     *
     * @return The headTokenIndex.
     */
    @java.lang.Override
    public int getHeadTokenIndex() {
      return headTokenIndex_;
    }
    /**
     *
     *
     * <pre>
     * Represents the head of this token in the dependency tree.
     * This is the index of the token which has an arc going to this token.
     * The index is the position of the token in the array of tokens returned
     * by the API method. If this token is a root token, then the
     * `head_token_index` is its own index.
     * </pre>
     *
     * <code>int32 head_token_index = 1;</code>
     *
     * @param value The headTokenIndex to set.
     * @return This builder for chaining.
     */
    public Builder setHeadTokenIndex(int value) {

      headTokenIndex_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents the head of this token in the dependency tree.
     * This is the index of the token which has an arc going to this token.
     * The index is the position of the token in the array of tokens returned
     * by the API method. If this token is a root token, then the
     * `head_token_index` is its own index.
     * </pre>
     *
     * <code>int32 head_token_index = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeadTokenIndex() {
      bitField0_ = (bitField0_ & ~0x00000001);
      headTokenIndex_ = 0;
      onChanged();
      return this;
    }

    private int label_ = 0;
    /**
     *
     *
     * <pre>
     * The parse label for the token.
     * </pre>
     *
     * <code>.google.cloud.language.v1.DependencyEdge.Label label = 2;</code>
     *
     * @return The enum numeric value on the wire for label.
     */
    @java.lang.Override
    public int getLabelValue() {
      return label_;
    }
    /**
     *
     *
     * <pre>
     * The parse label for the token.
     * </pre>
     *
     * <code>.google.cloud.language.v1.DependencyEdge.Label label = 2;</code>
     *
     * @param value The enum numeric value on the wire for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelValue(int value) {
      label_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parse label for the token.
     * </pre>
     *
     * <code>.google.cloud.language.v1.DependencyEdge.Label label = 2;</code>
     *
     * @return The label.
     */
    @java.lang.Override
    public com.google.cloud.language.v1.DependencyEdge.Label getLabel() {
      com.google.cloud.language.v1.DependencyEdge.Label result =
          com.google.cloud.language.v1.DependencyEdge.Label.forNumber(label_);
      return result == null
          ? com.google.cloud.language.v1.DependencyEdge.Label.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The parse label for the token.
     * </pre>
     *
     * <code>.google.cloud.language.v1.DependencyEdge.Label label = 2;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(com.google.cloud.language.v1.DependencyEdge.Label value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      label_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parse label for the token.
     * </pre>
     *
     * <code>.google.cloud.language.v1.DependencyEdge.Label label = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {
      bitField0_ = (bitField0_ & ~0x00000002);
      label_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.language.v1.DependencyEdge)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.language.v1.DependencyEdge)
  private static final com.google.cloud.language.v1.DependencyEdge DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.language.v1.DependencyEdge();
  }

  public static com.google.cloud.language.v1.DependencyEdge getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DependencyEdge> PARSER =
      new com.google.protobuf.AbstractParser<DependencyEdge>() {
        @java.lang.Override
        public DependencyEdge parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DependencyEdge> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DependencyEdge> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.language.v1.DependencyEdge getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
