/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/language/v1beta2/language_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.language.v1beta2;

/**
 *
 *
 * <pre>
 * The request message for the text annotation API, which can perform multiple
 * analysis types (sentiment, entities, and syntax) in one call.
 * </pre>
 *
 * Protobuf type {@code google.cloud.language.v1beta2.AnnotateTextRequest}
 */
public final class AnnotateTextRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.language.v1beta2.AnnotateTextRequest)
    AnnotateTextRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotateTextRequest.newBuilder() to construct.
  private AnnotateTextRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotateTextRequest() {
    encodingType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotateTextRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.language.v1beta2.AnnotateTextRequest.class,
            com.google.cloud.language.v1beta2.AnnotateTextRequest.Builder.class);
  }

  public interface FeaturesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.language.v1beta2.AnnotateTextRequest.Features)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Extract syntax information.
     * </pre>
     *
     * <code>bool extract_syntax = 1;</code>
     *
     * @return The extractSyntax.
     */
    boolean getExtractSyntax();

    /**
     *
     *
     * <pre>
     * Extract entities.
     * </pre>
     *
     * <code>bool extract_entities = 2;</code>
     *
     * @return The extractEntities.
     */
    boolean getExtractEntities();

    /**
     *
     *
     * <pre>
     * Extract document-level sentiment.
     * </pre>
     *
     * <code>bool extract_document_sentiment = 3;</code>
     *
     * @return The extractDocumentSentiment.
     */
    boolean getExtractDocumentSentiment();

    /**
     *
     *
     * <pre>
     * Extract entities and their associated sentiment.
     * </pre>
     *
     * <code>bool extract_entity_sentiment = 4;</code>
     *
     * @return The extractEntitySentiment.
     */
    boolean getExtractEntitySentiment();

    /**
     *
     *
     * <pre>
     * Classify the full document into categories. If this is true,
     * the API will use the default model which classifies into a
     * [predefined
     * taxonomy](https://cloud.google.com/natural-language/docs/categories).
     * </pre>
     *
     * <code>bool classify_text = 6;</code>
     *
     * @return The classifyText.
     */
    boolean getClassifyText();

    /**
     *
     *
     * <pre>
     * Moderate the document for harmful and sensitive categories.
     * </pre>
     *
     * <code>bool moderate_text = 11;</code>
     *
     * @return The moderateText.
     */
    boolean getModerateText();

    /**
     *
     *
     * <pre>
     * The model options to use for classification. Defaults to v1 options
     * if not specified. Only used if `classify_text` is set to true.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
     * </code>
     *
     * @return Whether the classificationModelOptions field is set.
     */
    boolean hasClassificationModelOptions();
    /**
     *
     *
     * <pre>
     * The model options to use for classification. Defaults to v1 options
     * if not specified. Only used if `classify_text` is set to true.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
     * </code>
     *
     * @return The classificationModelOptions.
     */
    com.google.cloud.language.v1beta2.ClassificationModelOptions getClassificationModelOptions();
    /**
     *
     *
     * <pre>
     * The model options to use for classification. Defaults to v1 options
     * if not specified. Only used if `classify_text` is set to true.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
     * </code>
     */
    com.google.cloud.language.v1beta2.ClassificationModelOptionsOrBuilder
        getClassificationModelOptionsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * All available features for sentiment, syntax, and semantic analysis.
   * Setting each one to true will enable that specific analysis for the input.
   * Next ID: 12
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1beta2.AnnotateTextRequest.Features}
   */
  public static final class Features extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.language.v1beta2.AnnotateTextRequest.Features)
      FeaturesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Features.newBuilder() to construct.
    private Features(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Features() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Features();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_Features_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_Features_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.class,
              com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.Builder.class);
    }

    private int bitField0_;
    public static final int EXTRACT_SYNTAX_FIELD_NUMBER = 1;
    private boolean extractSyntax_ = false;
    /**
     *
     *
     * <pre>
     * Extract syntax information.
     * </pre>
     *
     * <code>bool extract_syntax = 1;</code>
     *
     * @return The extractSyntax.
     */
    @java.lang.Override
    public boolean getExtractSyntax() {
      return extractSyntax_;
    }

    public static final int EXTRACT_ENTITIES_FIELD_NUMBER = 2;
    private boolean extractEntities_ = false;
    /**
     *
     *
     * <pre>
     * Extract entities.
     * </pre>
     *
     * <code>bool extract_entities = 2;</code>
     *
     * @return The extractEntities.
     */
    @java.lang.Override
    public boolean getExtractEntities() {
      return extractEntities_;
    }

    public static final int EXTRACT_DOCUMENT_SENTIMENT_FIELD_NUMBER = 3;
    private boolean extractDocumentSentiment_ = false;
    /**
     *
     *
     * <pre>
     * Extract document-level sentiment.
     * </pre>
     *
     * <code>bool extract_document_sentiment = 3;</code>
     *
     * @return The extractDocumentSentiment.
     */
    @java.lang.Override
    public boolean getExtractDocumentSentiment() {
      return extractDocumentSentiment_;
    }

    public static final int EXTRACT_ENTITY_SENTIMENT_FIELD_NUMBER = 4;
    private boolean extractEntitySentiment_ = false;
    /**
     *
     *
     * <pre>
     * Extract entities and their associated sentiment.
     * </pre>
     *
     * <code>bool extract_entity_sentiment = 4;</code>
     *
     * @return The extractEntitySentiment.
     */
    @java.lang.Override
    public boolean getExtractEntitySentiment() {
      return extractEntitySentiment_;
    }

    public static final int CLASSIFY_TEXT_FIELD_NUMBER = 6;
    private boolean classifyText_ = false;
    /**
     *
     *
     * <pre>
     * Classify the full document into categories. If this is true,
     * the API will use the default model which classifies into a
     * [predefined
     * taxonomy](https://cloud.google.com/natural-language/docs/categories).
     * </pre>
     *
     * <code>bool classify_text = 6;</code>
     *
     * @return The classifyText.
     */
    @java.lang.Override
    public boolean getClassifyText() {
      return classifyText_;
    }

    public static final int MODERATE_TEXT_FIELD_NUMBER = 11;
    private boolean moderateText_ = false;
    /**
     *
     *
     * <pre>
     * Moderate the document for harmful and sensitive categories.
     * </pre>
     *
     * <code>bool moderate_text = 11;</code>
     *
     * @return The moderateText.
     */
    @java.lang.Override
    public boolean getModerateText() {
      return moderateText_;
    }

    public static final int CLASSIFICATION_MODEL_OPTIONS_FIELD_NUMBER = 10;
    private com.google.cloud.language.v1beta2.ClassificationModelOptions
        classificationModelOptions_;
    /**
     *
     *
     * <pre>
     * The model options to use for classification. Defaults to v1 options
     * if not specified. Only used if `classify_text` is set to true.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
     * </code>
     *
     * @return Whether the classificationModelOptions field is set.
     */
    @java.lang.Override
    public boolean hasClassificationModelOptions() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The model options to use for classification. Defaults to v1 options
     * if not specified. Only used if `classify_text` is set to true.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
     * </code>
     *
     * @return The classificationModelOptions.
     */
    @java.lang.Override
    public com.google.cloud.language.v1beta2.ClassificationModelOptions
        getClassificationModelOptions() {
      return classificationModelOptions_ == null
          ? com.google.cloud.language.v1beta2.ClassificationModelOptions.getDefaultInstance()
          : classificationModelOptions_;
    }
    /**
     *
     *
     * <pre>
     * The model options to use for classification. Defaults to v1 options
     * if not specified. Only used if `classify_text` is set to true.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.language.v1beta2.ClassificationModelOptionsOrBuilder
        getClassificationModelOptionsOrBuilder() {
      return classificationModelOptions_ == null
          ? com.google.cloud.language.v1beta2.ClassificationModelOptions.getDefaultInstance()
          : classificationModelOptions_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (extractSyntax_ != false) {
        output.writeBool(1, extractSyntax_);
      }
      if (extractEntities_ != false) {
        output.writeBool(2, extractEntities_);
      }
      if (extractDocumentSentiment_ != false) {
        output.writeBool(3, extractDocumentSentiment_);
      }
      if (extractEntitySentiment_ != false) {
        output.writeBool(4, extractEntitySentiment_);
      }
      if (classifyText_ != false) {
        output.writeBool(6, classifyText_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(10, getClassificationModelOptions());
      }
      if (moderateText_ != false) {
        output.writeBool(11, moderateText_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (extractSyntax_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, extractSyntax_);
      }
      if (extractEntities_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, extractEntities_);
      }
      if (extractDocumentSentiment_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, extractDocumentSentiment_);
      }
      if (extractEntitySentiment_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, extractEntitySentiment_);
      }
      if (classifyText_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, classifyText_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, getClassificationModelOptions());
      }
      if (moderateText_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, moderateText_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.language.v1beta2.AnnotateTextRequest.Features)) {
        return super.equals(obj);
      }
      com.google.cloud.language.v1beta2.AnnotateTextRequest.Features other =
          (com.google.cloud.language.v1beta2.AnnotateTextRequest.Features) obj;

      if (getExtractSyntax() != other.getExtractSyntax()) return false;
      if (getExtractEntities() != other.getExtractEntities()) return false;
      if (getExtractDocumentSentiment() != other.getExtractDocumentSentiment()) return false;
      if (getExtractEntitySentiment() != other.getExtractEntitySentiment()) return false;
      if (getClassifyText() != other.getClassifyText()) return false;
      if (getModerateText() != other.getModerateText()) return false;
      if (hasClassificationModelOptions() != other.hasClassificationModelOptions()) return false;
      if (hasClassificationModelOptions()) {
        if (!getClassificationModelOptions().equals(other.getClassificationModelOptions()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXTRACT_SYNTAX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExtractSyntax());
      hash = (37 * hash) + EXTRACT_ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExtractEntities());
      hash = (37 * hash) + EXTRACT_DOCUMENT_SENTIMENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExtractDocumentSentiment());
      hash = (37 * hash) + EXTRACT_ENTITY_SENTIMENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExtractEntitySentiment());
      hash = (37 * hash) + CLASSIFY_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getClassifyText());
      hash = (37 * hash) + MODERATE_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getModerateText());
      if (hasClassificationModelOptions()) {
        hash = (37 * hash) + CLASSIFICATION_MODEL_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getClassificationModelOptions().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.language.v1beta2.AnnotateTextRequest.Features prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * All available features for sentiment, syntax, and semantic analysis.
     * Setting each one to true will enable that specific analysis for the input.
     * Next ID: 12
     * </pre>
     *
     * Protobuf type {@code google.cloud.language.v1beta2.AnnotateTextRequest.Features}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.language.v1beta2.AnnotateTextRequest.Features)
        com.google.cloud.language.v1beta2.AnnotateTextRequest.FeaturesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.language.v1beta2.LanguageServiceProto
            .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_Features_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.language.v1beta2.LanguageServiceProto
            .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_Features_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.class,
                com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.Builder.class);
      }

      // Construct using com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getClassificationModelOptionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        extractSyntax_ = false;
        extractEntities_ = false;
        extractDocumentSentiment_ = false;
        extractEntitySentiment_ = false;
        classifyText_ = false;
        moderateText_ = false;
        classificationModelOptions_ = null;
        if (classificationModelOptionsBuilder_ != null) {
          classificationModelOptionsBuilder_.dispose();
          classificationModelOptionsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.language.v1beta2.LanguageServiceProto
            .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_Features_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.language.v1beta2.AnnotateTextRequest.Features
          getDefaultInstanceForType() {
        return com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.language.v1beta2.AnnotateTextRequest.Features build() {
        com.google.cloud.language.v1beta2.AnnotateTextRequest.Features result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.language.v1beta2.AnnotateTextRequest.Features buildPartial() {
        com.google.cloud.language.v1beta2.AnnotateTextRequest.Features result =
            new com.google.cloud.language.v1beta2.AnnotateTextRequest.Features(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.language.v1beta2.AnnotateTextRequest.Features result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.extractSyntax_ = extractSyntax_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.extractEntities_ = extractEntities_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.extractDocumentSentiment_ = extractDocumentSentiment_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.extractEntitySentiment_ = extractEntitySentiment_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.classifyText_ = classifyText_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.moderateText_ = moderateText_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.classificationModelOptions_ =
              classificationModelOptionsBuilder_ == null
                  ? classificationModelOptions_
                  : classificationModelOptionsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.language.v1beta2.AnnotateTextRequest.Features) {
          return mergeFrom((com.google.cloud.language.v1beta2.AnnotateTextRequest.Features) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.language.v1beta2.AnnotateTextRequest.Features other) {
        if (other
            == com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.getDefaultInstance())
          return this;
        if (other.getExtractSyntax() != false) {
          setExtractSyntax(other.getExtractSyntax());
        }
        if (other.getExtractEntities() != false) {
          setExtractEntities(other.getExtractEntities());
        }
        if (other.getExtractDocumentSentiment() != false) {
          setExtractDocumentSentiment(other.getExtractDocumentSentiment());
        }
        if (other.getExtractEntitySentiment() != false) {
          setExtractEntitySentiment(other.getExtractEntitySentiment());
        }
        if (other.getClassifyText() != false) {
          setClassifyText(other.getClassifyText());
        }
        if (other.getModerateText() != false) {
          setModerateText(other.getModerateText());
        }
        if (other.hasClassificationModelOptions()) {
          mergeClassificationModelOptions(other.getClassificationModelOptions());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  extractSyntax_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  extractEntities_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  extractDocumentSentiment_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  extractEntitySentiment_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 48:
                {
                  classifyText_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 48
              case 82:
                {
                  input.readMessage(
                      getClassificationModelOptionsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 82
              case 88:
                {
                  moderateText_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 88
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean extractSyntax_;
      /**
       *
       *
       * <pre>
       * Extract syntax information.
       * </pre>
       *
       * <code>bool extract_syntax = 1;</code>
       *
       * @return The extractSyntax.
       */
      @java.lang.Override
      public boolean getExtractSyntax() {
        return extractSyntax_;
      }
      /**
       *
       *
       * <pre>
       * Extract syntax information.
       * </pre>
       *
       * <code>bool extract_syntax = 1;</code>
       *
       * @param value The extractSyntax to set.
       * @return This builder for chaining.
       */
      public Builder setExtractSyntax(boolean value) {

        extractSyntax_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Extract syntax information.
       * </pre>
       *
       * <code>bool extract_syntax = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExtractSyntax() {
        bitField0_ = (bitField0_ & ~0x00000001);
        extractSyntax_ = false;
        onChanged();
        return this;
      }

      private boolean extractEntities_;
      /**
       *
       *
       * <pre>
       * Extract entities.
       * </pre>
       *
       * <code>bool extract_entities = 2;</code>
       *
       * @return The extractEntities.
       */
      @java.lang.Override
      public boolean getExtractEntities() {
        return extractEntities_;
      }
      /**
       *
       *
       * <pre>
       * Extract entities.
       * </pre>
       *
       * <code>bool extract_entities = 2;</code>
       *
       * @param value The extractEntities to set.
       * @return This builder for chaining.
       */
      public Builder setExtractEntities(boolean value) {

        extractEntities_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Extract entities.
       * </pre>
       *
       * <code>bool extract_entities = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExtractEntities() {
        bitField0_ = (bitField0_ & ~0x00000002);
        extractEntities_ = false;
        onChanged();
        return this;
      }

      private boolean extractDocumentSentiment_;
      /**
       *
       *
       * <pre>
       * Extract document-level sentiment.
       * </pre>
       *
       * <code>bool extract_document_sentiment = 3;</code>
       *
       * @return The extractDocumentSentiment.
       */
      @java.lang.Override
      public boolean getExtractDocumentSentiment() {
        return extractDocumentSentiment_;
      }
      /**
       *
       *
       * <pre>
       * Extract document-level sentiment.
       * </pre>
       *
       * <code>bool extract_document_sentiment = 3;</code>
       *
       * @param value The extractDocumentSentiment to set.
       * @return This builder for chaining.
       */
      public Builder setExtractDocumentSentiment(boolean value) {

        extractDocumentSentiment_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Extract document-level sentiment.
       * </pre>
       *
       * <code>bool extract_document_sentiment = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExtractDocumentSentiment() {
        bitField0_ = (bitField0_ & ~0x00000004);
        extractDocumentSentiment_ = false;
        onChanged();
        return this;
      }

      private boolean extractEntitySentiment_;
      /**
       *
       *
       * <pre>
       * Extract entities and their associated sentiment.
       * </pre>
       *
       * <code>bool extract_entity_sentiment = 4;</code>
       *
       * @return The extractEntitySentiment.
       */
      @java.lang.Override
      public boolean getExtractEntitySentiment() {
        return extractEntitySentiment_;
      }
      /**
       *
       *
       * <pre>
       * Extract entities and their associated sentiment.
       * </pre>
       *
       * <code>bool extract_entity_sentiment = 4;</code>
       *
       * @param value The extractEntitySentiment to set.
       * @return This builder for chaining.
       */
      public Builder setExtractEntitySentiment(boolean value) {

        extractEntitySentiment_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Extract entities and their associated sentiment.
       * </pre>
       *
       * <code>bool extract_entity_sentiment = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExtractEntitySentiment() {
        bitField0_ = (bitField0_ & ~0x00000008);
        extractEntitySentiment_ = false;
        onChanged();
        return this;
      }

      private boolean classifyText_;
      /**
       *
       *
       * <pre>
       * Classify the full document into categories. If this is true,
       * the API will use the default model which classifies into a
       * [predefined
       * taxonomy](https://cloud.google.com/natural-language/docs/categories).
       * </pre>
       *
       * <code>bool classify_text = 6;</code>
       *
       * @return The classifyText.
       */
      @java.lang.Override
      public boolean getClassifyText() {
        return classifyText_;
      }
      /**
       *
       *
       * <pre>
       * Classify the full document into categories. If this is true,
       * the API will use the default model which classifies into a
       * [predefined
       * taxonomy](https://cloud.google.com/natural-language/docs/categories).
       * </pre>
       *
       * <code>bool classify_text = 6;</code>
       *
       * @param value The classifyText to set.
       * @return This builder for chaining.
       */
      public Builder setClassifyText(boolean value) {

        classifyText_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Classify the full document into categories. If this is true,
       * the API will use the default model which classifies into a
       * [predefined
       * taxonomy](https://cloud.google.com/natural-language/docs/categories).
       * </pre>
       *
       * <code>bool classify_text = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClassifyText() {
        bitField0_ = (bitField0_ & ~0x00000010);
        classifyText_ = false;
        onChanged();
        return this;
      }

      private boolean moderateText_;
      /**
       *
       *
       * <pre>
       * Moderate the document for harmful and sensitive categories.
       * </pre>
       *
       * <code>bool moderate_text = 11;</code>
       *
       * @return The moderateText.
       */
      @java.lang.Override
      public boolean getModerateText() {
        return moderateText_;
      }
      /**
       *
       *
       * <pre>
       * Moderate the document for harmful and sensitive categories.
       * </pre>
       *
       * <code>bool moderate_text = 11;</code>
       *
       * @param value The moderateText to set.
       * @return This builder for chaining.
       */
      public Builder setModerateText(boolean value) {

        moderateText_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Moderate the document for harmful and sensitive categories.
       * </pre>
       *
       * <code>bool moderate_text = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModerateText() {
        bitField0_ = (bitField0_ & ~0x00000020);
        moderateText_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.language.v1beta2.ClassificationModelOptions
          classificationModelOptions_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.language.v1beta2.ClassificationModelOptions,
              com.google.cloud.language.v1beta2.ClassificationModelOptions.Builder,
              com.google.cloud.language.v1beta2.ClassificationModelOptionsOrBuilder>
          classificationModelOptionsBuilder_;
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       *
       * @return Whether the classificationModelOptions field is set.
       */
      public boolean hasClassificationModelOptions() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       *
       * @return The classificationModelOptions.
       */
      public com.google.cloud.language.v1beta2.ClassificationModelOptions
          getClassificationModelOptions() {
        if (classificationModelOptionsBuilder_ == null) {
          return classificationModelOptions_ == null
              ? com.google.cloud.language.v1beta2.ClassificationModelOptions.getDefaultInstance()
              : classificationModelOptions_;
        } else {
          return classificationModelOptionsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       */
      public Builder setClassificationModelOptions(
          com.google.cloud.language.v1beta2.ClassificationModelOptions value) {
        if (classificationModelOptionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          classificationModelOptions_ = value;
        } else {
          classificationModelOptionsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       */
      public Builder setClassificationModelOptions(
          com.google.cloud.language.v1beta2.ClassificationModelOptions.Builder builderForValue) {
        if (classificationModelOptionsBuilder_ == null) {
          classificationModelOptions_ = builderForValue.build();
        } else {
          classificationModelOptionsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       */
      public Builder mergeClassificationModelOptions(
          com.google.cloud.language.v1beta2.ClassificationModelOptions value) {
        if (classificationModelOptionsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && classificationModelOptions_ != null
              && classificationModelOptions_
                  != com.google.cloud.language.v1beta2.ClassificationModelOptions
                      .getDefaultInstance()) {
            getClassificationModelOptionsBuilder().mergeFrom(value);
          } else {
            classificationModelOptions_ = value;
          }
        } else {
          classificationModelOptionsBuilder_.mergeFrom(value);
        }
        if (classificationModelOptions_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       */
      public Builder clearClassificationModelOptions() {
        bitField0_ = (bitField0_ & ~0x00000040);
        classificationModelOptions_ = null;
        if (classificationModelOptionsBuilder_ != null) {
          classificationModelOptionsBuilder_.dispose();
          classificationModelOptionsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       */
      public com.google.cloud.language.v1beta2.ClassificationModelOptions.Builder
          getClassificationModelOptionsBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getClassificationModelOptionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       */
      public com.google.cloud.language.v1beta2.ClassificationModelOptionsOrBuilder
          getClassificationModelOptionsOrBuilder() {
        if (classificationModelOptionsBuilder_ != null) {
          return classificationModelOptionsBuilder_.getMessageOrBuilder();
        } else {
          return classificationModelOptions_ == null
              ? com.google.cloud.language.v1beta2.ClassificationModelOptions.getDefaultInstance()
              : classificationModelOptions_;
        }
      }
      /**
       *
       *
       * <pre>
       * The model options to use for classification. Defaults to v1 options
       * if not specified. Only used if `classify_text` is set to true.
       * </pre>
       *
       * <code>
       * .google.cloud.language.v1beta2.ClassificationModelOptions classification_model_options = 10;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.language.v1beta2.ClassificationModelOptions,
              com.google.cloud.language.v1beta2.ClassificationModelOptions.Builder,
              com.google.cloud.language.v1beta2.ClassificationModelOptionsOrBuilder>
          getClassificationModelOptionsFieldBuilder() {
        if (classificationModelOptionsBuilder_ == null) {
          classificationModelOptionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.language.v1beta2.ClassificationModelOptions,
                  com.google.cloud.language.v1beta2.ClassificationModelOptions.Builder,
                  com.google.cloud.language.v1beta2.ClassificationModelOptionsOrBuilder>(
                  getClassificationModelOptions(), getParentForChildren(), isClean());
          classificationModelOptions_ = null;
        }
        return classificationModelOptionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.language.v1beta2.AnnotateTextRequest.Features)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.language.v1beta2.AnnotateTextRequest.Features)
    private static final com.google.cloud.language.v1beta2.AnnotateTextRequest.Features
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.language.v1beta2.AnnotateTextRequest.Features();
    }

    public static com.google.cloud.language.v1beta2.AnnotateTextRequest.Features
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Features> PARSER =
        new com.google.protobuf.AbstractParser<Features>() {
          @java.lang.Override
          public Features parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Features> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Features> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.AnnotateTextRequest.Features
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DOCUMENT_FIELD_NUMBER = 1;
  private com.google.cloud.language.v1beta2.Document document_;
  /**
   *
   *
   * <pre>
   * Required. Input document.
   * </pre>
   *
   * <code>
   * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the document field is set.
   */
  @java.lang.Override
  public boolean hasDocument() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Input document.
   * </pre>
   *
   * <code>
   * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The document.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.Document getDocument() {
    return document_ == null
        ? com.google.cloud.language.v1beta2.Document.getDefaultInstance()
        : document_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input document.
   * </pre>
   *
   * <code>
   * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.DocumentOrBuilder getDocumentOrBuilder() {
    return document_ == null
        ? com.google.cloud.language.v1beta2.Document.getDefaultInstance()
        : document_;
  }

  public static final int FEATURES_FIELD_NUMBER = 2;
  private com.google.cloud.language.v1beta2.AnnotateTextRequest.Features features_;
  /**
   *
   *
   * <pre>
   * Required. The enabled features.
   * </pre>
   *
   * <code>
   * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the features field is set.
   */
  @java.lang.Override
  public boolean hasFeatures() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The enabled features.
   * </pre>
   *
   * <code>
   * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The features.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.AnnotateTextRequest.Features getFeatures() {
    return features_ == null
        ? com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.getDefaultInstance()
        : features_;
  }
  /**
   *
   *
   * <pre>
   * Required. The enabled features.
   * </pre>
   *
   * <code>
   * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.AnnotateTextRequest.FeaturesOrBuilder
      getFeaturesOrBuilder() {
    return features_ == null
        ? com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.getDefaultInstance()
        : features_;
  }

  public static final int ENCODING_TYPE_FIELD_NUMBER = 3;
  private int encodingType_ = 0;
  /**
   *
   *
   * <pre>
   * The encoding type used by the API to calculate offsets.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.EncodingType encoding_type = 3;</code>
   *
   * @return The enum numeric value on the wire for encodingType.
   */
  @java.lang.Override
  public int getEncodingTypeValue() {
    return encodingType_;
  }
  /**
   *
   *
   * <pre>
   * The encoding type used by the API to calculate offsets.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.EncodingType encoding_type = 3;</code>
   *
   * @return The encodingType.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.EncodingType getEncodingType() {
    com.google.cloud.language.v1beta2.EncodingType result =
        com.google.cloud.language.v1beta2.EncodingType.forNumber(encodingType_);
    return result == null ? com.google.cloud.language.v1beta2.EncodingType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDocument());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getFeatures());
    }
    if (encodingType_ != com.google.cloud.language.v1beta2.EncodingType.NONE.getNumber()) {
      output.writeEnum(3, encodingType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocument());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFeatures());
    }
    if (encodingType_ != com.google.cloud.language.v1beta2.EncodingType.NONE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, encodingType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.language.v1beta2.AnnotateTextRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.language.v1beta2.AnnotateTextRequest other =
        (com.google.cloud.language.v1beta2.AnnotateTextRequest) obj;

    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (hasFeatures() != other.hasFeatures()) return false;
    if (hasFeatures()) {
      if (!getFeatures().equals(other.getFeatures())) return false;
    }
    if (encodingType_ != other.encodingType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    if (hasFeatures()) {
      hash = (37 * hash) + FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getFeatures().hashCode();
    }
    hash = (37 * hash) + ENCODING_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + encodingType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.language.v1beta2.AnnotateTextRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for the text annotation API, which can perform multiple
   * analysis types (sentiment, entities, and syntax) in one call.
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1beta2.AnnotateTextRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.language.v1beta2.AnnotateTextRequest)
      com.google.cloud.language.v1beta2.AnnotateTextRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1beta2.AnnotateTextRequest.class,
              com.google.cloud.language.v1beta2.AnnotateTextRequest.Builder.class);
    }

    // Construct using com.google.cloud.language.v1beta2.AnnotateTextRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentFieldBuilder();
        getFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      features_ = null;
      if (featuresBuilder_ != null) {
        featuresBuilder_.dispose();
        featuresBuilder_ = null;
      }
      encodingType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnnotateTextRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.AnnotateTextRequest getDefaultInstanceForType() {
      return com.google.cloud.language.v1beta2.AnnotateTextRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.AnnotateTextRequest build() {
      com.google.cloud.language.v1beta2.AnnotateTextRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.AnnotateTextRequest buildPartial() {
      com.google.cloud.language.v1beta2.AnnotateTextRequest result =
          new com.google.cloud.language.v1beta2.AnnotateTextRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.language.v1beta2.AnnotateTextRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.features_ = featuresBuilder_ == null ? features_ : featuresBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.encodingType_ = encodingType_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.language.v1beta2.AnnotateTextRequest) {
        return mergeFrom((com.google.cloud.language.v1beta2.AnnotateTextRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.language.v1beta2.AnnotateTextRequest other) {
      if (other == com.google.cloud.language.v1beta2.AnnotateTextRequest.getDefaultInstance())
        return this;
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (other.hasFeatures()) {
        mergeFeatures(other.getFeatures());
      }
      if (other.encodingType_ != 0) {
        setEncodingTypeValue(other.getEncodingTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                encodingType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.language.v1beta2.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.Document,
            com.google.cloud.language.v1beta2.Document.Builder,
            com.google.cloud.language.v1beta2.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the document field is set.
     */
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The document.
     */
    public com.google.cloud.language.v1beta2.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.cloud.language.v1beta2.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocument(com.google.cloud.language.v1beta2.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
      } else {
        documentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocument(com.google.cloud.language.v1beta2.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDocument(com.google.cloud.language.v1beta2.Document value) {
      if (documentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && document_ != null
            && document_ != com.google.cloud.language.v1beta2.Document.getDefaultInstance()) {
          getDocumentBuilder().mergeFrom(value);
        } else {
          document_ = value;
        }
      } else {
        documentBuilder_.mergeFrom(value);
      }
      if (document_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDocument() {
      bitField0_ = (bitField0_ & ~0x00000001);
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.language.v1beta2.Document.Builder getDocumentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.language.v1beta2.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.cloud.language.v1beta2.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input document.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.Document,
            com.google.cloud.language.v1beta2.Document.Builder,
            com.google.cloud.language.v1beta2.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.language.v1beta2.Document,
                com.google.cloud.language.v1beta2.Document.Builder,
                com.google.cloud.language.v1beta2.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private com.google.cloud.language.v1beta2.AnnotateTextRequest.Features features_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.AnnotateTextRequest.Features,
            com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.Builder,
            com.google.cloud.language.v1beta2.AnnotateTextRequest.FeaturesOrBuilder>
        featuresBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the features field is set.
     */
    public boolean hasFeatures() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The features.
     */
    public com.google.cloud.language.v1beta2.AnnotateTextRequest.Features getFeatures() {
      if (featuresBuilder_ == null) {
        return features_ == null
            ? com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.getDefaultInstance()
            : features_;
      } else {
        return featuresBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFeatures(
        com.google.cloud.language.v1beta2.AnnotateTextRequest.Features value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        features_ = value;
      } else {
        featuresBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFeatures(
        com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        features_ = builderForValue.build();
      } else {
        featuresBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeFeatures(
        com.google.cloud.language.v1beta2.AnnotateTextRequest.Features value) {
      if (featuresBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && features_ != null
            && features_
                != com.google.cloud.language.v1beta2.AnnotateTextRequest.Features
                    .getDefaultInstance()) {
          getFeaturesBuilder().mergeFrom(value);
        } else {
          features_ = value;
        }
      } else {
        featuresBuilder_.mergeFrom(value);
      }
      if (features_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFeatures() {
      bitField0_ = (bitField0_ & ~0x00000002);
      features_ = null;
      if (featuresBuilder_ != null) {
        featuresBuilder_.dispose();
        featuresBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.Builder
        getFeaturesBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.language.v1beta2.AnnotateTextRequest.FeaturesOrBuilder
        getFeaturesOrBuilder() {
      if (featuresBuilder_ != null) {
        return featuresBuilder_.getMessageOrBuilder();
      } else {
        return features_ == null
            ? com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.getDefaultInstance()
            : features_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The enabled features.
     * </pre>
     *
     * <code>
     * .google.cloud.language.v1beta2.AnnotateTextRequest.Features features = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.AnnotateTextRequest.Features,
            com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.Builder,
            com.google.cloud.language.v1beta2.AnnotateTextRequest.FeaturesOrBuilder>
        getFeaturesFieldBuilder() {
      if (featuresBuilder_ == null) {
        featuresBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.language.v1beta2.AnnotateTextRequest.Features,
                com.google.cloud.language.v1beta2.AnnotateTextRequest.Features.Builder,
                com.google.cloud.language.v1beta2.AnnotateTextRequest.FeaturesOrBuilder>(
                getFeatures(), getParentForChildren(), isClean());
        features_ = null;
      }
      return featuresBuilder_;
    }

    private int encodingType_ = 0;
    /**
     *
     *
     * <pre>
     * The encoding type used by the API to calculate offsets.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.EncodingType encoding_type = 3;</code>
     *
     * @return The enum numeric value on the wire for encodingType.
     */
    @java.lang.Override
    public int getEncodingTypeValue() {
      return encodingType_;
    }
    /**
     *
     *
     * <pre>
     * The encoding type used by the API to calculate offsets.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.EncodingType encoding_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for encodingType to set.
     * @return This builder for chaining.
     */
    public Builder setEncodingTypeValue(int value) {
      encodingType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoding type used by the API to calculate offsets.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.EncodingType encoding_type = 3;</code>
     *
     * @return The encodingType.
     */
    @java.lang.Override
    public com.google.cloud.language.v1beta2.EncodingType getEncodingType() {
      com.google.cloud.language.v1beta2.EncodingType result =
          com.google.cloud.language.v1beta2.EncodingType.forNumber(encodingType_);
      return result == null ? com.google.cloud.language.v1beta2.EncodingType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The encoding type used by the API to calculate offsets.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.EncodingType encoding_type = 3;</code>
     *
     * @param value The encodingType to set.
     * @return This builder for chaining.
     */
    public Builder setEncodingType(com.google.cloud.language.v1beta2.EncodingType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      encodingType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoding type used by the API to calculate offsets.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.EncodingType encoding_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncodingType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      encodingType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.language.v1beta2.AnnotateTextRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.language.v1beta2.AnnotateTextRequest)
  private static final com.google.cloud.language.v1beta2.AnnotateTextRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.language.v1beta2.AnnotateTextRequest();
  }

  public static com.google.cloud.language.v1beta2.AnnotateTextRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotateTextRequest> PARSER =
      new com.google.protobuf.AbstractParser<AnnotateTextRequest>() {
        @java.lang.Override
        public AnnotateTextRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotateTextRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotateTextRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.language.v1beta2.AnnotateTextRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
