/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/language/v1beta2/language_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.language.v1beta2;

/**
 *
 *
 * <pre>
 * Represents a phrase in the text that is a known entity, such as
 * a person, an organization, or location. The API associates information, such
 * as salience and mentions, with entities.
 * </pre>
 *
 * Protobuf type {@code google.cloud.language.v1beta2.Entity}
 */
public final class Entity extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.language.v1beta2.Entity)
    EntityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Entity.newBuilder() to construct.
  private Entity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Entity() {
    name_ = "";
    type_ = 0;
    mentions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Entity();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_Entity_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_Entity_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.language.v1beta2.Entity.class,
            com.google.cloud.language.v1beta2.Entity.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the entity. For most entity types, the associated metadata is a
   * Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`). The table
   * below lists the associated fields for entities that have different
   * metadata.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.language.v1beta2.Entity.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Person
     * </pre>
     *
     * <code>PERSON = 1;</code>
     */
    PERSON(1),
    /**
     *
     *
     * <pre>
     * Location
     * </pre>
     *
     * <code>LOCATION = 2;</code>
     */
    LOCATION(2),
    /**
     *
     *
     * <pre>
     * Organization
     * </pre>
     *
     * <code>ORGANIZATION = 3;</code>
     */
    ORGANIZATION(3),
    /**
     *
     *
     * <pre>
     * Event
     * </pre>
     *
     * <code>EVENT = 4;</code>
     */
    EVENT(4),
    /**
     *
     *
     * <pre>
     * Artwork
     * </pre>
     *
     * <code>WORK_OF_ART = 5;</code>
     */
    WORK_OF_ART(5),
    /**
     *
     *
     * <pre>
     * Consumer product
     * </pre>
     *
     * <code>CONSUMER_GOOD = 6;</code>
     */
    CONSUMER_GOOD(6),
    /**
     *
     *
     * <pre>
     * Other types of entities
     * </pre>
     *
     * <code>OTHER = 7;</code>
     */
    OTHER(7),
    /**
     *
     *
     * <pre>
     * Phone number
     *
     * The metadata lists the phone number, formatted according to local
     * convention, plus whichever additional elements appear in the text:
     *
     * * `number` - the actual number, broken down into sections as per local
     * convention
     * * `national_prefix` - country code, if detected
     * * `area_code` - region or area code, if detected
     * * `extension` - phone extension (to be dialed after connection), if
     * detected
     * </pre>
     *
     * <code>PHONE_NUMBER = 9;</code>
     */
    PHONE_NUMBER(9),
    /**
     *
     *
     * <pre>
     * Address
     *
     * The metadata identifies the street number and locality plus whichever
     * additional elements appear in the text:
     *
     * * `street_number` - street number
     * * `locality` - city or town
     * * `street_name` - street/route name, if detected
     * * `postal_code` - postal code, if detected
     * * `country` - country, if detected&lt;
     * * `broad_region` - administrative area, such as the state, if detected
     * * `narrow_region` - smaller administrative area, such as county, if
     * detected
     * * `sublocality` - used in Asian addresses to demark a district within a
     * city, if detected
     * </pre>
     *
     * <code>ADDRESS = 10;</code>
     */
    ADDRESS(10),
    /**
     *
     *
     * <pre>
     * Date
     *
     * The metadata identifies the components of the date:
     *
     * * `year` - four digit year, if detected
     * * `month` - two digit month number, if detected
     * * `day` - two digit day number, if detected
     * </pre>
     *
     * <code>DATE = 11;</code>
     */
    DATE(11),
    /**
     *
     *
     * <pre>
     * Number
     *
     * The metadata is the number itself.
     * </pre>
     *
     * <code>NUMBER = 12;</code>
     */
    NUMBER(12),
    /**
     *
     *
     * <pre>
     * Price
     *
     * The metadata identifies the `value` and `currency`.
     * </pre>
     *
     * <code>PRICE = 13;</code>
     */
    PRICE(13),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Person
     * </pre>
     *
     * <code>PERSON = 1;</code>
     */
    public static final int PERSON_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Location
     * </pre>
     *
     * <code>LOCATION = 2;</code>
     */
    public static final int LOCATION_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Organization
     * </pre>
     *
     * <code>ORGANIZATION = 3;</code>
     */
    public static final int ORGANIZATION_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Event
     * </pre>
     *
     * <code>EVENT = 4;</code>
     */
    public static final int EVENT_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Artwork
     * </pre>
     *
     * <code>WORK_OF_ART = 5;</code>
     */
    public static final int WORK_OF_ART_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Consumer product
     * </pre>
     *
     * <code>CONSUMER_GOOD = 6;</code>
     */
    public static final int CONSUMER_GOOD_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Other types of entities
     * </pre>
     *
     * <code>OTHER = 7;</code>
     */
    public static final int OTHER_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Phone number
     *
     * The metadata lists the phone number, formatted according to local
     * convention, plus whichever additional elements appear in the text:
     *
     * * `number` - the actual number, broken down into sections as per local
     * convention
     * * `national_prefix` - country code, if detected
     * * `area_code` - region or area code, if detected
     * * `extension` - phone extension (to be dialed after connection), if
     * detected
     * </pre>
     *
     * <code>PHONE_NUMBER = 9;</code>
     */
    public static final int PHONE_NUMBER_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Address
     *
     * The metadata identifies the street number and locality plus whichever
     * additional elements appear in the text:
     *
     * * `street_number` - street number
     * * `locality` - city or town
     * * `street_name` - street/route name, if detected
     * * `postal_code` - postal code, if detected
     * * `country` - country, if detected&lt;
     * * `broad_region` - administrative area, such as the state, if detected
     * * `narrow_region` - smaller administrative area, such as county, if
     * detected
     * * `sublocality` - used in Asian addresses to demark a district within a
     * city, if detected
     * </pre>
     *
     * <code>ADDRESS = 10;</code>
     */
    public static final int ADDRESS_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Date
     *
     * The metadata identifies the components of the date:
     *
     * * `year` - four digit year, if detected
     * * `month` - two digit month number, if detected
     * * `day` - two digit day number, if detected
     * </pre>
     *
     * <code>DATE = 11;</code>
     */
    public static final int DATE_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Number
     *
     * The metadata is the number itself.
     * </pre>
     *
     * <code>NUMBER = 12;</code>
     */
    public static final int NUMBER_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Price
     *
     * The metadata identifies the `value` and `currency`.
     * </pre>
     *
     * <code>PRICE = 13;</code>
     */
    public static final int PRICE_VALUE = 13;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return PERSON;
        case 2:
          return LOCATION;
        case 3:
          return ORGANIZATION;
        case 4:
          return EVENT;
        case 5:
          return WORK_OF_ART;
        case 6:
          return CONSUMER_GOOD;
        case 7:
          return OTHER;
        case 9:
          return PHONE_NUMBER;
        case 10:
          return ADDRESS;
        case 11:
          return DATE;
        case 12:
          return NUMBER;
        case 13:
          return PRICE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.language.v1beta2.Entity.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.language.v1beta2.Entity.Type)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The representative name for the entity.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The representative name for the entity.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The entity type.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.Entity.Type type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The entity type.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.Entity.Type type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.Entity.Type getType() {
    com.google.cloud.language.v1beta2.Entity.Type result =
        com.google.cloud.language.v1beta2.Entity.Type.forNumber(type_);
    return result == null ? com.google.cloud.language.v1beta2.Entity.Type.UNRECOGNIZED : result;
  }

  public static final int METADATA_FIELD_NUMBER = 3;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.language.v1beta2.LanguageServiceProto
                .internal_static_google_cloud_language_v1beta2_Entity_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Metadata associated with the entity.
   *
   * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
   * and Knowledge Graph MID (`mid`), if they are available. For the metadata
   * associated with other entity types, see the Type table below.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }
  /**
   *
   *
   * <pre>
   * Metadata associated with the entity.
   *
   * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
   * and Knowledge Graph MID (`mid`), if they are available. For the metadata
   * associated with other entity types, see the Type table below.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }
  /**
   *
   *
   * <pre>
   * Metadata associated with the entity.
   *
   * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
   * and Knowledge Graph MID (`mid`), if they are available. For the metadata
   * associated with other entity types, see the Type table below.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Metadata associated with the entity.
   *
   * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
   * and Knowledge Graph MID (`mid`), if they are available. For the metadata
   * associated with other entity types, see the Type table below.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SALIENCE_FIELD_NUMBER = 4;
  private float salience_ = 0F;
  /**
   *
   *
   * <pre>
   * The salience score associated with the entity in the [0, 1.0] range.
   *
   * The salience score for an entity provides information about the
   * importance or centrality of that entity to the entire document text.
   * Scores closer to 0 are less salient, while scores closer to 1.0 are highly
   * salient.
   * </pre>
   *
   * <code>float salience = 4;</code>
   *
   * @return The salience.
   */
  @java.lang.Override
  public float getSalience() {
    return salience_;
  }

  public static final int MENTIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.language.v1beta2.EntityMention> mentions_;
  /**
   *
   *
   * <pre>
   * The mentions of this entity in the input document. The API currently
   * supports proper noun mentions.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.language.v1beta2.EntityMention> getMentionsList() {
    return mentions_;
  }
  /**
   *
   *
   * <pre>
   * The mentions of this entity in the input document. The API currently
   * supports proper noun mentions.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.language.v1beta2.EntityMentionOrBuilder>
      getMentionsOrBuilderList() {
    return mentions_;
  }
  /**
   *
   *
   * <pre>
   * The mentions of this entity in the input document. The API currently
   * supports proper noun mentions.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
   */
  @java.lang.Override
  public int getMentionsCount() {
    return mentions_.size();
  }
  /**
   *
   *
   * <pre>
   * The mentions of this entity in the input document. The API currently
   * supports proper noun mentions.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.EntityMention getMentions(int index) {
    return mentions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The mentions of this entity in the input document. The API currently
   * supports proper noun mentions.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.EntityMentionOrBuilder getMentionsOrBuilder(int index) {
    return mentions_.get(index);
  }

  public static final int SENTIMENT_FIELD_NUMBER = 6;
  private com.google.cloud.language.v1beta2.Sentiment sentiment_;
  /**
   *
   *
   * <pre>
   * For calls to [AnalyzeEntitySentiment][] or if
   * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
   * is set to true, this field will contain the aggregate sentiment expressed
   * for this entity in the provided document.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
   *
   * @return Whether the sentiment field is set.
   */
  @java.lang.Override
  public boolean hasSentiment() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * For calls to [AnalyzeEntitySentiment][] or if
   * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
   * is set to true, this field will contain the aggregate sentiment expressed
   * for this entity in the provided document.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
   *
   * @return The sentiment.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.Sentiment getSentiment() {
    return sentiment_ == null
        ? com.google.cloud.language.v1beta2.Sentiment.getDefaultInstance()
        : sentiment_;
  }
  /**
   *
   *
   * <pre>
   * For calls to [AnalyzeEntitySentiment][] or if
   * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
   * is set to true, this field will contain the aggregate sentiment expressed
   * for this entity in the provided document.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.SentimentOrBuilder getSentimentOrBuilder() {
    return sentiment_ == null
        ? com.google.cloud.language.v1beta2.Sentiment.getDefaultInstance()
        : sentiment_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_ != com.google.cloud.language.v1beta2.Entity.Type.UNKNOWN.getNumber()) {
      output.writeEnum(2, type_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 3);
    if (java.lang.Float.floatToRawIntBits(salience_) != 0) {
      output.writeFloat(4, salience_);
    }
    for (int i = 0; i < mentions_.size(); i++) {
      output.writeMessage(5, mentions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getSentiment());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_ != com.google.cloud.language.v1beta2.Entity.Type.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metadata__);
    }
    if (java.lang.Float.floatToRawIntBits(salience_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, salience_);
    }
    for (int i = 0; i < mentions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, mentions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSentiment());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.language.v1beta2.Entity)) {
      return super.equals(obj);
    }
    com.google.cloud.language.v1beta2.Entity other = (com.google.cloud.language.v1beta2.Entity) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (java.lang.Float.floatToIntBits(getSalience())
        != java.lang.Float.floatToIntBits(other.getSalience())) return false;
    if (!getMentionsList().equals(other.getMentionsList())) return false;
    if (hasSentiment() != other.hasSentiment()) return false;
    if (hasSentiment()) {
      if (!getSentiment().equals(other.getSentiment())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    hash = (37 * hash) + SALIENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getSalience());
    if (getMentionsCount() > 0) {
      hash = (37 * hash) + MENTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMentionsList().hashCode();
    }
    if (hasSentiment()) {
      hash = (37 * hash) + SENTIMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSentiment().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Entity parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.Entity parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.Entity parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.language.v1beta2.Entity prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a phrase in the text that is a known entity, such as
   * a person, an organization, or location. The API associates information, such
   * as salience and mentions, with entities.
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1beta2.Entity}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.language.v1beta2.Entity)
      com.google.cloud.language.v1beta2.EntityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_Entity_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_Entity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1beta2.Entity.class,
              com.google.cloud.language.v1beta2.Entity.Builder.class);
    }

    // Construct using com.google.cloud.language.v1beta2.Entity.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMentionsFieldBuilder();
        getSentimentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      internalGetMutableMetadata().clear();
      salience_ = 0F;
      if (mentionsBuilder_ == null) {
        mentions_ = java.util.Collections.emptyList();
      } else {
        mentions_ = null;
        mentionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      sentiment_ = null;
      if (sentimentBuilder_ != null) {
        sentimentBuilder_.dispose();
        sentimentBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_Entity_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.Entity getDefaultInstanceForType() {
      return com.google.cloud.language.v1beta2.Entity.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.Entity build() {
      com.google.cloud.language.v1beta2.Entity result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.Entity buildPartial() {
      com.google.cloud.language.v1beta2.Entity result =
          new com.google.cloud.language.v1beta2.Entity(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.language.v1beta2.Entity result) {
      if (mentionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          mentions_ = java.util.Collections.unmodifiableList(mentions_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.mentions_ = mentions_;
      } else {
        result.mentions_ = mentionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.language.v1beta2.Entity result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metadata_ = internalGetMetadata();
        result.metadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.salience_ = salience_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sentiment_ = sentimentBuilder_ == null ? sentiment_ : sentimentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.language.v1beta2.Entity) {
        return mergeFrom((com.google.cloud.language.v1beta2.Entity) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.language.v1beta2.Entity other) {
      if (other == com.google.cloud.language.v1beta2.Entity.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      bitField0_ |= 0x00000004;
      if (other.getSalience() != 0F) {
        setSalience(other.getSalience());
      }
      if (mentionsBuilder_ == null) {
        if (!other.mentions_.isEmpty()) {
          if (mentions_.isEmpty()) {
            mentions_ = other.mentions_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureMentionsIsMutable();
            mentions_.addAll(other.mentions_);
          }
          onChanged();
        }
      } else {
        if (!other.mentions_.isEmpty()) {
          if (mentionsBuilder_.isEmpty()) {
            mentionsBuilder_.dispose();
            mentionsBuilder_ = null;
            mentions_ = other.mentions_;
            bitField0_ = (bitField0_ & ~0x00000010);
            mentionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMentionsFieldBuilder()
                    : null;
          } else {
            mentionsBuilder_.addAllMessages(other.mentions_);
          }
        }
      }
      if (other.hasSentiment()) {
        mergeSentiment(other.getSentiment());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                    input.readMessage(
                        MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadata()
                    .getMutableMap()
                    .put(metadata__.getKey(), metadata__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 37:
              {
                salience_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            case 42:
              {
                com.google.cloud.language.v1beta2.EntityMention m =
                    input.readMessage(
                        com.google.cloud.language.v1beta2.EntityMention.parser(),
                        extensionRegistry);
                if (mentionsBuilder_ == null) {
                  ensureMentionsIsMutable();
                  mentions_.add(m);
                } else {
                  mentionsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSentimentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The representative name for the entity.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The representative name for the entity.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The representative name for the entity.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The representative name for the entity.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The representative name for the entity.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The entity type.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Entity.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The entity type.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Entity.Type type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity type.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Entity.Type type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.language.v1beta2.Entity.Type getType() {
      com.google.cloud.language.v1beta2.Entity.Type result =
          com.google.cloud.language.v1beta2.Entity.Type.forNumber(type_);
      return result == null ? com.google.cloud.language.v1beta2.Entity.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The entity type.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Entity.Type type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.language.v1beta2.Entity.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity type.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Entity.Type type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the entity.
     *
     * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     * and Knowledge Graph MID (`mid`), if they are available. For the metadata
     * associated with other entity types, see the Type table below.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the entity.
     *
     * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     * and Knowledge Graph MID (`mid`), if they are available. For the metadata
     * associated with other entity types, see the Type table below.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the entity.
     *
     * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     * and Knowledge Graph MID (`mid`), if they are available. For the metadata
     * associated with other entity types, see the Type table below.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the entity.
     *
     * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     * and Knowledge Graph MID (`mid`), if they are available. For the metadata
     * associated with other entity types, see the Type table below.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the entity.
     *
     * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     * and Knowledge Graph MID (`mid`), if they are available. For the metadata
     * associated with other entity types, see the Type table below.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      bitField0_ |= 0x00000004;
      return internalGetMutableMetadata().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the entity.
     *
     * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     * and Knowledge Graph MID (`mid`), if they are available. For the metadata
     * associated with other entity types, see the Type table below.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the entity.
     *
     * For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     * and Knowledge Graph MID (`mid`), if they are available. For the metadata
     * associated with other entity types, see the Type table below.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private float salience_;
    /**
     *
     *
     * <pre>
     * The salience score associated with the entity in the [0, 1.0] range.
     *
     * The salience score for an entity provides information about the
     * importance or centrality of that entity to the entire document text.
     * Scores closer to 0 are less salient, while scores closer to 1.0 are highly
     * salient.
     * </pre>
     *
     * <code>float salience = 4;</code>
     *
     * @return The salience.
     */
    @java.lang.Override
    public float getSalience() {
      return salience_;
    }
    /**
     *
     *
     * <pre>
     * The salience score associated with the entity in the [0, 1.0] range.
     *
     * The salience score for an entity provides information about the
     * importance or centrality of that entity to the entire document text.
     * Scores closer to 0 are less salient, while scores closer to 1.0 are highly
     * salient.
     * </pre>
     *
     * <code>float salience = 4;</code>
     *
     * @param value The salience to set.
     * @return This builder for chaining.
     */
    public Builder setSalience(float value) {

      salience_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The salience score associated with the entity in the [0, 1.0] range.
     *
     * The salience score for an entity provides information about the
     * importance or centrality of that entity to the entire document text.
     * Scores closer to 0 are less salient, while scores closer to 1.0 are highly
     * salient.
     * </pre>
     *
     * <code>float salience = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSalience() {
      bitField0_ = (bitField0_ & ~0x00000008);
      salience_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.language.v1beta2.EntityMention> mentions_ =
        java.util.Collections.emptyList();

    private void ensureMentionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        mentions_ =
            new java.util.ArrayList<com.google.cloud.language.v1beta2.EntityMention>(mentions_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1beta2.EntityMention,
            com.google.cloud.language.v1beta2.EntityMention.Builder,
            com.google.cloud.language.v1beta2.EntityMentionOrBuilder>
        mentionsBuilder_;

    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public java.util.List<com.google.cloud.language.v1beta2.EntityMention> getMentionsList() {
      if (mentionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mentions_);
      } else {
        return mentionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public int getMentionsCount() {
      if (mentionsBuilder_ == null) {
        return mentions_.size();
      } else {
        return mentionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public com.google.cloud.language.v1beta2.EntityMention getMentions(int index) {
      if (mentionsBuilder_ == null) {
        return mentions_.get(index);
      } else {
        return mentionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder setMentions(int index, com.google.cloud.language.v1beta2.EntityMention value) {
      if (mentionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMentionsIsMutable();
        mentions_.set(index, value);
        onChanged();
      } else {
        mentionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder setMentions(
        int index, com.google.cloud.language.v1beta2.EntityMention.Builder builderForValue) {
      if (mentionsBuilder_ == null) {
        ensureMentionsIsMutable();
        mentions_.set(index, builderForValue.build());
        onChanged();
      } else {
        mentionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder addMentions(com.google.cloud.language.v1beta2.EntityMention value) {
      if (mentionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMentionsIsMutable();
        mentions_.add(value);
        onChanged();
      } else {
        mentionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder addMentions(int index, com.google.cloud.language.v1beta2.EntityMention value) {
      if (mentionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMentionsIsMutable();
        mentions_.add(index, value);
        onChanged();
      } else {
        mentionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder addMentions(
        com.google.cloud.language.v1beta2.EntityMention.Builder builderForValue) {
      if (mentionsBuilder_ == null) {
        ensureMentionsIsMutable();
        mentions_.add(builderForValue.build());
        onChanged();
      } else {
        mentionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder addMentions(
        int index, com.google.cloud.language.v1beta2.EntityMention.Builder builderForValue) {
      if (mentionsBuilder_ == null) {
        ensureMentionsIsMutable();
        mentions_.add(index, builderForValue.build());
        onChanged();
      } else {
        mentionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder addAllMentions(
        java.lang.Iterable<? extends com.google.cloud.language.v1beta2.EntityMention> values) {
      if (mentionsBuilder_ == null) {
        ensureMentionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mentions_);
        onChanged();
      } else {
        mentionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder clearMentions() {
      if (mentionsBuilder_ == null) {
        mentions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        mentionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public Builder removeMentions(int index) {
      if (mentionsBuilder_ == null) {
        ensureMentionsIsMutable();
        mentions_.remove(index);
        onChanged();
      } else {
        mentionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public com.google.cloud.language.v1beta2.EntityMention.Builder getMentionsBuilder(int index) {
      return getMentionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public com.google.cloud.language.v1beta2.EntityMentionOrBuilder getMentionsOrBuilder(
        int index) {
      if (mentionsBuilder_ == null) {
        return mentions_.get(index);
      } else {
        return mentionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.language.v1beta2.EntityMentionOrBuilder>
        getMentionsOrBuilderList() {
      if (mentionsBuilder_ != null) {
        return mentionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mentions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public com.google.cloud.language.v1beta2.EntityMention.Builder addMentionsBuilder() {
      return getMentionsFieldBuilder()
          .addBuilder(com.google.cloud.language.v1beta2.EntityMention.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public com.google.cloud.language.v1beta2.EntityMention.Builder addMentionsBuilder(int index) {
      return getMentionsFieldBuilder()
          .addBuilder(index, com.google.cloud.language.v1beta2.EntityMention.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mentions of this entity in the input document. The API currently
     * supports proper noun mentions.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.EntityMention mentions = 5;</code>
     */
    public java.util.List<com.google.cloud.language.v1beta2.EntityMention.Builder>
        getMentionsBuilderList() {
      return getMentionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1beta2.EntityMention,
            com.google.cloud.language.v1beta2.EntityMention.Builder,
            com.google.cloud.language.v1beta2.EntityMentionOrBuilder>
        getMentionsFieldBuilder() {
      if (mentionsBuilder_ == null) {
        mentionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.language.v1beta2.EntityMention,
                com.google.cloud.language.v1beta2.EntityMention.Builder,
                com.google.cloud.language.v1beta2.EntityMentionOrBuilder>(
                mentions_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        mentions_ = null;
      }
      return mentionsBuilder_;
    }

    private com.google.cloud.language.v1beta2.Sentiment sentiment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.Sentiment,
            com.google.cloud.language.v1beta2.Sentiment.Builder,
            com.google.cloud.language.v1beta2.SentimentOrBuilder>
        sentimentBuilder_;
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     *
     * @return Whether the sentiment field is set.
     */
    public boolean hasSentiment() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     *
     * @return The sentiment.
     */
    public com.google.cloud.language.v1beta2.Sentiment getSentiment() {
      if (sentimentBuilder_ == null) {
        return sentiment_ == null
            ? com.google.cloud.language.v1beta2.Sentiment.getDefaultInstance()
            : sentiment_;
      } else {
        return sentimentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     */
    public Builder setSentiment(com.google.cloud.language.v1beta2.Sentiment value) {
      if (sentimentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sentiment_ = value;
      } else {
        sentimentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     */
    public Builder setSentiment(
        com.google.cloud.language.v1beta2.Sentiment.Builder builderForValue) {
      if (sentimentBuilder_ == null) {
        sentiment_ = builderForValue.build();
      } else {
        sentimentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     */
    public Builder mergeSentiment(com.google.cloud.language.v1beta2.Sentiment value) {
      if (sentimentBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && sentiment_ != null
            && sentiment_ != com.google.cloud.language.v1beta2.Sentiment.getDefaultInstance()) {
          getSentimentBuilder().mergeFrom(value);
        } else {
          sentiment_ = value;
        }
      } else {
        sentimentBuilder_.mergeFrom(value);
      }
      if (sentiment_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     */
    public Builder clearSentiment() {
      bitField0_ = (bitField0_ & ~0x00000020);
      sentiment_ = null;
      if (sentimentBuilder_ != null) {
        sentimentBuilder_.dispose();
        sentimentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     */
    public com.google.cloud.language.v1beta2.Sentiment.Builder getSentimentBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSentimentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     */
    public com.google.cloud.language.v1beta2.SentimentOrBuilder getSentimentOrBuilder() {
      if (sentimentBuilder_ != null) {
        return sentimentBuilder_.getMessageOrBuilder();
      } else {
        return sentiment_ == null
            ? com.google.cloud.language.v1beta2.Sentiment.getDefaultInstance()
            : sentiment_;
      }
    }
    /**
     *
     *
     * <pre>
     * For calls to [AnalyzeEntitySentiment][] or if
     * [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment]
     * is set to true, this field will contain the aggregate sentiment expressed
     * for this entity in the provided document.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.Sentiment sentiment = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.Sentiment,
            com.google.cloud.language.v1beta2.Sentiment.Builder,
            com.google.cloud.language.v1beta2.SentimentOrBuilder>
        getSentimentFieldBuilder() {
      if (sentimentBuilder_ == null) {
        sentimentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.language.v1beta2.Sentiment,
                com.google.cloud.language.v1beta2.Sentiment.Builder,
                com.google.cloud.language.v1beta2.SentimentOrBuilder>(
                getSentiment(), getParentForChildren(), isClean());
        sentiment_ = null;
      }
      return sentimentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.language.v1beta2.Entity)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.language.v1beta2.Entity)
  private static final com.google.cloud.language.v1beta2.Entity DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.language.v1beta2.Entity();
  }

  public static com.google.cloud.language.v1beta2.Entity getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Entity> PARSER =
      new com.google.protobuf.AbstractParser<Entity>() {
        @java.lang.Override
        public Entity parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Entity> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Entity> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.language.v1beta2.Entity getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
