/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/language/v1beta2/language_service.proto

package com.google.cloud.language.v1beta2;

/**
 *
 *
 * <pre>
 * The syntax analysis response message.
 * </pre>
 *
 * Protobuf type {@code google.cloud.language.v1beta2.AnalyzeSyntaxResponse}
 */
public final class AnalyzeSyntaxResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.language.v1beta2.AnalyzeSyntaxResponse)
    AnalyzeSyntaxResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnalyzeSyntaxResponse.newBuilder() to construct.
  private AnalyzeSyntaxResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnalyzeSyntaxResponse() {
    sentences_ = java.util.Collections.emptyList();
    tokens_ = java.util.Collections.emptyList();
    language_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnalyzeSyntaxResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnalyzeSyntaxResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                sentences_ = new java.util.ArrayList<com.google.cloud.language.v1beta2.Sentence>();
                mutable_bitField0_ |= 0x00000001;
              }
              sentences_.add(
                  input.readMessage(
                      com.google.cloud.language.v1beta2.Sentence.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                tokens_ = new java.util.ArrayList<com.google.cloud.language.v1beta2.Token>();
                mutable_bitField0_ |= 0x00000002;
              }
              tokens_.add(
                  input.readMessage(
                      com.google.cloud.language.v1beta2.Token.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              language_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        sentences_ = java.util.Collections.unmodifiableList(sentences_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        tokens_ = java.util.Collections.unmodifiableList(tokens_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_AnalyzeSyntaxResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_AnalyzeSyntaxResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse.class,
            com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse.Builder.class);
  }

  public static final int SENTENCES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.language.v1beta2.Sentence> sentences_;
  /**
   *
   *
   * <pre>
   * Sentences in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.language.v1beta2.Sentence> getSentencesList() {
    return sentences_;
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.language.v1beta2.SentenceOrBuilder>
      getSentencesOrBuilderList() {
    return sentences_;
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public int getSentencesCount() {
    return sentences_.size();
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.Sentence getSentences(int index) {
    return sentences_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Sentences in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.SentenceOrBuilder getSentencesOrBuilder(int index) {
    return sentences_.get(index);
  }

  public static final int TOKENS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.language.v1beta2.Token> tokens_;
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.language.v1beta2.Token> getTokensList() {
    return tokens_;
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.language.v1beta2.TokenOrBuilder>
      getTokensOrBuilderList() {
    return tokens_;
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
   */
  @java.lang.Override
  public int getTokensCount() {
    return tokens_.size();
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.Token getTokens(int index) {
    return tokens_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tokens, along with their syntactic information, in the input document.
   * </pre>
   *
   * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.TokenOrBuilder getTokensOrBuilder(int index) {
    return tokens_.get(index);
  }

  public static final int LANGUAGE_FIELD_NUMBER = 3;
  private volatile java.lang.Object language_;
  /**
   *
   *
   * <pre>
   * The language of the text, which will be the same as the language specified
   * in the request or, if not specified, the automatically-detected language.
   * See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
   * </pre>
   *
   * <code>string language = 3;</code>
   *
   * @return The language.
   */
  @java.lang.Override
  public java.lang.String getLanguage() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      language_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language of the text, which will be the same as the language specified
   * in the request or, if not specified, the automatically-detected language.
   * See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
   * </pre>
   *
   * <code>string language = 3;</code>
   *
   * @return The bytes for language.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageBytes() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      language_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < sentences_.size(); i++) {
      output.writeMessage(1, sentences_.get(i));
    }
    for (int i = 0; i < tokens_.size(); i++) {
      output.writeMessage(2, tokens_.get(i));
    }
    if (!getLanguageBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, language_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < sentences_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, sentences_.get(i));
    }
    for (int i = 0; i < tokens_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, tokens_.get(i));
    }
    if (!getLanguageBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, language_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse other =
        (com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse) obj;

    if (!getSentencesList().equals(other.getSentencesList())) return false;
    if (!getTokensList().equals(other.getTokensList())) return false;
    if (!getLanguage().equals(other.getLanguage())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSentencesCount() > 0) {
      hash = (37 * hash) + SENTENCES_FIELD_NUMBER;
      hash = (53 * hash) + getSentencesList().hashCode();
    }
    if (getTokensCount() > 0) {
      hash = (37 * hash) + TOKENS_FIELD_NUMBER;
      hash = (53 * hash) + getTokensList().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguage().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The syntax analysis response message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1beta2.AnalyzeSyntaxResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.language.v1beta2.AnalyzeSyntaxResponse)
      com.google.cloud.language.v1beta2.AnalyzeSyntaxResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnalyzeSyntaxResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnalyzeSyntaxResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse.class,
              com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse.Builder.class);
    }

    // Construct using com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSentencesFieldBuilder();
        getTokensFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (sentencesBuilder_ == null) {
        sentences_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        sentencesBuilder_.clear();
      }
      if (tokensBuilder_ == null) {
        tokens_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        tokensBuilder_.clear();
      }
      language_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_AnalyzeSyntaxResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse getDefaultInstanceForType() {
      return com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse build() {
      com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse buildPartial() {
      com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse result =
          new com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse(this);
      int from_bitField0_ = bitField0_;
      if (sentencesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          sentences_ = java.util.Collections.unmodifiableList(sentences_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.sentences_ = sentences_;
      } else {
        result.sentences_ = sentencesBuilder_.build();
      }
      if (tokensBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          tokens_ = java.util.Collections.unmodifiableList(tokens_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.tokens_ = tokens_;
      } else {
        result.tokens_ = tokensBuilder_.build();
      }
      result.language_ = language_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse) {
        return mergeFrom((com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse other) {
      if (other == com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse.getDefaultInstance())
        return this;
      if (sentencesBuilder_ == null) {
        if (!other.sentences_.isEmpty()) {
          if (sentences_.isEmpty()) {
            sentences_ = other.sentences_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSentencesIsMutable();
            sentences_.addAll(other.sentences_);
          }
          onChanged();
        }
      } else {
        if (!other.sentences_.isEmpty()) {
          if (sentencesBuilder_.isEmpty()) {
            sentencesBuilder_.dispose();
            sentencesBuilder_ = null;
            sentences_ = other.sentences_;
            bitField0_ = (bitField0_ & ~0x00000001);
            sentencesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSentencesFieldBuilder()
                    : null;
          } else {
            sentencesBuilder_.addAllMessages(other.sentences_);
          }
        }
      }
      if (tokensBuilder_ == null) {
        if (!other.tokens_.isEmpty()) {
          if (tokens_.isEmpty()) {
            tokens_ = other.tokens_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTokensIsMutable();
            tokens_.addAll(other.tokens_);
          }
          onChanged();
        }
      } else {
        if (!other.tokens_.isEmpty()) {
          if (tokensBuilder_.isEmpty()) {
            tokensBuilder_.dispose();
            tokensBuilder_ = null;
            tokens_ = other.tokens_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tokensBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTokensFieldBuilder()
                    : null;
          } else {
            tokensBuilder_.addAllMessages(other.tokens_);
          }
        }
      }
      if (!other.getLanguage().isEmpty()) {
        language_ = other.language_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.language.v1beta2.Sentence> sentences_ =
        java.util.Collections.emptyList();

    private void ensureSentencesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sentences_ =
            new java.util.ArrayList<com.google.cloud.language.v1beta2.Sentence>(sentences_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1beta2.Sentence,
            com.google.cloud.language.v1beta2.Sentence.Builder,
            com.google.cloud.language.v1beta2.SentenceOrBuilder>
        sentencesBuilder_;

    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public java.util.List<com.google.cloud.language.v1beta2.Sentence> getSentencesList() {
      if (sentencesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sentences_);
      } else {
        return sentencesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public int getSentencesCount() {
      if (sentencesBuilder_ == null) {
        return sentences_.size();
      } else {
        return sentencesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1beta2.Sentence getSentences(int index) {
      if (sentencesBuilder_ == null) {
        return sentences_.get(index);
      } else {
        return sentencesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder setSentences(int index, com.google.cloud.language.v1beta2.Sentence value) {
      if (sentencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSentencesIsMutable();
        sentences_.set(index, value);
        onChanged();
      } else {
        sentencesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder setSentences(
        int index, com.google.cloud.language.v1beta2.Sentence.Builder builderForValue) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.set(index, builderForValue.build());
        onChanged();
      } else {
        sentencesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder addSentences(com.google.cloud.language.v1beta2.Sentence value) {
      if (sentencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSentencesIsMutable();
        sentences_.add(value);
        onChanged();
      } else {
        sentencesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder addSentences(int index, com.google.cloud.language.v1beta2.Sentence value) {
      if (sentencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSentencesIsMutable();
        sentences_.add(index, value);
        onChanged();
      } else {
        sentencesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder addSentences(
        com.google.cloud.language.v1beta2.Sentence.Builder builderForValue) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.add(builderForValue.build());
        onChanged();
      } else {
        sentencesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder addSentences(
        int index, com.google.cloud.language.v1beta2.Sentence.Builder builderForValue) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.add(index, builderForValue.build());
        onChanged();
      } else {
        sentencesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder addAllSentences(
        java.lang.Iterable<? extends com.google.cloud.language.v1beta2.Sentence> values) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sentences_);
        onChanged();
      } else {
        sentencesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder clearSentences() {
      if (sentencesBuilder_ == null) {
        sentences_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        sentencesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public Builder removeSentences(int index) {
      if (sentencesBuilder_ == null) {
        ensureSentencesIsMutable();
        sentences_.remove(index);
        onChanged();
      } else {
        sentencesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1beta2.Sentence.Builder getSentencesBuilder(int index) {
      return getSentencesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1beta2.SentenceOrBuilder getSentencesOrBuilder(int index) {
      if (sentencesBuilder_ == null) {
        return sentences_.get(index);
      } else {
        return sentencesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.language.v1beta2.SentenceOrBuilder>
        getSentencesOrBuilderList() {
      if (sentencesBuilder_ != null) {
        return sentencesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sentences_);
      }
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1beta2.Sentence.Builder addSentencesBuilder() {
      return getSentencesFieldBuilder()
          .addBuilder(com.google.cloud.language.v1beta2.Sentence.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public com.google.cloud.language.v1beta2.Sentence.Builder addSentencesBuilder(int index) {
      return getSentencesFieldBuilder()
          .addBuilder(index, com.google.cloud.language.v1beta2.Sentence.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sentences in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Sentence sentences = 1;</code>
     */
    public java.util.List<com.google.cloud.language.v1beta2.Sentence.Builder>
        getSentencesBuilderList() {
      return getSentencesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1beta2.Sentence,
            com.google.cloud.language.v1beta2.Sentence.Builder,
            com.google.cloud.language.v1beta2.SentenceOrBuilder>
        getSentencesFieldBuilder() {
      if (sentencesBuilder_ == null) {
        sentencesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.language.v1beta2.Sentence,
                com.google.cloud.language.v1beta2.Sentence.Builder,
                com.google.cloud.language.v1beta2.SentenceOrBuilder>(
                sentences_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        sentences_ = null;
      }
      return sentencesBuilder_;
    }

    private java.util.List<com.google.cloud.language.v1beta2.Token> tokens_ =
        java.util.Collections.emptyList();

    private void ensureTokensIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        tokens_ = new java.util.ArrayList<com.google.cloud.language.v1beta2.Token>(tokens_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1beta2.Token,
            com.google.cloud.language.v1beta2.Token.Builder,
            com.google.cloud.language.v1beta2.TokenOrBuilder>
        tokensBuilder_;

    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public java.util.List<com.google.cloud.language.v1beta2.Token> getTokensList() {
      if (tokensBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tokens_);
      } else {
        return tokensBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public int getTokensCount() {
      if (tokensBuilder_ == null) {
        return tokens_.size();
      } else {
        return tokensBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1beta2.Token getTokens(int index) {
      if (tokensBuilder_ == null) {
        return tokens_.get(index);
      } else {
        return tokensBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder setTokens(int index, com.google.cloud.language.v1beta2.Token value) {
      if (tokensBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTokensIsMutable();
        tokens_.set(index, value);
        onChanged();
      } else {
        tokensBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder setTokens(
        int index, com.google.cloud.language.v1beta2.Token.Builder builderForValue) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.set(index, builderForValue.build());
        onChanged();
      } else {
        tokensBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder addTokens(com.google.cloud.language.v1beta2.Token value) {
      if (tokensBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTokensIsMutable();
        tokens_.add(value);
        onChanged();
      } else {
        tokensBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder addTokens(int index, com.google.cloud.language.v1beta2.Token value) {
      if (tokensBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTokensIsMutable();
        tokens_.add(index, value);
        onChanged();
      } else {
        tokensBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder addTokens(com.google.cloud.language.v1beta2.Token.Builder builderForValue) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.add(builderForValue.build());
        onChanged();
      } else {
        tokensBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder addTokens(
        int index, com.google.cloud.language.v1beta2.Token.Builder builderForValue) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.add(index, builderForValue.build());
        onChanged();
      } else {
        tokensBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder addAllTokens(
        java.lang.Iterable<? extends com.google.cloud.language.v1beta2.Token> values) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tokens_);
        onChanged();
      } else {
        tokensBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder clearTokens() {
      if (tokensBuilder_ == null) {
        tokens_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tokensBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public Builder removeTokens(int index) {
      if (tokensBuilder_ == null) {
        ensureTokensIsMutable();
        tokens_.remove(index);
        onChanged();
      } else {
        tokensBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1beta2.Token.Builder getTokensBuilder(int index) {
      return getTokensFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1beta2.TokenOrBuilder getTokensOrBuilder(int index) {
      if (tokensBuilder_ == null) {
        return tokens_.get(index);
      } else {
        return tokensBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.language.v1beta2.TokenOrBuilder>
        getTokensOrBuilderList() {
      if (tokensBuilder_ != null) {
        return tokensBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tokens_);
      }
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1beta2.Token.Builder addTokensBuilder() {
      return getTokensFieldBuilder()
          .addBuilder(com.google.cloud.language.v1beta2.Token.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public com.google.cloud.language.v1beta2.Token.Builder addTokensBuilder(int index) {
      return getTokensFieldBuilder()
          .addBuilder(index, com.google.cloud.language.v1beta2.Token.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Tokens, along with their syntactic information, in the input document.
     * </pre>
     *
     * <code>repeated .google.cloud.language.v1beta2.Token tokens = 2;</code>
     */
    public java.util.List<com.google.cloud.language.v1beta2.Token.Builder> getTokensBuilderList() {
      return getTokensFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.language.v1beta2.Token,
            com.google.cloud.language.v1beta2.Token.Builder,
            com.google.cloud.language.v1beta2.TokenOrBuilder>
        getTokensFieldBuilder() {
      if (tokensBuilder_ == null) {
        tokensBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.language.v1beta2.Token,
                com.google.cloud.language.v1beta2.Token.Builder,
                com.google.cloud.language.v1beta2.TokenOrBuilder>(
                tokens_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        tokens_ = null;
      }
      return tokensBuilder_;
    }

    private java.lang.Object language_ = "";
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 3;</code>
     *
     * @return The language.
     */
    public java.lang.String getLanguage() {
      java.lang.Object ref = language_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        language_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 3;</code>
     *
     * @return The bytes for language.
     */
    public com.google.protobuf.ByteString getLanguageBytes() {
      java.lang.Object ref = language_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        language_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 3;</code>
     *
     * @param value The language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      language_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguage() {

      language_ = getDefaultInstance().getLanguage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the text, which will be the same as the language specified
     * in the request or, if not specified, the automatically-detected language.
     * See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
     * </pre>
     *
     * <code>string language = 3;</code>
     *
     * @param value The bytes for language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      language_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.language.v1beta2.AnalyzeSyntaxResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.language.v1beta2.AnalyzeSyntaxResponse)
  private static final com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse();
  }

  public static com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnalyzeSyntaxResponse> PARSER =
      new com.google.protobuf.AbstractParser<AnalyzeSyntaxResponse>() {
        @java.lang.Override
        public AnalyzeSyntaxResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnalyzeSyntaxResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnalyzeSyntaxResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnalyzeSyntaxResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
