/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/language/v1beta2/language_service.proto

package com.google.cloud.language.v1beta2;

/**
 *
 *
 * <pre>
 * Represents the smallest syntactic building block of the text.
 * </pre>
 *
 * Protobuf type {@code google.cloud.language.v1beta2.Token}
 */
public final class Token extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.language.v1beta2.Token)
    TokenOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Token.newBuilder() to construct.
  private Token(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Token() {
    lemma_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Token();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_Token_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.language.v1beta2.LanguageServiceProto
        .internal_static_google_cloud_language_v1beta2_Token_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.language.v1beta2.Token.class,
            com.google.cloud.language.v1beta2.Token.Builder.class);
  }

  public static final int TEXT_FIELD_NUMBER = 1;
  private com.google.cloud.language.v1beta2.TextSpan text_;
  /**
   *
   *
   * <pre>
   * The token text.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
   *
   * @return Whether the text field is set.
   */
  @java.lang.Override
  public boolean hasText() {
    return text_ != null;
  }
  /**
   *
   *
   * <pre>
   * The token text.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.TextSpan getText() {
    return text_ == null ? com.google.cloud.language.v1beta2.TextSpan.getDefaultInstance() : text_;
  }
  /**
   *
   *
   * <pre>
   * The token text.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.TextSpanOrBuilder getTextOrBuilder() {
    return getText();
  }

  public static final int PART_OF_SPEECH_FIELD_NUMBER = 2;
  private com.google.cloud.language.v1beta2.PartOfSpeech partOfSpeech_;
  /**
   *
   *
   * <pre>
   * Parts of speech tag for this token.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
   *
   * @return Whether the partOfSpeech field is set.
   */
  @java.lang.Override
  public boolean hasPartOfSpeech() {
    return partOfSpeech_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parts of speech tag for this token.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
   *
   * @return The partOfSpeech.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.PartOfSpeech getPartOfSpeech() {
    return partOfSpeech_ == null
        ? com.google.cloud.language.v1beta2.PartOfSpeech.getDefaultInstance()
        : partOfSpeech_;
  }
  /**
   *
   *
   * <pre>
   * Parts of speech tag for this token.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.PartOfSpeechOrBuilder getPartOfSpeechOrBuilder() {
    return getPartOfSpeech();
  }

  public static final int DEPENDENCY_EDGE_FIELD_NUMBER = 3;
  private com.google.cloud.language.v1beta2.DependencyEdge dependencyEdge_;
  /**
   *
   *
   * <pre>
   * Dependency tree parse for this token.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
   *
   * @return Whether the dependencyEdge field is set.
   */
  @java.lang.Override
  public boolean hasDependencyEdge() {
    return dependencyEdge_ != null;
  }
  /**
   *
   *
   * <pre>
   * Dependency tree parse for this token.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
   *
   * @return The dependencyEdge.
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.DependencyEdge getDependencyEdge() {
    return dependencyEdge_ == null
        ? com.google.cloud.language.v1beta2.DependencyEdge.getDefaultInstance()
        : dependencyEdge_;
  }
  /**
   *
   *
   * <pre>
   * Dependency tree parse for this token.
   * </pre>
   *
   * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.language.v1beta2.DependencyEdgeOrBuilder getDependencyEdgeOrBuilder() {
    return getDependencyEdge();
  }

  public static final int LEMMA_FIELD_NUMBER = 4;
  private volatile java.lang.Object lemma_;
  /**
   *
   *
   * <pre>
   * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
   * </pre>
   *
   * <code>string lemma = 4;</code>
   *
   * @return The lemma.
   */
  @java.lang.Override
  public java.lang.String getLemma() {
    java.lang.Object ref = lemma_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lemma_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
   * </pre>
   *
   * <code>string lemma = 4;</code>
   *
   * @return The bytes for lemma.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLemmaBytes() {
    java.lang.Object ref = lemma_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lemma_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (text_ != null) {
      output.writeMessage(1, getText());
    }
    if (partOfSpeech_ != null) {
      output.writeMessage(2, getPartOfSpeech());
    }
    if (dependencyEdge_ != null) {
      output.writeMessage(3, getDependencyEdge());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lemma_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, lemma_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (text_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getText());
    }
    if (partOfSpeech_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPartOfSpeech());
    }
    if (dependencyEdge_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDependencyEdge());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lemma_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, lemma_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.language.v1beta2.Token)) {
      return super.equals(obj);
    }
    com.google.cloud.language.v1beta2.Token other = (com.google.cloud.language.v1beta2.Token) obj;

    if (hasText() != other.hasText()) return false;
    if (hasText()) {
      if (!getText().equals(other.getText())) return false;
    }
    if (hasPartOfSpeech() != other.hasPartOfSpeech()) return false;
    if (hasPartOfSpeech()) {
      if (!getPartOfSpeech().equals(other.getPartOfSpeech())) return false;
    }
    if (hasDependencyEdge() != other.hasDependencyEdge()) return false;
    if (hasDependencyEdge()) {
      if (!getDependencyEdge().equals(other.getDependencyEdge())) return false;
    }
    if (!getLemma().equals(other.getLemma())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasText()) {
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
    }
    if (hasPartOfSpeech()) {
      hash = (37 * hash) + PART_OF_SPEECH_FIELD_NUMBER;
      hash = (53 * hash) + getPartOfSpeech().hashCode();
    }
    if (hasDependencyEdge()) {
      hash = (37 * hash) + DEPENDENCY_EDGE_FIELD_NUMBER;
      hash = (53 * hash) + getDependencyEdge().hashCode();
    }
    hash = (37 * hash) + LEMMA_FIELD_NUMBER;
    hash = (53 * hash) + getLemma().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Token parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.Token parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.language.v1beta2.Token parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.language.v1beta2.Token prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the smallest syntactic building block of the text.
   * </pre>
   *
   * Protobuf type {@code google.cloud.language.v1beta2.Token}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.language.v1beta2.Token)
      com.google.cloud.language.v1beta2.TokenOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_Token_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_Token_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.language.v1beta2.Token.class,
              com.google.cloud.language.v1beta2.Token.Builder.class);
    }

    // Construct using com.google.cloud.language.v1beta2.Token.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (textBuilder_ == null) {
        text_ = null;
      } else {
        text_ = null;
        textBuilder_ = null;
      }
      if (partOfSpeechBuilder_ == null) {
        partOfSpeech_ = null;
      } else {
        partOfSpeech_ = null;
        partOfSpeechBuilder_ = null;
      }
      if (dependencyEdgeBuilder_ == null) {
        dependencyEdge_ = null;
      } else {
        dependencyEdge_ = null;
        dependencyEdgeBuilder_ = null;
      }
      lemma_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.language.v1beta2.LanguageServiceProto
          .internal_static_google_cloud_language_v1beta2_Token_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.Token getDefaultInstanceForType() {
      return com.google.cloud.language.v1beta2.Token.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.Token build() {
      com.google.cloud.language.v1beta2.Token result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.language.v1beta2.Token buildPartial() {
      com.google.cloud.language.v1beta2.Token result =
          new com.google.cloud.language.v1beta2.Token(this);
      if (textBuilder_ == null) {
        result.text_ = text_;
      } else {
        result.text_ = textBuilder_.build();
      }
      if (partOfSpeechBuilder_ == null) {
        result.partOfSpeech_ = partOfSpeech_;
      } else {
        result.partOfSpeech_ = partOfSpeechBuilder_.build();
      }
      if (dependencyEdgeBuilder_ == null) {
        result.dependencyEdge_ = dependencyEdge_;
      } else {
        result.dependencyEdge_ = dependencyEdgeBuilder_.build();
      }
      result.lemma_ = lemma_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.language.v1beta2.Token) {
        return mergeFrom((com.google.cloud.language.v1beta2.Token) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.language.v1beta2.Token other) {
      if (other == com.google.cloud.language.v1beta2.Token.getDefaultInstance()) return this;
      if (other.hasText()) {
        mergeText(other.getText());
      }
      if (other.hasPartOfSpeech()) {
        mergePartOfSpeech(other.getPartOfSpeech());
      }
      if (other.hasDependencyEdge()) {
        mergeDependencyEdge(other.getDependencyEdge());
      }
      if (!other.getLemma().isEmpty()) {
        lemma_ = other.lemma_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTextFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPartOfSpeechFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDependencyEdgeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                lemma_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.cloud.language.v1beta2.TextSpan text_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.TextSpan,
            com.google.cloud.language.v1beta2.TextSpan.Builder,
            com.google.cloud.language.v1beta2.TextSpanOrBuilder>
        textBuilder_;
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    public boolean hasText() {
      return textBuilder_ != null || text_ != null;
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     *
     * @return The text.
     */
    public com.google.cloud.language.v1beta2.TextSpan getText() {
      if (textBuilder_ == null) {
        return text_ == null
            ? com.google.cloud.language.v1beta2.TextSpan.getDefaultInstance()
            : text_;
      } else {
        return textBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     */
    public Builder setText(com.google.cloud.language.v1beta2.TextSpan value) {
      if (textBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        onChanged();
      } else {
        textBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     */
    public Builder setText(com.google.cloud.language.v1beta2.TextSpan.Builder builderForValue) {
      if (textBuilder_ == null) {
        text_ = builderForValue.build();
        onChanged();
      } else {
        textBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     */
    public Builder mergeText(com.google.cloud.language.v1beta2.TextSpan value) {
      if (textBuilder_ == null) {
        if (text_ != null) {
          text_ =
              com.google.cloud.language.v1beta2.TextSpan.newBuilder(text_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          text_ = value;
        }
        onChanged();
      } else {
        textBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     */
    public Builder clearText() {
      if (textBuilder_ == null) {
        text_ = null;
        onChanged();
      } else {
        text_ = null;
        textBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     */
    public com.google.cloud.language.v1beta2.TextSpan.Builder getTextBuilder() {

      onChanged();
      return getTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     */
    public com.google.cloud.language.v1beta2.TextSpanOrBuilder getTextOrBuilder() {
      if (textBuilder_ != null) {
        return textBuilder_.getMessageOrBuilder();
      } else {
        return text_ == null
            ? com.google.cloud.language.v1beta2.TextSpan.getDefaultInstance()
            : text_;
      }
    }
    /**
     *
     *
     * <pre>
     * The token text.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.TextSpan text = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.TextSpan,
            com.google.cloud.language.v1beta2.TextSpan.Builder,
            com.google.cloud.language.v1beta2.TextSpanOrBuilder>
        getTextFieldBuilder() {
      if (textBuilder_ == null) {
        textBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.language.v1beta2.TextSpan,
                com.google.cloud.language.v1beta2.TextSpan.Builder,
                com.google.cloud.language.v1beta2.TextSpanOrBuilder>(
                getText(), getParentForChildren(), isClean());
        text_ = null;
      }
      return textBuilder_;
    }

    private com.google.cloud.language.v1beta2.PartOfSpeech partOfSpeech_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.PartOfSpeech,
            com.google.cloud.language.v1beta2.PartOfSpeech.Builder,
            com.google.cloud.language.v1beta2.PartOfSpeechOrBuilder>
        partOfSpeechBuilder_;
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     *
     * @return Whether the partOfSpeech field is set.
     */
    public boolean hasPartOfSpeech() {
      return partOfSpeechBuilder_ != null || partOfSpeech_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     *
     * @return The partOfSpeech.
     */
    public com.google.cloud.language.v1beta2.PartOfSpeech getPartOfSpeech() {
      if (partOfSpeechBuilder_ == null) {
        return partOfSpeech_ == null
            ? com.google.cloud.language.v1beta2.PartOfSpeech.getDefaultInstance()
            : partOfSpeech_;
      } else {
        return partOfSpeechBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     */
    public Builder setPartOfSpeech(com.google.cloud.language.v1beta2.PartOfSpeech value) {
      if (partOfSpeechBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partOfSpeech_ = value;
        onChanged();
      } else {
        partOfSpeechBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     */
    public Builder setPartOfSpeech(
        com.google.cloud.language.v1beta2.PartOfSpeech.Builder builderForValue) {
      if (partOfSpeechBuilder_ == null) {
        partOfSpeech_ = builderForValue.build();
        onChanged();
      } else {
        partOfSpeechBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     */
    public Builder mergePartOfSpeech(com.google.cloud.language.v1beta2.PartOfSpeech value) {
      if (partOfSpeechBuilder_ == null) {
        if (partOfSpeech_ != null) {
          partOfSpeech_ =
              com.google.cloud.language.v1beta2.PartOfSpeech.newBuilder(partOfSpeech_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          partOfSpeech_ = value;
        }
        onChanged();
      } else {
        partOfSpeechBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     */
    public Builder clearPartOfSpeech() {
      if (partOfSpeechBuilder_ == null) {
        partOfSpeech_ = null;
        onChanged();
      } else {
        partOfSpeech_ = null;
        partOfSpeechBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     */
    public com.google.cloud.language.v1beta2.PartOfSpeech.Builder getPartOfSpeechBuilder() {

      onChanged();
      return getPartOfSpeechFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     */
    public com.google.cloud.language.v1beta2.PartOfSpeechOrBuilder getPartOfSpeechOrBuilder() {
      if (partOfSpeechBuilder_ != null) {
        return partOfSpeechBuilder_.getMessageOrBuilder();
      } else {
        return partOfSpeech_ == null
            ? com.google.cloud.language.v1beta2.PartOfSpeech.getDefaultInstance()
            : partOfSpeech_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parts of speech tag for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.PartOfSpeech part_of_speech = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.PartOfSpeech,
            com.google.cloud.language.v1beta2.PartOfSpeech.Builder,
            com.google.cloud.language.v1beta2.PartOfSpeechOrBuilder>
        getPartOfSpeechFieldBuilder() {
      if (partOfSpeechBuilder_ == null) {
        partOfSpeechBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.language.v1beta2.PartOfSpeech,
                com.google.cloud.language.v1beta2.PartOfSpeech.Builder,
                com.google.cloud.language.v1beta2.PartOfSpeechOrBuilder>(
                getPartOfSpeech(), getParentForChildren(), isClean());
        partOfSpeech_ = null;
      }
      return partOfSpeechBuilder_;
    }

    private com.google.cloud.language.v1beta2.DependencyEdge dependencyEdge_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.DependencyEdge,
            com.google.cloud.language.v1beta2.DependencyEdge.Builder,
            com.google.cloud.language.v1beta2.DependencyEdgeOrBuilder>
        dependencyEdgeBuilder_;
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     *
     * @return Whether the dependencyEdge field is set.
     */
    public boolean hasDependencyEdge() {
      return dependencyEdgeBuilder_ != null || dependencyEdge_ != null;
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     *
     * @return The dependencyEdge.
     */
    public com.google.cloud.language.v1beta2.DependencyEdge getDependencyEdge() {
      if (dependencyEdgeBuilder_ == null) {
        return dependencyEdge_ == null
            ? com.google.cloud.language.v1beta2.DependencyEdge.getDefaultInstance()
            : dependencyEdge_;
      } else {
        return dependencyEdgeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     */
    public Builder setDependencyEdge(com.google.cloud.language.v1beta2.DependencyEdge value) {
      if (dependencyEdgeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dependencyEdge_ = value;
        onChanged();
      } else {
        dependencyEdgeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     */
    public Builder setDependencyEdge(
        com.google.cloud.language.v1beta2.DependencyEdge.Builder builderForValue) {
      if (dependencyEdgeBuilder_ == null) {
        dependencyEdge_ = builderForValue.build();
        onChanged();
      } else {
        dependencyEdgeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     */
    public Builder mergeDependencyEdge(com.google.cloud.language.v1beta2.DependencyEdge value) {
      if (dependencyEdgeBuilder_ == null) {
        if (dependencyEdge_ != null) {
          dependencyEdge_ =
              com.google.cloud.language.v1beta2.DependencyEdge.newBuilder(dependencyEdge_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dependencyEdge_ = value;
        }
        onChanged();
      } else {
        dependencyEdgeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     */
    public Builder clearDependencyEdge() {
      if (dependencyEdgeBuilder_ == null) {
        dependencyEdge_ = null;
        onChanged();
      } else {
        dependencyEdge_ = null;
        dependencyEdgeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     */
    public com.google.cloud.language.v1beta2.DependencyEdge.Builder getDependencyEdgeBuilder() {

      onChanged();
      return getDependencyEdgeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     */
    public com.google.cloud.language.v1beta2.DependencyEdgeOrBuilder getDependencyEdgeOrBuilder() {
      if (dependencyEdgeBuilder_ != null) {
        return dependencyEdgeBuilder_.getMessageOrBuilder();
      } else {
        return dependencyEdge_ == null
            ? com.google.cloud.language.v1beta2.DependencyEdge.getDefaultInstance()
            : dependencyEdge_;
      }
    }
    /**
     *
     *
     * <pre>
     * Dependency tree parse for this token.
     * </pre>
     *
     * <code>.google.cloud.language.v1beta2.DependencyEdge dependency_edge = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.language.v1beta2.DependencyEdge,
            com.google.cloud.language.v1beta2.DependencyEdge.Builder,
            com.google.cloud.language.v1beta2.DependencyEdgeOrBuilder>
        getDependencyEdgeFieldBuilder() {
      if (dependencyEdgeBuilder_ == null) {
        dependencyEdgeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.language.v1beta2.DependencyEdge,
                com.google.cloud.language.v1beta2.DependencyEdge.Builder,
                com.google.cloud.language.v1beta2.DependencyEdgeOrBuilder>(
                getDependencyEdge(), getParentForChildren(), isClean());
        dependencyEdge_ = null;
      }
      return dependencyEdgeBuilder_;
    }

    private java.lang.Object lemma_ = "";
    /**
     *
     *
     * <pre>
     * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
     * </pre>
     *
     * <code>string lemma = 4;</code>
     *
     * @return The lemma.
     */
    public java.lang.String getLemma() {
      java.lang.Object ref = lemma_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lemma_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
     * </pre>
     *
     * <code>string lemma = 4;</code>
     *
     * @return The bytes for lemma.
     */
    public com.google.protobuf.ByteString getLemmaBytes() {
      java.lang.Object ref = lemma_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lemma_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
     * </pre>
     *
     * <code>string lemma = 4;</code>
     *
     * @param value The lemma to set.
     * @return This builder for chaining.
     */
    public Builder setLemma(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      lemma_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
     * </pre>
     *
     * <code>string lemma = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLemma() {

      lemma_ = getDefaultInstance().getLemma();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
     * </pre>
     *
     * <code>string lemma = 4;</code>
     *
     * @param value The bytes for lemma to set.
     * @return This builder for chaining.
     */
    public Builder setLemmaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      lemma_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.language.v1beta2.Token)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.language.v1beta2.Token)
  private static final com.google.cloud.language.v1beta2.Token DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.language.v1beta2.Token();
  }

  public static com.google.cloud.language.v1beta2.Token getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Token> PARSER =
      new com.google.protobuf.AbstractParser<Token>() {
        @java.lang.Override
        public Token parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Token> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Token> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.language.v1beta2.Token getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
