/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.SinkNameType;
import java.util.Map;

public class SinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/sinks/{sink}");
    private final String project;
    private final String sink;

    public String getProject() {
        return this.project;
    }

    public String getSink() {
        return this.sink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SinkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.sink = (String)Preconditions.checkNotNull((Object)builder.getSink());
    }

    public static SinkName create(String project, String sink) {
        return SinkName.newBuilder().setProject(project).setSink(sink).build();
    }

    public static SinkName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SinkName.parse: formattedString not in valid format");
        return SinkName.create((String)matchMap.get("project"), (String)matchMap.get("sink"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return SinkNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "sink", this.sink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SinkName) {
            SinkName that = (SinkName)o;
            return this.project.equals(that.project) && this.sink.equals(that.sink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.sink.hashCode();
    }

    public static class Builder {
        private String project;
        private String sink;

        public String getProject() {
            return this.project;
        }

        public String getSink() {
            return this.sink;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        private Builder() {
        }

        private Builder(SinkName sinkName) {
            this.project = sinkName.project;
            this.sink = sinkName.sink;
        }

        public SinkName build() {
            return new SinkName(this);
        }
    }
}

