/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.BillingExclusionNameType;
import java.util.Map;

public class BillingExclusionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/exclusions/{exclusion}");
    private final String billingAccount;
    private final String exclusion;

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public String getExclusion() {
        return this.exclusion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BillingExclusionName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
    }

    public static BillingExclusionName create(String billingAccount, String exclusion) {
        return BillingExclusionName.newBuilder().setBillingAccount(billingAccount).setExclusion(exclusion).build();
    }

    public static BillingExclusionName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BillingExclusionName.parse: formattedString not in valid format");
        return BillingExclusionName.create((String)matchMap.get("billing_account"), (String)matchMap.get("exclusion"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return BillingExclusionNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"billing_account", this.billingAccount, "exclusion", this.exclusion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BillingExclusionName) {
            BillingExclusionName that = (BillingExclusionName)o;
            return this.billingAccount.equals(that.billingAccount) && this.exclusion.equals(that.exclusion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.billingAccount.hashCode();
        h *= 1000003;
        return h ^= this.exclusion.hashCode();
    }

    public static class Builder {
        private String billingAccount;
        private String exclusion;

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public Builder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        private Builder() {
        }

        private Builder(BillingExclusionName billingExclusionName) {
            this.billingAccount = billingExclusionName.billingAccount;
            this.exclusion = billingExclusionName.exclusion;
        }

        public BillingExclusionName build() {
            return new BillingExclusionName(this);
        }
    }
}

