/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.ExclusionNameType;
import java.util.Map;

public class ExclusionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/exclusions/{exclusion}");
    private final String project;
    private final String exclusion;

    public String getProject() {
        return this.project;
    }

    public String getExclusion() {
        return this.exclusion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ExclusionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
    }

    public static ExclusionName create(String project, String exclusion) {
        return ExclusionName.newBuilder().setProject(project).setExclusion(exclusion).build();
    }

    public static ExclusionName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ExclusionName.parse: formattedString not in valid format");
        return ExclusionName.create((String)matchMap.get("project"), (String)matchMap.get("exclusion"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return ExclusionNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "exclusion", this.exclusion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExclusionName) {
            ExclusionName that = (ExclusionName)o;
            return this.project.equals(that.project) && this.exclusion.equals(that.exclusion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.exclusion.hashCode();
    }

    public static class Builder {
        private String project;
        private String exclusion;

        public String getProject() {
            return this.project;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        private Builder() {
        }

        private Builder(ExclusionName exclusionName) {
            this.project = exclusionName.project;
            this.exclusion = exclusionName.exclusion;
        }

        public ExclusionName build() {
            return new ExclusionName(this);
        }
    }
}

