/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.FolderExclusionNameType;
import java.util.Map;

public class FolderExclusionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/exclusions/{exclusion}");
    private final String folder;
    private final String exclusion;

    public String getFolder() {
        return this.folder;
    }

    public String getExclusion() {
        return this.exclusion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FolderExclusionName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
    }

    public static FolderExclusionName create(String folder, String exclusion) {
        return FolderExclusionName.newBuilder().setFolder(folder).setExclusion(exclusion).build();
    }

    public static FolderExclusionName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FolderExclusionName.parse: formattedString not in valid format");
        return FolderExclusionName.create((String)matchMap.get("folder"), (String)matchMap.get("exclusion"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return FolderExclusionNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"folder", this.folder, "exclusion", this.exclusion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FolderExclusionName) {
            FolderExclusionName that = (FolderExclusionName)o;
            return this.folder.equals(that.folder) && this.exclusion.equals(that.exclusion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.folder.hashCode();
        h *= 1000003;
        return h ^= this.exclusion.hashCode();
    }

    public static class Builder {
        private String folder;
        private String exclusion;

        public String getFolder() {
            return this.folder;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        private Builder() {
        }

        private Builder(FolderExclusionName folderExclusionName) {
            this.folder = folderExclusionName.folder;
            this.exclusion = folderExclusionName.exclusion;
        }

        public FolderExclusionName build() {
            return new FolderExclusionName(this);
        }
    }
}

