/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.common.base.Preconditions;
import com.google.logging.v2.BillingLogName;
import com.google.logging.v2.FolderLogName;
import com.google.logging.v2.LogName;
import com.google.logging.v2.OrganizationLogName;

public class LogNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public LogName getLogName() {
        if (this.resourceName instanceof LogName) {
            return (LogName)this.resourceName;
        }
        return null;
    }

    public OrganizationLogName getOrganizationLogName() {
        if (this.resourceName instanceof OrganizationLogName) {
            return (OrganizationLogName)this.resourceName;
        }
        return null;
    }

    public FolderLogName getFolderLogName() {
        if (this.resourceName instanceof FolderLogName) {
            return (FolderLogName)this.resourceName;
        }
        return null;
    }

    public BillingLogName getBillingLogName() {
        if (this.resourceName instanceof BillingLogName) {
            return (BillingLogName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private LogNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static LogNameOneof parse(String resourceNameString) {
        if (LogName.isParsableFrom(resourceNameString)) {
            return new LogNameOneof(LogName.parse(resourceNameString));
        }
        if (OrganizationLogName.isParsableFrom(resourceNameString)) {
            return new LogNameOneof(OrganizationLogName.parse(resourceNameString));
        }
        if (FolderLogName.isParsableFrom(resourceNameString)) {
            return new LogNameOneof(FolderLogName.parse(resourceNameString));
        }
        if (BillingLogName.isParsableFrom(resourceNameString)) {
            return new LogNameOneof(BillingLogName.parse(resourceNameString));
        }
        return new LogNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static LogNameOneof from(LogName logName) {
        return new LogNameOneof(logName);
    }

    public static LogNameOneof from(OrganizationLogName organizationLogName) {
        return new LogNameOneof(organizationLogName);
    }

    public static LogNameOneof from(FolderLogName folderLogName) {
        return new LogNameOneof(folderLogName);
    }

    public static LogNameOneof from(BillingLogName billingLogName) {
        return new LogNameOneof(billingLogName);
    }

    public static LogNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new LogNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LogNameOneof) {
            LogNameOneof that = (LogNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

