/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.MetricNameType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetricName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/metrics/{metric}");
    private final String project;
    private final String metric;

    public String getProject() {
        return this.project;
    }

    public String getMetric() {
        return this.metric;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.metric = (String)Preconditions.checkNotNull((Object)builder.getMetric());
    }

    public static MetricName of(String project, String metric) {
        return MetricName.newBuilder().setProject(project).setMetric(metric).build();
    }

    @Deprecated
    public static MetricName create(String project, String metric) {
        return MetricName.of(project, metric);
    }

    public static String format(String project, String metric) {
        return MetricName.newBuilder().setProject(project).setMetric(metric).build().toString();
    }

    public static MetricName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MetricName.parse: formattedString not in valid format");
        return MetricName.of((String)matchMap.get("project"), (String)matchMap.get("metric"));
    }

    public static List<MetricName> parseList(List<String> formattedStrings) {
        ArrayList<MetricName> list = new ArrayList<MetricName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetricName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetricName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetricName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return MetricNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "metric", this.metric});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricName) {
            MetricName that = (MetricName)o;
            return this.project.equals(that.project) && this.metric.equals(that.metric);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.metric.hashCode();
    }

    public static class Builder {
        private String project;
        private String metric;

        public String getProject() {
            return this.project;
        }

        public String getMetric() {
            return this.metric;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMetric(String metric) {
            this.metric = metric;
            return this;
        }

        private Builder() {
        }

        private Builder(MetricName metricName) {
            this.project = metricName.project;
            this.metric = metricName.metric;
        }

        public MetricName build() {
            return new MetricName(this);
        }
    }
}

