/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.FolderLogNameType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FolderLogName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/logs/{log}");
    private final String folder;
    private final String log;

    public String getFolder() {
        return this.folder;
    }

    public String getLog() {
        return this.log;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FolderLogName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
    }

    public static FolderLogName of(String folder, String log) {
        return FolderLogName.newBuilder().setFolder(folder).setLog(log).build();
    }

    @Deprecated
    public static FolderLogName create(String folder, String log) {
        return FolderLogName.of(folder, log);
    }

    public static String format(String folder, String log) {
        return FolderLogName.newBuilder().setFolder(folder).setLog(log).build().toString();
    }

    public static FolderLogName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FolderLogName.parse: formattedString not in valid format");
        return FolderLogName.of((String)matchMap.get("folder"), (String)matchMap.get("log"));
    }

    public static List<FolderLogName> parseList(List<String> formattedStrings) {
        ArrayList<FolderLogName> list = new ArrayList<FolderLogName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FolderLogName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FolderLogName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FolderLogName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return FolderLogNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"folder", this.folder, "log", this.log});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FolderLogName) {
            FolderLogName that = (FolderLogName)o;
            return this.folder.equals(that.folder) && this.log.equals(that.log);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.folder.hashCode();
        h *= 1000003;
        return h ^= this.log.hashCode();
    }

    public static class Builder {
        private String folder;
        private String log;

        public String getFolder() {
            return this.folder;
        }

        public String getLog() {
            return this.log;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder setLog(String log) {
            this.log = log;
            return this;
        }

        private Builder() {
        }

        private Builder(FolderLogName folderLogName) {
            this.folder = folderLogName.folder;
            this.log = folderLogName.log;
        }

        public FolderLogName build() {
            return new FolderLogName(this);
        }
    }
}

