/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.OrganizationLogNameType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OrganizationLogName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/logs/{log}");
    private final String organization;
    private final String log;

    public String getOrganization() {
        return this.organization;
    }

    public String getLog() {
        return this.log;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OrganizationLogName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
    }

    public static OrganizationLogName of(String organization, String log) {
        return OrganizationLogName.newBuilder().setOrganization(organization).setLog(log).build();
    }

    @Deprecated
    public static OrganizationLogName create(String organization, String log) {
        return OrganizationLogName.of(organization, log);
    }

    public static String format(String organization, String log) {
        return OrganizationLogName.newBuilder().setOrganization(organization).setLog(log).build().toString();
    }

    public static OrganizationLogName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OrganizationLogName.parse: formattedString not in valid format");
        return OrganizationLogName.of((String)matchMap.get("organization"), (String)matchMap.get("log"));
    }

    public static List<OrganizationLogName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationLogName> list = new ArrayList<OrganizationLogName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationLogName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationLogName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationLogName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return OrganizationLogNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "log", this.log});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrganizationLogName) {
            OrganizationLogName that = (OrganizationLogName)o;
            return this.organization.equals(that.organization) && this.log.equals(that.log);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        return h ^= this.log.hashCode();
    }

    public static class Builder {
        private String organization;
        private String log;

        public String getOrganization() {
            return this.organization;
        }

        public String getLog() {
            return this.log;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLog(String log) {
            this.log = log;
            return this;
        }

        private Builder() {
        }

        private Builder(OrganizationLogName organizationLogName) {
            this.organization = organizationLogName.organization;
            this.log = organizationLogName.log;
        }

        public OrganizationLogName build() {
            return new OrganizationLogName(this);
        }
    }
}

